//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: rblanc $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 14670 $
// $Date: 2014-04-23 18:45:38 +0200 (Wed, 23 Apr 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : DC IIR Filter Top.                                                  
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/DCIIRFilterComp/verilog/rtl/DCIIRFilterCompTop.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

module  DCIIRFilterCompTop #(parameter INPUTWIDTH = 14,
                             parameter BW_PARAM   = 80 // 20/40/80
                            )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock & Reset.
            input    wire                                       PhyClk,
            input    wire                                       nPhyRst,
            //Enable for valid DC Estimation value.
            input    wire                                       DCEstValid,
            //Rx input with valid signal.
            input    wire                                       RxDataInValid,
            input    wire       signed    [(INPUTWIDTH-1):0]    RxDataInRe,
            input    wire       signed    [(INPUTWIDTH-1):0]    RxDataInIm,
            //Block enable.
            input    wire                                       BlockEn,
            //DC Estimation value.
            input    wire       signed    [(INPUTWIDTH-1):0]    DCEstRe,
            input    wire       signed    [(INPUTWIDTH-1):0]    DCEstIm,
            //Hold time after which DC Estimation value is hold.
            input    wire                 [6:0]                 dcHoldTime,
            //Compensation Type.
            input    wire                 [1:0]                 dcCompType,
            //Zero compensation counter value.
            input    wire                 [6:0]                 dcForceZeroCnt,


            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Rx Output Port with valid signal.
            output   wire                                       DCOutValid,
            //Register & Neutral scale outputs.
            output   wire   signed    [(INPUTWIDTH-3):0]       DCOutNeutralScaleRe,
            output   wire   signed    [(INPUTWIDTH-3):0]       DCOutNeutralScaleIm
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                            DCOutValidRe;
wire                            DCOutValidIm;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign DCOutValid = DCOutValidRe || DCOutValidIm;

//Instantiation for DC Compensation of Real part of Rx Data.
DCIIRFilterComp#(.BW_PARAM(BW_PARAM),
                 .INPUTWIDTH(INPUTWIDTH))
Re_DC (
             .PhyClk(PhyClk),
             .nPhyRst(nPhyRst),
             .RxDataInValid(RxDataInValid),
             .BlockEn(BlockEn),
             .DCEstValid(DCEstValid),
             .RxDataIn(RxDataInRe),
             .DCEst(DCEstRe),
             .dcHoldTime(dcHoldTime),
             .dcCompType(dcCompType),
             .dcForceZeroCnt(dcForceZeroCnt),
             .DCOutNeutralScale(DCOutNeutralScaleRe),
             .DCOutValid(DCOutValidRe)
        );

//Instantiation for DC Compensation of Imag part of Rx Data.
DCIIRFilterComp #(.BW_PARAM(BW_PARAM),
                  .INPUTWIDTH(INPUTWIDTH))
Im_DC (
             .PhyClk(PhyClk),
             .nPhyRst(nPhyRst),
             .RxDataInValid(RxDataInValid),
             .BlockEn(BlockEn),
             .DCEstValid(DCEstValid),
             .RxDataIn(RxDataInIm),
             .DCEst(DCEstIm),
             .dcHoldTime(dcHoldTime),
             .dcCompType(dcCompType),
             .dcForceZeroCnt(dcForceZeroCnt),
             .DCOutNeutralScale(DCOutNeutralScaleIm),
             .DCOutValid(DCOutValidIm)
        );

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
