//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: rblanc $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 14670 $
// $Date: 2014-04-23 18:45:38 +0200 (Wed, 23 Apr 2014) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : DC IIR Filter Top.                                                  
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/DCIIRFilterEst/verilog/rtl/DCIIRFilterEstTop.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

module  DCIIRFilterEstTop #(parameter INPUTWIDTH = 12
                           )(
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock & Reset
            input  wire                                  PhyClk,
            input  wire                                  nPhyRst,

            // Data and Control
            //Enable input for valid data in.
            input  wire                                  EnableIn,
            //Rx input with valid signal.
            input  wire signed    [(INPUTWIDTH-1):0]     RxDataInRe,
            input  wire signed    [(INPUTWIDTH-1):0]     RxDataInIm,
            input  wire           [1:0]                  Mode,
            input  wire           [6:0]                  DelStableDC,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Rx Output Port with valid signal.
            output  wire                                 DCEstValid,
            output  wire signed   [(INPUTWIDTH-1):0]     DCEstRe,
            output  wire signed   [(INPUTWIDTH-1):0]     DCEstIm
            );

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

DCIIRFilterEst#(.INPUTWIDTH(INPUTWIDTH))
Re_DC (
             .PhyClk(PhyClk),
             .nPhyRst(nPhyRst), 
             .EnableIn(EnableIn),
             .RxDataIn(RxDataInRe),
             .Mode(Mode),
             .DelStableDC(DelStableDC),
             .DCEst(DCEstRe),
             .DCEstValid(DCEstValid)
        );

DCIIRFilterEst#(.INPUTWIDTH(INPUTWIDTH))
Im_DC (
             .PhyClk(PhyClk),
             .nPhyRst(nPhyRst),
             .EnableIn(EnableIn),
             .RxDataIn(RxDataInIm),
             .Mode(Mode),
             .DelStableDC(DelStableDC),
             .DCEst(DCEstIm),
             .DCEstValid()
        );

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
