/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
********************************************************************************
* $Author: $
* Company          : RivieraWaves
********************************************************************************
* $Revision: $
* $Date: $
* ******************************************************************************
* Dependencies     : None
* Description      : Top level of TxRxFrontEndX40
* Simulation Notes : 
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
* ******************************************************************************
*
* $HeadURL: $
*
********************************************************************************
* DEFIFNE:
*
*  RW_NX_DERIV_80211B     : support 802.11B
*  RW_NX_DSSS_CORR_EN     : support DSSS correlation based detection
*  RW_RADAR_EN            : support RADAR
*  RW_NX_DERIV_FE_PATH40M : support 40 MHz channel
*  RW_NX_DERIV_FE_PATH80M : support 80 MHz channel
*
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
* ATTENTION 
* apply the following points otherwise functionnaly is altered:
*  rule 1) fe_clk,fe40_clk,fe80_clk and fe160_clk SHALL HAVE A COMMON RISING EDGE
*  rule 2) agc_ofdm_blocken and agc_dsss_blocken SHALL BE ASSERTED ON RISING fe40_clk/2 EDGE
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*
*******************************************************************************/
`default_nettype none
module TxRxFrontEndX40
(
  /*****************************************************************************
  * resets
  *****************************************************************************/
  input  wire        fe_rst_n,
  input  wire        fe40_rst_n,
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire        fe80_rst_n,
`endif  
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire        fe160_rst_n,
`endif  
  /*****************************************************************************
  * clocks
  *****************************************************************************/
  input  wire        ferx_clk,
  input  wire        fetx_clk,
  input  wire        fe40_clk,
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire        fe80_clk,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire        fe160_clk,
`endif  

  /*****************************************************************************
  * registers (asynchronous)
  *****************************************************************************/
  input  wire [ 1:0] mdmcfg_conf_bw,
  input  wire [ 2:0] mdmcfg_conf_primary,

`ifdef RW_NX_DERIV_80211B
  input wire  [ 1:0] mdmcfg_dsss_dccomptype, 
  input wire  [ 6:0] mdmcfg_dsss_dcholdtime, 
  input wire  [ 6:0] mdmcfg_dsss_dczerotime, 
`endif
  input wire  [ 1:0] mdmcfg_center_dccomptype, 
  input wire  [ 6:0] mdmcfg_center_dcholdtime, 
  input wire  [ 6:0] mdmcfg_center_dczerotime, 
  input wire  [ 1:0] mdmcfg_primary_dccomptype,
  input wire  [ 6:0] mdmcfg_primary_dcholdtime,
  input wire  [ 6:0] mdmcfg_primary_dczerotime,
`ifdef RW_RADAR_EN
  input wire  [ 1:0] mdmcfg_radar_dccomptype, 
  input wire  [ 6:0] mdmcfg_radar_dcholdtime, 
  input wire  [ 6:0] mdmcfg_radar_dczerotime, 
`endif  

  /*****************************************************************************
  * AGC control (FEClk)
  *****************************************************************************/
  /* block enables */
  input  wire        agc_ofdm_blocken,
`ifdef RW_NX_DERIV_80211B
  input  wire        agc_dsss_blocken,
`endif

  /* digital gains */
  input  wire [ 3:0] agc20_diggain6db,    
  input  wire [ 5:0] agc20_diggainlin,    
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire [ 3:0] agc40_diggain6db,    
  input  wire [ 5:0] agc40_diggainlin,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire [ 3:0] agc80_diggain6db,    
  input  wire [ 5:0] agc80_diggainlin,    
`endif

  /*****************************************************************************
  * MFSM control (FEClk)
  *****************************************************************************/
  input  wire        mfsm_ofdm_tx_blocken,
  
`ifdef RW_NX_DERIV_80211B
  input  wire        mfsm_dsss_tx_blocken,
`endif

  /*****************************************************************************
  * Converters (FEClk)
  *****************************************************************************/
  /* ADC */
  input  wire [11:0] adc_i,
  input  wire [11:0] adc_q,
  
  /* DAC */
  output wire        dac_en,
  output wire [11:0] dac_i,
  output wire [11:0] dac_q,
 
  /*****************************************************************************
  * OFDM PHY interface (FEClk)
  *****************************************************************************/
  /* RX */
  output reg         ofdm_rx_valid, 
  output wire [12:0] ofdm_rx20_i,    
  output wire [12:0] ofdm_rx20_q,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire [12:0] ofdm_rx20sec_i,    
  output wire [12:0] ofdm_rx20sec_q,    
  output wire [12:0] ofdm_rx40_i,    
  output wire [12:0] ofdm_rx40_q,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire [12:0] ofdm_rx80_i,    
  output wire [12:0] ofdm_rx80_q,    
`endif
  
  /* TX */
  /* start delay */
  output wire        ofdm_tx_pipe_loaded,
  input  wire        ofdm_tx_pipe_release,
  
  /* frame parameter */
  input  wire [ 6:0] ofdm_tx_diggain,
  input  wire        ofdm_tx_sfo_bypass,
  input  wire [26:0] ofdm_tx_sfo_ppm,
  input  wire        ofdm_tx_cfo_bypass,
  input  wire [24:0] ofdm_tx_cfo_freq,

  /* sample stream */
  output wire        ofdm_tx_ready,
  input  wire [12:0] ofdm_tx_i, 
  input  wire [12:0] ofdm_tx_q, 
  input  wire        ofdm_tx_valid,
  
`ifdef RW_NX_DERIV_80211B
  /*****************************************************************************
  * RSF440 interface (fe40_clk)
  *****************************************************************************/
  /* TX */
  input  wire        dsss_tx_valid,
  input  wire [11:0] dsss_tx_i,
  input  wire [11:0] dsss_tx_q,       

  /* RX */
  output wire        dsss_rx_valid,
  output wire [12:0] dsss_rx_i,
  output wire [12:0] dsss_rx_q,
`endif

  /*****************************************************************************
  * AGC if (FEClk)
  *****************************************************************************/
  input wire  [11:0] adc_dcest_i,            
  input wire  [11:0] adc_dcest_q, 

`ifdef RW_RADAR_EN
  output wire [12:0] agc_radar_i,   
  output wire [12:0] agc_radar_q,   
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire [12:0] agc20_sec_i,   
  output wire [12:0] agc20_sec_q,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire [12:0] agc40_sec_i,   
  output wire [12:0] agc40_sec_q,
`endif
  output wire [12:0] agc20_i,   
  output wire [12:0] agc20_q
);
  
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  localparam     BW_20=2'd0,BW_40=2'd1,BW_80=2'd2;
  wire           rx_blocken; 
  wire           tx_blocken; 

  /*****************************************************************************
  * HBF20_LPF4040 instance
  *****************************************************************************/
  wire        hbf20_blocken;
  wire        hbf20_cfs;
  wire        hbf20_cfsen;
  wire        rxhbf20_in_valid;
  wire [11:0] rxhbf20_in_i,rxhbf20_in_q;
  wire [11:0] rxhbf20_in_dc_i,rxhbf20_in_dc_q;
  wire        rxhbf20_valid;
  wire [12:0] rxhbf20_pri_i,rxhbf20_pri_q;
  wire [12:0] rxhbf20_sec_i,rxhbf20_sec_q;
  wire [12:0] rxhbf20_dc_i,rxhbf20_dc_q;
  wire [12:0] rxlpf4040_i,rxlpf4040_q; 
  wire [12:0] rxlpf4040_dc_i,rxlpf4040_dc_q; 
  wire        rx20dc_blocken;

`ifdef RW_NX_DERIV_80211B
  /*****************************************************************************
  * RXDSSS DC COMP
  *****************************************************************************/
  /* RX DCCOMP DSSS CENTERED */ 
  wire [12:0] rx4040dcc_i,rx4040dcc_q;
  
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(          0),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx4040dcc
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe40_rst_n),
    .clk(                   fe40_clk),

    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx20dc_blocken),            
    .dc_comp_type(          mdmcfg_dsss_dccomptype),
    .dc_hold_time(          mdmcfg_dsss_dcholdtime),
    .dc_zero_time(          mdmcfg_dsss_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf20_valid),
    .in_dc_i(               rxlpf4040_dc_i),  
    .in_dc_q(               rxlpf4040_dc_q),  
    .in_i(                  rxlpf4040_i),
    .in_q(                  rxlpf4040_q),
    .out_i(                 rx4040dcc_i),
    .out_q(                 rx4040dcc_q)
  );

  /*****************************************************************************
  * RX44 GAIN
  *****************************************************************************/
  rx_dig_gain  
  #(
    .g_pipeline(            0)
  )
  u_rx20scale_rsf
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe40_rst_n),
    .clk(                   fe40_clk),
    
    /*****************************************************************************
    * control
    *****************************************************************************/
    .gain_6db(              agc20_diggain6db),
    .gain_lin(              agc20_diggainlin),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  rx4040dcc_i),
    .in_q(                  rx4040dcc_q),
    .in_valid(              rxhbf20_valid),
    
    .out_i(                 dsss_rx_i),
    .out_q(                 dsss_rx_q),
    .out_valid(             dsss_rx_valid)
  );
  
`endif // RW_NX_DERIV_80211B

  hbf20_lpf4040 // NOT USED in TX
  #(
`ifdef RW_NX_DERIV_80211B
    .lpf4040_present(       1)
`else
    .lpf4040_present(       0)
`endif
  )
  u_hbf20_lpf4040
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe40_rst_n),
    .clk(                   fe40_clk),
    /*****************************************************************************
    * control
    *****************************************************************************/
    .blocken(               hbf20_blocken),  
    .rxmode(                rx_blocken),  
    .cfsen(                 hbf20_cfsen),    
    .cfs(                   hbf20_cfs),   
`ifdef RW_NX_DERIV_80211B
    .lpf4040en(             agc_dsss_blocken),
`else
    .lpf4040en(             1'b0),
`endif
    
    /*****************************************************************************
    * RX
    *****************************************************************************/
    .in_rx_valid(           rxhbf20_in_valid), 
    .in_rx_i(               rxhbf20_in_i),
    .in_rx_q(               rxhbf20_in_q),
    .in_rx_dc_i(            rxhbf20_in_dc_i),
    .in_rx_dc_q(            rxhbf20_in_dc_q),
    
    .out_rx_valid(          rxhbf20_valid),
    .out_rx_hbf20_pri_i(    rxhbf20_pri_i),
    .out_rx_hbf20_pri_q(    rxhbf20_pri_q),
    .out_rx_hbf20_sec_i(    rxhbf20_sec_i),
    .out_rx_hbf20_sec_q(    rxhbf20_sec_q),
    .out_rx_hbf20_dc_i(     rxhbf20_dc_i),
    .out_rx_hbf20_dc_q(     rxhbf20_dc_q),
    .out_rx_lpf4040_i(      rxlpf4040_i),
    .out_rx_lpf4040_q(      rxlpf4040_q),
    .out_rx_lpf4040_dc_i(   rxlpf4040_dc_i),
    .out_rx_lpf4040_dc_q(   rxlpf4040_dc_q),
    
    /*****************************************************************************
    * TX
    *****************************************************************************/
    .in_tx_valid(           1'b0),
    .in_tx_i(               12'b0),
    .in_tx_q(               12'b0),
    
    .out_tx_valid(          ),
    .out_tx_i(              ),
    .out_tx_q(              )
  );

  /*****************************************************************************
  * RX20 DC COMPENSATION
  *****************************************************************************/
  /* RX DCCOMP 20 CENTERED */ 
  wire [12:0] rx20dcc_i,rx20dcc_q;
  
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(          0),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx20dcc
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe40_rst_n),
    .clk(                   fe40_clk),

    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx20dc_blocken),            
    .dc_comp_type(          mdmcfg_center_dccomptype),
    .dc_hold_time(          mdmcfg_center_dcholdtime),
    .dc_zero_time(          mdmcfg_center_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf20_valid),
    .in_dc_i(               rxhbf20_dc_i),  
    .in_dc_q(               rxhbf20_dc_q),  
    .in_i(                  rxhbf20_pri_i),
    .in_q(                  rxhbf20_pri_q),
    .out_i(                 rx20dcc_i),
    .out_q(                 rx20dcc_q)
  );
  
  /* RX DCCOMP 20 PRIMARY */ 
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           0),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx20dcp
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe40_rst_n),
    .clk(                   fe40_clk),
  
    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx20dc_blocken),           
    .dc_comp_type(          mdmcfg_primary_dccomptype),
    .dc_hold_time(          mdmcfg_primary_dcholdtime),
    .dc_zero_time(          mdmcfg_primary_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf20_valid),
    .in_dc_i(               rxhbf20_dc_i),  
    .in_dc_q(               rxhbf20_dc_q),  
    .in_i(                  rxhbf20_pri_i),
    .in_q(                  rxhbf20_pri_q),
    .out_i(                 agc20_i),
    .out_q(                 agc20_q)
  );
 
`ifdef RW_RADAR_EN
  /* RX DCCOMP 20 RADAR */ 
  wire [12:0] rx20dcr_i,rx20dcr_q;
 
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           0),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx20dcr
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe40_rst_n),
    .clk(                   fe40_clk),
  
    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx20dc_blocken),      
    .dc_comp_type(          mdmcfg_radar_dccomptype),
    .dc_hold_time(          mdmcfg_radar_dcholdtime),
    .dc_zero_time(          mdmcfg_radar_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf20_valid),
    .in_dc_i(               rxhbf20_dc_i),  
    .in_dc_q(               rxhbf20_dc_q),  
    .in_i(                  rxhbf20_pri_i),
    .in_q(                  rxhbf20_pri_q),
    .out_i(                 rx20dcr_i),
    .out_q(                 rx20dcr_q)
  );
`endif // RW_RADAR_EN 

  /*****************************************************************************
  * RX20 PRIMARY GAIN
  *****************************************************************************/
  rx_dig_gain
  #(
    .g_pipeline(            1)
  )
  u_rx20scale_pri
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe_rst_n),
    .clk(                   ferx_clk),
    
    /*****************************************************************************
    * control
    *****************************************************************************/
    .gain_6db(              agc20_diggain6db),
    .gain_lin(              agc20_diggainlin),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  rx20dcc_i),
    .in_q(                  rx20dcc_q),
    .in_valid(              rxhbf20_valid),
    
    .out_i(                 ofdm_rx20_i),
    .out_q(                 ofdm_rx20_q),
    .out_valid(             )
  );
  
`ifdef RW_NX_DERIV_FE_PATH40M
  assign agc20_sec_i = rxhbf20_sec_i;
  assign agc20_sec_q = rxhbf20_sec_q;
  
  /*****************************************************************************
  * RX20 SECONDARY GAIN
  *****************************************************************************/
  rx_dig_gain
  #(
    .g_pipeline(            1)
  )
  u_rx20scale_sec
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe_rst_n),
    .clk(                   ferx_clk),
   
    /*****************************************************************************
    * control
    *****************************************************************************/
    .gain_6db(              agc20_diggain6db),
    .gain_lin(              agc20_diggainlin),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  rxhbf20_sec_i),
    .in_q(                  rxhbf20_sec_q),
    .in_valid(              rxhbf20_valid),
    
    .out_i(                 ofdm_rx20sec_i),
    .out_q(                 ofdm_rx20sec_q),
    .out_valid(             )
  );
 
  /*****************************************************************************
  * HBF40 instance
  *****************************************************************************/
  wire        hbf40_blocken;
  wire        hbf40_cfs;
  wire        hbf40_cfsen;
  wire        rxhbf40_in_valid;
  wire [11:0] rxhbf40_in_i,rxhbf40_in_q;
  wire [11:0] rxhbf40_in_dc_i,rxhbf40_in_dc_q;
  wire        rxhbf40_valid;
  wire [12:0] rxhbf40_pri_i,rxhbf40_pri_q;
  wire [12:0] rxhbf40_sec_i,rxhbf40_sec_q;
  wire [12:0] rxhbf40_dc_i,rxhbf40_dc_q;
  wire        txhbf40_valid; 
  wire [11:0] txhbf40_i,txhbf40_q; 
  
  hbf40 u_hbf40
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe80_rst_n),
    .clk(                   fe80_clk),

    /*****************************************************************************
    * control
    *****************************************************************************/
    .blocken(               hbf40_blocken), // global enable 
    .rxmode(                rx_blocken),    // 1=RX; 0=TX
    .cfsen(                 hbf40_cfsen),   // enable spectrum shift
    .cfs(                   hbf40_cfs),     // 0=primary is left, 1=primary is right
    
    /*****************************************************************************
    * RX
    *****************************************************************************/
    .in_rx_valid(           rxhbf40_in_valid), 
    .in_rx_i(               rxhbf40_in_i),
    .in_rx_q(               rxhbf40_in_q),
    .in_rx_dc_i(            rxhbf40_in_dc_i),
    .in_rx_dc_q(            rxhbf40_in_dc_q),
    
    .out_rx_valid(          rxhbf40_valid),
    .out_rx_pri_i(          rxhbf40_pri_i),
    .out_rx_pri_q(          rxhbf40_pri_q),
    .out_rx_sec_i(          rxhbf40_sec_i),
    .out_rx_sec_q(          rxhbf40_sec_q),
    .out_rx_dc_i(           rxhbf40_dc_i),
    .out_rx_dc_q(           rxhbf40_dc_q),
    
    /*****************************************************************************
    * TX
    *****************************************************************************/
`ifdef RW_NX_DERIV_80211B
    .in_tx_valid(           dsss_tx_valid),
    .in_tx_i(               dsss_tx_i),
    .in_tx_q(               dsss_tx_q),
`else
    .in_tx_valid(           1'b0),
    .in_tx_i(               12'b0),
    .in_tx_q(               12'b0),
`endif
    
    .out_tx_valid(          txhbf40_valid),
    .out_tx_i(              txhbf40_i),
    .out_tx_q(              txhbf40_q)
  );

  /*****************************************************************************
  * TX40 FREQSHIFT 
  *****************************************************************************/
  wire        tx40fs8_cfsen;
  wire        tx40fs8_cfs;
  wire        tx40fs8_valid;
  wire [11:0] tx40fs8_i,tx40fs8_q;
  
  freqshift_fs8
  #(
    .g_pipeline(            1'b0)
  )
  u_tx40fs8
  (
    /***************************************************************************** 
    * system                                                                       
    *****************************************************************************/ 
    .rst_n(                 fe80_rst_n),                                                            
    .clk(                   fe80_clk),                                                              

    /***************************************************************************** 
    * control                                                                      
    *****************************************************************************/ 
    .cfsen(                 tx40fs8_cfsen),
    .cfs(                   tx40fs8_cfs),
  
    .in_valid(              txhbf40_valid),                                                   
    .in_i(                  txhbf40_i),                                                       
    .in_q(                  txhbf40_q),                                                       
  
    .out_valid(             tx40fs8_valid),                                                  
    .out_i(                 tx40fs8_i),                                                      
    .out_q(                 tx40fs8_q)                                                       
  );

  /*****************************************************************************
  * RX40 DC COMPENSATION
  *****************************************************************************/
  wire         rx40dc_blocken;
  
  /* RX DCCOMP 40 CENTERED */ 
  wire [12:0] rx40dcc_i,rx40dcc_q;
 
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           1),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx40dcc
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe80_rst_n),
    .clk(                   fe80_clk),

    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx40dc_blocken),            
    .dc_comp_type(          mdmcfg_center_dccomptype),
    .dc_hold_time(          mdmcfg_center_dcholdtime),
    .dc_zero_time(          mdmcfg_center_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf40_valid),
    .in_dc_i(               rxhbf40_dc_i),  
    .in_dc_q(               rxhbf40_dc_q),  
    .in_i(                  rxhbf40_pri_i),
    .in_q(                  rxhbf40_pri_q),
    .out_i(                 rx40dcc_i),
    .out_q(                 rx40dcc_q)
  );
  
  /* RX DCCOMP 40 PRIMARY */ 
  wire [11:0] rx40dcp_i,rx40dcp_q;
  
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           1),
    /* output operands width : 12 or 13 */
    .g_width(               12)
  )
  u_rx40dcp
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe80_rst_n),
    .clk(                   fe80_clk),
  
    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx40dc_blocken),           
    .dc_comp_type(          mdmcfg_primary_dccomptype),
    .dc_hold_time(          mdmcfg_primary_dcholdtime),
    .dc_zero_time(          mdmcfg_primary_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf40_valid),
    .in_dc_i(               rxhbf40_dc_i),  
    .in_dc_q(               rxhbf40_dc_q),  
    .in_i(                  rxhbf40_pri_i),
    .in_q(                  rxhbf40_pri_q),
    .out_i(                 rx40dcp_i),
    .out_q(                 rx40dcp_q)
  );

`ifdef RW_RADAR_EN
  /* RX DCCOMP 40 RADAR */ 
  wire [12:0] rx40dcr_i,rx40dcr_q;
 
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           1),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx40dcr
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe80_rst_n),
    .clk(                   fe80_clk),
  
    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx40dc_blocken),      
    .dc_comp_type(          mdmcfg_radar_dccomptype),
    .dc_hold_time(          mdmcfg_radar_dcholdtime),
    .dc_zero_time(          mdmcfg_radar_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf40_valid),
    .in_dc_i(               rxhbf40_dc_i),  
    .in_dc_q(               rxhbf40_dc_q),  
    .in_i(                  rxhbf40_pri_i),
    .in_q(                  rxhbf40_pri_q),
    .out_i(                 rx40dcr_i),
    .out_q(                 rx40dcr_q)
  );
`endif // RW_RADAR_EN

  /*****************************************************************************
  * RX40 GAIN
  *****************************************************************************/
  rx_dig_gain
  #(
    .g_pipeline(            1)
  )
  u_rx40scale
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe_rst_n),
    .clk(                   ferx_clk),
   
    /*****************************************************************************
    * control
    *****************************************************************************/
    .gain_6db(              agc40_diggain6db),
    .gain_lin(              agc40_diggainlin),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  rx40dcc_i),
    .in_q(                  rx40dcc_q),
    .in_valid(              rxhbf40_valid),
    .out_i(                 ofdm_rx40_i),
    .out_q(                 ofdm_rx40_q),
    .out_valid(             )
  );
  
`endif // RW_NX_DERIV_FE_PATH40M

`ifdef RW_NX_DERIV_FE_PATH80M
  assign agc40_sec_i = rxhbf40_sec_i;
  assign agc40_sec_q = rxhbf40_sec_q;
 
  /*****************************************************************************
  * HBF80 instance
  *****************************************************************************/
  wire        hbf80_blocken;
  wire        rxhbf80_valid;
  wire [12:0] rxhbf80_i,rxhbf80_q;
  wire [12:0] rxhbf80_dc_i,rxhbf80_dc_q;
 
  hbf80 u_hbf80
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe160_rst_n),
    .clk(                   fe160_clk),

    /*****************************************************************************
    * control
    *****************************************************************************/
    .blocken(               hbf80_blocken),    // global enable
    .rxmode(                rx_blocken),           // 1=RX; 0=TX
  
    /*****************************************************************************
    * RX
    *****************************************************************************/
    .in_rx_valid(           agc_ofdm_blocken), 
    .in_rx_i(               adc_i), 
    .in_rx_q(               adc_q), 
    .in_rx_dc_i(            adc_dcest_i), 
    .in_rx_dc_q(            adc_dcest_q), 
  
    .out_rx_valid(          rxhbf80_valid),
    .out_rx_i(              rxhbf80_i),
    .out_rx_q(              rxhbf80_q),
    .out_rx_dc_i(           rxhbf80_dc_i),
    .out_rx_dc_q(           rxhbf80_dc_q),
  
    /*****************************************************************************
    * TX
    *****************************************************************************/
    .in_tx_valid(           1'b0), 
    .in_tx_i(               12'b0),
    .in_tx_q(               12'b0),
  
    .out_tx_valid(          ),
    .out_tx_i(              ),
    .out_tx_q(              )
  );
 
  /*****************************************************************************
  * RX80 DC COMPENSATION
  *****************************************************************************/
  wire        rx80dc_blocken;
  
  /* RX DCCOMP 80 CENTERED */ 
  wire [12:0] rx80dcc_i,rx80dcc_q;
  
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           2),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx80dcc
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe160_rst_n),
    .clk(                   fe160_clk),

    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx80dc_blocken),            
    .dc_comp_type(          mdmcfg_center_dccomptype),
    .dc_hold_time(          mdmcfg_center_dcholdtime),
    .dc_zero_time(          mdmcfg_center_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf80_valid),
    .in_dc_i(               rxhbf80_dc_i),  
    .in_dc_q(               rxhbf80_dc_q),  
    .in_i(                  rxhbf80_i),
    .in_q(                  rxhbf80_q),
    .out_i(                 rx80dcc_i),
    .out_q(                 rx80dcc_q)
  );
  
  /* RX DCCOMP 80 PRIMARY */ 
  wire [11:0] rx80dcp_i,rx80dcp_q;
  
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           2),
    /* output operands width : 12 or 13 */
    .g_width(               12)
  )
  u_rx80dcp
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe160_rst_n),
    .clk(                   fe160_clk),
  
    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx80dc_blocken),           
    .dc_comp_type(          mdmcfg_primary_dccomptype),
    .dc_hold_time(          mdmcfg_primary_dcholdtime),
    .dc_zero_time(          mdmcfg_primary_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf80_valid),
    .in_dc_i(               rxhbf80_dc_i),  
    .in_dc_q(               rxhbf80_dc_q),  
    .in_i(                  rxhbf80_i),
    .in_q(                  rxhbf80_q),
    .out_i(                 rx80dcp_i),
    .out_q(                 rx80dcp_q)
  );
 
 reg        rx80dcp_1t_valid,rx80dcp_2t_valid;
 reg [11:0] rx80dcp_1t_i,rx80dcp_1t_q;
 reg [11:0] rx80dcp_2t_i,rx80dcp_2t_q;
 
 always @(posedge fe80_clk,negedge fe80_rst_n)
 begin
   if(!fe80_rst_n)
   begin
     rx80dcp_2t_valid <= 1'b0;
     rx80dcp_2t_i     <= 12'b0;
     rx80dcp_2t_q     <= 12'b0;  
     rx80dcp_1t_valid <= 1'b0;
     rx80dcp_1t_i     <= 12'b0;
     rx80dcp_1t_q     <= 12'b0;  
   end
   else
   begin
     rx80dcp_2t_valid <= rx80dcp_1t_valid;
     rx80dcp_2t_i     <= rx80dcp_1t_i;    
     rx80dcp_2t_q     <= rx80dcp_1t_q;    
     rx80dcp_1t_valid <= rxhbf80_valid;
     rx80dcp_1t_i     <= rx80dcp_i;
     rx80dcp_1t_q     <= rx80dcp_q;
   end
 end
 
`ifdef RW_RADAR_EN
  /* RX DCCOMP 80 RADAR */ 
  wire [12:0] rx80dcr_i,rx80dcr_q;
 
  rx_dc_comp 
  #(
    /* clock period: 0=40M, 1=80M, 2=160M */
    .g_clk_period(           2),
    /* output operands width : 12 or 13 */
    .g_width(               13)
  )
  u_rx80dcr
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe160_rst_n),
    .clk(                   fe160_clk),
  
    /*****************************************************************************
    * control parameter
    *****************************************************************************/
    .blocken(               rx80dc_blocken),      
    .dc_comp_type(          mdmcfg_radar_dccomptype),
    .dc_hold_time(          mdmcfg_radar_dcholdtime),
    .dc_zero_time(          mdmcfg_radar_dczerotime),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_valid(              rxhbf80_valid),
    .in_dc_i(               rxhbf80_dc_i),  
    .in_dc_q(               rxhbf80_dc_q),  
    .in_i(                  rxhbf80_i),
    .in_q(                  rxhbf80_q),
    .out_i(                 rx80dcr_i),
    .out_q(                 rx80dcr_q)
  );
`endif // RW_RADAR_EN 

  /*****************************************************************************
  * RX80 GAIN
  *****************************************************************************/
  rx_dig_gain
  #(
    .g_pipeline(            2)
  )
  u_rx80scale
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(                 fe_rst_n),
    .clk(                   ferx_clk),
   
    /*****************************************************************************
    * control
    *****************************************************************************/
    .gain_6db(              agc80_diggain6db),
    .gain_lin(              agc80_diggainlin),

    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  rx80dcc_i),
    .in_q(                  rx80dcc_q),
    .in_valid(              rxhbf80_valid),
    .out_i(                 ofdm_rx80_i),
    .out_q(                 ofdm_rx80_q),
    .out_valid(             )
  );
  
`endif // RW_NX_DERIV_FE_PATH80M
                          
  /*****************************************************************************
  * BLOCK ENABLE MUX
  *****************************************************************************/
 
`ifdef RW_NX_DERIV_80211B
  assign rx_blocken        = agc_ofdm_blocken    | agc_dsss_blocken;
`else
  assign rx_blocken        = agc_ofdm_blocken;
`endif
 
  always @(posedge ferx_clk,negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      ofdm_rx_valid <= 1'b0;
    end
    else
    begin
      ofdm_rx_valid <= rx_blocken;
    end
  end

  /*****************************************************************************
  * DAC MUX
  *****************************************************************************/
  wire [11:0] tx_tbprecomp_i;
  wire [11:0] tx_tbprecomp_q; 
  wire        tx_tbprecomp_valid;

  assign {dac_en,dac_i,dac_q} =
`ifdef RW_NX_DERIV_80211B
`ifdef RW_NX_DERIV_FE_PATH40M
    (mdmcfg_conf_bw==BW_40 && mfsm_dsss_tx_blocken) ? {     tx40fs8_valid,      tx40fs8_i,       tx40fs8_q} :
`endif
   mfsm_dsss_tx_blocken                             ? {     dsss_tx_valid,      dsss_tx_i,       dsss_tx_q} :
`endif
                                                      {tx_tbprecomp_valid, tx_tbprecomp_i,  tx_tbprecomp_q};

  /*****************************************************************************
  * OFDM tx path
  *****************************************************************************/
  wire [11:0] tx_diggain_i;
  wire [11:0] tx_diggain_q; 
  wire        tx_diggain_valid;
  
  /* tx digital gain */
  tx_dig_gain u_txdiggain 
  (
    /* system */
    .rst_n(                 fe_rst_n),
    .clk(                   fetx_clk),
   
    /* control */
    .enable(                mfsm_ofdm_tx_blocken),
    .gain_lin(              ofdm_tx_diggain),

    /* data */
    .ready(                 ofdm_tx_ready),
    
    .in_i(                  ofdm_tx_i),
    .in_q(                  ofdm_tx_q),
    .in_valid(              ofdm_tx_valid),
    .out_i(                 tx_diggain_i),
    .out_q(                 tx_diggain_q),
    .out_valid(             tx_diggain_valid)
  );
  
  /* tx trigger based pre-compensation*/
  tx_tbprecomp
  #(
    /* 0=20M only, 1=20M and 40M */
    .g_bandwidth_max(       1)
  )
  u_tx_tbprecomp
  (
    /* system */
    .rst_n(                 fe_rst_n),
    .clk(                   fetx_clk),
    
    /* static parameters */
    .cfg_conf_bw(           mdmcfg_conf_bw),
    .cfg_sfo_bypass(        ofdm_tx_sfo_bypass),
    .cfg_sfo_ppm(           ofdm_tx_sfo_ppm),
    .cfg_cfo_bypass(        ofdm_tx_cfo_bypass),
    .cfg_cfo_freq(          ofdm_tx_cfo_freq),
    
    /* control */
    .enable(                mfsm_ofdm_tx_blocken),
    .pipe_loaded(           ofdm_tx_pipe_loaded),
    .pipe_release(          ofdm_tx_pipe_release),
    
    /* data path */
    .in_ready(              ofdm_tx_ready),
    .in_i(                  tx_diggain_i),
    .in_q(                  tx_diggain_q),
    .in_valid(              tx_diggain_valid),
    
    .out_i(                 tx_tbprecomp_i),
    .out_q(                 tx_tbprecomp_q),
    .out_valid(             tx_tbprecomp_valid)
  );

  /*****************************************************************************
  * AGC RADAR
  *****************************************************************************/
`ifdef RW_RADAR_EN
  assign {agc_radar_i,agc_radar_q} = 
`ifdef RW_NX_DERIV_FE_PATH80M
    (mdmcfg_conf_bw==BW_80) ? {rx80dcr_i,rx80dcr_q} :
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    (mdmcfg_conf_bw==BW_40) ? {rx40dcr_i,rx40dcr_q} :
`endif
                       {rx20dcr_i,rx20dcr_q};
`endif
  
`ifdef RW_NX_DERIV_FE_PATH40M
  /*****************************************************************************
  * RX HBF40 IN MUX
  *****************************************************************************/
  assign {rxhbf40_in_valid,rxhbf40_in_i,rxhbf40_in_q,rxhbf40_in_dc_i,rxhbf40_in_dc_q} = 
`ifdef RW_NX_DERIV_FE_PATH80M
    (mdmcfg_conf_bw==BW_80) ? {rx80dcp_2t_valid,rx80dcp_2t_i,rx80dcp_2t_q,12'b0,12'b0}:
`endif
                       {rx_blocken,adc_i,adc_q,adc_dcest_i,adc_dcest_q};
`endif    
  /*****************************************************************************
  * RX HBF20 IN MUX
  *****************************************************************************/
  assign {rxhbf20_in_valid,rxhbf20_in_i,rxhbf20_in_q,rxhbf20_in_dc_i,rxhbf20_in_dc_q} = 
`ifdef RW_NX_DERIV_FE_PATH40M
    (mdmcfg_conf_bw!=BW_20) ? {rxhbf40_valid,rx40dcp_i,rx40dcp_q,12'b0,12'b0} :
`endif
                       {rx_blocken,adc_i,adc_q,adc_dcest_i,adc_dcest_q};

  /*****************************************************************************
  * RXDC BLOCKEN
  *****************************************************************************/
  assign rx20dc_blocken   = rx_blocken & mdmcfg_conf_bw==BW_20;
`ifdef RW_NX_DERIV_FE_PATH40M
  assign rx40dc_blocken   = rx_blocken & mdmcfg_conf_bw==BW_40;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  assign rx80dc_blocken   = rx_blocken & mdmcfg_conf_bw==BW_80;
`endif 

  /*****************************************************************************
  * HBF BLOCKEN
  *****************************************************************************/
  wire   rxhbf20_blocken,rxhbf40_blocken,rxhbf80_blocken;
  wire   txhbf40_blocken,txhbf80_blocken;
 
  assign rxhbf20_blocken = rx_blocken;
  assign rxhbf40_blocken = rx_blocken & (mdmcfg_conf_bw==BW_40 | mdmcfg_conf_bw==BW_80);
  assign rxhbf80_blocken = rx_blocken & (mdmcfg_conf_bw==BW_80);

`ifdef RW_NX_DERIV_80211B
  assign txhbf40_blocken = mfsm_dsss_tx_blocken & (mdmcfg_conf_bw==BW_40 | mdmcfg_conf_bw==BW_80) ;
  assign txhbf80_blocken = mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_80;
`else
  assign txhbf40_blocken = 1'b0;
  assign txhbf80_blocken = 1'b0;
`endif

  assign hbf20_blocken   = rxhbf20_blocken; 
`ifdef RW_NX_DERIV_FE_PATH40M
  assign hbf40_blocken   = rxhbf40_blocken | txhbf40_blocken; 
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  assign hbf80_blocken   = rxhbf80_blocken | txhbf80_blocken; 
`endif  
  /*****************************************************************************
  * RX HBF20 CFS (cfs=1 primary is right side ; cfs=0 primary is left side)
  *****************************************************************************/
  assign {hbf20_cfsen,hbf20_cfs} =                                                        /*   0123   */
    { 1'b1, 1'b0} & {2{rx_blocken & mdmcfg_conf_bw==BW_40 &   !mdmcfg_conf_primary[0]}} | /*   .PS.   CfgRegPSSel==2'd0,1*/
    { 1'b1, 1'b1} & {2{rx_blocken & mdmcfg_conf_bw==BW_40 &    mdmcfg_conf_primary[0]}} | /*   .SP.   CfgRegPSSel==2'd2,3*/
    { 1'b1, 1'b0} & {2{rx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd0}} | /*   PS..   CfgRegPSSel==2'd0  */
    { 1'b1, 1'b1} & {2{rx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd1}} | /*   SP..   CfgRegPSSel==2'd1  */
    { 1'b1, 1'b0} & {2{rx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd2}} | /*   ..PS   CfgRegPSSel==2'd2  */
    { 1'b1, 1'b1} & {2{rx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd3}};  /*   ..SP   CfgRegPSSel==2'd3  */
 
`ifdef RW_NX_DERIV_FE_PATH40M
  /*****************************************************************************
  * RX HBF40 CFS (cfs=1 primary is right side ; cfs=0 primary is left side)
  *****************************************************************************/
  assign {hbf40_cfsen,hbf40_cfs} =                                                        /*   0123   */
    { 1'b1, 1'b0} & {2{rx_blocken & mdmcfg_conf_bw==BW_80 & !mdmcfg_conf_primary[1]}} |   /*   PPSS   */
    { 1'b1, 1'b1} & {2{rx_blocken & mdmcfg_conf_bw==BW_80 &  mdmcfg_conf_primary[1]}};    /*   SSPP   */
 
`ifdef RW_NX_DERIV_80211B
  /*****************************************************************************
  * TX40 FS8 (cfs=1 shift spectrum right ; cfs=0 shift spectrum left)
  *****************************************************************************/
  assign {tx40fs8_cfsen,tx40fs8_cfs} =                                                              /*   0123        CFS40 CFS80 */
    { 1'b1, 1'b0} & {2{mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_40 &   !mdmcfg_conf_primary[0]}} | /*    P.    -10 =  -10    0  */
    { 1'b1, 1'b1} & {2{mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_40 &    mdmcfg_conf_primary[0]}} | /*    .P    +10 =  +10    0  */
   
    { 1'b1, 1'b0} & {2{mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd0}} | /*   P...   -30 =  -10  -20  */
    { 1'b1, 1'b1} & {2{mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd1}} | /*   .P..   -10 =  +10  -20  */
    { 1'b1, 1'b0} & {2{mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd2}} | /*   ..P.   +10 =  -10  +20  */
    { 1'b1, 1'b1} & {2{mfsm_dsss_tx_blocken & mdmcfg_conf_bw==BW_80 & mdmcfg_conf_primary==3'd3}};  /*   ...P   +30 =  +10  +20  */
`endif
`endif  
 
endmodule
`default_nettype wire
