`default_nettype none
module rsf440
(
  /*****************************************************************************
  * control (assumed synchronous from fe40_clk)
  *****************************************************************************/
  input wire         rxenable, 
  input wire         txenable, 
  
  input wire  [ 2:0] rxshift,
  input wire  [ 1:0] txshift,
  
  /*****************************************************************************
  * 40 Mhz domain
  *****************************************************************************/
  input  wire        fe40_rst_n,
  input  wire        fe40_clk,
  
  input  wire        fe40_rx_valid, 
  input  wire [12:0] fe40_rx_i,     
  input  wire [12:0] fe40_rx_q,     
  
  output wire        fe40_tx_valid, 
  output wire [11:0] fe40_tx_i,     
  output wire [11:0] fe40_tx_q,     
  
  /*****************************************************************************
  * 44 Mhz domain
  *****************************************************************************/
  input  wire        phy44_rst_n,
  input  wire        phy44_clk,
  
  output wire        phy44_rxenable,
  output wire        phy44_rx_valid,
  output wire [ 6:0] phy44_rx_i, 
  output wire [ 6:0] phy44_rx_q,
 
  input  wire        phy44_tx_valid,
  input  wire [ 6:0] phy44_tx_i, 
  input  wire [ 6:0] phy44_tx_q
);
  
  /*****************************************************************************
  * resynchro
  *****************************************************************************/
  wire       phy44_txenable;
  wire [1:0] phy44_txshift;

  ClkSyncSimple u_fe2phy44_rxenable_resync
  ( 
    .dstclk(         phy44_clk),
    .dstresetn(      phy44_rst_n),
    .srcdata(        rxenable),   
    .dstdata(        phy44_rxenable)   
  );

  ClkSyncSimple u_fe2phy44_txenable_resync
  ( 
    .dstclk(         phy44_clk),
    .dstresetn(      phy44_rst_n),
    .srcdata(        txenable),   
    .dstdata(        phy44_txenable)   
  );
 
  /* we don't mind about sampling error for this vector,
    it is stable long ago before used */
  ClkSyncSimple u_fe2phy44_txshift0_resync
  ( 
    .dstclk(         phy44_clk),
    .dstresetn(      phy44_rst_n),
    .srcdata(        txshift[0]),   
    .dstdata(        phy44_txshift[0])   
  );

  ClkSyncSimple u_fe2phy44_txshift1_resync
  ( 
    .dstclk(         phy44_clk),
    .dstresetn(      phy44_rst_n),
    .srcdata(        txshift[1]),   
    .dstdata(        phy44_txshift[1])   
  );

  /*****************************************************************************
  * TX
  *****************************************************************************/
  wire        fe44_tx_valid;
  wire [11:0] fe44_tx_i,fe44_tx_q;

  rsf440_tx_fifo u_rsf440_tx_fifo
  (
    /*****************************************************************************
    * write port 
    *****************************************************************************/
    .phy44_rst_n(    phy44_rst_n), 
    .phy44_clk(      phy44_clk), 
  
    .phy44_valid(    fe44_tx_valid),
    .phy44_i(        fe44_tx_i),     
    .phy44_q(        fe44_tx_q),     
  
    /*****************************************************************************
    * read port
    *****************************************************************************/
    .fe40_rst_n(     fe40_rst_n),
    .fe40_clk(       fe40_clk),
  
    .fe40_valid(     fe40_tx_valid),
    .fe40_i(         fe40_tx_i), 
    .fe40_q(         fe40_tx_q)
  );

  /*****************************************************************************
  * RX
  *****************************************************************************/
  wire        fe40_rx_scaled_valid;
  wire [ 7:0] fe40_rx_scaled_i,fe40_rx_scaled_q;
 
  wire        fe44_rx_ready;
  wire        fe44_rx_valid;
  wire [ 7:0] fe44_rx_i,fe44_rx_q;
 
  /* RX GAIN */
  rsf440_rx_gain u_rsf440_rx_gain_i
  (
    .rst_n(          fe40_rst_n),          
    .clk(            fe40_clk),            
    .shift(          rxshift),
    .enable(         rxenable),             
    .in_data(        fe40_rx_i),           
    .in_valid(       fe40_rx_valid),       
    .out_data(       fe40_rx_scaled_i),    
    .out_valid(      fe40_rx_scaled_valid) 
  );
  
  rsf440_rx_gain u_rsf440_rx_gain_q
  (
    .rst_n(          fe40_rst_n),
    .clk(            fe40_clk),
    .shift(          rxshift),
    .enable(         rxenable),             
    .in_data(        fe40_rx_q),
    .in_valid(       fe40_rx_valid),
    .out_data(       fe40_rx_scaled_q),
    .out_valid(      )
  );
  
  /* RX FIFO */
  rsf440_rx_fifo u_rsf440_rx_fifo
  (
    /*****************************************************************************
    * write port 
    *****************************************************************************/
    .fe40_rst_n(     fe40_rst_n),
    .fe40_clk(       fe40_clk),
  
    .fe40_valid(     fe40_rx_scaled_valid),                                                 
    .fe40_i(         fe40_rx_scaled_i),                                                     
    .fe40_q(         fe40_rx_scaled_q),                                                      
  
    /***************************************************************************** 
    * read port                                                                    
    *****************************************************************************/ 
    .phy44_rst_n(    phy44_rst_n), 
    .phy44_clk(      phy44_clk), 
  
    .phy44_ready(    fe44_rx_ready),           
    .phy44_valid(    fe44_rx_valid),            
    .phy44_i(        fe44_rx_i),                
    .phy44_q(        fe44_rx_q)
  );
  
  /*****************************************************************************
  * RSF440 FIR
  *****************************************************************************/
  /* I */
  rsf440_fir u_rsf440_i
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(          phy44_rst_n),
    .clk(            phy44_clk),
    
    /*****************************************************************************
    * RX
    *****************************************************************************/
    .rxenable(       phy44_rxenable),  
    .in_rx_ready(    fe44_rx_ready),
    .in_rx_data(     fe44_rx_i),
    .in_rx_valid(    fe44_rx_valid),
    .out_rx_data(    phy44_rx_i),
    .out_rx_valid(   phy44_rx_valid),
    
    /*****************************************************************************
    * TX
    *****************************************************************************/
    .txenable(       phy44_txenable),
    .txshift(        phy44_txshift),
    .in_tx_data(     phy44_tx_i), 
    .in_tx_valid(    phy44_tx_valid),
    .out_tx_data(    fe44_tx_i),
    .out_tx_valid(   fe44_tx_valid)
  );
  
  /* Q */
  rsf440_fir u_rsf440_q
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .rst_n(          phy44_rst_n),
    .clk(            phy44_clk),
    
    /*****************************************************************************
    * RX
    *****************************************************************************/
    .rxenable(       phy44_rxenable),  
    .in_rx_ready(    ), // timed by u_rsf440_i
    .in_rx_data(     fe44_rx_q),
    .in_rx_valid(    fe44_rx_valid),
    .out_rx_data(    phy44_rx_q),
    .out_rx_valid(   ), // timed by u_rsf440_i
    
    /*****************************************************************************
    * TX
    *****************************************************************************/
    .txenable(       phy44_txenable),
    .txshift(        phy44_txshift),
    .in_tx_data(     phy44_tx_q), 
    .in_tx_valid(    phy44_tx_valid),
    .out_tx_data(    fe44_tx_q),
    .out_tx_valid(   )  // timed by u_rsf440_i
  );

endmodule
`default_nettype wire
