`default_nettype none
module rsf440_rx_gain
(
  input  wire        rst_n,
  input  wire        clk,
  
  input  wire [ 2:0] shift,
  input  wire        enable,
  input  wire [12:0] in_data,
  input  wire        in_valid,
  
  output reg  [ 7:0] out_data,
  output reg         out_valid
);
  
  reg [14:0] data_sh;
  reg [14:0] data_fix;
  reg [ 7:0] data_sat;
  
  always @(*)
  begin
    /* data right shift */
    case(shift)                                            
      3'b000:  data_sh = {{1{in_data[12]}}, in_data,1'b0};  
      3'b001:  data_sh = {{2{in_data[12]}},      in_data};  
      3'b010:  data_sh = {{3{in_data[12]}},in_data[12:1]};  
      3'b011:  data_sh = {{4{in_data[12]}},in_data[12:2]};  
      3'b100:  data_sh = {{5{in_data[12]}},in_data[12:3]};  
      default: data_sh = {{6{in_data[12]}},in_data[12:4]};  
    endcase                                                  
  
    /* rounding fix */
    data_fix = data_sh + 15'd1;
    
    /* trunc saturation to 8 bits */
    if((data_fix[14:8]==7'b0000000) || (data_fix[14:8]==7'b1111111))
      data_sat = data_fix[8:1];
    else
      data_sat = {data_fix[14],{7{~data_fix[14]}}};
  end
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      out_data  <= 8'b0;
      out_valid <= 1'b0;
    end
    else
    begin
      if(in_valid && enable)
      begin
        out_valid <= 1'b1;
        out_data  <= data_sat;
      end
      else
      begin
        out_valid <= 1'b0;
        out_data  <= 8'd0;
      end
    end
  end  
  
endmodule
`default_nettype wire
