//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rx_dig_gain module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module rx_dig_gain
#(
  parameter g_pipeline = 0
)
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,
 
  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire  [ 3:0] gain_6db,
  input  wire  [ 5:0] gain_lin,

  /*****************************************************************************
  * data
  *****************************************************************************/
  input  wire  [12:0] in_i,
  input  wire  [12:0] in_q,
  input  wire         in_valid,
  
  output reg   [12:0] out_i,
  output reg   [12:0] out_q,
  output reg          out_valid
  
);

  /*****************************************************************************
  * gain re-registering
  *****************************************************************************/
  reg [ 3:0] gain_6db_1t;
  reg [ 5:0] gain_lin_1t;
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      gain_6db_1t <= 4'd0;    
      gain_lin_1t <= 6'd0;    
    end
    else
    begin
      gain_6db_1t <= gain_6db;    
      gain_lin_1t <= gain_lin;    
    end

  /*****************************************************************************
  * +6dB pregain 
  *****************************************************************************/
  reg [12:0] n_i_6db;
  always @(*)
  begin:b_barrel_shifter_i
    reg [22:0] v;
    /* barrel shifter */
    v={{10{in_i[12]}},in_i};
    if(gain_6db_1t[0]) v={v[22-1:0],1'b0};
    if(gain_6db_1t[1]) v={v[22-2:0],2'b0};
    if(gain_6db_1t[2]) v={v[22-4:0],4'b0};
    if(gain_6db_1t[3]) v={v[22-8:0],8'b0};
    /* 13 bits saturation */
    if((v[22:12]==11'b00000000000) || (v[22:12]==11'b11111111111))
      n_i_6db = v[12:0];
    else
      n_i_6db = {v[22],{12{~v[22]}}};
  end

  reg [12:0] n_q_6db;
  always @(*)
  begin:b_barrel_shifter_q
    reg [22:0] v;
    /* barrel shifter */
    v={{10{in_q[12]}},in_q};
    if(gain_6db_1t[0]) v={v[22-1:0],1'b0};
    if(gain_6db_1t[1]) v={v[22-2:0],2'b0};
    if(gain_6db_1t[2]) v={v[22-4:0],4'b0};
    if(gain_6db_1t[3]) v={v[22-8:0],8'b0};
    /* 13 bits saturation */
    if((v[22:12]==11'b00000000000) || (v[22:12]==11'b11111111111))
      n_q_6db = v[12:0];
    else
      n_q_6db = {v[22],{12{~v[22]}}};
  end
  
  reg [12:0] i_6db,q_6db;
  reg        valid_6db;
  
  generate if(g_pipeline!=0)
    always @(posedge clk, negedge rst_n)
      if(!rst_n)
      begin
        i_6db     <= 13'b0;
        q_6db     <= 13'b0;
        valid_6db <= 1'b0;
      end
      else
      begin
        i_6db     <= n_i_6db;
        q_6db     <= n_q_6db;
        valid_6db <= in_valid;
      end
  endgenerate
  
  generate if(g_pipeline==0)
    always @(*)
    begin
      i_6db     = n_i_6db;
      q_6db     = n_q_6db;
      valid_6db = in_valid;
    end
  endgenerate
  
  /*****************************************************************************
  * linear gain
  *****************************************************************************/
  reg  [18:0]  i_lin;
  reg  [15:0]  i_fix;
  reg  [12:0]  n_out_i;
  always @(*)
  begin
    /* [-4096 4095] * [0 63] = [-258048   257985] that fits 19 bits */
    i_lin     = $signed(i_6db) * $signed({1'b0,gain_lin_1t});
    
    /* drop 4 first lsb, add the round fix to weight 2^4 */
    i_fix = {i_lin[18],i_lin[18:4]} + 16'b1;
  
    /* drop 1 bit and saturate to 13 bit */
    if((i_fix[15:13]==3'b000) ||
       (i_fix[15:13]==3'b111))
      n_out_i = i_fix[13:1];
    else
      n_out_i = {i_fix[15],{12{~i_fix[15]}}};
  end
 
  reg  [18:0]  q_lin;
  reg  [15:0]  q_fix;
  reg  [12:0]  n_out_q;
  always @(*)
  begin
    /* [-4096 4095] * [0 63] = [-258048   257985] that fits 19 bits */
    q_lin     = $signed(q_6db) * $signed({1'b0,gain_lin_1t});
    
    /* drop 4 first lsb, add the round fix to weight 2^4 */
    q_fix = {q_lin[18],q_lin[18:4]} + 16'b1;
  
    /* drop 1 bit and saturate to 13 bit */
    if((q_fix[15:13]==3'b000) ||
       (q_fix[15:13]==3'b111))
      n_out_q = q_fix[13:1];
    else
      n_out_q = {q_fix[15],{12{~q_fix[15]}}};
  end

  generate if(g_pipeline==2)
    always @(posedge clk, negedge rst_n)
      if(!rst_n)
      begin
        out_i     <= 13'b0;
        out_q     <= 13'b0;
        out_valid <= 1'b0;
      end
      else
      begin
        out_i     <= n_out_i;
        out_q     <= n_out_q;
        out_valid <= valid_6db;
      end
  endgenerate
  
  generate if(g_pipeline!=2)
    always @(*)
    begin
      out_i     = n_out_i;
      out_q     = n_out_q;
      out_valid = valid_6db;
    end
  endgenerate


endmodule
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
