//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 9205 $
// $Date: 2013-07-23 10:08:56 +0200 (Tue, 23 Jul 2013) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of hbf40
// Simulation Notes : 
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_SDM_DS_CEL/HW/Modem/RIU/TxRxFrontEndX40/verilog/rtl/tx_dc_comp.v $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module tx_dc_comp
(
  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire  [ 7:0] offset,

  /*****************************************************************************
  * data
  *****************************************************************************/
  input  wire  [11:0] data_in,
  output reg   [11:0] data_out
);
  /*****************************************************************************
  * declaration 
  *****************************************************************************/
  wire [12:0] data_presat;

  /*****************************************************************************
  * compensation
  *****************************************************************************/
  assign data_presat = {data_in[11],data_in} + {{5{ offset[7]}},offset};
  
  /*****************************************************************************
  * saturation
  *****************************************************************************/
  always @(*)
  begin
  
    if((data_presat[12:11]==2'b00) ||
       (data_presat[12:11]==2'b11))
    
      data_out = data_presat[11:0];
    
    else
    
      data_out = {data_presat[12],{11{~data_presat[12]}}};
  
  end

endmodule
`default_nettype wire
