//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of hbf40
// Simulation Notes : 
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module tx_dig_gain
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input wire          rst_n,
  input wire          clk,

  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire  [ 6:0] gain_lin,
  input  wire         enable,

  /*****************************************************************************
  * data
  *****************************************************************************/
  input  wire         ready,
 
  input  wire  [12:0] in_i,
  input  wire  [12:0] in_q,
  input  wire         in_valid,

  output reg   [11:0] out_i,
  output reg   [11:0] out_q,
  output reg          out_valid
);
      
  /*****************************************************************************
  * linear gain
  *****************************************************************************/
  reg  [19:0]  scaled_i,scaled_q;
  reg  [11:0]  scale_rnd_sat_i,scale_rnd_sat_q;
  always @(*)
  begin
    /* [-4096 4095] * 127 = [-520192 520065] that fits 20 bits [-2^19 2^19-1]=[-524288   524287] */
    scaled_i = $signed(in_i) * $signed({1'b0,gain_lin});
    scaled_q = $signed(in_q) * $signed({1'b0,gain_lin});
    
    /* drop 6 bit and saturate to 12 bit */
    if((scaled_i[19:17]==3'b000) ||
       (scaled_i[19:17]==3'b111))
      scale_rnd_sat_i = scaled_i[17:6];
    else
      scale_rnd_sat_i = {scaled_i[19],{11{~scaled_i[19]}}};

    if((scaled_q[19:17]==3'b000) ||
       (scaled_q[19:17]==3'b111))
      scale_rnd_sat_q = scaled_q[17:6];
    else
      scale_rnd_sat_q = {scaled_q[19],{11{~scaled_q[19]}}};
  end

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      out_i     <= 12'd0;
      out_q     <= 12'd0;
      out_valid <= 1'd0;
    end
    else if(!enable)
    begin
      out_i     <= 12'd0;
      out_q     <= 12'd0;
      out_valid <= 1'd0;
    end
    else if(ready)
    begin 
      if(in_valid)
      begin
        out_i     <= scale_rnd_sat_i;
        out_q     <= scale_rnd_sat_q;
        out_valid <= 1'b1;
      end
      else
      begin
        out_valid <= 1'b0;
      end
    end
  end

endmodule

`default_nettype wire

