//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of Resampler module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module LagrangeLUT ( 
  input  wire [7:0] UAddr,

  output reg  [9:0] coeff0,
  output reg  [9:0] coeff1,
  output reg  [9:0] coeff2,
  output reg  [9:0] coeff3,
  output reg  [9:0] coeff4,
  output reg  [9:0] coeff5,
  output reg  [9:0] coeff6,
  output reg  [9:0] coeff7
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

always @(*)
begin
  case (UAddr)
    8'd0   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd0,     10'd0,    10'd511,     10'd0,     10'd0,      10'd0,     10'd0};
    8'd1   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd0,    -10'd2,    10'd511,     10'd4,    -10'd1,      10'd0,     10'd0};
    8'd2   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd1,    -10'd5,    10'd510,     10'd8,    -10'd2,      10'd1,     10'd0};
    8'd3   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd1,    -10'd7,    10'd509,    10'd12,    -10'd4,      10'd1,     10'd0};
    8'd4   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd9,    10'd507,    10'd16,    -10'd5,      10'd1,     10'd0};
    8'd5   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd11,   10'd506,    10'd21,    -10'd6,      10'd1,     10'd0};
    8'd6   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd14,   10'd504,    10'd25,    -10'd7,      10'd2,     10'd0};
    8'd7   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd16,   10'd503,    10'd29,    -10'd8,      10'd2,     10'd0};
    8'd8   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd18,   10'd501,    10'd33,    -10'd10,     10'd2,     10'd0};
    8'd9   : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd20,   10'd500,    10'd38,    -10'd11,     10'd2,     10'd0};
    8'd10  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd22,   10'd498,    10'd42,    -10'd12,     10'd3,     10'd0};
    8'd11  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd24,   10'd496,    10'd47,    -10'd13,     10'd3,     10'd0};
    8'd12  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd25,   10'd494,    10'd51,    -10'd15,     10'd3,     10'd0};
    8'd13  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd5,    -10'd27,   10'd492,    10'd56,    -10'd16,     10'd3,     10'd0};
    8'd14  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd5,    -10'd29,   10'd490,    10'd60,    -10'd17,     10'd4,     10'd0};
    8'd15  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd5,    -10'd31,   10'd488,    10'd65,    -10'd18,     10'd4,     10'd0};
    8'd16  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd32,   10'd485,    10'd69,    -10'd19,     10'd4,     10'd0};
    8'd17  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd34,   10'd483,    10'd74,    -10'd21,     10'd4,     10'd0};
    8'd18  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd36,   10'd481,    10'd79,    -10'd22,     10'd5,    -10'd1};
    8'd19  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd37,   10'd478,    10'd83,    -10'd23,     10'd5,    -10'd1};
    8'd20  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd39,   10'd476,    10'd88,    -10'd24,     10'd5,    -10'd1};
    8'd21  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd40,   10'd473,    10'd93,    -10'd25,     10'd5,    -10'd1};
    8'd22  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd41,   10'd470,    10'd98,    -10'd27,     10'd6,    -10'd1};
    8'd23  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd43,   10'd468,   10'd102,    -10'd28,     10'd6,    -10'd1};
    8'd24  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd44,   10'd465,   10'd107,    -10'd29,     10'd6,    -10'd1};
    8'd25  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd45,   10'd462,   10'd112,    -10'd30,     10'd6,    -10'd1};
    8'd26  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd46,   10'd459,   10'd117,    -10'd31,     10'd7,    -10'd1};
    8'd27  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd48,   10'd456,   10'd122,    -10'd32,     10'd7,    -10'd1};
    8'd28  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd49,   10'd453,   10'd127,    -10'd33,     10'd7,    -10'd1};
    8'd29  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd50,   10'd450,   10'd132,    -10'd34,     10'd7,    -10'd1};
    8'd30  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd51,   10'd447,   10'd137,    -10'd36,     10'd8,    -10'd1};
    8'd31  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd52,   10'd443,   10'd142,    -10'd37,     10'd8,    -10'd1};
    8'd32  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd53,   10'd440,   10'd147,    -10'd38,     10'd8,    -10'd1};
    8'd33  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd54,   10'd436,   10'd152,    -10'd39,     10'd8,    -10'd1};
    8'd34  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd55,   10'd433,   10'd157,    -10'd40,     10'd8,    -10'd1};
    8'd35  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd55,   10'd429,   10'd162,    -10'd41,     10'd9,    -10'd1};
    8'd36  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd56,   10'd426,   10'd167,    -10'd42,     10'd9,    -10'd1};
    8'd37  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd57,   10'd422,   10'd172,    -10'd43,     10'd9,    -10'd1};
    8'd38  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd57,   10'd419,   10'd177,    -10'd44,     10'd9,    -10'd1};
    8'd39  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd58,   10'd415,   10'd182,    -10'd45,     10'd9,    -10'd1};
    8'd40  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd59,   10'd411,   10'd187,    -10'd46,    10'd10,    -10'd1};
    8'd41  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd59,   10'd407,   10'd192,    -10'd47,    10'd10,    -10'd1};
    8'd42  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd60,   10'd403,   10'd197,    -10'd47,    10'd10,    -10'd1};
    8'd43  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd60,   10'd399,   10'd202,    -10'd48,    10'd10,    -10'd1};
    8'd44  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd61,   10'd395,   10'd207,    -10'd49,    10'd10,    -10'd1};
    8'd45  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd61,   10'd391,   10'd212,    -10'd50,    10'd10,    -10'd1};
    8'd46  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd61,   10'd387,   10'd217,    -10'd51,    10'd11,    -10'd1};
    8'd47  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd383,   10'd222,    -10'd52,    10'd11,    -10'd1};
    8'd48  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd379,   10'd227,    -10'd52,    10'd11,    -10'd1};
    8'd49  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd374,   10'd232,    -10'd53,    10'd11,    -10'd1};
    8'd50  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd370,   10'd237,    -10'd54,    10'd11,    -10'd1};
    8'd51  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd366,   10'd242,    -10'd55,    10'd11,    -10'd1};
    8'd52  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd361,   10'd247,    -10'd55,    10'd11,    -10'd1};
    8'd53  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd357,   10'd252,    -10'd56,    10'd11,    -10'd1};
    8'd54  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd353,   10'd257,    -10'd57,    10'd12,    -10'd1};
    8'd55  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd348,   10'd262,    -10'd57,    10'd12,    -10'd1};
    8'd56  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd344,   10'd267,    -10'd58,    10'd12,    -10'd1};
    8'd57  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd339,   10'd272,    -10'd58,    10'd12,    -10'd1};
    8'd58  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd63,   10'd334,   10'd277,    -10'd59,    10'd12,    -10'd1};
    8'd59  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd330,   10'd282,    -10'd59,    10'd12,    -10'd1};
    8'd60  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd325,   10'd287,    -10'd60,    10'd12,    -10'd1};
    8'd61  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd320,   10'd292,    -10'd60,    10'd12,    -10'd1};
    8'd62  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd316,   10'd297,    -10'd61,    10'd12,    -10'd1};
    8'd63  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd62,   10'd311,   10'd301,    -10'd61,    10'd12,    -10'd1};
    8'd64  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd61,   10'd306,   10'd306,    -10'd61,    10'd12,    -10'd1};
    8'd65  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd61,   10'd301,   10'd311,    -10'd62,    10'd12,    -10'd1};
    8'd66  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd61,   10'd297,   10'd316,    -10'd62,    10'd12,    -10'd1};
    8'd67  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd60,   10'd292,   10'd320,    -10'd62,    10'd12,    -10'd1};
    8'd68  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd60,   10'd287,   10'd325,    -10'd62,    10'd12,    -10'd1};
    8'd69  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd59,   10'd282,   10'd330,    -10'd62,    10'd12,    -10'd1};
    8'd70  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd59,   10'd277,   10'd334,    -10'd63,    10'd12,    -10'd1};
    8'd71  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd58,   10'd272,   10'd339,    -10'd63,    10'd12,    -10'd1};
    8'd72  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd58,   10'd267,   10'd344,    -10'd63,    10'd12,    -10'd1};
    8'd73  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd57,   10'd262,   10'd348,    -10'd63,    10'd12,    -10'd1};
    8'd74  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd12,    -10'd57,   10'd257,   10'd353,    -10'd63,    10'd12,    -10'd1};
    8'd75  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd56,   10'd252,   10'd357,    -10'd63,    10'd12,    -10'd1};
    8'd76  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd55,   10'd247,   10'd361,    -10'd63,    10'd12,    -10'd1};
    8'd77  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd55,   10'd242,   10'd366,    -10'd63,    10'd12,    -10'd1};
    8'd78  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd54,   10'd237,   10'd370,    -10'd62,    10'd12,    -10'd1};
    8'd79  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd53,   10'd232,   10'd374,    -10'd62,    10'd12,    -10'd1};
    8'd80  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd52,   10'd227,   10'd379,    -10'd62,    10'd12,    -10'd1};
    8'd81  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd52,   10'd222,   10'd383,    -10'd62,    10'd12,    -10'd1};
    8'd82  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd11,    -10'd51,   10'd217,   10'd387,    -10'd61,    10'd12,    -10'd1};
    8'd83  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd50,   10'd212,   10'd391,    -10'd61,    10'd12,    -10'd1};
    8'd84  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd49,   10'd207,   10'd395,    -10'd61,    10'd12,    -10'd1};
    8'd85  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd48,   10'd202,   10'd399,    -10'd60,    10'd11,    -10'd1};
    8'd86  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd47,   10'd197,   10'd403,    -10'd60,    10'd11,    -10'd1};
    8'd87  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd47,   10'd192,   10'd407,    -10'd59,    10'd11,    -10'd1};
    8'd88  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,    10'd10,    -10'd46,   10'd187,   10'd411,    -10'd59,    10'd11,    -10'd1};
    8'd89  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd45,   10'd182,   10'd415,    -10'd58,    10'd11,    -10'd1};
    8'd90  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd44,   10'd177,   10'd419,    -10'd57,    10'd11,    -10'd1};
    8'd91  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd43,   10'd172,   10'd422,    -10'd57,    10'd11,    -10'd1};
    8'd92  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd42,   10'd167,   10'd426,    -10'd56,    10'd11,    -10'd1};
    8'd93  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd9,    -10'd41,   10'd162,   10'd429,    -10'd55,    10'd10,    -10'd1};
    8'd94  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd40,   10'd157,   10'd433,    -10'd55,    10'd10,    -10'd1};
    8'd95  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd39,   10'd152,   10'd436,    -10'd54,    10'd10,    -10'd1};
    8'd96  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd38,   10'd147,   10'd440,    -10'd53,    10'd10,    -10'd1};
    8'd97  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd37,   10'd142,   10'd443,    -10'd52,    10'd10,    -10'd1};
    8'd98  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd8,    -10'd36,   10'd137,   10'd447,    -10'd51,     10'd9,    -10'd1};
    8'd99  : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd34,   10'd132,   10'd450,    -10'd50,     10'd9,    -10'd1};
    8'd100 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd33,   10'd127,   10'd453,    -10'd49,     10'd9,    -10'd1};
    8'd101 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd32,   10'd122,   10'd456,    -10'd48,     10'd9,    -10'd1};
    8'd102 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd7,    -10'd31,   10'd117,   10'd459,    -10'd46,     10'd8,    -10'd1};
    8'd103 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd30,   10'd112,   10'd462,    -10'd45,     10'd8,    -10'd1};
    8'd104 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd29,   10'd107,   10'd465,    -10'd44,     10'd8,    -10'd1};
    8'd105 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd28,   10'd102,   10'd468,    -10'd43,     10'd8,    -10'd1};
    8'd106 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd6,    -10'd27,    10'd98,   10'd470,    -10'd41,     10'd7,    -10'd1};
    8'd107 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd5,    -10'd25,    10'd93,   10'd473,    -10'd40,     10'd7,    -10'd1};
    8'd108 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd5,    -10'd24,    10'd88,   10'd476,    -10'd39,     10'd7,    -10'd1};
    8'd109 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd5,    -10'd23,    10'd83,   10'd478,    -10'd37,     10'd7,    -10'd1};
    8'd110 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = {-10'd1,     10'd5,    -10'd22,    10'd79,   10'd481,    -10'd36,     10'd6,    -10'd1};
    8'd111 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd21,    10'd74,   10'd483,    -10'd34,     10'd6,    -10'd1};
    8'd112 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd19,    10'd69,   10'd485,    -10'd32,     10'd6,    -10'd1};
    8'd113 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd18,    10'd65,   10'd488,    -10'd31,     10'd5,    -10'd1};
    8'd114 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd4,    -10'd17,    10'd60,   10'd490,    -10'd29,     10'd5,     10'd0};
    8'd115 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd16,    10'd56,   10'd492,    -10'd27,     10'd5,     10'd0};
    8'd116 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd15,    10'd51,   10'd494,    -10'd25,     10'd4,     10'd0};
    8'd117 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd13,    10'd47,   10'd496,    -10'd24,     10'd4,     10'd0};
    8'd118 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd3,    -10'd12,    10'd42,   10'd498,    -10'd22,     10'd4,     10'd0};
    8'd119 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd11,    10'd38,   10'd500,    -10'd20,     10'd3,     10'd0};
    8'd120 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd10,    10'd33,   10'd501,    -10'd18,     10'd3,     10'd0};
    8'd121 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd8,     10'd29,   10'd503,    -10'd16,     10'd3,     10'd0};
    8'd122 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd2,    -10'd7,     10'd25,   10'd504,    -10'd14,     10'd2,     10'd0};
    8'd123 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd1,    -10'd6,     10'd21,   10'd506,    -10'd11,     10'd2,     10'd0};
    8'd124 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd1,    -10'd5,     10'd16,   10'd507,     -10'd9,     10'd2,     10'd0};
    8'd125 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd1,    -10'd4,     10'd12,   10'd509,     -10'd7,     10'd1,     10'd0};
    8'd126 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd1,    -10'd2,     10'd8,    10'd510,     -10'd5,     10'd1,     10'd0};
    8'd127 : {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd0,    -10'd1,     10'd4,    10'd511,     -10'd2,     10'd0,     10'd0};
    default: {coeff0, coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7} = { 10'd0,     10'd0,     10'd0,     10'd0,    10'd511,      10'd0,     10'd0,     10'd0}; // 128

  endcase
end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
