//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of Resampler module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module ResamplerLUT ( 
  input  wire [7:0] UAddr,

  output reg  [9:0] c1P1,
  output reg  [9:0] c1P0,
  output reg  [9:0] c1M1
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

always @(*)
begin
  case (UAddr)
    8'd0   : {c1P1, c1P0, c1M1} = {  10'd0,  10'd511,    10'd0};
    8'd1   : {c1P1, c1P0, c1M1} = { -10'd1,  10'd509,    10'd5};
    8'd2   : {c1P1, c1P0, c1M1} = { -10'd2,  10'd506,   10'd10};
    8'd3   : {c1P1, c1P0, c1M1} = { -10'd4,  10'd504,   10'd16};
    8'd4   : {c1P1, c1P0, c1M1} = { -10'd5,  10'd501,   10'd21};
    8'd5   : {c1P1, c1P0, c1M1} = { -10'd6,  10'd498,   10'd26};
    8'd6   : {c1P1, c1P0, c1M1} = { -10'd7,  10'd495,   10'd31};
    8'd7   : {c1P1, c1P0, c1M1} = { -10'd8,  10'd492,   10'd36};
    8'd8   : {c1P1, c1P0, c1M1} = { -10'd9,  10'd489,   10'd41};
    8'd9   : {c1P1, c1P0, c1M1} = {-10'd10,  10'd486,   10'd46};
    8'd10  : {c1P1, c1P0, c1M1} = {-10'd11,  10'd483,   10'd51};
    8'd11  : {c1P1, c1P0, c1M1} = {-10'd12,  10'd480,   10'd56};
    8'd12  : {c1P1, c1P0, c1M1} = {-10'd13,  10'd477,   10'd61};
    8'd13  : {c1P1, c1P0, c1M1} = {-10'd14,  10'd474,   10'd66};
    8'd14  : {c1P1, c1P0, c1M1} = {-10'd15,  10'd471,   10'd71};
    8'd15  : {c1P1, c1P0, c1M1} = {-10'd16,  10'd468,   10'd76};
    8'd16  : {c1P1, c1P0, c1M1} = {-10'd17,  10'd465,   10'd81};
    8'd17  : {c1P1, c1P0, c1M1} = {-10'd18,  10'd462,   10'd86};
    8'd18  : {c1P1, c1P0, c1M1} = {-10'd19,  10'd459,   10'd91};
    8'd19  : {c1P1, c1P0, c1M1} = {-10'd19,  10'd455,   10'd95};
    8'd20  : {c1P1, c1P0, c1M1} = {-10'd20,  10'd452,  10'd100};
    8'd21  : {c1P1, c1P0, c1M1} = {-10'd21,  10'd449,  10'd105};
    8'd22  : {c1P1, c1P0, c1M1} = {-10'd22,  10'd446,  10'd110};
    8'd23  : {c1P1, c1P0, c1M1} = {-10'd23,  10'd443,  10'd115};
    8'd24  : {c1P1, c1P0, c1M1} = {-10'd23,  10'd439,  10'd119};
    8'd25  : {c1P1, c1P0, c1M1} = {-10'd24,  10'd436,  10'd124};
    8'd26  : {c1P1, c1P0, c1M1} = {-10'd25,  10'd433,  10'd129};
    8'd27  : {c1P1, c1P0, c1M1} = {-10'd26,  10'd430,  10'd134};
    8'd28  : {c1P1, c1P0, c1M1} = {-10'd26,  10'd426,  10'd138};
    8'd29  : {c1P1, c1P0, c1M1} = {-10'd27,  10'd423,  10'd143};
    8'd30  : {c1P1, c1P0, c1M1} = {-10'd28,  10'd420,  10'd148};
    8'd31  : {c1P1, c1P0, c1M1} = {-10'd28,  10'd416,  10'd152};
    8'd32  : {c1P1, c1P0, c1M1} = {-10'd29,  10'd413,  10'd157};
    8'd33  : {c1P1, c1P0, c1M1} = {-10'd29,  10'd409,  10'd161};
    8'd34  : {c1P1, c1P0, c1M1} = {-10'd30,  10'd406,  10'd166};
    8'd35  : {c1P1, c1P0, c1M1} = {-10'd31,  10'd403,  10'd171};
    8'd36  : {c1P1, c1P0, c1M1} = {-10'd31,  10'd399,  10'd175};
    8'd37  : {c1P1, c1P0, c1M1} = {-10'd32,  10'd396,  10'd180};
    8'd38  : {c1P1, c1P0, c1M1} = {-10'd32,  10'd392,  10'd184};
    8'd39  : {c1P1, c1P0, c1M1} = {-10'd33,  10'd389,  10'd189};
    8'd40  : {c1P1, c1P0, c1M1} = {-10'd33,  10'd385,  10'd193};
    8'd41  : {c1P1, c1P0, c1M1} = {-10'd33,  10'd381,  10'd197};
    8'd42  : {c1P1, c1P0, c1M1} = {-10'd34,  10'd378,  10'd202};
    8'd43  : {c1P1, c1P0, c1M1} = {-10'd34,  10'd374,  10'd206};
    8'd44  : {c1P1, c1P0, c1M1} = {-10'd35,  10'd371,  10'd211};
    8'd45  : {c1P1, c1P0, c1M1} = {-10'd35,  10'd367,  10'd215};
    8'd46  : {c1P1, c1P0, c1M1} = {-10'd35,  10'd363,  10'd219};
    8'd47  : {c1P1, c1P0, c1M1} = {-10'd36,  10'd360,  10'd224};
    8'd48  : {c1P1, c1P0, c1M1} = {-10'd36,  10'd356,  10'd228};
    8'd49  : {c1P1, c1P0, c1M1} = {-10'd36,  10'd352,  10'd232};
    8'd50  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd349,  10'd237};
    8'd51  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd345,  10'd241};
    8'd52  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd341,  10'd245};
    8'd53  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd337,  10'd249};
    8'd54  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd333,  10'd253};
    8'd55  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd330,  10'd258};
    8'd56  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd326,  10'd262};
    8'd57  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd322,  10'd266};
    8'd58  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd318,  10'd270};
    8'd59  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd314,  10'd274};
    8'd60  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd310,  10'd278};
    8'd61  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd306,  10'd282};
    8'd62  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd302,  10'd286};
    8'd63  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd298,  10'd290};
    8'd64  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd294,  10'd294};
    8'd65  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd290,  10'd298};
    8'd66  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd286,  10'd302};
    8'd67  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd282,  10'd306};
    8'd68  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd278,  10'd310};
    8'd69  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd274,  10'd314};
    8'd70  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd270,  10'd318};
    8'd71  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd266,  10'd322};
    8'd72  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd262,  10'd326};
    8'd73  : {c1P1, c1P0, c1M1} = {-10'd38,  10'd258,  10'd330};
    8'd74  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd253,  10'd333};
    8'd75  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd249,  10'd337};
    8'd76  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd245,  10'd341};
    8'd77  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd241,  10'd345};
    8'd78  : {c1P1, c1P0, c1M1} = {-10'd37,  10'd237,  10'd349};
    8'd79  : {c1P1, c1P0, c1M1} = {-10'd36,  10'd232,  10'd352};
    8'd80  : {c1P1, c1P0, c1M1} = {-10'd36,  10'd228,  10'd356};
    8'd81  : {c1P1, c1P0, c1M1} = {-10'd36,  10'd224,  10'd360};
    8'd82  : {c1P1, c1P0, c1M1} = {-10'd35,  10'd219,  10'd363};
    8'd83  : {c1P1, c1P0, c1M1} = {-10'd35,  10'd215,  10'd367};
    8'd84  : {c1P1, c1P0, c1M1} = {-10'd35,  10'd211,  10'd371};
    8'd85  : {c1P1, c1P0, c1M1} = {-10'd34,  10'd206,  10'd374};
    8'd86  : {c1P1, c1P0, c1M1} = {-10'd34,  10'd202,  10'd378};
    8'd87  : {c1P1, c1P0, c1M1} = {-10'd33,  10'd197,  10'd381};
    8'd88  : {c1P1, c1P0, c1M1} = {-10'd33,  10'd193,  10'd385};
    8'd89  : {c1P1, c1P0, c1M1} = {-10'd33,  10'd189,  10'd389};
    8'd90  : {c1P1, c1P0, c1M1} = {-10'd32,  10'd184,  10'd392};
    8'd91  : {c1P1, c1P0, c1M1} = {-10'd32,  10'd180,  10'd396};
    8'd92  : {c1P1, c1P0, c1M1} = {-10'd31,  10'd175,  10'd399};
    8'd93  : {c1P1, c1P0, c1M1} = {-10'd31,  10'd171,  10'd403};
    8'd94  : {c1P1, c1P0, c1M1} = {-10'd30,  10'd166,  10'd406};
    8'd95  : {c1P1, c1P0, c1M1} = {-10'd29,  10'd161,  10'd409};
    8'd96  : {c1P1, c1P0, c1M1} = {-10'd29,  10'd157,  10'd413};
    8'd97  : {c1P1, c1P0, c1M1} = {-10'd28,  10'd152,  10'd416};
    8'd98  : {c1P1, c1P0, c1M1} = {-10'd28,  10'd148,  10'd420};
    8'd99  : {c1P1, c1P0, c1M1} = {-10'd27,  10'd143,  10'd423};
    8'd100 : {c1P1, c1P0, c1M1} = {-10'd26,  10'd138,  10'd426};
    8'd101 : {c1P1, c1P0, c1M1} = {-10'd26,  10'd134,  10'd430};
    8'd102 : {c1P1, c1P0, c1M1} = {-10'd25,  10'd129,  10'd433};
    8'd103 : {c1P1, c1P0, c1M1} = {-10'd24,  10'd124,  10'd436};
    8'd104 : {c1P1, c1P0, c1M1} = {-10'd23,  10'd119,  10'd439};
    8'd105 : {c1P1, c1P0, c1M1} = {-10'd23,  10'd115,  10'd443};
    8'd106 : {c1P1, c1P0, c1M1} = {-10'd22,  10'd110,  10'd446};
    8'd107 : {c1P1, c1P0, c1M1} = {-10'd21,  10'd105,  10'd449};
    8'd108 : {c1P1, c1P0, c1M1} = {-10'd20,  10'd100,  10'd452};
    8'd109 : {c1P1, c1P0, c1M1} = {-10'd19,   10'd95,  10'd455};
    8'd110 : {c1P1, c1P0, c1M1} = {-10'd19,   10'd91,  10'd459};
    8'd111 : {c1P1, c1P0, c1M1} = {-10'd18,   10'd86,  10'd462};
    8'd112 : {c1P1, c1P0, c1M1} = {-10'd17,   10'd81,  10'd465};
    8'd113 : {c1P1, c1P0, c1M1} = {-10'd16,   10'd76,  10'd468};
    8'd114 : {c1P1, c1P0, c1M1} = {-10'd15,   10'd71,  10'd471};
    8'd115 : {c1P1, c1P0, c1M1} = {-10'd14,   10'd66,  10'd474};
    8'd116 : {c1P1, c1P0, c1M1} = {-10'd13,   10'd61,  10'd477};
    8'd117 : {c1P1, c1P0, c1M1} = {-10'd12,   10'd56,  10'd480};
    8'd118 : {c1P1, c1P0, c1M1} = {-10'd11,   10'd51,  10'd483};
    8'd119 : {c1P1, c1P0, c1M1} = {-10'd10,   10'd46,  10'd486};
    8'd120 : {c1P1, c1P0, c1M1} = { -10'd9,   10'd41,  10'd489};
    8'd121 : {c1P1, c1P0, c1M1} = { -10'd8,   10'd36,  10'd492};
    8'd122 : {c1P1, c1P0, c1M1} = { -10'd7,   10'd31,  10'd495};
    8'd123 : {c1P1, c1P0, c1M1} = { -10'd6,   10'd26,  10'd498};
    8'd124 : {c1P1, c1P0, c1M1} = { -10'd5,   10'd21,  10'd501};
    8'd125 : {c1P1, c1P0, c1M1} = { -10'd4,   10'd16,  10'd504};
    8'd126 : {c1P1, c1P0, c1M1} = { -10'd2,   10'd10,  10'd506};
    8'd127 : {c1P1, c1P0, c1M1} = { -10'd1,    10'd5,  10'd509};
    default: {c1P1, c1P0, c1M1} = {  10'd0,    10'd0,  10'd511}; // 128
  endcase
end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
