`default_nettype none
module tx_tbprecomp
#(
  parameter g_bandwidth_max = 32'd1
)
( 
  input  wire         clk,
  input  wire         rst_n,
  
  input  wire  [ 1:0] cfg_conf_bw,
  input  wire         cfg_sfo_bypass,
  input  wire  [26:0] cfg_sfo_ppm,
  input  wire         cfg_cfo_bypass,
  input  wire  [24:0] cfg_cfo_freq,
   
  input  wire         enable,
  output reg          pipe_loaded,
  input  wire         pipe_release,
  
  output reg          in_ready,
  input  wire [11:0]  in_i,
  input  wire [11:0]  in_q,
  input  wire         in_valid,
  
  output wire [11:0]  out_i,
  output wire [11:0]  out_q,
  output wire         out_valid
);

  reg  [24:0] angle;
  wire        enable_cfo;
  wire [11:0] focomp_i;
  wire [11:0] focomp_q;
  wire        focomp_valid;
  reg  [11:0] mux_i;
  reg  [11:0] mux_q;
  reg         mux_valid;
  wire [11:0] resampler_i;
  wire [11:0] resampler_q;
  wire        resampler_valid;
  reg  [11:0] outslot_i;
  reg  [11:0] outslot_q;
  reg         outslot_valid;
  wire        stall;
  
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      angle <= 'd0;
    end
    else if(!enable || cfg_cfo_bypass)
    begin
      angle <= cfg_cfo_freq;
    end
    else
    begin
      if(!stall)
      begin
        if(in_valid)
          angle  <= angle + cfg_cfo_freq;
      end
    end
  end
  
  assign enable_cfo = enable & !cfg_cfo_bypass;
 
  TxTdFoCordicRotTop 
  #(
    .NPIPE(         6), 
    .NCOMBSTG(      2), 
    .SCALING(       1), 
    .DATAWIDTH(    12), 
    .ANGLEWIDTH(   25)  
  ) 
  U_CordicRotFlowCtrl 
  (
    //Clock and Reset
    .nPhyRst(      rst_n),
    .PhyClk(       clk),
    //Control Signals
    .Enable(       enable_cfo),
    .stall(        stall),
    .AngleIn(      angle),
    // Input data
    .DataInValid(  in_valid),
    .ReDataIn0(    in_i),
    .ImDataIn0(    in_q),
    //Compensated data
    .DataOutValid( focomp_valid),
    .ReDataOut0(   focomp_i),
    .ImDataOut0(   focomp_q)
  );

  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      mux_i     <= 12'd0;
      mux_q     <= 12'd0;
      mux_valid <= 1'b0;
    end
    else if(!enable)
    begin
      mux_i     <= 12'd0;
      mux_q     <= 12'd0;
      mux_valid <= 1'b0;
    end
    else
    begin
      if(!stall)
      begin
        if(cfg_cfo_bypass)
        begin                                     
          mux_i     <= in_i;                      
          mux_q     <= in_q;                      
          mux_valid <= in_valid;                  
        end                                       
        else                                      
        begin                                     
          mux_i     <= focomp_i;                  
          mux_q     <= focomp_q;                  
          mux_valid <= focomp_valid;  
        end                                       
      end
    end
  end
  
  /*****************************************************************************
  * SOCOMP 
  *****************************************************************************/
  Resampler 
  #(
    .g_bandwidth_max( g_bandwidth_max),
    .DWIDTH(          12)
  ) 
  U_Resampler 
  (
    .Clk(              clk),
    .nRst(             rst_n),
    .Enable(           enable),
    .stall(            stall),
    .ResamplingBypass( cfg_sfo_bypass),
    .CfgDeltaT(        cfg_sfo_ppm),
    .CfgBw(            cfg_conf_bw),
    .DataInI(          mux_i),
    .DataInQ(          mux_q),
    .DataInValid(      mux_valid),
    .DataOutI(         resampler_i),
    .DataOutQ(         resampler_q),
    .DataOutValid(     resampler_valid)
  );
  
  
  /*****************************************************************************
  * output slot 
  *****************************************************************************/
  assign stall = ~in_ready;
  
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      outslot_i     <= 12'b0;
      outslot_q     <= 12'b0;
      outslot_valid <= 1'b0;
      in_ready      <= 1'b0;
      pipe_loaded   <= 1'b0;
    end
    else if(!enable)
    begin
      outslot_i     <= 12'b0;
      outslot_q     <= 12'b0;
      outslot_valid <= 1'b0;
      in_ready    <= 1'b0;
      pipe_loaded <= 1'b0;
    end
    else
    begin
      if(!pipe_loaded)
      begin
        if(!resampler_valid)
        begin
          in_ready <= 1'b1;
        end
        else
        begin
          outslot_i   <= resampler_i;
          outslot_q   <= resampler_q;
          in_ready    <= 1'b0;
          pipe_loaded <= 1'b1;
        end
      end
      else
      begin
        if(pipe_release)
        begin
          in_ready <= 1'b1;
          if(!in_ready)
          begin
            outslot_valid <= 1'b1;
          end
          else
          begin
            if(resampler_valid)
            begin
              outslot_i     <= resampler_i;
              outslot_q     <= resampler_q;
              outslot_valid <= 1'b1;
            end
            else
            begin
              /* end of frame */
              outslot_i     <= 12'd0;
              outslot_q     <= 12'd0;
              outslot_valid <= 1'b0;
            end
          end
        end
      end
    end
  end
  
  assign {out_valid,out_q,out_i} = {outslot_valid,outslot_q,outslot_i} & {25{!stall}};
  
  
endmodule
`default_nettype none
