//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: agrunert $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 29891 $
// $Date: 2017-02-27 12:06:08 +0100 (Mon, 27 Feb 2017) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of IQImbalance module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module IQImbalance( 
  /*****************************************************************************
  * resets
  *****************************************************************************/
  input  wire        nFERst,
`ifdef RW_NX_FIQ_COMP_EN
  input  wire        nFENoWdRst, // no asserted in case of watchdog reset
`endif // RW_NX_FIQ_COMP_EN

  /*****************************************************************************
  * clocks
  *****************************************************************************/
  input  wire        FERx0Clk,
  input  wire        FETxRx0Clk,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        FETxRx1Clk,
`endif

  /*****************************************************************************
  * registers (asynchronous)
  *****************************************************************************/
  input  wire        CfgRegTxIQGainCompEn0,
  input  wire        CfgRegTxIQPhaseCompEn0,
  input  wire [10:0] CfgRegTxIQGain0,
  input  wire [ 8:0] CfgRegTxIQPhase0,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        CfgRegTxIQGainCompEn1,
  input  wire        CfgRegTxIQPhaseCompEn1,
  input  wire [10:0] CfgRegTxIQGain1,
  input  wire [ 8:0] CfgRegTxIQPhase1,
`endif
  //
  input  wire [ 1:0] CfgRegCBW,
  input  wire        CfgRegRxIQEstIterClr,
  input  wire [7:0]  CfgRegRxIQEstSNRMin,
  input  wire [3:0]  CfgRegRxIQEstMCSMin,
  input  wire [2:0]  CfgRegRxIQEstBWList,
  input  wire [7:0]  CfgRegRxIQEstFOMin,
  input  wire        CfgRegRxIQPhaseEstEn,
  input  wire        CfgRegRxIQGainEstEn,
  input  wire        CfgRegRxIQGainCompEn,
  input  wire        CfgRegRxIQPhaseCompEn,
  input  wire [2:0]  CfgRegRxIQEstDel,
  input  wire [2:0]  CfgRegRxIQEstGainStepInit,
  input  wire [2:0]  CfgRegRxIQEstGainStepStop,
  input  wire [2:0]  CfgRegRxIQEstPhaseStepInit,
  input  wire [2:0]  CfgRegRxIQEstPhaseStepStop,
  input  wire [2:0]  CfgRegRxIQEstStepDel0,
  input  wire [2:0]  CfgRegRxIQEstStepDel1,
  input  wire [2:0]  CfgRegRxIQEstStepDel2,
  input  wire [2:0]  CfgRegRxIQEstStepDel3,
  input  wire [2:0]  CfgRegRxIQEstStepDel4,
  //
  input  wire [10:0] CfgRegRxIQGain0,
  input  wire [8:0]  CfgRegRxIQPhase0,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire [10:0] CfgRegRxIQGain1,
  input  wire [8:0]  CfgRegRxIQPhase1,
`endif
  //
  output wire [21:0] StRegRxIQEstVarI0,
  output wire [21:0] StRegRxIQEstVarQ0,
  output wire [22:0] StRegRxIQEstMIQ0,
  output wire [10:0] StRegRxIQEstIQGainEst0,
  output wire [8:0]  StRegRxIQEstIQPhaseEst0,
  output wire        StRegRxIQEstValid,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [21:0] StRegRxIQEstVarI1,
  output wire [21:0] StRegRxIQEstVarQ1,
  output wire [22:0] StRegRxIQEstMIQ1,
  output wire [10:0] StRegRxIQEstIQGainEst1,
  output wire [8:0]  StRegRxIQEstIQPhaseEst1,
`endif

  /*****************************************************************************
  * Converters (FEClk)
  *****************************************************************************/
  /* ADC */
  input  wire        ADCEn,
  input  wire [11:0] ADCI0,
  input  wire [11:0] ADCQ0,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire [11:0] ADCI1,
  input  wire [11:0] ADCQ1,
`endif
  
  /* DAC */
  output wire        DACEn0,
  output wire [11:0] DACI0,
  output wire [11:0] DACQ0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire        DACEn1,
  output wire [11:0] DACI1,
  output wire [11:0] DACQ1,
`endif
 
  /*****************************************************************************
  * FE interface
  *****************************************************************************/
  /* FE Tx input */
  input  wire        FETxEn0,
  input  wire [11:0] FETxI0,
  input  wire [11:0] FETxQ0,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        FETxEn1,
  input  wire [11:0] FETxI1,
  input  wire [11:0] FETxQ1,
`endif

  /* FE Rx input */
  input wire  [12:0] FERx20I0,
  input wire  [12:0] FERx20Q0,
`ifdef RW_NX_DERIV_FE_PATH40M
  input wire  [12:0] FERx40I0,    
  input wire  [12:0] FERx40Q0,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input wire  [12:0] FERx80I0,
  input wire  [12:0] FERx80Q0,
`endif
`ifdef RW_NX_DERIV_FE_PATH1
  input wire  [12:0] FERx20I1,
  input wire  [12:0] FERx20Q1,
`ifdef RW_NX_DERIV_FE_PATH40M
  input wire  [12:0] FERx40I1,    
  input wire  [12:0] FERx40Q1,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input wire  [12:0] FERx80I1,
  input wire  [12:0] FERx80Q1,
`endif
`endif

  /* FE Rx output */
  output wire [11:0] FERxI0,
  output wire [11:0] FERxQ0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [11:0] FERxI1,
  output wire [11:0] FERxQ1,
`endif

  /*****************************************************************************
  * Control from AGC
  *****************************************************************************/
  input  wire        RxIQEstGainAccEn,
  input  wire        RxIQEstPhaseAccEn,
  input  wire [7:0]  SNR,
  input  wire        AGCLock,
  //
  input  wire        RxIQCompEn,

  /*****************************************************************************
  * Control from Modem
  *****************************************************************************/
  input wire         OFDMTxBlockEn,
`ifdef RW_NX_DERIV_80211B
  input wire         DSSSTxBlockEn,
`endif
  //
  input  wire        FrameLeg,
  input  wire        FrameVHT,
  input  wire [3:0]  LegRate,
  input  wire [6:0]  MCS,
  input  wire        BWEq20,
  input  wire        BWEq40,
  input  wire        BWEq80,
  input  wire [7:0]  FOEst
  
`ifdef RW_NX_FIQ_COMP_EN
  ,
  /*****************************************************************************
  * fIQ imbalance 
  *****************************************************************************/
  // Controls
  input  wire        fIQCollStartP,
  output wire        fIQCollDone,
  input  wire        fIQEstStartP,
  output wire        fIQEstDone,
  // registers (no timing dependency or have an associated valid flag)
  input  wire        CfgRegfIQCalEn,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        CfgRegfIQPathSel,
`endif  
  input  wire        CfgRegfIQTxRx,
  input  wire        CfgRegfIQTxBypass,
  input  wire        CfgRegfIQRxBypass,
  input  wire        CfgRegfIQCollPath,
  input  wire [ 7:0] CfgRegfIQCollWrOffset,
  input  wire [ 7:0] CfgRegfIQCollRdOffset,
  input  wire [ 7:0] CfgRegfIQCollSize,
  input  wire [ 7:0] CfgRegfIQEstIOffset,
  input  wire [ 7:0] CfgRegfIQEstQOffset,
  input  wire [ 7:0] CfgRegfIQEstSize,
  input  wire [ 4:0] CfgRegfIQTxDel,
  input  wire [ 4:0] CfgRegfIQRxDel,
  input  wire [ 7:0] CfgRegfIQCollDel,
  input  wire [ 3:0] CfgRegfIQEstStep,
  input  wire [15:0] CfgRegfIQEstNite,
  input  wire [15:0] CfgRegfIQCoeff0,
  input  wire [15:0] CfgRegfIQCoeff1,
  input  wire [15:0] CfgRegfIQCoeff2,
  input  wire [15:0] CfgRegfIQCoeff3,
  input  wire [15:0] CfgRegfIQCoeff4,
  input  wire [15:0] CfgRegfIQCoeff5,
  input  wire [15:0] CfgRegfIQCoeff6,
  input  wire [15:0] CfgRegfIQCoeff7,
  input  wire [15:0] CfgRegfIQCoeff8,
  input  wire [15:0] CfgRegfIQCoeff9,
  input  wire [15:0] CfgRegfIQCoeff10,
  input  wire [15:0] CfgRegfIQCoeff11,
  input  wire [15:0] CfgRegfIQCoeff12,
  input  wire [15:0] CfgRegfIQCoeff13,
  input  wire [15:0] CfgRegfIQCoeff14,
  input  wire [15:0] CfgRegfIQCoeff15,
  input  wire [15:0] CfgRegfIQCoeff16,
  input  wire [15:0] CfgRegfIQCoeff17,
  input  wire [15:0] CfgRegfIQCoeff18,
  input  wire [15:0] CfgRegfIQCoeff19,
  input  wire        CfgRegfIQCoeffUpdate,
  // Status
  output wire        StRegfIQToggle0,
  output wire [12:0] StRegfIQRxEstError0,
  output wire [12:0] StRegfIQTxEstError0,
  output wire [15:0] StRegfIQCoeff0,
  output wire [15:0] StRegfIQCoeff1,
  output wire [15:0] StRegfIQCoeff2,
  output wire [15:0] StRegfIQCoeff3,
  output wire [15:0] StRegfIQCoeff4,
  output wire [15:0] StRegfIQCoeff5,
  output wire [15:0] StRegfIQCoeff6,
  output wire [15:0] StRegfIQCoeff7,
  output wire [15:0] StRegfIQCoeff8,
  output wire [15:0] StRegfIQCoeff9,
  output wire [15:0] StRegfIQCoeff10,
  output wire [15:0] StRegfIQCoeff11,
  output wire [15:0] StRegfIQCoeff12,
  output wire [15:0] StRegfIQCoeff13,
  output wire [15:0] StRegfIQCoeff14,
  output wire [15:0] StRegfIQCoeff15,
  output wire [15:0] StRegfIQCoeff16,
  output wire [15:0] StRegfIQCoeff17,
  output wire [15:0] StRegfIQCoeff18,
  output wire [15:0] StRegfIQCoeff19,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire        StRegfIQToggle1,
  output wire [12:0] StRegfIQRxEstError1,
  output wire [12:0] StRegfIQTxEstError1,
`endif
  // RAM interface
  output wire [7:0]  RamAddr,
  output wire        RamRdEn,
  output wire        RamWrEn,
  output wire [63:0] RamWrData,
  input  wire [63:0] RamRdData,
  // Debug port
  output wire [15:0] Dbg0
`endif // RW_NX_FIQ_COMP_EN

  );


//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

  // Tx/Rx mux
  wire        TxBlockEn;
  wire        iq_gain_comp_en0;
  wire        iq_phase_comp_en0;
  wire [10:0] iq_gain0;
  wire [8:0]  iq_phase0;
  wire [11:0] in_i0;
  wire [11:0] in_q0;
  wire        in_en0;
  wire [11:0] out_i0;
  wire [11:0] out_q0;
  wire        out_en0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire        iq_gain_comp_en1;
  wire        iq_phase_comp_en1;
  wire [10:0] iq_gain1;
  wire [8:0]  iq_phase1;
  wire [11:0] in_i1;
  wire [11:0] in_q1;
  wire        in_en1;
  wire [11:0] out_i1;
  wire [11:0] out_q1;
  wire        out_en1;
`endif

  // RX IQ estimates
  wire        rx_iq_gain_comp_en;
  wire        rx_iq_phase_comp_en;
  wire [10:0] rx_iq_gain_est0;
  wire [8:0]  rx_iq_phase_est0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire [10:0] rx_iq_gain_est1;
  wire [8:0]  rx_iq_phase_est1;
`endif

  // fIQ imbalance
  wire [11:0] rxfIQCompDataI0;
  wire [11:0] rxfIQCompDataQ0;
  wire        rxfIQCompValid0;
  wire        txfIQInValid0; 
  wire [11:0] txfIQInDataI0;
  wire [11:0] txfIQInDataQ0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire [11:0] rxfIQCompDataI1;
  wire [11:0] rxfIQCompDataQ1;
  wire        rxfIQCompValid1;
  wire        txfIQInValid1; 
  wire [11:0] txfIQInDataI1;
  wire [11:0] txfIQInDataQ1;
`endif

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  /*****************************************************************************
  * TX/RX IQ COMPENSATION
  *****************************************************************************/

  // IQ COMPENSATION MUX
  assign TxBlockEn = OFDMTxBlockEn
`ifdef RW_NX_DERIV_80211B
                   | DSSSTxBlockEn
`endif
                                  ;
  
  assign rx_iq_gain_comp_en  = RxIQCompEn & CfgRegRxIQGainCompEn;
  assign rx_iq_phase_comp_en = RxIQCompEn & CfgRegRxIQPhaseCompEn;

  assign iq_gain_comp_en0  = (TxBlockEn) ? CfgRegTxIQGainCompEn0  : rx_iq_gain_comp_en;
  assign iq_phase_comp_en0 = (TxBlockEn) ? CfgRegTxIQPhaseCompEn0 : rx_iq_phase_comp_en;
  assign iq_gain0          = (TxBlockEn) ? CfgRegTxIQGain0        : rx_iq_gain_est0;
  assign iq_phase0         = (TxBlockEn) ? CfgRegTxIQPhase0       : rx_iq_phase_est0;
  assign in_i0             = (TxBlockEn) ? FETxI0                 : rxfIQCompDataI0;
  assign in_q0             = (TxBlockEn) ? FETxQ0                 : rxfIQCompDataQ0;
  assign in_en0            = (TxBlockEn) ? FETxEn0                : rxfIQCompValid0;
  //
  assign txfIQInDataI0     = (TxBlockEn) ? out_i0                 : 12'b0;
  assign txfIQInDataQ0     = (TxBlockEn) ? out_q0                 : 12'b0;
  assign txfIQInValid0     = (TxBlockEn) ? out_en0                : 1'b0;
  //
  assign FERxI0            = (TxBlockEn) ? 12'b0                  : out_i0;
  assign FERxQ0            = (TxBlockEn) ? 12'b0                  : out_q0;

  iq_comp u_txrx_iq_comp0 (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .reset_n(               nFERst),
    .clk(                   FETxRx0Clk),
    /*****************************************************************************
    * control
    *****************************************************************************/
    .iq_gain_comp_en(       iq_gain_comp_en0),
    .iq_phase_comp_en(      iq_phase_comp_en0),
    .iq_gain(               iq_gain0),
    .iq_phase(              iq_phase0),
    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  in_i0),
    .in_q(                  in_q0),
    .in_en(                 in_en0),
    .out_i(                 out_i0),
    .out_q(                 out_q0),
    .out_en(                out_en0)
  );

`ifdef RW_NX_DERIV_FE_PATH1
  // IQ COMPENSATION MUX
  assign iq_gain_comp_en1  = (TxBlockEn) ? CfgRegTxIQGainCompEn1  : rx_iq_gain_comp_en;
  assign iq_phase_comp_en1 = (TxBlockEn) ? CfgRegTxIQPhaseCompEn1 : rx_iq_phase_comp_en;
  assign iq_gain1          = (TxBlockEn) ? CfgRegTxIQGain1        : rx_iq_gain_est1;
  assign iq_phase1         = (TxBlockEn) ? CfgRegTxIQPhase1       : rx_iq_phase_est1;
  assign in_i1             = (TxBlockEn) ? FETxI1                 : rxfIQCompDataI1;
  assign in_q1             = (TxBlockEn) ? FETxQ1                 : rxfIQCompDataQ1;
  assign in_en1            = (TxBlockEn) ? FETxEn1                : rxfIQCompValid1;
  //
  assign txfIQInDataI1     = (TxBlockEn) ? out_i1                 : 12'b0;
  assign txfIQInDataQ1     = (TxBlockEn) ? out_q1                 : 12'b0;
  assign txfIQInValid1     = (TxBlockEn) ? out_en1                : 1'b0;
  //
  assign FERxI1            = (TxBlockEn) ? 12'b0                  : out_i1;
  assign FERxQ1            = (TxBlockEn) ? 12'b0                  : out_q1;

  iq_comp u_txrx_iq_comp1 (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .reset_n(               nFERst),
    .clk(                   FETxRx1Clk),
    /*****************************************************************************
    * control
    *****************************************************************************/
    .iq_gain_comp_en(       iq_gain_comp_en1),
    .iq_phase_comp_en(      iq_phase_comp_en1),
    .iq_gain(               iq_gain1),
    .iq_phase(              iq_phase1),
    /*****************************************************************************
    * data
    *****************************************************************************/
    .in_i(                  in_i1),
    .in_q(                  in_q1),
    .in_en(                 in_en1),
    .out_i(                 out_i1),
    .out_q(                 out_q1),
    .out_en(                out_en1)
  );
`endif

  /*****************************************************************************
  * RX IQ ESTIMATION
  *****************************************************************************/
  iq_est u_iq_est (
    .clk                              (FERx0Clk),
    .reset_n                          (nFERst),
    //
    .reg_cbw                          (CfgRegCBW),
    .reg_iq_est_iter_clr              (CfgRegRxIQEstIterClr),
    .reg_iq_est_snr_min               (CfgRegRxIQEstSNRMin),
    .reg_iq_est_mcs_min               (CfgRegRxIQEstMCSMin),
    .reg_iq_est_bw_list               (CfgRegRxIQEstBWList),
    .reg_iq_est_fo_min                (CfgRegRxIQEstFOMin),
    .reg_iq_est_phase_en              (CfgRegRxIQPhaseEstEn),
    .reg_iq_est_gain_en               (CfgRegRxIQGainEstEn),
    .reg_iq_est_del                   (CfgRegRxIQEstDel),
    .reg_iq_est_gain_step_init        (CfgRegRxIQEstGainStepInit),
    .reg_iq_est_gain_step_stop        (CfgRegRxIQEstGainStepStop),
    .reg_iq_est_phase_step_init       (CfgRegRxIQEstPhaseStepInit),
    .reg_iq_est_phase_step_stop       (CfgRegRxIQEstPhaseStepStop),
    .reg_iq_est_step_del0             (CfgRegRxIQEstStepDel0),
    .reg_iq_est_step_del1             (CfgRegRxIQEstStepDel1),
    .reg_iq_est_step_del2             (CfgRegRxIQEstStepDel2),
    .reg_iq_est_step_del3             (CfgRegRxIQEstStepDel3),
    .reg_iq_est_step_del4             (CfgRegRxIQEstStepDel4),
    //
    .reg_iq_gain0                     (CfgRegRxIQGain0),
    .reg_iq_phase0                    (CfgRegRxIQPhase0),
    //
    .stat_reg_var_i0                  (StRegRxIQEstVarI0),
    .stat_reg_var_q0                  (StRegRxIQEstVarQ0),
    .stat_reg_m_iq0                   (StRegRxIQEstMIQ0),
    .stat_reg_iq_gain_est0            (StRegRxIQEstIQGainEst0),
    .stat_reg_iq_phase_est0           (StRegRxIQEstIQPhaseEst0),
    .stat_reg_valid                   (StRegRxIQEstValid),
`ifdef RW_NX_DERIV_FE_PATH1
    .reg_iq_gain1                     (CfgRegRxIQGain1),
    .reg_iq_phase1                    (CfgRegRxIQPhase1),
    //
    .stat_reg_var_i1                  (StRegRxIQEstVarI1),
    .stat_reg_var_q1                  (StRegRxIQEstVarQ1),
    .stat_reg_m_iq1                   (StRegRxIQEstMIQ1),
    .stat_reg_iq_gain_est1            (StRegRxIQEstIQGainEst1),
    .stat_reg_iq_phase_est1           (StRegRxIQEstIQPhaseEst1),
`endif
    //
    .fe_20i0                          (FERx20I0),
    .fe_20q0                          (FERx20Q0),
  `ifdef RW_NX_DERIV_FE_PATH40M
    .fe_40i0                          (FERx40I0),
    .fe_40q0                          (FERx40Q0),
  `endif
  `ifdef RW_NX_DERIV_FE_PATH80M
    .fe_80i0                          (FERx80I0),
    .fe_80q0                          (FERx80Q0),
  `endif
`ifdef RW_NX_DERIV_FE_PATH1
    .fe_20i1                          (FERx20I1),
    .fe_20q1                          (FERx20Q1),
  `ifdef RW_NX_DERIV_FE_PATH40M
    .fe_40i1                          (FERx40I1),
    .fe_40q1                          (FERx40Q1),
  `endif
  `ifdef RW_NX_DERIV_FE_PATH80M
    .fe_80i1                          (FERx80I1),
    .fe_80q1                          (FERx80Q1),
  `endif
`endif
    //
    .iq_gain_est0                     (rx_iq_gain_est0),
    .iq_phase_est0                    (rx_iq_phase_est0),
`ifdef RW_NX_DERIV_FE_PATH1
    .iq_gain_est1                     (rx_iq_gain_est1),
    .iq_phase_est1                    (rx_iq_phase_est1),
`endif
    //
    .iq_est_gain_acc_en               (RxIQEstGainAccEn),
    .iq_est_phase_acc_en              (RxIQEstPhaseAccEn),
    .snr                              (SNR),
    .agc_lock                         (AGCLock),
    //
    .frame_leg                        (FrameLeg),
    .frame_vht                        (FrameVHT),
    .legrate                          (LegRate),
    .mcs                              (MCS),
    .bweq20                           (BWEq20),
    .bweq40                           (BWEq40),
    .bweq80                           (BWEq80),
    .fo_est                           (FOEst)
    );
  

`ifndef RW_NX_FIQ_COMP_EN

  assign DACEn0 = txfIQInValid0; 
  assign DACI0  = txfIQInDataI0; 
  assign DACQ0  = txfIQInDataQ0; 

  assign rxfIQCompDataI0 = ADCI0; 
  assign rxfIQCompDataQ0 = ADCQ0;
  assign rxfIQCompValid0 = ADCEn;

`ifdef RW_NX_DERIV_FE_PATH1
  assign DACEn1 = txfIQInValid1; 
  assign DACI1  = txfIQInDataI1; 
  assign DACQ1  = txfIQInDataQ1; 

  assign rxfIQCompDataI1 = ADCI1; 
  assign rxfIQCompDataQ1 = ADCQ1;
  assign rxfIQCompValid1 = ADCEn;
`endif // RW_NX_DERIV_FE_PATH1

`else
  /*****************************************************************************
  * FILTERS IQ ESTIMATION AND COMPENSATION
  *****************************************************************************/
  wire [15:0] UnusedCoeff;
  assign UnusedCoeff = 16'd0;
  fIQEstComp #(
    .NTAPS(20),
    .NDEL(15)
  ) u_fIQEstComp (
    .Clk                   (FETxRx0Clk),
    .nRst                  (nFENoWdRst),
    .nCoeffRst             (nFENoWdRst),
    .TxEn                  (TxBlockEn),
    .RxIQCompEn            (RxIQCompEn),
    .FeRamFreqRatio        (CfgRegCBW),
    .CollStartP            (fIQCollStartP),
    .CollDone              (fIQCollDone),
    .EstStartP             (fIQEstStartP),
    .EstDone               (fIQEstDone),
    .CfgRegfIQCalEn        (CfgRegfIQCalEn),
    .CfgRegfIQTxRx         (CfgRegfIQTxRx),
    .CfgRegfIQTxBypass     (CfgRegfIQTxBypass),
    .CfgRegfIQRxBypass     (CfgRegfIQRxBypass),
    .CfgRegfIQCollPath     (CfgRegfIQCollPath),
    .CfgRegfIQCollWrOffset (CfgRegfIQCollWrOffset),
    .CfgRegfIQCollRdOffset (CfgRegfIQCollRdOffset),
    .CfgRegfIQCollSize     (CfgRegfIQCollSize),
    .CfgRegfIQEstIOffset   (CfgRegfIQEstIOffset),
    .CfgRegfIQEstQOffset   (CfgRegfIQEstQOffset),
    .CfgRegfIQEstSize      (CfgRegfIQEstSize),
    .CfgRegfIQTxDel        (CfgRegfIQTxDel),
    .CfgRegfIQRxDel        (CfgRegfIQRxDel),
    .CfgRegfIQCollDel      (CfgRegfIQCollDel),
    .CfgRegfIQEstStep      (CfgRegfIQEstStep),
    .CfgRegfIQEstNite      (CfgRegfIQEstNite),
    .rxInDataI0            (ADCI0),
    .rxInDataQ0            (ADCQ0),
    .rxInValid0            (ADCEn),
    .rxCompDataI0          (rxfIQCompDataI0),
    .rxCompDataQ0          (rxfIQCompDataQ0),
    .rxCompValid0          (rxfIQCompValid0),
    .txInValid0            (txfIQInValid0),
    .txInDataI0            (txfIQInDataI0),
    .txInDataQ0            (txfIQInDataQ0),
    .txOutValid0           (DACEn0),
    .txOutDataI0           (DACI0),
    .txOutDataQ0           (DACQ0),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegfIQPathSel      (CfgRegfIQPathSel),
    .rxInDataI1            (ADCI1),
    .rxInDataQ1            (ADCQ1),
    .rxInValid1            (ADCEn),
    .rxCompDataI1          (rxfIQCompDataI1),
    .rxCompDataQ1          (rxfIQCompDataQ1),
    .rxCompValid1          (rxfIQCompValid1),
    .txInValid1            (txfIQInValid1),
    .txInDataI1            (txfIQInDataI1),
    .txInDataQ1            (txfIQInDataQ1),
    .txOutValid1           (DACEn1),
    .txOutDataI1           (DACI1),
    .txOutDataQ1           (DACQ1),
`endif
    .RamAddr               (RamAddr),
    .RamRdEn               (RamRdEn),
    .RamWrEn               (RamWrEn),
    .RamWrData             (RamWrData),
    .RamRdData             (RamRdData),
    .StatfIQToggle0        (StRegfIQToggle0),
    .StatfIQRxEstError0    (StRegfIQRxEstError0),
    .StatfIQTxEstError0    (StRegfIQTxEstError0),
`ifdef RW_NX_DERIV_FE_PATH1
    .StatfIQToggle1        (StRegfIQToggle1),
    .StatfIQRxEstError1    (StRegfIQRxEstError1),
    .StatfIQTxEstError1    (StRegfIQTxEstError1),
`endif
    .Coeff0                (StRegfIQCoeff0),
    .Coeff1                (StRegfIQCoeff1),
    .Coeff2                (StRegfIQCoeff2),
    .Coeff3                (StRegfIQCoeff3),
    .Coeff4                (StRegfIQCoeff4),
    .Coeff5                (StRegfIQCoeff5),
    .Coeff6                (StRegfIQCoeff6),
    .Coeff7                (StRegfIQCoeff7),
    .Coeff8                (StRegfIQCoeff8),
    .Coeff9                (StRegfIQCoeff9),
    .Coeff10               (StRegfIQCoeff10),
    .Coeff11               (StRegfIQCoeff11),
    .Coeff12               (StRegfIQCoeff12),
    .Coeff13               (StRegfIQCoeff13),
    .Coeff14               (StRegfIQCoeff14),
    .Coeff15               (StRegfIQCoeff15),
    .Coeff16               (StRegfIQCoeff16),
    .Coeff17               (StRegfIQCoeff17),
    .Coeff18               (StRegfIQCoeff18),
    .Coeff19               (StRegfIQCoeff19),
    .Coeff20               (),
    .Coeff21               (),
    .Coeff22               (),
    .Coeff23               (),
    .Coeff24               (),
    .Coeff25               (),
    .Coeff26               (),
    .Coeff27               (),
    .Coeff28               (),
    .Coeff29               (),
    .Coeff30               (),
    .Coeff31               (),
    .Coeff32               (),
    .Coeff33               (),
    .Coeff34               (),
    .Coeff35               (),
    .Coeff36               (),
    .Coeff37               (),
    .Coeff38               (),
    .Coeff39               (),
    .CfgRegfIQCoeff0       (CfgRegfIQCoeff0),
    .CfgRegfIQCoeff1       (CfgRegfIQCoeff1),
    .CfgRegfIQCoeff2       (CfgRegfIQCoeff2),
    .CfgRegfIQCoeff3       (CfgRegfIQCoeff3),
    .CfgRegfIQCoeff4       (CfgRegfIQCoeff4),
    .CfgRegfIQCoeff5       (CfgRegfIQCoeff5),
    .CfgRegfIQCoeff6       (CfgRegfIQCoeff6),
    .CfgRegfIQCoeff7       (CfgRegfIQCoeff7),
    .CfgRegfIQCoeff8       (CfgRegfIQCoeff8),
    .CfgRegfIQCoeff9       (CfgRegfIQCoeff9),
    .CfgRegfIQCoeff10      (CfgRegfIQCoeff10),
    .CfgRegfIQCoeff11      (CfgRegfIQCoeff11),
    .CfgRegfIQCoeff12      (CfgRegfIQCoeff12),
    .CfgRegfIQCoeff13      (CfgRegfIQCoeff13),
    .CfgRegfIQCoeff14      (CfgRegfIQCoeff14),
    .CfgRegfIQCoeff15      (CfgRegfIQCoeff15),
    .CfgRegfIQCoeff16      (CfgRegfIQCoeff16),
    .CfgRegfIQCoeff17      (CfgRegfIQCoeff17),
    .CfgRegfIQCoeff18      (CfgRegfIQCoeff18),
    .CfgRegfIQCoeff19      (CfgRegfIQCoeff19),
    .CfgRegfIQCoeff20      (UnusedCoeff),
    .CfgRegfIQCoeff21      (UnusedCoeff),
    .CfgRegfIQCoeff22      (UnusedCoeff),
    .CfgRegfIQCoeff23      (UnusedCoeff),
    .CfgRegfIQCoeff24      (UnusedCoeff),
    .CfgRegfIQCoeff25      (UnusedCoeff),
    .CfgRegfIQCoeff26      (UnusedCoeff),
    .CfgRegfIQCoeff27      (UnusedCoeff),
    .CfgRegfIQCoeff28      (UnusedCoeff),
    .CfgRegfIQCoeff29      (UnusedCoeff),
    .CfgRegfIQCoeff30      (UnusedCoeff),
    .CfgRegfIQCoeff31      (UnusedCoeff),
    .CfgRegfIQCoeff32      (UnusedCoeff),
    .CfgRegfIQCoeff33      (UnusedCoeff),
    .CfgRegfIQCoeff34      (UnusedCoeff),
    .CfgRegfIQCoeff35      (UnusedCoeff),
    .CfgRegfIQCoeff36      (UnusedCoeff),
    .CfgRegfIQCoeff37      (UnusedCoeff),
    .CfgRegfIQCoeff38      (UnusedCoeff),
    .CfgRegfIQCoeff39      (UnusedCoeff),
    .CfgRegfIQCoeffUpdate  (CfgRegfIQCoeffUpdate),
    .Dbg0                  (Dbg0)
  );
`endif

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
