//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module CompFilter # (
  parameter NTAPS = 40 // between 12 and 40
) ( 
  // System
  input wire         Clk,
  input wire         nRst,
  
  // Control
  input  wire        Enable,
  input  wire        CfgRegfIQCalEn, // enable for Sample Collection and Estimation

  // Data path
  input  wire        ValidXkp1,      // High when SampleX(k+1) and Coefficients(k) are valid
  input  wire [11:0] SampleXkp1,     // x(k+1)
  output reg         ValidYk,        // High when SampleY(k) is valid
  output reg  [11:0] SampleYk,       // y(k)
  output wire        EstLineFilledP, // Indicates when the delau line is filled in estimation mode
  
  // Coefficients
  input  wire [15:0] Coeffk0,
  input  wire [15:0] Coeffk1,
  input  wire [15:0] Coeffk2,
  input  wire [15:0] Coeffk3,
  input  wire [15:0] Coeffk4,
  input  wire [15:0] Coeffk5,
  input  wire [15:0] Coeffk6,
  input  wire [15:0] Coeffk7,
  input  wire [15:0] Coeffk8,
  input  wire [15:0] Coeffk9,
  input  wire [15:0] Coeffk10,
  input  wire [15:0] Coeffk11,
  input  wire [15:0] Coeffk12,
  input  wire [15:0] Coeffk13,
  input  wire [15:0] Coeffk14,
  input  wire [15:0] Coeffk15,
  input  wire [15:0] Coeffk16,
  input  wire [15:0] Coeffk17,
  input  wire [15:0] Coeffk18,
  input  wire [15:0] Coeffk19,
  input  wire [15:0] Coeffk20,
  input  wire [15:0] Coeffk21,
  input  wire [15:0] Coeffk22,
  input  wire [15:0] Coeffk23,
  input  wire [15:0] Coeffk24,
  input  wire [15:0] Coeffk25,
  input  wire [15:0] Coeffk26,
  input  wire [15:0] Coeffk27,
  input  wire [15:0] Coeffk28,
  input  wire [15:0] Coeffk29,
  input  wire [15:0] Coeffk30,
  input  wire [15:0] Coeffk31,
  input  wire [15:0] Coeffk32,
  input  wire [15:0] Coeffk33,
  input  wire [15:0] Coeffk34,
  input  wire [15:0] Coeffk35,
  input  wire [15:0] Coeffk36,
  input  wire [15:0] Coeffk37,
  input  wire [15:0] Coeffk38,
  input  wire [15:0] Coeffk39,
  
  // Delay line samples
  output wire [11:0] SampleXk   , // x(k)
  output wire [11:0] SampleXkm1 , // x(k-1)
  output wire [11:0] SampleXkm2 , // x(k-2)...
  output wire [11:0] SampleXkm3 ,
  output wire [11:0] SampleXkm4 ,
  output wire [11:0] SampleXkm5 ,
  output wire [11:0] SampleXkm6 ,
  output wire [11:0] SampleXkm7 ,
  output wire [11:0] SampleXkm8 ,
  output wire [11:0] SampleXkm9 ,
  output wire [11:0] SampleXkm10,
  output wire [11:0] SampleXkm11,
  output wire [11:0] SampleXkm12,
  output wire [11:0] SampleXkm13,
  output wire [11:0] SampleXkm14,
  output wire [11:0] SampleXkm15,
  output wire [11:0] SampleXkm16,
  output wire [11:0] SampleXkm17,
  output wire [11:0] SampleXkm18,
  output wire [11:0] SampleXkm19,
  output wire [11:0] SampleXkm20,
  output wire [11:0] SampleXkm21,
  output wire [11:0] SampleXkm22,
  output wire [11:0] SampleXkm23,
  output wire [11:0] SampleXkm24,
  output wire [11:0] SampleXkm25,
  output wire [11:0] SampleXkm26,
  output wire [11:0] SampleXkm27,
  output wire [11:0] SampleXkm28,
  output wire [11:0] SampleXkm29,
  output wire [11:0] SampleXkm30,
  output wire [11:0] SampleXkm31,
  output wire [11:0] SampleXkm32,
  output wire [11:0] SampleXkm33,
  output wire [11:0] SampleXkm34,
  output wire [11:0] SampleXkm35,
  output wire [11:0] SampleXkm36,
  output wire [11:0] SampleXkm37,
  output wire [11:0] SampleXkm38,
  output wire [11:0] SampleXkm39
  
);


//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

reg         [12:0] SampleLine   [NTAPS-1:0]; 
reg         [26:0] S1MultKArray [NTAPS-1:0];
wire signed [31:0] MultNext     [NTAPS-1:0];

wire        [11:0] SampleLineWire   [39:0]; 
wire        [26:0] S1MultKArrayWire [39:0];
wire        [15:0] CoeffKArray      [39:0];

wire               NextS1ValidK;
reg                S1ValidK;

wire        [29:0] S2Sum [7:0];
reg                S2ValidK;

//wire        [32:0] S3Sum0;
//wire        [32:0] S3Sum1;
reg               S3ValidK;

wire        [33:0] SumLastNext;
wire        [18:0] SumLastRndNext;
//wire        [29:0] UnusedData;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  // map coefficients to array
  ///////////////////////////////
  assign CoeffKArray[0 ] = Coeffk0;
  assign CoeffKArray[1 ] = Coeffk1;
  assign CoeffKArray[2 ] = Coeffk2;
  assign CoeffKArray[3 ] = Coeffk3;
  assign CoeffKArray[4 ] = Coeffk4;
  assign CoeffKArray[5 ] = Coeffk5;
  assign CoeffKArray[6 ] = Coeffk6;
  assign CoeffKArray[7 ] = Coeffk7;
  assign CoeffKArray[8 ] = Coeffk8;
  assign CoeffKArray[9 ] = Coeffk9;
  assign CoeffKArray[10] = Coeffk10;
  assign CoeffKArray[11] = Coeffk11;
  assign CoeffKArray[12] = Coeffk12;
  assign CoeffKArray[13] = Coeffk13;
  assign CoeffKArray[14] = Coeffk14;
  assign CoeffKArray[15] = Coeffk15;
  assign CoeffKArray[16] = Coeffk16;
  assign CoeffKArray[17] = Coeffk17;
  assign CoeffKArray[18] = Coeffk18;
  assign CoeffKArray[19] = Coeffk19;
  assign CoeffKArray[20] = Coeffk20;
  assign CoeffKArray[21] = Coeffk21;
  assign CoeffKArray[22] = Coeffk22;
  assign CoeffKArray[23] = Coeffk23;
  assign CoeffKArray[24] = Coeffk24;
  assign CoeffKArray[25] = Coeffk25;
  assign CoeffKArray[26] = Coeffk26;
  assign CoeffKArray[27] = Coeffk27;
  assign CoeffKArray[28] = Coeffk28;
  assign CoeffKArray[29] = Coeffk29;
  assign CoeffKArray[30] = Coeffk30;
  assign CoeffKArray[31] = Coeffk31;
  assign CoeffKArray[32] = Coeffk32;
  assign CoeffKArray[33] = Coeffk33;
  assign CoeffKArray[34] = Coeffk34;
  assign CoeffKArray[35] = Coeffk35;
  assign CoeffKArray[36] = Coeffk36;
  assign CoeffKArray[37] = Coeffk37;
  assign CoeffKArray[38] = Coeffk38;
  assign CoeffKArray[39] = Coeffk39;


  // Delay line
  ///////////////////////////////////////////
  always @(posedge Clk or negedge nRst)
  begin : FilterLine
    integer i;
    if (nRst == 1'b0) begin
      for (i=0;i<NTAPS;i=i+1) begin : CompFilterInitLoop
        SampleLine[i]       <= 13'd0;
      end // CompFilterInitLoop
    end else begin

      // Reset line (e.g. between Tx and Rx)
      if (Enable==1'd0) begin
        for (i=0;i<NTAPS;i=i+1) begin : CompFilterEnableLoop
          SampleLine[i]     <= 13'd0;
        end // CompFilterEnableLoop
      end else begin

        // The delay line contains the samples values and associated valid signal.
        // The valid is used in Estimation, to start generating the filter output for Coefficient update
        // only when the line is full.
        if (ValidXkp1==1'd1) begin
          SampleLine[0]         <= {1'b1,SampleXkp1};
          for (i=0;i<NTAPS-1;i=i+1) begin : CompFilterShiftLoop
            SampleLine[i+1] <= SampleLine[i];
          end // CompFilterShiftLoop
        end

        // Estimation only: Reset the valid signal once the sample has been fed to the next stages of the filter.
        // The delay line is frozen during Coefficient update. Reseting the valid makes sure each sample
        // is processed only once.
        if ((SampleLine[NTAPS-1][12]==1'b1) && (CfgRegfIQCalEn==1'b1))
          SampleLine[NTAPS-1][12]<=1'b0;

      end
    end
  end
  

  // Generate multipliers for each filter tap
  ///////////////////////////////////////////
  genvar p;
  generate 
    // MultNext[p] = SampleLine[p] * CoeffKArray[p]
    for (p=0; p<NTAPS; p=p+1) begin: CompFilterMultGen
      assign MultNext[p] = $signed({{20{SampleLine[p][11]}},SampleLine[p][11:0]}) * $signed({{16{CoeffKArray[p][15]}},CoeffKArray[p]});
    end //CompFilterMultGen
  endgenerate


  // Compute filter output based on delay line contents
  //  for Compensation : this is done as soon as the delay line contains data, i.e. triggered by ValidXkp1
  //  for Estimation   : this is done when the delay line is full, i.e. triggered by EstLineFilledP
  // EstLineFilledP is sent out as indication to freeze the delay line until coefficient update is done.
  assign EstLineFilledP = SampleLine[NTAPS-1][12];
  assign NextS1ValidK   = (CfgRegfIQCalEn==1'b1) ? EstLineFilledP : ValidXkp1;
  always @(posedge Clk or negedge nRst)
  begin: Multiply
    integer i;
    if (nRst == 1'b0) begin
      for (i=0;i<NTAPS;i=i+1) begin : CompMultInitLoop
        S1MultKArray[i]     <= 27'd0;
      end // CompMultInitLoop
      S1ValidK              <= 1'b0;
    end else begin
      
      if (Enable==1'd0) begin
        for (i=0;i<NTAPS;i=i+1) begin : CompMultEnableLoop
          S1MultKArray[i]   <= 27'd0;
        end // CompMultEnableLoop
        S1ValidK            <= 1'b0;
      
      end else begin
        
        S1ValidK            <= NextS1ValidK;
        if (NextS1ValidK==1'b1) begin
          for (i=0;i<NTAPS;i=i+1) begin : CompMultLoop
            S1MultKArray[i]     <= MultNext[i][26:0];
          end // CompMultLoop
        end

      end
    end
  end


  // Fill arraies with TAPs values and zeros when TAPS not present,
  // to be used in sum of all multipliers outputs
  ///////////////////////////////
  genvar j;
  generate 
    for (j=0; j<NTAPS; j=j+1) begin: CompFilterUsedGen
      assign SampleLineWire[j]   = SampleLine[j][11:0];
      assign S1MultKArrayWire[j] = S1MultKArray[j];
    end //CompFilterUsedGen
  endgenerate

  genvar k;
  generate 
    for (k=NTAPS; k<40; k=k+1) begin: CompFilterUnusedGen
      assign SampleLineWire[k]   = 12'd0;
      assign S1MultKArrayWire[k] = 27'd0;
    end //CompFilterUnusedGen
  endgenerate


  // Add together muliplier outputs
  ///////////////////////////////
  always @(posedge Clk or negedge nRst)
  begin
    if (nRst == 1'b0)
    begin
      S2ValidK <= 1'b0;
    end else begin
      if (Enable == 1'b0) begin
        S2ValidK  <= 1'b0;
      end else if (S1ValidK == 1'b1) begin
        S2ValidK  <= 1'b1;
      end else begin
        S2ValidK  <= 1'b0;
      end
    end
  end

  // Add multiplier outputs 5 by 5
  genvar l;
  generate
    for (l=0; l<8; l=l+1) begin : S2SumGen
      if (NTAPS > l*5) begin : CompAddGen
        wire [29:0] SumNext;
        reg  [29:0] Sum;

        assign SumNext = {{3{S1MultKArrayWire[l*5][27-1]}}, S1MultKArrayWire[l*5]} +
                         {{3{S1MultKArrayWire[l*5+1][27-1]}}, S1MultKArrayWire[l*5+1]} +
                         {{3{S1MultKArrayWire[l*5+2][27-1]}}, S1MultKArrayWire[l*5+2]} +
                         {{3{S1MultKArrayWire[l*5+3][27-1]}}, S1MultKArrayWire[l*5+3]} +
                         {{3{S1MultKArrayWire[l*5+4][27-1]}}, S1MultKArrayWire[l*5+4]}; 

        always @(posedge Clk or negedge nRst)
        begin
          if (nRst == 1'b0)
          begin
            Sum      <= 30'd0;
          end else begin
            if (Enable == 1'b1) begin
              if (S1ValidK == 1'b1)
                Sum      <= SumNext;
            end
          end
        end
        assign S2Sum[l] = Sum;

      end else begin : noCompAddGen
        assign S2Sum[l] = 30'd0;
      end
    end //S2SumGen
  endgenerate
  
  
  // Add adder outputs 5 by 5
  wire [31:0] S3Sum0Next;
  reg  [31:0] S3Sum0;
  wire [31:0] S3Sum1Next;
  reg  [31:0] S3Sum1;

  assign S3Sum0Next = {{2{S2Sum[0][29]}}, S2Sum[0]} +
                      {{2{S2Sum[2][29]}}, S2Sum[2]} +
                      {{2{S2Sum[4][29]}}, S2Sum[4]} +
                      {{2{S2Sum[6][29]}}, S2Sum[6]}; 

  assign S3Sum1Next = {{2{S2Sum[1][29]}}, S2Sum[1]} +
                      {{2{S2Sum[3][29]}}, S2Sum[3]} +
                      {{2{S2Sum[5][29]}}, S2Sum[5]} +
                      {{2{S2Sum[7][29]}}, S2Sum[7]}; 

  always @(posedge Clk or negedge nRst)
  begin
    if (nRst == 1'b0)
    begin
      S3Sum0      <= 32'd0;
      S3Sum1      <= 32'd0;
      S3ValidK    <= 1'b0;
    end else begin
      if (Enable == 1'b0) begin
        S3ValidK    <= 1'b0;
      end else begin
        if (S2ValidK == 1'b1) begin
          S3Sum0      <= S3Sum0Next;
          S3Sum1      <= S3Sum1Next;
          S3ValidK    <= 1'b1;
        end else begin
          S3ValidK    <= 1'b0;
        end
      end
    end
  end

  assign SumLastNext = {{2{S3Sum0[31]}},S3Sum0} + 
                       {{2{S3Sum1[31]}},S3Sum1} + 
                       {19'b0,15'b100000000000000}; // rndfix


// SumDbg is the sum without rndfix: it corresponds to the Matlab sum value
// and can be used for bit-true debug.
`ifdef RW_SIMU_ON
  // pragma coverage block = off, expr = off, toggle = off
  wire [32:0] SumDbg;
  assign SumDbg = {S3Sum0[31],S3Sum0} + 
                  {S3Sum1[31],S3Sum1} ;
  // pragma coverage block = on, expr = on, toggle = on
`endif

  // rnd15
  assign SumLastRndNext = SumLastNext[33:15];

  // Sat 12
  reg [11:0] SumLastSatNext;
  always @(*)
  begin
    if((SumLastRndNext[18:11]==8'b11111111) || (SumLastRndNext[18:11]==8'd0))
      SumLastSatNext = SumLastRndNext[11:0];
    else
      SumLastSatNext = {SumLastRndNext[18],{11{~SumLastRndNext[18]}}};
  end
  
  // register saturated output
  always @(posedge Clk or negedge nRst)
  begin
    if (nRst == 1'b0)
    begin
      SampleYk   <= 12'd0;
      ValidYk    <= 1'd0;
    end else if (Enable == 1'b0) begin
      SampleYk   <= 12'd0;
      ValidYk    <= 1'd0;
    end else if (S3ValidK == 1'b1) begin
      SampleYk   <= SumLastSatNext;
      ValidYk    <= 1'd1;
    end else begin
      ValidYk    <= 1'd0;
    end
  end

  // map taps to outputs
  ///////////////////////////////
  assign SampleXk    = SampleLineWire[0 ];
  assign SampleXkm1  = SampleLineWire[1 ];
  assign SampleXkm2  = SampleLineWire[2 ];
  assign SampleXkm3  = SampleLineWire[3 ];
  assign SampleXkm4  = SampleLineWire[4 ];
  assign SampleXkm5  = SampleLineWire[5 ];
  assign SampleXkm6  = SampleLineWire[6 ];
  assign SampleXkm7  = SampleLineWire[7 ];
  assign SampleXkm8  = SampleLineWire[8 ];
  assign SampleXkm9  = SampleLineWire[9 ];
  assign SampleXkm10 = SampleLineWire[10];
  assign SampleXkm11 = SampleLineWire[11];
  assign SampleXkm12 = SampleLineWire[12];
  assign SampleXkm13 = SampleLineWire[13];
  assign SampleXkm14 = SampleLineWire[14];
  assign SampleXkm15 = SampleLineWire[15];
  assign SampleXkm16 = SampleLineWire[16];
  assign SampleXkm17 = SampleLineWire[17];
  assign SampleXkm18 = SampleLineWire[18];
  assign SampleXkm19 = SampleLineWire[19];
  assign SampleXkm20 = SampleLineWire[20];
  assign SampleXkm21 = SampleLineWire[21];
  assign SampleXkm22 = SampleLineWire[22];
  assign SampleXkm23 = SampleLineWire[23];
  assign SampleXkm24 = SampleLineWire[24];
  assign SampleXkm25 = SampleLineWire[25];
  assign SampleXkm26 = SampleLineWire[26];
  assign SampleXkm27 = SampleLineWire[27];
  assign SampleXkm28 = SampleLineWire[28];
  assign SampleXkm29 = SampleLineWire[29];
  assign SampleXkm30 = SampleLineWire[30];
  assign SampleXkm31 = SampleLineWire[31];
  assign SampleXkm32 = SampleLineWire[32];
  assign SampleXkm33 = SampleLineWire[33];
  assign SampleXkm34 = SampleLineWire[34];
  assign SampleXkm35 = SampleLineWire[35];
  assign SampleXkm36 = SampleLineWire[36];
  assign SampleXkm37 = SampleLineWire[37];
  assign SampleXkm38 = SampleLineWire[38];
  assign SampleXkm39 = SampleLineWire[39];

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
