//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of fIQComp module, to be used if only compensation is needed
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module fIQComp # (
  parameter NTAPS = 40,
  parameter NDEL  = 30
) ( 
  // System
  input wire         Clk,
  input wire         nRst,
  
  // Control
  input  wire        Enable,
  input  wire        CfgRegfIQCalEn,
  input  wire [4:0]  fIQDel,

  // Data path
  input  wire        ValidXkp1,
  input  wire [11:0] SampleXikp1,
  input  wire [11:0] SampleXqkp1,
  output wire        ValidYk,
  output wire        EstLineFilledP,
  output wire [11:0] SampleYik,
  output wire [11:0] SampleYqk,
  
  // Coefficients
  input  wire [15:0] Coeffk0,
  input  wire [15:0] Coeffk1,
  input  wire [15:0] Coeffk2,
  input  wire [15:0] Coeffk3,
  input  wire [15:0] Coeffk4,
  input  wire [15:0] Coeffk5,
  input  wire [15:0] Coeffk6,
  input  wire [15:0] Coeffk7,
  input  wire [15:0] Coeffk8,
  input  wire [15:0] Coeffk9,
  input  wire [15:0] Coeffk10,
  input  wire [15:0] Coeffk11,
  input  wire [15:0] Coeffk12,
  input  wire [15:0] Coeffk13,
  input  wire [15:0] Coeffk14,
  input  wire [15:0] Coeffk15,
  input  wire [15:0] Coeffk16,
  input  wire [15:0] Coeffk17,
  input  wire [15:0] Coeffk18,
  input  wire [15:0] Coeffk19,
  input  wire [15:0] Coeffk20,
  input  wire [15:0] Coeffk21,
  input  wire [15:0] Coeffk22,
  input  wire [15:0] Coeffk23,
  input  wire [15:0] Coeffk24,
  input  wire [15:0] Coeffk25,
  input  wire [15:0] Coeffk26,
  input  wire [15:0] Coeffk27,
  input  wire [15:0] Coeffk28,
  input  wire [15:0] Coeffk29,
  input  wire [15:0] Coeffk30,
  input  wire [15:0] Coeffk31,
  input  wire [15:0] Coeffk32,
  input  wire [15:0] Coeffk33,
  input  wire [15:0] Coeffk34,
  input  wire [15:0] Coeffk35,
  input  wire [15:0] Coeffk36,
  input  wire [15:0] Coeffk37,
  input  wire [15:0] Coeffk38,
  input  wire [15:0] Coeffk39,
  
  // Delay line samples
  output wire [11:0] SampleXqk   ,
  output wire [11:0] SampleXqkm1 ,
  output wire [11:0] SampleXqkm2 ,
  output wire [11:0] SampleXqkm3 ,
  output wire [11:0] SampleXqkm4 ,
  output wire [11:0] SampleXqkm5 ,
  output wire [11:0] SampleXqkm6 ,
  output wire [11:0] SampleXqkm7 ,
  output wire [11:0] SampleXqkm8 ,
  output wire [11:0] SampleXqkm9 ,
  output wire [11:0] SampleXqkm10,
  output wire [11:0] SampleXqkm11,
  output wire [11:0] SampleXqkm12,
  output wire [11:0] SampleXqkm13,
  output wire [11:0] SampleXqkm14,
  output wire [11:0] SampleXqkm15,
  output wire [11:0] SampleXqkm16,
  output wire [11:0] SampleXqkm17,
  output wire [11:0] SampleXqkm18,
  output wire [11:0] SampleXqkm19,
  output wire [11:0] SampleXqkm20,
  output wire [11:0] SampleXqkm21,
  output wire [11:0] SampleXqkm22,
  output wire [11:0] SampleXqkm23,
  output wire [11:0] SampleXqkm24,
  output wire [11:0] SampleXqkm25,
  output wire [11:0] SampleXqkm26,
  output wire [11:0] SampleXqkm27,
  output wire [11:0] SampleXqkm28,
  output wire [11:0] SampleXqkm29,
  output wire [11:0] SampleXqkm30,
  output wire [11:0] SampleXqkm31,
  output wire [11:0] SampleXqkm32,
  output wire [11:0] SampleXqkm33,
  output wire [11:0] SampleXqkm34,
  output wire [11:0] SampleXqkm35,
  output wire [11:0] SampleXqkm36,
  output wire [11:0] SampleXqkm37,
  output wire [11:0] SampleXqkm38,
  output wire [11:0] SampleXqkm39
  
);



//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  reg       ValidYkEn;
  wire      ValidYkInt;
  wire      ValidXkp1Int;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////
  // When not in calibration mode, for bit-true compensation tests, assert first Valid
  // one sample later
  always @(posedge Clk or negedge nRst)
  begin
    if (nRst == 1'b0) begin
      ValidYkEn <= 1'b0;
    end else begin
      if (Enable==1'b0) begin
        ValidYkEn <= 1'b0;
      end else begin
        ValidYkEn <= ValidYkInt;
      end
    end
  end
  assign ValidYk = (CfgRegfIQCalEn==1'b1) ? ValidYkInt : (ValidYkInt && ValidYkEn); 

  reg   [4:0]   FlushCnt;
  reg           FlushDone;
  // When not in calibration mode, flush filter for fIQdel samples when input valid goes low.
  always @(posedge Clk or negedge nRst)
  begin
    if (nRst == 1'b0) begin
      FlushCnt               <= 5'd0;
      FlushDone              <= 1'd1;

    end else begin

      if (Enable==1'b0) begin
        FlushCnt               <= 5'd0;
        FlushDone              <= 1'd1;

      end else begin
        if ((ValidXkp1==1'b1) && (CfgRegfIQCalEn==1'b0)) begin
          FlushDone              <= 1'd0;
          FlushCnt               <= fIQDel;
        end
        if ((ValidXkp1==1'b0) && (FlushDone==1'b0)) begin
          if (FlushCnt>3'd1)
            FlushCnt <= FlushCnt-3'd1;
          else
            FlushDone <= 1'b1;
        end
      end
    end
  end
  
  assign ValidXkp1Int = ValidXkp1 | !FlushDone; 

  // Delay on I path
  CompDelay #(
    .LENGTH(NDEL),
    .FILTERLAT(4)
  )
  UCompDelay (
    .Clk             (Clk),
    .nRst            (nRst),
    .Enable          (Enable),
    .CfgRegfIQCalEn  (CfgRegfIQCalEn),
    .fIQDel          (fIQDel),
    .ValidXkp1       (ValidXkp1Int),
    .SampleXkp1      (SampleXikp1),
    .SampleYk        (SampleYik)
  );
  
  // Filter on Q path
  CompFilter #(
    .NTAPS(NTAPS)
  )
  UCompFilter (
    //System
    .Clk             (Clk),
    .nRst            (nRst),
    //Control
    .Enable          (Enable),
    .CfgRegfIQCalEn  (CfgRegfIQCalEn),
    //Data path
    .ValidXkp1       (ValidXkp1Int),
    .SampleXkp1      (SampleXqkp1),
    .ValidYk         (ValidYkInt),
    .SampleYk        (SampleYqk),
    .EstLineFilledP  (EstLineFilledP),
    //Coefficients
    .Coeffk0         (Coeffk0),
    .Coeffk1         (Coeffk1),
    .Coeffk2         (Coeffk2),
    .Coeffk3         (Coeffk3),
    .Coeffk4         (Coeffk4),
    .Coeffk5         (Coeffk5),
    .Coeffk6         (Coeffk6),
    .Coeffk7         (Coeffk7),
    .Coeffk8         (Coeffk8),
    .Coeffk9         (Coeffk9),
    .Coeffk10        (Coeffk10),
    .Coeffk11        (Coeffk11),
    .Coeffk12        (Coeffk12),
    .Coeffk13        (Coeffk13),
    .Coeffk14        (Coeffk14),
    .Coeffk15        (Coeffk15),
    .Coeffk16        (Coeffk16),
    .Coeffk17        (Coeffk17),
    .Coeffk18        (Coeffk18),
    .Coeffk19        (Coeffk19),
    .Coeffk20        (Coeffk20),
    .Coeffk21        (Coeffk21),
    .Coeffk22        (Coeffk22),
    .Coeffk23        (Coeffk23),
    .Coeffk24        (Coeffk24),
    .Coeffk25        (Coeffk25),
    .Coeffk26        (Coeffk26),
    .Coeffk27        (Coeffk27),
    .Coeffk28        (Coeffk28),
    .Coeffk29        (Coeffk29),
    .Coeffk30        (Coeffk30),
    .Coeffk31        (Coeffk31),
    .Coeffk32        (Coeffk32),
    .Coeffk33        (Coeffk33),
    .Coeffk34        (Coeffk34),
    .Coeffk35        (Coeffk35),
    .Coeffk36        (Coeffk36),
    .Coeffk37        (Coeffk37),
    .Coeffk38        (Coeffk38),
    .Coeffk39        (Coeffk39),
    //Delay line samples
    .SampleXk        (SampleXqk),
    .SampleXkm1      (SampleXqkm1),
    .SampleXkm2      (SampleXqkm2),
    .SampleXkm3      (SampleXqkm3),
    .SampleXkm4      (SampleXqkm4),
    .SampleXkm5      (SampleXqkm5),
    .SampleXkm6      (SampleXqkm6),
    .SampleXkm7      (SampleXqkm7),
    .SampleXkm8      (SampleXqkm8),
    .SampleXkm9      (SampleXqkm9),
    .SampleXkm10     (SampleXqkm10),
    .SampleXkm11     (SampleXqkm11),
    .SampleXkm12     (SampleXqkm12),
    .SampleXkm13     (SampleXqkm13),
    .SampleXkm14     (SampleXqkm14),
    .SampleXkm15     (SampleXqkm15),
    .SampleXkm16     (SampleXqkm16),
    .SampleXkm17     (SampleXqkm17),
    .SampleXkm18     (SampleXqkm18),
    .SampleXkm19     (SampleXqkm19),
    .SampleXkm20     (SampleXqkm20),
    .SampleXkm21     (SampleXqkm21),
    .SampleXkm22     (SampleXqkm22),
    .SampleXkm23     (SampleXqkm23),
    .SampleXkm24     (SampleXqkm24),
    .SampleXkm25     (SampleXqkm25),
    .SampleXkm26     (SampleXqkm26),
    .SampleXkm27     (SampleXqkm27),
    .SampleXkm28     (SampleXqkm28),
    .SampleXkm29     (SampleXqkm29),
    .SampleXkm30     (SampleXqkm30),
    .SampleXkm31     (SampleXqkm31),
    .SampleXkm32     (SampleXqkm32),
    .SampleXkm33     (SampleXqkm33),
    .SampleXkm34     (SampleXqkm34),
    .SampleXkm35     (SampleXqkm35),
    .SampleXkm36     (SampleXqkm36),
    .SampleXkm37     (SampleXqkm37),
    .SampleXkm38     (SampleXqkm38),
    .SampleXkm39     (SampleXqkm39)
  );

  
endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
