//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission 
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 29405 $
// $Date: 2017-01-11 19:05:55 +0100 (Wed, 11 Jan 2017) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : IQ Gain and phase error estimation
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module iq_err(
  // Clock and reset
  input  wire        clk,     // FE Clock (160/80/40 MHz)
  input  wire        reset_n, // Global asynchronous reset (active LOW)

  // Control
  input  wire        err_clr,
  input  wire        err_en,

  // Input data
  input  wire [12:0] in_i,
  input  wire [12:0] in_q,

  // Error estimates
  output reg  [21:0] var_i,
  output reg  [21:0] var_q,
  output reg  [22:0] m_iq
  );

//////////////////////////////////////////////////////////////////////////////
// Internal Regs declarations
//////////////////////////////////////////////////////////////////////////////
  reg         toggle;
  reg         err_en_1t;
  reg  [6:0]  in_i_shift;
  reg  [6:0]  in_q_shift;

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  wire [6:0]  in_shift_mux;
  wire [13:0] mult;
  wire [14:0] iq_mult;
  wire [21:0] var_in_mux;
  wire [21:0] var_mux;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Capture and shift inputs by 6 bits
always @(posedge clk or negedge reset_n)
begin
  if (reset_n == 1'b0)
  begin
    in_i_shift <= 7'b0;
    in_q_shift <= 7'b0;
  end
  else if (!toggle)
  begin
    in_i_shift <= in_i[12:6];
    in_q_shift <= in_q[12:6];
  end
end

// Multiplications
assign in_shift_mux = (toggle) ? in_i_shift : in_q_shift;
assign mult         = $signed(in_shift_mux) * $signed(in_shift_mux);
assign iq_mult      = $signed(in_i_shift)   * $signed(in_q_shift);

// Adder
assign var_in_mux = (toggle) ? var_i : var_q;
assign var_mux    = var_in_mux + {8'b0,mult};

// Register accumulators
always @(posedge clk or negedge reset_n)
begin
  if (reset_n == 1'b0)
  begin
    toggle    <= 1'b0;
    err_en_1t <= 1'b0;
    var_i     <= 22'b0;
    var_q     <= 22'b0;
    m_iq      <= 23'b0;
  end
  else if (err_clr)
  begin
    toggle    <= 1'b0;
    err_en_1t <= 1'b0;
    var_i     <= 22'b0;
    var_q     <= 22'b0;
    m_iq      <= 23'b0;
  end
  else
  begin
    if (err_en | err_en_1t)
      toggle <= ~toggle;
    if (err_en && toggle) begin
      var_i <= var_mux;
      m_iq  <= $signed(m_iq) + $signed(iq_mult);
    end
    else if (err_en_1t && !toggle)
      var_q <= var_mux;
    err_en_1t <= err_en;
  end
end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
