//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 29367 $
// $Date: 2017-01-05 16:19:53 +0100 (Thu, 05 Jan 2017) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of iq_est module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module iq_est(
  // Clock and reset
  input  wire        clk,     // FE Clock (160/80/40 MHz)
  input  wire        reset_n, // Global asynchronous reset (active LOW)

  // Registers (asynchronous)
  input  wire [1:0]  reg_cbw,
  //
  input  wire        reg_iq_est_iter_clr,
  //
  input  wire [7:0]  reg_iq_est_snr_min,
  input  wire [3:0]  reg_iq_est_mcs_min,
  input  wire [2:0]  reg_iq_est_bw_list,
  input  wire [7:0]  reg_iq_est_fo_min,
  //
  input  wire        reg_iq_est_phase_en,
  input  wire        reg_iq_est_gain_en,
  //
  input  wire [2:0]  reg_iq_est_del,
  //
  input  wire [2:0]  reg_iq_est_gain_step_init,
  input  wire [2:0]  reg_iq_est_gain_step_stop,
  input  wire [2:0]  reg_iq_est_phase_step_init,
  input  wire [2:0]  reg_iq_est_phase_step_stop,
  //
  input  wire [2:0]  reg_iq_est_step_del0,
  input  wire [2:0]  reg_iq_est_step_del1,
  input  wire [2:0]  reg_iq_est_step_del2,
  input  wire [2:0]  reg_iq_est_step_del3,
  input  wire [2:0]  reg_iq_est_step_del4,
  //
  input  wire [10:0] reg_iq_gain0,
  input  wire [8:0]  reg_iq_phase0,
  //
  output wire [21:0] stat_reg_var_i0,
  output wire [21:0] stat_reg_var_q0,
  output wire [22:0] stat_reg_m_iq0,
  output wire [10:0] stat_reg_iq_gain_est0,
  output wire [8:0]  stat_reg_iq_phase_est0,
  output wire        stat_reg_valid,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire [10:0] reg_iq_gain1,
  input  wire [8:0]  reg_iq_phase1,
  //
  output wire [21:0] stat_reg_var_i1,
  output wire [21:0] stat_reg_var_q1,
  output wire [22:0] stat_reg_m_iq1,
  output wire [10:0] stat_reg_iq_gain_est1,
  output wire [8:0]  stat_reg_iq_phase_est1,
`endif
  
  // Input data from FE
  input wire  [12:0] fe_20i0,
  input wire  [12:0] fe_20q0,
`ifdef RW_NX_DERIV_FE_PATH40M
  input wire  [12:0] fe_40i0,    
  input wire  [12:0] fe_40q0,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input wire  [12:0] fe_80i0,
  input wire  [12:0] fe_80q0,
`endif
`ifdef RW_NX_DERIV_FE_PATH1
  input wire  [12:0] fe_20i1,    
  input wire  [12:0] fe_20q1,
`ifdef RW_NX_DERIV_FE_PATH40M
  input wire  [12:0] fe_40i1,    
  input wire  [12:0] fe_40q1,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input wire  [12:0] fe_80i1,
  input wire  [12:0] fe_80q1,
`endif
`endif

  // IQ estimates
  output wire [10:0] iq_gain_est0,
  output wire [8:0]  iq_phase_est0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [10:0] iq_gain_est1,
  output wire [8:0]  iq_phase_est1,
`endif
  
  // Control from AGC
  input  wire        iq_est_gain_acc_en,
  input  wire        iq_est_phase_acc_en,
  input  wire [7:0]  snr,
  input  wire        agc_lock,

  // Control from modem
  input  wire        frame_leg,
  input  wire        frame_vht,
  input  wire [3:0]  legrate,
  input  wire [6:0]  mcs,
  input  wire        bweq20,
  input  wire        bweq40,
  input  wire        bweq80,
  input  wire [7:0]  fo_est
  );

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  wire        err_clr;
  wire        err_en;

  wire [2:0]  gain_step;
  wire [2:0]  phase_step;
  wire        iter_gain_inc;
  wire        iter_phase_inc;

  wire [12:0] err_in_i0;
  wire [12:0] err_in_q0;
  wire [21:0] var_i0;
  wire [21:0] var_q0;
  wire [22:0] m_iq0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire [12:0] err_in_i1;
  wire [12:0] err_in_q1;
  wire [21:0] var_i1;
  wire [21:0] var_q1;
  wire [22:0] m_iq1;
`endif

//////////////////////////////////////////////////////////////////////////////
// Internal Regs declarations
//////////////////////////////////////////////////////////////////////////////
  reg  [12:0] fe_20i0_1t;
  reg  [12:0] fe_20q0_1t;
`ifdef RW_NX_DERIV_FE_PATH40M
  reg  [12:0] fe_40i0_1t;
  reg  [12:0] fe_40q0_1t;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  reg  [12:0] fe_80i0_1t;
  reg  [12:0] fe_80q0_1t;
`endif
`ifdef RW_NX_DERIV_FE_PATH1
  reg  [12:0] fe_20i1_1t;
  reg  [12:0] fe_20q1_1t;
`ifdef RW_NX_DERIV_FE_PATH40M
  reg  [12:0] fe_40i1_1t;
  reg  [12:0] fe_40q1_1t;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  reg  [12:0] fe_80i1_1t;
  reg  [12:0] fe_80q1_1t;
`endif
`endif

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Instanciation of iq_est_ctrl
// Name of the instance : u_iq_est_ctrl
// Name of the file containing this module : iq_est_ctrl.v
iq_est_ctrl u_iq_est_ctrl (
    .clk                              (clk),
    .reset_n                          (reset_n),
    .reg_cbw                          (reg_cbw),
    .reg_iq_est_iter_clr              (reg_iq_est_iter_clr),
    .reg_iq_est_snr_min               (reg_iq_est_snr_min),
    .reg_iq_est_mcs_min               (reg_iq_est_mcs_min),
    .reg_iq_est_bw_list               (reg_iq_est_bw_list),
    .reg_iq_est_fo_min                (reg_iq_est_fo_min),
    .reg_iq_est_phase_en              (reg_iq_est_phase_en),
    .reg_iq_est_gain_en               (reg_iq_est_gain_en),
    .reg_iq_est_del                   (reg_iq_est_del),
    .reg_iq_est_gain_step_init        (reg_iq_est_gain_step_init),
    .reg_iq_est_gain_step_stop        (reg_iq_est_gain_step_stop),
    .reg_iq_est_phase_step_init       (reg_iq_est_phase_step_init),
    .reg_iq_est_phase_step_stop       (reg_iq_est_phase_step_stop),
    .reg_iq_est_step_del0             (reg_iq_est_step_del0),
    .reg_iq_est_step_del1             (reg_iq_est_step_del1),
    .reg_iq_est_step_del2             (reg_iq_est_step_del2),
    .reg_iq_est_step_del3             (reg_iq_est_step_del3),
    .reg_iq_est_step_del4             (reg_iq_est_step_del4),
    .stat_reg_valid                   (stat_reg_valid),
    .iq_est_gain_acc_en               (iq_est_gain_acc_en),
    .iq_est_phase_acc_en              (iq_est_phase_acc_en),
    .snr                              (snr),
    .agc_lock                         (agc_lock),
    .frame_leg                        (frame_leg),
    .frame_vht                        (frame_vht),
    .legrate                          (legrate),
    .mcs                              (mcs),
    .bweq20                           (bweq20),
    .bweq40                           (bweq40),
    .bweq80                           (bweq80),
    .fo_est                           (fo_est),
    .err_clr                          (err_clr),
    .err_en                           (err_en),
    .gain_step                        (gain_step),
    .phase_step                       (phase_step),
    .iter_gain_inc                    (iter_gain_inc),
    .iter_phase_inc                   (iter_phase_inc)
    );

// Capture FE input before mux
always @(posedge clk or negedge reset_n)
begin
  if (reset_n == 1'b0)
  begin
    fe_20i0_1t <= 13'b0;
    fe_20q0_1t <= 13'b0;
`ifdef RW_NX_DERIV_FE_PATH40M
    fe_40i0_1t <= 13'b0;
    fe_40q0_1t <= 13'b0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    fe_80i0_1t <= 13'b0;
    fe_80q0_1t <= 13'b0;
`endif
  end
  else 
  begin
    fe_20i0_1t <= fe_20i0;
    fe_20q0_1t <= fe_20q0;
`ifdef RW_NX_DERIV_FE_PATH40M
    fe_40i0_1t <= fe_40i0;
    fe_40q0_1t <= fe_40q0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    fe_80i0_1t <= fe_80i0;
    fe_80q0_1t <= fe_80q0;
`endif
  end
end

// IQ error estimation input mux
assign {err_in_i0,err_in_q0} =
`ifdef RW_NX_DERIV_FE_PATH80M
           (reg_cbw==2'd2) ? {fe_80i0_1t, fe_80q0_1t} :
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
           (reg_cbw==2'd1) ? {fe_40i0_1t, fe_40q0_1t} :
`endif
                             {fe_20i0_1t, fe_20q0_1t};

// Instanciation of iq_err
// Name of the instance : u_iq_err
// Name of the file containing this module : iq_err.v
iq_err u_iq_err0 (
    .clk          (clk),
    .reset_n      (reset_n),
    .err_clr      (err_clr),
    .err_en       (err_en),
    .in_i         (err_in_i0),
    .in_q         (err_in_q0),
    .var_i        (var_i0),
    .var_q        (var_q0),
    .m_iq         (m_iq0)
    );

// Instanciation of iq_est_loop
// Name of the instance : u_iq_est_loop
// Name of the file containing this module : iq_est_loop.v
iq_est_loop u_iq_est_loop0 (
    .clk                    (clk),
    .reset_n                (reset_n),
    .reg_iq_est_iter_clr    (reg_iq_est_iter_clr),
    .reg_iq_gain            (reg_iq_gain0),
    .reg_iq_phase           (reg_iq_phase0),
    .var_i                  (var_i0),
    .var_q                  (var_q0),
    .m_iq                   (m_iq0),
    .gain_step              (gain_step),
    .phase_step             (phase_step),
    .iter_gain_inc          (iter_gain_inc),
    .iter_phase_inc         (iter_phase_inc),
    .iq_gain_est            (iq_gain_est0),
    .iq_phase_est           (iq_phase_est0)
    );

`ifdef RW_NX_DERIV_FE_PATH1

// Capture FE input before mux
always @(posedge clk or negedge reset_n)
begin
  if (reset_n == 1'b0)
  begin
    fe_20i1_1t <= 13'b0;
    fe_20q1_1t <= 13'b0;
`ifdef RW_NX_DERIV_FE_PATH40M
    fe_40i1_1t <= 13'b0;
    fe_40q1_1t <= 13'b0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    fe_80i1_1t <= 13'b0;
    fe_80q1_1t <= 13'b0;
`endif
  end
  else 
  begin
    fe_20i1_1t <= fe_20i1;
    fe_20q1_1t <= fe_20q1;
`ifdef RW_NX_DERIV_FE_PATH40M
    fe_40i1_1t <= fe_40i1;
    fe_40q1_1t <= fe_40q1;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    fe_80i1_1t <= fe_80i1;
    fe_80q1_1t <= fe_80q1;
`endif
  end
end

// IQ error estimation input mux
assign {err_in_i1,err_in_q1} =
`ifdef RW_NX_DERIV_FE_PATH80M
           (reg_cbw==2'd2) ? {fe_80i1_1t, fe_80q1_1t} :
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
           (reg_cbw==2'd1) ? {fe_40i1_1t, fe_40q1_1t} :
`endif
                             {fe_20i1_1t, fe_20q1_1t};

// Instanciation of iq_err
// Name of the instance : u_iq_err
// Name of the file containing this module : iq_err.v
iq_err u_iq_err1 (
    .clk          (clk),
    .reset_n      (reset_n),
    .err_clr      (err_clr),
    .err_en       (err_en),
    .in_i         (err_in_i1),
    .in_q         (err_in_q1),
    .var_i        (var_i1),
    .var_q        (var_q1),
    .m_iq         (m_iq1)
    );

// Instanciation of iq_est_loop
// Name of the instance : u_iq_est_loop
// Name of the file containing this module : iq_est_loop.v
iq_est_loop u_iq_est_loop1 (
    .clk                    (clk),
    .reset_n                (reset_n),
    .reg_iq_est_iter_clr    (reg_iq_est_iter_clr),
    .reg_iq_gain            (reg_iq_gain1),
    .reg_iq_phase           (reg_iq_phase1),
    .var_i                  (var_i1),
    .var_q                  (var_q1),
    .m_iq                   (m_iq1),
    .gain_step              (gain_step),
    .phase_step             (phase_step),
    .iter_gain_inc          (iter_gain_inc),
    .iter_phase_inc         (iter_phase_inc),
    .iq_gain_est            (iq_gain_est1),
    .iq_phase_est           (iq_phase_est1)
    );
`endif

// Status registers
assign stat_reg_var_i0        = var_i0;
assign stat_reg_var_q0        = var_q0;
assign stat_reg_m_iq0         = m_iq0;
assign stat_reg_iq_gain_est0  = iq_gain_est0;
assign stat_reg_iq_phase_est0 = iq_phase_est0;
`ifdef RW_NX_DERIV_FE_PATH1
assign stat_reg_var_i1        = var_i1;
assign stat_reg_var_q1        = var_q1;
assign stat_reg_m_iq1         = m_iq1;
assign stat_reg_iq_gain_est1  = iq_gain_est1;
assign stat_reg_iq_phase_est1 = iq_phase_est1;
`endif

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
