/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: oringot $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: 22181 $
* $Date: 2015-10-23 15:48:27 +0200 (Fri, 23 Oct 2015) $
* -------------------------------------------------------------------------
* Dependencies     :                                                       
* Description      : 
*   Swap IQ and signed/unsigned represntation change
*     o can work-around ADC/DAC sign issue
*     o can work-around I/Q swap, differential swap (spectral inversion)
* Simulation Notes :                                                       
* Synthesis Notes  :                                                       
* Application Note :                                                       
* Simulator        :                                                       
* Parameters       : 
* Terms & concepts :                                                       
* Bugs             :                                                       
* Open issues and future enhancements :                                    
* References       :                                                       
* Revision History :                                                       
*--------------------------------------------------------------------------
*                                                                          
* $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MDMCOMMON/RIUCORE/RIUCore/verilog/rtl/FEFix.v $
*
*******************************************************************************/
`default_nettype none
module FEFix
(
    /***************************************************************************
    * system
    ***************************************************************************/
    input  wire        Clk,
    input  wire        nRst,
    /***************************************************************************
    * parameters
    ***************************************************************************/
    input  wire        C2SDisable,
    input  wire        IQSwap,
    input  wire        IDelay,
    input  wire        QDelay,
    /***************************************************************************
    * datapath
    ***************************************************************************/
    input  wire [11:0] I,                             
    input  wire [11:0] Q,
    output wire [11:0] FixedI,
    output wire [11:0] FixedQ
);

  /* sign/unsigned fix*/
  wire   [11:0] cfix_i,cfix_q;
  assign {cfix_i,cfix_q} = (C2SDisable)?{~I[11],I[10:0],~Q[11],Q[10:0]}:{I,Q};
 
  /* swap fix*/
  wire   [11:0] sfix_i,sfix_q;
  assign {sfix_i,sfix_q} = (IQSwap)?{cfix_q,cfix_i}:{cfix_i,cfix_q};
  
  /* delay fix */
  reg    [11:0] i_1t,q_1t;
  always @(posedge Clk,negedge nRst)
    if(!nRst)
      {i_1t,q_1t} <= 24'b0;
    else
      {i_1t,q_1t} <={sfix_i,sfix_q};

  assign FixedI = IDelay?i_1t:sfix_i;
  assign FixedQ = QDelay?q_1t:sfix_q;

endmodule
`default_nettype wire
/*******************************************************************************
* End of file
*******************************************************************************/

