//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: oringot $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 37536 $
// $Date: 2019-02-08 00:09:42 +0100 (Fri, 08 Feb 2019) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of RIU Core module
//                    All resynchronization must be implemented with 
//                    RIUCore instance
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module RIUCore
(
  /*****************************************************************************
  * Resets
  *****************************************************************************/
  input  wire        nAGCRst,
  input  wire        nFERst,
`ifdef RW_NX_FIQ_COMP_EN
  input  wire        nFENoWdRst,
`endif // RW_NX_FIQ_COMP_EN
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire        nFE160Rst,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire        nFE80Rst,
`endif
  input  wire        nFE40Rst,
`ifdef RW_NX_DERIV_80211B
  input  wire        nFE44Rst,
`endif  

`ifdef RW_RADAR_EN
  input  wire        nRegBusRst,
  input  wire        nRadarTimRst,
`endif // RW_RADAR_EN

  /*****************************************************************************
  * Clocks
  *****************************************************************************/
  /* AGC */
  input  wire        AGCGClk,
  input  wire        ADCPowGClk,

  /* regbus */
  input  wire        RegBusClk,
  
  /* Front-end 44MHz */
`ifdef RW_NX_DERIV_80211B
  input  wire        FE44GClk, // SHALL BE COHERENT WITH FEClk
`endif

  /* Front-end path 0*/
  input  wire        FERxPath0GClk,
  input  wire        FETxPath0GClk,
`ifdef RW_NX_IQ_COMP_EN
  input  wire        FETxRxPath0GClk,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire        FE160Path0GClk,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire        FE80Path0GClk,
`endif  
  input  wire        FE40Path0GClk,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        FERxPath1GClk,
  input  wire        FETxPath1GClk,
`ifdef RW_NX_IQ_COMP_EN
  input  wire        FETxRxPath1GClk,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire        FE160Path1GClk,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire        FE80Path1GClk,
`endif  
  input  wire        FE40Path1GClk,
`endif // RW_NX_DERIV_FE_PATH1               

`ifdef RW_RADAR_EN
  /* Radar detection */
  input  wire        RadarTimGClk,
`endif 

  /*****************************************************************************
  * modem configuration
  *****************************************************************************/
  input  wire [ 1:0] CfgRegMdmConfBW,
  input  wire [ 2:0] CfgRegMdmConfPrimary,

`ifdef RW_RADAR_EN
  /*****************************************************************************
  * Radar FIFO read interface (@ RegBusClk)
  *****************************************************************************/
  input  wire        RadarFifoRdEn,
  output wire [31:0] RadarFifoRdData,
`endif // RW_RADAR_EN
  
  /*****************************************************************************
  * AGC
  *****************************************************************************/
  output wire        AGCRifsDetected,
  output wire        AGCOFDMLock,
  output wire        AGCOFDMHTSTF,
  output wire        AGCDSSSLock,
  //
  output wire        AGCP1Update,
  output wire [7:0]  AGCP1SNR,
  output wire [7:0]  AGCP1NoiseVardB,
  //
  output wire        AGCP2Update,                                                    
  output wire [7:0]  AGCP2RxAntennaset,
  output wire [7:0]  AGCP2Rssi1,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [7:0]  AGCP2Rssi2,
`endif
  //
  output wire        AGCCCAPrimary20,
  output wire        AGCCCASecondary20,
  output wire        AGCCCASecondary40,
  //
  input wire         AGCOn,
  input wire         AGCKeepRFOn,
  //
  input wire         AGCSFDFound,
  input wire         AGCStartEstimP,
  input wire         AGCGainUpdateP,
  input wire         AGCVHTFrame,
  input wire         AGCNoACIMargin,
  input wire         AGCDemodRun,
  
  input wire         AGCBWSup20,
  input wire         AGCBWEq20,
  input wire         AGCBWEq40,
  input wire         AGCBWEq80,
  input wire         AGCPlatFallP,     // qualify AGCBWxxx

  input wire         AGCCCALSIGValid,
  input wire         AGCCCAHTSigVHTSigAValid,
  input wire         AGCRxEndTiming,
  input wire [6:0]   AGCFrameParamMCS,
  input wire         RxFEEnDSSS,

  input wire         InbdPowStartCaptureP,
  
`ifdef RW_NX_IQ_COMP_EN
  input wire         AGCLegFrame,
  input wire [7:0]   AGCFOAngle,
  input wire [3:0]   AGCFrameParamLegRate,
`endif

  /*****************************************************************************
  * FE block enables
  *****************************************************************************/
  input wire         OFDMTxBlockEn,
`ifdef RW_NX_DERIV_80211B
  input wire         DSSSTxBlockEn,
`endif
  
  /*****************************************************************************
  * OFDM PHY datapath
  *****************************************************************************/
  /* TX0 */ 
  input  wire        OFDMTxPipeRelease,
  output wire        OFDMTxPipeLoaded,
  input  wire        OFDMTxSFOBypass,   
  input  wire [26:0] OFDMTxSFOPPM,
  input  wire        OFDMTxCFOBypass,   
  input  wire [24:0] OFDMTxCFOFreq,
  input  wire [ 6:0] OFDMTxDigGain0,

  output wire        OFDMTxReady,   
  input  wire [12:0] OFDMTxI0,
  input  wire [12:0] OFDMTxQ0,
  input  wire        OFDMTxValid,   
  
  /* RX 0 */
  output wire        OFDMRxValid,
  output wire [12:0] OFDMRx20I0,
  output wire [12:0] OFDMRx20Q0,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire [12:0] OFDMRx20SecI,    
  output wire [12:0] OFDMRx20SecQ,    
  output wire [12:0] OFDMRx40I0,   
  output wire [12:0] OFDMRx40Q0,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire [12:0] OFDMRx80I0,    
  output wire [12:0] OFDMRx80Q0,    
`endif
 
`ifdef RW_NX_DERIV_FE_PATH1
  /* TX1 */ 
  input  wire [6:0]  OFDMTxDigGain1,
  input  wire [11:0] OFDMTxI1,
  input  wire [11:0] OFDMTxQ1,
  
  /* RX 1 */
  output wire [12:0] OFDMRx20I1,
  output wire [12:0] OFDMRx20Q1,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire [12:0] OFDMRx40I1,    
  output wire [12:0] OFDMRx40Q1,    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire [12:0] OFDMRx80I1,    
  output wire [12:0] OFDMRx80Q1,    
`endif
`endif // RW_NX_DERIV_FE_PATH1

`ifdef RW_NX_DERIV_80211B
  /*****************************************************************************
  * DSSS PHY datapath
  *****************************************************************************/
  /* TX */
  input  wire        DSSSTxValid,
  input  wire [ 6:0] DSSSTxI,
  input  wire [ 6:0] DSSSTxQ,       
 
  /* RX */
  output wire        DSSSRxValid,
  output wire [ 6:0] DSSSRxI,
  output wire [ 6:0] DSSSRxQ,
`endif

  /*****************************************************************************
  * memories
  *****************************************************************************/
  /* AGC */
  output wire [8:0]  AGCMemAddr,
  input  wire [31:0] AGCMemRdData,

  /* fIQ Imbalance */
`ifdef RW_NX_FIQ_COMP_EN
  output wire [7:0]  fIQMemAddr,
  output wire        fIQMemWrEn,
  output wire        fIQMemRdEn,
  output wire [63:0] fIQMemWrData,
  input  wire [63:0] fIQMemRdData,
`endif // RW_NX_FIQ_COMP_EN

`ifdef RW_RADAR_EN
  /* Radar detection */
  output wire [8:0]  RadarMemAddr,
  output wire        RadarMemEn,
  output wire        RadarMemWrEn,
  output wire [9:0]  RadarMemWrData,
  input  wire [9:0]  RadarMemRdData,
`endif // RW_RADAR_EN
 
  /*****************************************************************************
  * Converters 
  *****************************************************************************/
  /* ADC 0 */
  input  wire [11:0] ADCI0,      
  input  wire [11:0] ADCQ0,      
  /* DAC 0 */
  output wire        DACEn0, 
  output wire [11:0] DACI0,  
  output wire [11:0] DACQ0, 
   
`ifdef RW_NX_DERIV_FE_PATH1
  /* ADC 1 */
  input  wire [11:0] ADCI1,      
  input  wire [11:0] ADCQ1,      
  /* DAC 1 */
  output wire        DACEn1, 
  output wire [11:0] DACI1,  
  output wire [11:0] DACQ1,  
`endif  

  /*******************************************************************
  * RC and Gain Table interface
  *******************************************************************/
  input  wire        RCProgRFDone,
  input  wire        RCRFGainCompDone,
  input  wire        RCExtDetect0,
  input  wire [7:0]  RFGaindB0,
`ifdef RW_NX_AGC_SNR_EN
  input  wire [5:0]  RFGainNFdB0,
`endif // RW_NX_AGC_SNR_EN
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        RCExtDetect1,
  input  wire [7:0]  RFGaindB1,
`ifdef RW_NX_AGC_SNR_EN
  input  wire [5:0]  RFGainNFdB1,
`endif // RW_NX_AGC_SNR_EN
`endif

  output wire        RCProgRF,
  output wire        RCRFGainCompReq,
  output wire [7:0]  AGCGainTgt0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [7:0]  AGCGainTgt1,
`endif

  /*****************************************************************************
  * Register Interface
  *****************************************************************************/
  input  wire        StatusTrigConf,
  output wire        StatusTrigReq,

  output wire [7:0]  StRegRxGainAnt0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [7:0]  StRegRxGainAnt1,
`endif //   RW_NX_DERIV_FE_PATH1  
    
  output wire [8:0]  StRegADCPowqdBVAnt0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [8:0]  StRegADCPowqdBVAnt1,
`endif  

  output wire [9:0]  StRegInBd20PowqdBmAnt0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [9:0]  StRegInBd20PowqdBmAnt1,
`endif  

  output wire [6:0]  StRegDigGaindB80Ant0,
  output wire [6:0]  StRegDigGaindB40Ant0,
  output wire [6:0]  StRegDigGaindB20Ant0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [6:0]  StRegDigGaindB80Ant1,
  output wire [6:0]  StRegDigGaindB40Ant1,
  output wire [6:0]  StRegDigGaindB20Ant1,
`endif  
  
`ifdef RW_RADAR_EN
  output wire        StRegRadarFifoEmpty, 
`endif // RW_RADAR_EN
    
  output wire [9:0]  StRegInbdPow20PNoisedBm0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [9:0]  StRegInbdPow20PNoisedBm1,
`endif  
  output wire        StRegInbdPow20PNoiseUpdate, 
  output wire [9:0]  StRegInbdPow40SdBm,
  output wire [9:0]  StRegInbdPow20SdBm,
  output wire [9:0]  StRegInbdPow40SNoisedBm,
  output wire [9:0]  StRegInbdPow20SNoisedBm,
  
  input wire [1:0]   CfgRegActiveAnt,
  input wire         CfgRegTxIQSwapPath0,
  input wire         CfgRegRxIQSwapPath0,
  input wire         CfgRegTxIQDelPathQ0,
  input wire         CfgRegTxIQDelPathI0,
  input wire         CfgRegRxIQDelPathQ0,
  input wire         CfgRegRxIQDelPathI0,
`ifdef RW_NX_DERIV_FE_PATH1
  input wire         CfgRegTxIQSwapPath1,
  input wire         CfgRegRxIQSwapPath1,
  input wire         CfgRegTxIQDelPathQ1,
  input wire         CfgRegTxIQDelPathI1,
  input wire         CfgRegRxIQDelPathQ1,
  input wire         CfgRegRxIQDelPathI1,
`endif  
  input wire         CfgRegTxC2sDisb,
  input wire         CfgRegRxC2sDisb,
`ifdef RW_NX_IQ_COMP_EN
  input  wire        CfgRegTxIQGainCompEn0,
  input  wire        CfgRegTxIQPhaseCompEn0,
  input  wire [10:0] CfgRegTxIQGain0,
  input  wire [ 8:0] CfgRegTxIQPhase0,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        CfgRegTxIQGainCompEn1,
  input  wire        CfgRegTxIQPhaseCompEn1,
  input  wire [10:0] CfgRegTxIQGain1,
  input  wire [ 8:0] CfgRegTxIQPhase1,
`endif
  input  wire        CfgRegRxIQEstIterClr,
  input  wire [7:0]  CfgRegRxIQEstSNRMin,
  input  wire [3:0]  CfgRegRxIQEstMCSMin,
  input  wire [2:0]  CfgRegRxIQEstBWList,
  input  wire [7:0]  CfgRegRxIQEstFOMin,
  input  wire        CfgRegRxIQPhaseEstEn,
  input  wire        CfgRegRxIQGainEstEn,
  input  wire        CfgRegRxIQPhaseCompEn,
  input  wire        CfgRegRxIQGainCompEn,
  input  wire [2:0]  CfgRegRxIQEstDel,
  input  wire [2:0]  CfgRegRxIQEstGainStepInit,
  input  wire [2:0]  CfgRegRxIQEstGainStepStop,
  input  wire [2:0]  CfgRegRxIQEstPhaseStepInit,
  input  wire [2:0]  CfgRegRxIQEstPhaseStepStop,
  input  wire [2:0]  CfgRegRxIQEstStepDel0,
  input  wire [2:0]  CfgRegRxIQEstStepDel1,
  input  wire [2:0]  CfgRegRxIQEstStepDel2,
  input  wire [2:0]  CfgRegRxIQEstStepDel3,
  input  wire [2:0]  CfgRegRxIQEstStepDel4,
  //
  input  wire [10:0] CfgRegRxIQGain0,
  input  wire [8:0]  CfgRegRxIQPhase0,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire [10:0] CfgRegRxIQGain1,
  input  wire [8:0]  CfgRegRxIQPhase1,
`endif
  //
  output wire [21:0] StRegRxIQEstVarI0,
  output wire [21:0] StRegRxIQEstVarQ0,
  output wire [22:0] StRegRxIQEstMIQ0,
  output wire [10:0] StRegRxIQEstIQGainEst0,
  output wire [8:0]  StRegRxIQEstIQPhaseEst0,
  output wire        StRegRxIQEstValid,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [21:0] StRegRxIQEstVarI1,
  output wire [21:0] StRegRxIQEstVarQ1,
  output wire [22:0] StRegRxIQEstMIQ1,
  output wire [10:0] StRegRxIQEstIQGainEst1,
  output wire [8:0]  StRegRxIQEstIQPhaseEst1,
`endif
`endif
  input wire [3:0]   AgcRegAntLossDB0,
  input wire [3:0]   AgcRegAntLossDB1,
  input wire [6:0]   AgcRegRFGainMax4DetdB,
  input wire [6:0]   AgcRegRFGainMin4DetdB,
  input wire [6:0]   AgcRegRFGainMaxdB,
  input wire [6:0]   AgcRegRFGainMindB,
  input wire [3:0]   AgcRegDigGain80vs20,
  input wire [3:0]   AgcRegDigGain40vs20,
`ifdef RW_NX_AGC_SNR_EN
  input wire         AgcRegSNRMeasSel,
`endif // RW_NX_AGC_SNR_EN
  input wire [5:0]   AgcRegACI20MargMCS3,
  input wire [5:0]   AgcRegACI20MargMCS2,
  input wire [5:0]   AgcRegACI20MargMCS1,
  input wire [5:0]   AgcRegACI20MargMCS0,
  input wire [5:0]   AgcRegACI20MargMCS7,
  input wire [5:0]   AgcRegACI20MargMCS6,
  input wire [5:0]   AgcRegACI20MargMCS5,
  input wire [5:0]   AgcRegACI20MargMCS4,
  input wire [5:0]   AgcRegACI20MargMCS9,
  input wire [5:0]   AgcRegACI20MargMCS8,
  input wire [5:0]   AgcRegACI40MargMCS3,
  input wire [5:0]   AgcRegACI40MargMCS2,
  input wire [5:0]   AgcRegACI40MargMCS1,
  input wire [5:0]   AgcRegACI40MargMCS0,
  input wire [5:0]   AgcRegACI40MargMCS7,
  input wire [5:0]   AgcRegACI40MargMCS6,
  input wire [5:0]   AgcRegACI40MargMCS5,
  input wire [5:0]   AgcRegACI40MargMCS4,
  input wire [5:0]   AgcRegACI40MargMCS9,
  input wire [5:0]   AgcRegACI40MargMCS8,
  input wire [5:0]   AgcRegACI80MargMCS3,
  input wire [5:0]   AgcRegACI80MargMCS2,
  input wire [5:0]   AgcRegACI80MargMCS1,
  input wire [5:0]   AgcRegACI80MargMCS0,
  input wire [5:0]   AgcRegACI80MargMCS7,
  input wire [5:0]   AgcRegACI80MargMCS6,
  input wire [5:0]   AgcRegACI80MargMCS5,
  input wire [5:0]   AgcRegACI80MargMCS4,
  input wire [5:0]   AgcRegACI80MargMCS9,
  input wire [5:0]   AgcRegACI80MargMCS8,
  input wire [4:0]   AgcRegSatDelayCount,
  input wire [5:0]   AgcRegSatDynHighThr,
  input wire [5:0]   AgcRegSatLowThr,
  input wire [5:0]   AgcRegSatDynLowThr,
  input wire [9:0]   AgcRegDetFallThrqdBm,
  input wire [9:0]   AgcRegDetRiseThrqdBm,
  input wire [2:0]   AgcRegDelRampDownTap,
  input wire [7:0]   AgcRegDetRampDown,
  input wire [2:0]   AgcRegDelRampUpTap,
  input wire [7:0]   AgcRegDetRampUp,
  input wire [3:0]   AgcRegADCPowDisNdl,
  input wire [6:0]   AgcRegADCPowDisThrdBV,
  input wire [2:0]   AgcRegDelPlatTap,
  input wire [4:0]   AgcRegDetPlat,
`ifdef RW_NX_DERIV_80211B
  input wire [1:0]   AgcRegDC4DSSSCompType,
  input wire [6:0]   AgcRegDC4DSSSHoldTime,
  input wire [6:0]   AgcRegDC4DSSSZeroTime,
`endif  
  input wire [1:0]   AgcRegDC4CenteredCompType,
  input wire [6:0]   AgcRegDC4CenteredHoldTime,
  input wire [6:0]   AgcRegDC4CenteredZeroTime,
  input wire [1:0]   AgcRegDC4PrimaryCompType,
  input wire [6:0]   AgcRegDC4PrimaryHoldTime,
  input wire [6:0]   AgcRegDC4PrimaryZeroTime,
  input wire [1:0]   AgcRegDC4ADCCompType,
  input wire [6:0]   AgcRegDC4ADCHoldTime,
  input wire [6:0]   AgcRegDC4ADCZeroTime,
`ifdef RW_RADAR_EN
  input wire [1:0]   AgcRegDC4RadarCompType,
  input wire [6:0]   AgcRegDC4RadarHoldTime,
  input wire [6:0]   AgcRegDC4RadarZeroTime,
`endif // RW_RADAR_EN
  input wire [6:0]   AgcRegDelStableDC,
  input wire [31:0]  AgcRegFsmEvent0,
  input wire [31:0]  AgcRegFsmEvent1,
  input wire [31:0]  AgcRegFsmEvent2,
  input wire [31:0]  AgcRegFsmEvent3,
  input wire         AgcRegHTSTFGainEn,
  input wire         AgcRegAgcFsmReset,
`ifdef RW_RADAR_EN
  input wire         AgcRegRadarDetEn,
`endif // RW_RADAR_EN
  input wire         AgcRegRifsDetEn,
  input wire         AgcRegModeB,
  input wire         AgcRegModeA,
  input wire [3:0]   AgcRegGPSetting,
  input wire [1:0]   AgcRegChCombMode,
  input wire [3:0]   AgcRegNBitAdc,
  input wire [7:0]   AgcRegVPeakADCqdBV,
  input wire [7:0]   AgcRegADCdBVThr,
  input wire [7:0]   AgcRegADCPowBiasqdBV,
  input wire [7:0]   AgcRegADCdBmThr,
  input wire [7:0]   AgcRegADCPowBiasqdBm,
  input wire [7:0]   AgcRegInBd40SPowBiasqdBm,
  input wire [7:0]   AgcRegInBd20SPowBiasqdBm,
  input wire [7:0]   AgcRegInBd20PPowBiasqdBm,
  input wire [7:0]   AgcRegInBddBVThr,
  input wire [1:0]   AgcRegInBdRnd,
  input wire [7:0]   AgcRegInBddBmThr,
  input wire [7:0]   AgcRegFE40Gain,
  input wire [7:0]   AgcRegFE20Gain,
  input wire [2:0]   AgcRegDelCCARampDownTap,
  input wire [2:0]   AgcRegDelCCARampUpTap,
  input wire [5:0]   AgcRegCCADetRampDown,
  input wire [5:0]   AgcRegCCADetRampUp,
  input wire [8:0]   AgcRegInbdCCA20PPowMindBm,
  input wire [7:0]   AgcRegCCA20PFallThrdBm,
  input wire         AgcRegDisCCAEn,
  input wire         AgcRegSatCCAEn,
  input wire [7:0]   AgcRegCCA20PRiseThrdBm,
  input wire [8:0]   AgcRegInbdCCA20SPowMindBm,
  input wire [7:0]   AgcRegCCA20SFallThrdBm,
  input wire [7:0]   AgcRegCCA20SRiseThrdBm,
  input wire [8:0]   AgcRegInbdCCA40SPowMindBm,
  input wire [7:0]   AgcRegCCA40SFallThrdBm,
  input wire [7:0]   AgcRegCCA40SRiseThrdBm,
  input wire [3:0]   AgcRegCCAFlag3Ctrl,
  input wire [3:0]   AgcRegCCAFlag2Ctrl,
  input wire [3:0]   AgcRegCCAFlag1Ctrl,
  input wire [3:0]   AgcRegCCAFlag0Ctrl,
  input wire [1:0]   AgcRegAntSelCCA40s,
  input wire [1:0]   AgcRegAntSelCCA20s,
  input wire         AgcRegCCADemod,
  input wire         AgcRegCCACSEn,
  input wire [2:0]   AgcRegCCARampUDen,
  input wire [2:0]   AgcRegCCAEnergyEn,
  input wire [10:0]  AgcRegRxStateCca20SSel,
  input wire [10:0]  AgcRegRxStateCca20PSel,
  input wire [10:0]  AgcRegRxStateCca40SSel,
  input wire [31:0]  AgcRegCCATimeOut,
  input wire [7:0]   AgcRegIdInbdPowGapDnqdBm,
  input wire [7:0]   AgcRegIdInbdPowGapUpqdBm,
  input wire [7:0]   AgcRegInbdPowInfThrdBm,
  input wire [7:0]   AgcRegInbdPowSupThrdBm,
  input wire [7:0]   AgcRegADCPowInfThrdBV,
  input wire [7:0]   AgcRegADCPowSupThrdBV,
  input wire [7:0]   AgcRegADCPowInfThrdBm,
  input wire [7:0]   AgcRegADCPowSupThrdBm,
`ifdef RW_RADAR_EN
  input wire [1:0]   AgcRegAntSelRadar,
  input wire [3:0]   AgcRegFreqSingGap,
  input wire [7:0]   AgcRegFreqSing,
  input wire [3:0]   AgcRegFomSingGap,
  input wire [7:0]   AgcRegFomSing,
  input wire         PulseTimerClear,
  input wire [2:0]   AgcRegPulseIrqFifoThr,
  input wire [7:0]   AgcRegPulseIrqTimeOut,
`endif // RW_RADAR_EN
  input wire [2:0]   CfgRegBRxShift,
  input wire [1:0]   CfgRegBTxShift,
  input wire [1:0]   CfgRegBRxPathSel,
  input wire         CfgRegRxPathSelFromReg,

`ifdef RW_NX_FIQ_COMP_EN
  /*****************************************************************************
  * fIQ imbalance 
  *****************************************************************************/
  // Controls
  input  wire        fIQCollStartP,
  output wire        fIQCollDone,
  input  wire        fIQEstStartP,
  output wire        fIQEstDone,
  // registers
  input  wire        CfgRegfIQCalEn,
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire        CfgRegfIQPathSel,
`endif  
  input  wire        CfgRegfIQTxRx,
  input  wire        CfgRegfIQTxBypass,
  input  wire        CfgRegfIQRxBypass,
  input  wire        CfgRegfIQCollPath,
  input  wire [ 7:0] CfgRegfIQCollWrOffset,
  input  wire [ 7:0] CfgRegfIQCollRdOffset,
  input  wire [ 7:0] CfgRegfIQCollSize,
  input  wire [ 7:0] CfgRegfIQEstIOffset,
  input  wire [ 7:0] CfgRegfIQEstQOffset,
  input  wire [ 7:0] CfgRegfIQEstSize,
  input  wire [ 4:0] CfgRegfIQTxDel,
  input  wire [ 4:0] CfgRegfIQRxDel,
  input  wire [ 7:0] CfgRegfIQCollDel,
  input  wire [ 3:0] CfgRegfIQEstStep,
  input  wire [15:0] CfgRegfIQEstNite,
  input  wire [15:0] CfgRegfIQCoeff0,
  input  wire [15:0] CfgRegfIQCoeff1,
  input  wire [15:0] CfgRegfIQCoeff2,
  input  wire [15:0] CfgRegfIQCoeff3,
  input  wire [15:0] CfgRegfIQCoeff4,
  input  wire [15:0] CfgRegfIQCoeff5,
  input  wire [15:0] CfgRegfIQCoeff6,
  input  wire [15:0] CfgRegfIQCoeff7,
  input  wire [15:0] CfgRegfIQCoeff8,
  input  wire [15:0] CfgRegfIQCoeff9,
  input  wire [15:0] CfgRegfIQCoeff10,
  input  wire [15:0] CfgRegfIQCoeff11,
  input  wire [15:0] CfgRegfIQCoeff12,
  input  wire [15:0] CfgRegfIQCoeff13,
  input  wire [15:0] CfgRegfIQCoeff14,
  input  wire [15:0] CfgRegfIQCoeff15,
  input  wire [15:0] CfgRegfIQCoeff16,
  input  wire [15:0] CfgRegfIQCoeff17,
  input  wire [15:0] CfgRegfIQCoeff18,
  input  wire [15:0] CfgRegfIQCoeff19,
  input  wire        CfgRegfIQCoeffUpdate,
  // Status
  output wire        StRegfIQToggle0,
  output wire [12:0] StRegfIQRxEstError0,
  output wire [12:0] StRegfIQTxEstError0,
  output wire [15:0] StRegfIQCoeff0,
  output wire [15:0] StRegfIQCoeff1,
  output wire [15:0] StRegfIQCoeff2,
  output wire [15:0] StRegfIQCoeff3,
  output wire [15:0] StRegfIQCoeff4,
  output wire [15:0] StRegfIQCoeff5,
  output wire [15:0] StRegfIQCoeff6,
  output wire [15:0] StRegfIQCoeff7,
  output wire [15:0] StRegfIQCoeff8,
  output wire [15:0] StRegfIQCoeff9,
  output wire [15:0] StRegfIQCoeff10,
  output wire [15:0] StRegfIQCoeff11,
  output wire [15:0] StRegfIQCoeff12,
  output wire [15:0] StRegfIQCoeff13,
  output wire [15:0] StRegfIQCoeff14,
  output wire [15:0] StRegfIQCoeff15,
  output wire [15:0] StRegfIQCoeff16,
  output wire [15:0] StRegfIQCoeff17,
  output wire [15:0] StRegfIQCoeff18,
  output wire [15:0] StRegfIQCoeff19,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire        StRegfIQToggle1,
  output wire [12:0] StRegfIQRxEstError1,
  output wire [12:0] StRegfIQTxEstError1,
`endif
`endif // RW_NX_FIQ_COMP_EN

  /*****************************************************************************
  * Interrupt Controller Interface
  *****************************************************************************/
  output wire        CCATimeOutErrIrq,
`ifdef RW_RADAR_EN
  output wire        RadarIrq,
`endif // RW_RADAR_EN

  /*****************************************************************************
  * debug/diag
  *****************************************************************************/
`ifdef RW_NX_FIQ_COMP_EN
  output wire [15:0] fIQDbgBank,
`endif // RW_NX_FIQ_COMP_EN
`ifdef RW_RADAR_EN
  output wire [15:0] DbgBank8,
`endif // RW_RADAR_EN
  output wire [15:0] DbgBank0,
  output wire [15:0] DbgBank1,
  output wire [15:0] DbgBank2,
  output wire [15:0] DbgBank3,
  output wire [15:0] DbgBank4,
  output wire [15:0] DbgBank5,
  output wire [15:0] DbgBank6,
  output wire [15:0] DbgBank7,
  output wire [15:0] CcaDbgBank
);
  
  /*****************************************************************************
  * Decode Modem Config
  *****************************************************************************/
  wire   force20,force40;
  assign force40   = CfgRegMdmConfBW==2'd1;
  assign force20   = CfgRegMdmConfBW==2'd0;



  /*****************************************************************************
  * TXSTARTDELAY
  *****************************************************************************/

  /*****************************************************************************
  * PATH 0
  *****************************************************************************/
  /* ADC PATH 0 */
  wire [11:0] ADCFixedI0,ADCFixedQ0;
  FEFix u_adc_fix_path0 (
    /***************************************************************************
    * system
    ***************************************************************************/
    .nRst(             nFERst),
    .Clk(              FERxPath0GClk),
    /***************************************************************************
    * parameters
    ***************************************************************************/
    .C2SDisable(       CfgRegRxC2sDisb),
    .IQSwap(           CfgRegRxIQSwapPath0),
    .IDelay(           CfgRegRxIQDelPathI0),
    .QDelay(           CfgRegRxIQDelPathQ0),
    
    /***************************************************************************
    * datapath
    ***************************************************************************/
    .I(                ADCI0),                             
    .Q(                ADCQ0),
    .FixedI(           ADCFixedI0),
    .FixedQ(           ADCFixedQ0)
  );
  
  /* DAC PATH 0 */
  wire [11:0] DACPreFixedI0,DACPreFixedQ0;
  FEFix u_dac_fix_path0 (
    /***************************************************************************
    * system
    ***************************************************************************/
    .nRst(             nFERst),
    .Clk(              FETxPath0GClk),
    /***************************************************************************
    * parameters
    ***************************************************************************/
    .C2SDisable(       CfgRegTxC2sDisb),
    .IQSwap(           CfgRegTxIQSwapPath0),
    .IDelay(           CfgRegTxIQDelPathI0),
    .QDelay(           CfgRegTxIQDelPathQ0),
    
    /***************************************************************************
    * datapath
    ***************************************************************************/
    .I(                DACPreFixedI0),                             
    .Q(                DACPreFixedQ0),
    .FixedI(           DACI0),
    .FixedQ(           DACQ0)
  );

  /* FRONTEND 0 */
  wire [1:0]   AntSelDSSS;
  wire [1:0]   AntSelDSSSMux;
  wire [12:0]  OFDMRx20SecI0,OFDMRx20SecQ0;
 
  wire         AGCOFDMFEEn,AGCDSSSFEEn;
  wire         AGCOFDMBlockEn0,AGCDSSSBlockEn0;
  wire         MFSMOFDMTxBlockEn0;

`ifdef RW_NX_IQ_COMP_EN
  wire         AGCIQGnPhCompEn,AGCIQEstGainAccEn,AGCIQEstPhaseAccEn;
`endif
  
  wire [ 3:0]  Agc2FERx20DigGain6dB0;  
  wire [ 5:0]  Agc2FERx20DigGainLin0;
  wire [ 3:0]  Agc2FERx40DigGain6dB0;  
  wire [ 5:0]  Agc2FERx40DigGainLin0;
  wire [ 3:0]  Agc2FERx80DigGain6dB0; 
  wire [ 5:0]  Agc2FERx80DigGainLin0;
 
  wire [12:0]  FE0AGC20I,     FE0AGC20Q;
  wire [12:0]  FE0AGC20SecI,  FE0AGC20SecQ;
  wire [12:0]  FE0AGC40SecI,  FE0AGC40SecQ;
  wire [12:0]  FE0RadI,       FE0RadQ;
  wire [11:0]  FE0DCEstI,     FE0DCEstQ;

  wire         FEDACEn0;
  wire [11:0]  FEDACI0,       FEDACQ0;
  wire [11:0]  FEADCI0,       FEADCQ0;
  
`ifdef RW_NX_DERIV_80211B
  wire         MFSMDSSSTxBlockEn0;
  wire         TxRSF440Valid;
  wire [11:0]  TxRSF440I;
  wire [11:0]  TxRSF440Q;
  wire         FE0RxRSF440Valid;
  wire [12:0]  FE0RxRSF440I;
  wire [12:0]  FE0RxRSF440Q;
`endif
 
  /* ensure that Frontend works on the same FE20 sub-phase */
  reg AGCOFDMFEEn_aligned,FE40Toggle,AGCDSSSBlockEn_aligned;
  always @(posedge FE40Path0GClk,negedge nFE40Rst)
  begin
    if(!nFE40Rst)
    begin
      AGCOFDMFEEn_aligned    <= 1'b0;
      AGCDSSSBlockEn_aligned <= 1'b0;
      FE40Toggle             <= 1'b0;
    end
    else if(!AGCOn)
    begin
      AGCOFDMFEEn_aligned    <= 1'b0;
      AGCDSSSBlockEn_aligned <= 1'b0;
      FE40Toggle             <= 1'b0;
    end
    else
    begin
      FE40Toggle             <= ~FE40Toggle;
      if(~FE40Toggle)
      begin
        AGCOFDMFEEn_aligned    <= AGCOFDMFEEn;
        AGCDSSSBlockEn_aligned <= RxFEEnDSSS | AGCDSSSFEEn;
      end
    end
  end
  
  /* FE control */
  assign AGCOFDMBlockEn0    = CfgRegActiveAnt[0] & AGCOFDMFEEn_aligned;
  assign MFSMOFDMTxBlockEn0 = CfgRegActiveAnt[0] & OFDMTxBlockEn;
  
`ifdef RW_NX_DERIV_80211B
  assign AGCDSSSBlockEn0    = CfgRegActiveAnt[0] & AGCDSSSBlockEn_aligned;
  assign MFSMDSSSTxBlockEn0 = CfgRegActiveAnt[0] & DSSSTxBlockEn;
`endif
 
  TxRxFrontEndX40 u_frontend0 (
    /*****************************************************************************
    * resets
    *****************************************************************************/
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe160_rst_n(              nFE160Rst),
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_rst_n(               nFE80Rst),
`endif
    .fe_rst_n(                 nFERst),
    .fe40_rst_n(               nFE40Rst),
   
    /*****************************************************************************
    * clocks
    *****************************************************************************/
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe160_clk(                 FE160Path0GClk),
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clk(                  FE80Path0GClk),
`endif
    .ferx_clk(                  FERxPath0GClk),
    .fetx_clk(                  FETxPath0GClk),
    .fe40_clk(                  FE40Path0GClk),
    
    /*****************************************************************************
    * registers (asynchronous)
    *****************************************************************************/
    .mdmcfg_conf_bw(            CfgRegMdmConfBW),
    .mdmcfg_conf_primary(       CfgRegMdmConfPrimary),

`ifdef RW_NX_DERIV_80211B
    .mdmcfg_dsss_dccomptype(    AgcRegDC4DSSSCompType),
    .mdmcfg_dsss_dcholdtime(    AgcRegDC4DSSSHoldTime),
    .mdmcfg_dsss_dczerotime(    AgcRegDC4DSSSZeroTime),
`endif
    .mdmcfg_center_dccomptype(  AgcRegDC4CenteredCompType),
    .mdmcfg_center_dcholdtime(  AgcRegDC4CenteredHoldTime),
    .mdmcfg_center_dczerotime(  AgcRegDC4CenteredZeroTime),
    .mdmcfg_primary_dccomptype( AgcRegDC4PrimaryCompType),
    .mdmcfg_primary_dcholdtime( AgcRegDC4PrimaryHoldTime),
    .mdmcfg_primary_dczerotime( AgcRegDC4PrimaryZeroTime),
`ifdef RW_RADAR_EN
    .mdmcfg_radar_dccomptype(   AgcRegDC4RadarCompType), 
    .mdmcfg_radar_dcholdtime(   AgcRegDC4RadarHoldTime),
    .mdmcfg_radar_dczerotime(   AgcRegDC4RadarZeroTime),
`endif  
    /*****************************************************************************
    * AGC control (FEClk)
    *****************************************************************************/
    /* block enables */
    .agc_ofdm_blocken(          AGCOFDMBlockEn0),
`ifdef RW_NX_DERIV_80211B
    .agc_dsss_blocken(          AGCDSSSBlockEn0),
`endif
    /* digital gain */
    .agc20_diggain6db(          Agc2FERx20DigGain6dB0),
    .agc20_diggainlin(          Agc2FERx20DigGainLin0),
`ifdef RW_NX_DERIV_FE_PATH40M
    .agc40_diggain6db(          Agc2FERx40DigGain6dB0),    
    .agc40_diggainlin(          Agc2FERx40DigGainLin0),    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .agc80_diggain6db(          Agc2FERx80DigGain6dB0),  
    .agc80_diggainlin(          Agc2FERx80DigGainLin0),  
`endif
    /*****************************************************************************
    * MFSM control (FEClk)
    *****************************************************************************/
    .mfsm_ofdm_tx_blocken(      MFSMOFDMTxBlockEn0),
`ifdef RW_NX_DERIV_80211B
    .mfsm_dsss_tx_blocken(      MFSMDSSSTxBlockEn0),
`endif

    /*****************************************************************************
    * Converters (FEClk)
    *****************************************************************************/
    /* ADC */
    .adc_i(                     FEADCI0),
    .adc_q(                     FEADCQ0),
    /* DAC */
    .dac_en(                    FEDACEn0),
    .dac_i(                     FEDACI0),
    .dac_q(                     FEDACQ0),
 
    /*****************************************************************************
    * OFDM PHY interface (FEClk)
    *****************************************************************************/
    /* RX */
    .ofdm_rx_valid(              OFDMRxValid), 
    .ofdm_rx20_i(                OFDMRx20I0),    
    .ofdm_rx20_q(                OFDMRx20Q0),    
`ifdef RW_NX_DERIV_FE_PATH40M
    .ofdm_rx20sec_i(             OFDMRx20SecI0),         
    .ofdm_rx20sec_q(             OFDMRx20SecQ0),       
    .ofdm_rx40_i(                OFDMRx40I0),
    .ofdm_rx40_q(                OFDMRx40Q0),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .ofdm_rx80_i(                OFDMRx80I0),
    .ofdm_rx80_q(                OFDMRx80Q0),
`endif
    /* TX */
    .ofdm_tx_diggain(            OFDMTxDigGain0),
    .ofdm_tx_pipe_loaded(        OFDMTxPipeLoaded),
    .ofdm_tx_pipe_release(       OFDMTxPipeRelease),
    .ofdm_tx_sfo_bypass(         OFDMTxSFOBypass), 
    .ofdm_tx_sfo_ppm(            OFDMTxSFOPPM), 
    .ofdm_tx_cfo_bypass(         OFDMTxCFOBypass), 
    .ofdm_tx_cfo_freq(           OFDMTxCFOFreq), 
    
    .ofdm_tx_ready(              OFDMTxReady),
    .ofdm_tx_i(                  OFDMTxI0), 
    .ofdm_tx_q(                  OFDMTxQ0), 
    .ofdm_tx_valid(              OFDMTxValid),

`ifdef RW_NX_DERIV_80211B
    /*****************************************************************************
    * RSF440 interface (FE40Clk)
    *****************************************************************************/
    /* TX */
    .dsss_tx_valid(              TxRSF440Valid),
    .dsss_tx_i(                  TxRSF440I),
    .dsss_tx_q(                  TxRSF440Q),
    
    /* RX */
    .dsss_rx_valid(              FE0RxRSF440Valid),
    .dsss_rx_i(                  FE0RxRSF440I),
    .dsss_rx_q(                  FE0RxRSF440Q),
`endif

    /*****************************************************************************
    * AGC if (FE80Clk)
    *****************************************************************************/
    .adc_dcest_i(                FE0DCEstI),          
    .adc_dcest_q(                FE0DCEstQ), 
               
`ifdef RW_RADAR_EN
    .agc_radar_i(                FE0RadI),
    .agc_radar_q(                FE0RadQ),
`endif    
`ifdef RW_NX_DERIV_FE_PATH40M
    .agc20_sec_i(                FE0AGC20SecI),   
    .agc20_sec_q(                FE0AGC20SecQ),   
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .agc40_sec_i(                FE0AGC40SecI),    
    .agc40_sec_q(                FE0AGC40SecQ),   
`endif
    .agc20_i(                    FE0AGC20I),    
    .agc20_q(                    FE0AGC20Q)    
  );

`ifdef RW_NX_DERIV_FE_PATH1
  /*****************************************************************************
  * PATH 1
  *****************************************************************************/
  /* ADC PATH 1 */
  wire [11:0] ADCFixedI1,ADCFixedQ1;
  FEFix u_adc_fix_path1 (
    /***************************************************************************
    * system
    ***************************************************************************/
    .nRst(             nFERst),
    .Clk(              FERxPath1GClk),
    /***************************************************************************
    * parameters
    ***************************************************************************/
    .C2SDisable(       CfgRegRxC2sDisb),
    .IQSwap(           CfgRegRxIQSwapPath1),
    .IDelay(           CfgRegRxIQDelPathI1),
    .QDelay(           CfgRegRxIQDelPathQ1),
    
    /***************************************************************************
    * datapath
    ***************************************************************************/
    .I(                ADCI1),                             
    .Q(                ADCQ1),
    .FixedI(           ADCFixedI1),
    .FixedQ(           ADCFixedQ1)
  );
  
  /* DAC PATH 1 */
  wire [11:0] DACPreFixedI1,DACPreFixedQ1;
  FEFix u_dac_fix_path1 (
    /***************************************************************************
    * system
    ***************************************************************************/
    .nRst(             nFERst),
    .Clk(              FETxPath1GClk),
    /***************************************************************************
    * parameters
    ***************************************************************************/
    .C2SDisable(       CfgRegTxC2sDisb),
    .IQSwap(           CfgRegTxIQSwapPath1),
    .IDelay(           CfgRegTxIQDelPathI1),
    .QDelay(           CfgRegTxIQDelPathQ1),
    
    /***************************************************************************
    * datapath
    ***************************************************************************/
    .I(                DACPreFixedI1),                             
    .Q(                DACPreFixedQ1),
    .FixedI(           DACI1),
    .FixedQ(           DACQ1)
  );

  /* FRONTEND 1 */
  wire [12:0]  OFDMRx20SecI1,OFDMRx20SecQ1;
  
  wire         AGCOFDMBlockEn1,AGCDSSSBlockEn1;
  
  wire [ 3:0]  Agc2FERx20DigGain6dB1;  
  wire [ 5:0]  Agc2FERx20DigGainLin1;
  wire [ 3:0]  Agc2FERx40DigGain6dB1; 
  wire [ 5:0]  Agc2FERx40DigGainLin1;
  wire [ 3:0]  Agc2FERx80DigGain6dB1;
  wire [ 5:0]  Agc2FERx80DigGainLin1;

  wire [12:0]  FE1AGC20I,     FE1AGC20Q;
  wire [12:0]  FE1AGC20SecI,  FE1AGC20SecQ;
  wire [12:0]  FE1AGC40SecI,  FE1AGC40SecQ;
  wire [12:0]  FE1RadI,       FE1RadQ;
  wire [11:0]  FE1DCEstI,     FE1DCEstQ;

  wire         FEDACEn1;
  wire [11:0]  FEDACI1,       FEDACQ1;
  wire [11:0]  FEADCI1,       FEADCQ1;

`ifdef RW_NX_DERIV_80211B
  wire         MFSMDSSSTxBlockEn1;
  wire         FE1RxRSF440Valid;
  wire [12:0]  FE1RxRSF440I;
  wire [12:0]  FE1RxRSF440Q;
`endif
 
  /* FE control */
  assign AGCOFDMBlockEn1    = CfgRegActiveAnt[1] & AGCOFDMFEEn_aligned;
 
`ifdef RW_NX_DERIV_80211B
  /* MFSM2FE control */
  assign AGCDSSSBlockEn1    = CfgRegActiveAnt[1] & AGCDSSSBlockEn_aligned;
  assign MFSMDSSSTxBlockEn1 = CfgRegActiveAnt[1] & DSSSTxBlockEn;
`endif

  TxRxFrontEndX40 u_frontend1 (
    /*****************************************************************************
    * resets
    *****************************************************************************/
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe160_rst_n(                nFE160Rst),
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_rst_n(                 nFE80Rst),
`endif
    .fe_rst_n(                   nFERst),
    .fe40_rst_n(                 nFE40Rst),
    
    /*****************************************************************************
    * clocks
    *****************************************************************************/
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe160_clk(                 FE160Path1GClk),
`endif  
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clk(                  FE80Path1GClk),
`endif  
    .ferx_clk(                  FERxPath1GClk),
    .fetx_clk(                  FETxPath1GClk),
    .fe40_clk(                  FE40Path1GClk),
    
    /*****************************************************************************
    * registers (asynchronous)
    *****************************************************************************/
    .mdmcfg_conf_bw(            CfgRegMdmConfBW),
    .mdmcfg_conf_primary(       CfgRegMdmConfPrimary),
`ifdef RW_NX_DERIV_80211B
    .mdmcfg_dsss_dccomptype(    AgcRegDC4DSSSCompType),
    .mdmcfg_dsss_dcholdtime(    AgcRegDC4DSSSHoldTime),
    .mdmcfg_dsss_dczerotime(    AgcRegDC4DSSSZeroTime),
`endif
    .mdmcfg_center_dccomptype(  AgcRegDC4CenteredCompType),
    .mdmcfg_center_dcholdtime(  AgcRegDC4CenteredHoldTime),
    .mdmcfg_center_dczerotime(  AgcRegDC4CenteredZeroTime),
    .mdmcfg_primary_dccomptype( AgcRegDC4PrimaryCompType),
    .mdmcfg_primary_dcholdtime( AgcRegDC4PrimaryHoldTime),
    .mdmcfg_primary_dczerotime( AgcRegDC4PrimaryZeroTime),
`ifdef RW_RADAR_EN
    .mdmcfg_radar_dccomptype(   AgcRegDC4RadarCompType), 
    .mdmcfg_radar_dcholdtime(   AgcRegDC4RadarHoldTime),
    .mdmcfg_radar_dczerotime(   AgcRegDC4RadarZeroTime),
`endif  
    /*****************************************************************************
    * AGC control (FEClk)
    *****************************************************************************/
    /* block enables */
    .agc_ofdm_blocken(          AGCOFDMBlockEn1),
`ifdef RW_NX_DERIV_80211B
    .agc_dsss_blocken(          AGCDSSSBlockEn1),
`endif
    /* digital gains */
    .agc20_diggain6db(          Agc2FERx20DigGain6dB1),
    .agc20_diggainlin(          Agc2FERx20DigGainLin1),
`ifdef RW_NX_DERIV_FE_PATH40M
    .agc40_diggain6db(          Agc2FERx40DigGain6dB1),    
    .agc40_diggainlin(          Agc2FERx40DigGainLin1),    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .agc80_diggain6db(          Agc2FERx80DigGain6dB1),  
    .agc80_diggainlin(          Agc2FERx80DigGainLin1),  
`endif

    /*****************************************************************************
    * MFSM control (FEClk)
    *****************************************************************************/
    .mfsm_ofdm_tx_blocken(      ????),
`ifdef RW_NX_DERIV_80211B
    .mfsm_dsss_tx_blocken(      MFSMDSSSTxBlockEn1),
`endif

    /*****************************************************************************
    * Converters (FEClk)
    *****************************************************************************/
    /* ADC */
    .adc_i(                     FEADCI1),
    .adc_q(                     FEADCQ1),
    /* DAC */
    .dac_en(                    FEDACEn1),
    .dac_i(                     FEDACI1),
    .dac_q(                     FEDACQ1),
 
    /*****************************************************************************
    * OFDM PHY interface (FEClk)
    *****************************************************************************/
    /* RX */
    .ofdm_rx_valid(             ), 
    .ofdm_rx20_i(               OFDMRx20I1),    
    .ofdm_rx20_q(               OFDMRx20Q1),    
`ifdef RW_NX_DERIV_FE_PATH40M
    .ofdm_rx20sec_i(            OFDMRx20SecI1),         
    .ofdm_rx20sec_q(            OFDMRx20SecQ1),       
    .ofdm_rx40_i(               OFDMRx40I1),
    .ofdm_rx40_q(               OFDMRx40Q1),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .ofdm_rx80_i(               OFDMRx80I1),
    .ofdm_rx80_q(               OFDMRx80Q1),
`endif
  
    /* TX */
    .ofdm_tx_diggain(           OFDMTxDigGain1),
    .ofdm_tx_pipe_loaded(       /* not connected, same timing than FE0 */),
    .ofdm_tx_pipe_release(      OFDMTxPipeRelease),
    .ofdm_tx_sfo_bypass(        OFDMTxSFOBypass), 
    .ofdm_tx_sfo_ppm(           OFDMTxSFOPPM), 
    .ofdm_tx_cfo_bypass(        OFDMTxCFOBypass), 
    .ofdm_tx_cfo_freq(          OFDMTxCFOFreq), 
   
    .ofdm_tx_ready(             /* not connected, same timing than FE0 */),
    .ofdm_tx_valid(             OFDMTxValid),
    .ofdm_tx_i(                 OFDMTxI1), 
    .ofdm_tx_q(                 OFDMTxQ1), 

`ifdef RW_NX_DERIV_80211B
    /*****************************************************************************
    * RSF440 interface (FE40Clk)
    *****************************************************************************/
    /* TX */
    .dsss_tx_valid(            TxRSF440Valid),
    .dsss_tx_i(                TxRSF440I),
    .dsss_tx_q(                TxRSF440Q),
    
    /* RX */
    .dsss_rx_valid(            FE1RxRSF440Valid),
    .dsss_rx_i(                FE1RxRSF440I),
    .dsss_rx_q(                FE1RxRSF440Q),
`endif

    /*****************************************************************************
    * AGC if (FE80Clk)
    *****************************************************************************/
    .adc_dcest_i(              FE1DCEstI),            
    .adc_dcest_q(              FE1DCEstQ), 
               
`ifdef RW_RADAR_EN
    .agc_radar_i(              FE1RadI),
    .agc_radar_q(              FE1RadQ),
`endif    
`ifdef RW_NX_DERIV_FE_PATH40M
    .agc20_sec_i(              FE1AGC20SecI),   
    .agc20_sec_q(              FE1AGC20SecQ),   
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .agc40_sec_i(              FE1AGC40SecI),    
    .agc40_sec_q(              FE1AGC40SecQ),   
`endif
    .agc20_i(                  FE1AGC20I),    
    .agc20_q(                  FE1AGC20Q)    
  );
`endif // RW_NX_DERIV_FE_PATH1

`ifdef RW_NX_DERIV_80211B

  /*****************************************************************************
  * RSF440 PATH MUXES
  *****************************************************************************/
  wire         DSSSRxEnable;
  wire         RxRSF440Valid;
  wire [12:0]  RxRSF440I, RxRSF440Q;
`ifdef RW_NX_DSSS_CORR_EN
  wire         DSSSFilt4CorrToggle;
  wire  [ 9:0] DSSSFilt4CorrI, DSSSFilt4CorrQ;
  wire         DSSSFilt4CorrToggleSync;    
  reg          DSSSFilt4CorrToggleSync_1t;
  reg   [ 9:0] FEBRxFilt4CorrI_resync, FEBRxFilt4CorrQ_resync;
  reg          FEBRxFilt4CorrValid;
`endif

  assign AntSelDSSSMux = (CfgRegRxPathSelFromReg) ? CfgRegBRxPathSel : AntSelDSSS;

  assign {RxRSF440I,RxRSF440Q,RxRSF440Valid} =
`ifdef RW_NX_DERIV_FE_PATH1
   (AntSelDSSSMux==2'd1)?{FE1RxRSF440I,FE1RxRSF440Q,FE1RxRSF440Valid}:
`endif
                         {FE0RxRSF440I,FE0RxRSF440Q,FE0RxRSF440Valid};

  /*****************************************************************************
  * RSF440 instance
  *****************************************************************************/
  rsf440 u_rsf440 
  (
    /*****************************************************************************
    * control (async)
    *****************************************************************************/
    .rxenable(              AGCDSSSBlockEn_aligned), 
    .txenable(              DSSSTxBlockEn), 
  
    .rxshift(               CfgRegBRxShift),
    .txshift(               CfgRegBTxShift),
  
    /*****************************************************************************
    * 40 Mhz domain
    *****************************************************************************/
    .fe40_rst_n(            nFE40Rst),
    .fe40_clk(              FE40Path0GClk),

    .fe40_rx_valid(         RxRSF440Valid),
    .fe40_rx_i(             RxRSF440I),     
    .fe40_rx_q(             RxRSF440Q),
  
    .fe40_tx_valid(         TxRSF440Valid), 
    .fe40_tx_i(             TxRSF440I), 
    .fe40_tx_q(             TxRSF440Q), 
  
    /*****************************************************************************
    * 44 Mhz domain
    *****************************************************************************/
    .phy44_rst_n(           nFE44Rst),
    .phy44_clk(             FE44GClk),
  
    .phy44_rxenable(        DSSSRxEnable),
    .phy44_rx_valid(        DSSSRxValid),
    .phy44_rx_i(            DSSSRxI), 
    .phy44_rx_q(            DSSSRxQ),
 
    .phy44_tx_valid(        DSSSTxValid),
    .phy44_tx_i(            DSSSTxI), 
    .phy44_tx_q(            DSSSTxQ)
  );
  
`ifdef RW_NX_DSSS_CORR_EN
  /*****************************************************************************
  * Filter for DSSS correlator
  *****************************************************************************/
  rx_filter4corr u_rx_filter4corr ( 
    /***************************************************************************
    * Clock and reset          
    ***************************************************************************/
    .clk44(                 FE44GClk),
    .reset_n(               nFE44Rst),
    .blocken(               DSSSRxEnable),
    
    /***************************************************************************
    * I & Q      
    ***************************************************************************/
    .filter_in_i(           DSSSRxI),
    .filter_in_q(           DSSSRxQ),
    .filter_in_en(          DSSSRxValid),
    
    .filt_out_4_corr_i(     DSSSFilt4CorrI),
    .filt_out_4_corr_q(     DSSSFilt4CorrQ),
    .filter_out_tog(        DSSSFilt4CorrToggle)
  );

  //////////////////////////////////////////////////
  // Capture DSSSFilt4Corr outputs to AGC clock domain
  always @(posedge AGCGClk or negedge nAGCRst)
  begin
    if(nAGCRst == 1'b0) 
    begin
      DSSSFilt4CorrToggleSync_1t <= 1'b0;
      FEBRxFilt4CorrI_resync     <= 10'b0;
      FEBRxFilt4CorrQ_resync     <= 10'b0;
      FEBRxFilt4CorrValid        <= 1'b0;
    end
    else 
    begin
      FEBRxFilt4CorrValid        <= 1'b0;
      DSSSFilt4CorrToggleSync_1t <= DSSSFilt4CorrToggleSync;
      if (DSSSFilt4CorrToggleSync != DSSSFilt4CorrToggleSync_1t) 
      begin
        FEBRxFilt4CorrI_resync <= DSSSFilt4CorrI;
        FEBRxFilt4CorrQ_resync <= DSSSFilt4CorrQ;
        FEBRxFilt4CorrValid    <= 1'b1;
      end
    end
  end

  ClkSyncSimple u_DSSSFilt4CorrToggleSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (DSSSFilt4CorrToggle),
    .dstdata    (DSSSFilt4CorrToggleSync)
  );

`endif // RW_NX_DSSS_CORR_EN
`else
  assign AntSelDSSSMux = 2'b0;
`endif // RW_NX_DERIV_80211B

`ifdef RW_NX_IQ_COMP_EN
  /*****************************************************************************
  * IQ Imbalance instances
  *****************************************************************************/
  IQImbalance  u_IQImbalance (
    // resets
    .nFERst (                     nFERst),
`ifdef RW_NX_FIQ_COMP_EN
    .nFENoWdRst (                 nFENoWdRst),
`endif // RW_NX_FIQ_COMP_EN
    // clocks
    .FERx0Clk (                   FERxPath0GClk),
    .FETxRx0Clk (                 FETxRxPath0GClk),
`ifdef RW_NX_DERIV_FE_PATH1
    .FETxRx1Clk (                 FETxRxPath1GClk),
`endif
    // registers (asynchronous)
    .CfgRegTxIQGainCompEn0 (      CfgRegTxIQGainCompEn0),
    .CfgRegTxIQPhaseCompEn0 (     CfgRegTxIQPhaseCompEn0),
    .CfgRegTxIQGain0 (            CfgRegTxIQGain0),
    .CfgRegTxIQPhase0 (           CfgRegTxIQPhase0),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegTxIQGainCompEn1 (      CfgRegTxIQGainCompEn1),
    .CfgRegTxIQPhaseCompEn1 (     CfgRegTxIQPhaseCompEn1),
    .CfgRegTxIQGain1 (            CfgRegTxIQGain1),
    .CfgRegTxIQPhase1 (           CfgRegTxIQPhase1),
`endif
    .CfgRegCBW (                  CfgRegMdmConfBW),
    .CfgRegRxIQEstIterClr (       CfgRegRxIQEstIterClr),
    .CfgRegRxIQEstSNRMin (        CfgRegRxIQEstSNRMin),
    .CfgRegRxIQEstMCSMin (        CfgRegRxIQEstMCSMin),
    .CfgRegRxIQEstBWList (        CfgRegRxIQEstBWList),
    .CfgRegRxIQEstFOMin  (        CfgRegRxIQEstFOMin),
    .CfgRegRxIQPhaseEstEn (       CfgRegRxIQPhaseEstEn),
    .CfgRegRxIQGainEstEn(         CfgRegRxIQGainEstEn),
    .CfgRegRxIQPhaseCompEn (      CfgRegRxIQPhaseCompEn),
    .CfgRegRxIQGainCompEn (       CfgRegRxIQGainCompEn),
    .CfgRegRxIQEstDel (           CfgRegRxIQEstDel),
    .CfgRegRxIQEstGainStepInit (  CfgRegRxIQEstGainStepInit),
    .CfgRegRxIQEstGainStepStop (  CfgRegRxIQEstGainStepStop),
    .CfgRegRxIQEstPhaseStepInit ( CfgRegRxIQEstPhaseStepInit),
    .CfgRegRxIQEstPhaseStepStop ( CfgRegRxIQEstPhaseStepStop),
    .CfgRegRxIQEstStepDel0 (      CfgRegRxIQEstStepDel0),
    .CfgRegRxIQEstStepDel1 (      CfgRegRxIQEstStepDel1),
    .CfgRegRxIQEstStepDel2 (      CfgRegRxIQEstStepDel2),
    .CfgRegRxIQEstStepDel3 (      CfgRegRxIQEstStepDel3),
    .CfgRegRxIQEstStepDel4 (      CfgRegRxIQEstStepDel4),
    .CfgRegRxIQGain0 (            CfgRegRxIQGain0),
    .CfgRegRxIQPhase0  (          CfgRegRxIQPhase0),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegRxIQGain1 (            CfgRegRxIQGain1),
    .CfgRegRxIQPhase1 (           CfgRegRxIQPhase1),
`endif
    //
    .StRegRxIQEstVarI0 (          StRegRxIQEstVarI0),
    .StRegRxIQEstVarQ0 (          StRegRxIQEstVarQ0),
    .StRegRxIQEstMIQ0 (           StRegRxIQEstMIQ0),
    .StRegRxIQEstIQGainEst0 (     StRegRxIQEstIQGainEst0),
    .StRegRxIQEstIQPhaseEst0 (    StRegRxIQEstIQPhaseEst0),
    .StRegRxIQEstValid (          StRegRxIQEstValid),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegRxIQEstVarI1 (          StRegRxIQEstVarI1),
    .StRegRxIQEstVarQ1 (          StRegRxIQEstVarQ1),
    .StRegRxIQEstMIQ1 (           StRegRxIQEstMIQ1),
    .StRegRxIQEstIQGainEst1 (     StRegRxIQEstIQGainEst1),
    .StRegRxIQEstIQPhaseEst1 (    StRegRxIQEstIQPhaseEst1),
`endif
    // Converters (FEClk)
    .ADCEn (                      AGCOn),
    .ADCI0 (                      ADCFixedI0),
    .ADCQ0 (                      ADCFixedQ0),
`ifdef RW_NX_DERIV_FE_PATH1
    .ADCI1 (                      ADCFixedI1),
    .ADCQ1 (                      ADCFixedQ1),
`endif
    .DACEn0 (                     DACEn0),
    .DACI0 (                      DACPreFixedI0),
    .DACQ0 (                      DACPreFixedQ0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DACEn1 (                     DACEn1),
    .DACI1 (                      DACPreFixedI1),
    .DACQ1 (                      DACPreFixedQ1),
`endif
    // FE interface
    .FETxEn0 (                    FEDACEn0),
    .FETxI0 (                     FEDACI0),
    .FETxQ0 (                     FEDACQ0),
`ifdef RW_NX_DERIV_FE_PATH1
    .FETxEn1 (                    FEDACEn1),
    .FETxI1 (                     FEDACI1),
    .FETxQ1 (                     FEDACQ1),
`endif
    .FERx20I0 (                   OFDMRx20I0),
    .FERx20Q0 (                   OFDMRx20Q0),
`ifdef RW_NX_DERIV_FE_PATH40M
    .FERx40I0 (                   OFDMRx40I0),    
    .FERx40Q0 (                   OFDMRx40Q0),    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .FERx80I0 (                   OFDMRx80I0),
    .FERx80Q0 (                   OFDMRx80Q0),
`endif
`ifdef RW_NX_DERIV_FE_PATH1
    .FERx20I1 (                   OFDMRx20I1),
    .FERx20Q1 (                   OFDMRx20Q1),
`ifdef RW_NX_DERIV_FE_PATH40M
    .FERx40I1 (                   OFDMRx40I1),    
    .FERx40Q1 (                   OFDMRx40Q1),    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .FERx80I1 (                   OFDMRx80I1),
    .FERx80Q1 (                   OFDMRx80Q1),
`endif
`endif
    .FERxI0 (                     FEADCI0),
    .FERxQ0 (                     FEADCQ0),
`ifdef RW_NX_DERIV_FE_PATH1
    .FERxI1 (                     FEADCI1),
    .FERxQ1 (                     FEADCQ1),
`endif
    .RxIQEstGainAccEn (           AGCIQEstGainAccEn),
    .RxIQEstPhaseAccEn (          AGCIQEstPhaseAccEn),
    .SNR (                        AGCP1SNR),
    .AGCLock (                    AGCOFDMLock),
    .RxIQCompEn (                 AGCIQGnPhCompEn),
    //
    .OFDMTxBlockEn (              OFDMTxBlockEn),
`ifdef RW_NX_DERIV_80211B
    .DSSSTxBlockEn (              DSSSTxBlockEn),
`endif
    .FrameLeg (                   AGCLegFrame),
    .FrameVHT (                   AGCVHTFrame),
    .LegRate (                    AGCFrameParamLegRate),
    .MCS (                        AGCFrameParamMCS),
    .BWEq20 (                     AGCBWEq20),
    .BWEq40 (                     AGCBWEq40),
    .BWEq80 (                     AGCBWEq80),
    .FOEst (                      AGCFOAngle)
`ifdef RW_NX_FIQ_COMP_EN
  ,
  // fIQ Imbalance
  .fIQCollStartP(                 fIQCollStartP),
  .fIQCollDone(                   fIQCollDone),
  .fIQEstStartP(                  fIQEstStartP),
  .fIQEstDone(                    fIQEstDone),
  // Registers
  .CfgRegfIQCalEn(                CfgRegfIQCalEn),
`ifdef RW_NX_DERIV_FE_PATH1
  .CfgRegfIQPathSel(              CfgRegfIQPathSel),
`endif // RW_NX_DERIV_FE_PATH1
  .CfgRegfIQTxRx(                 CfgRegfIQTxRx),
  .CfgRegfIQTxBypass(             CfgRegfIQTxBypass),
  .CfgRegfIQRxBypass(             CfgRegfIQRxBypass),
  .CfgRegfIQCollPath(             CfgRegfIQCollPath),
  .CfgRegfIQCollWrOffset(         CfgRegfIQCollWrOffset),
  .CfgRegfIQCollRdOffset(         CfgRegfIQCollRdOffset),
  .CfgRegfIQCollSize(             CfgRegfIQCollSize),
  .CfgRegfIQEstIOffset(           CfgRegfIQEstIOffset),
  .CfgRegfIQEstQOffset(           CfgRegfIQEstQOffset),
  .CfgRegfIQEstSize(              CfgRegfIQEstSize),
  .CfgRegfIQTxDel(                CfgRegfIQTxDel),
  .CfgRegfIQRxDel(                CfgRegfIQRxDel),
  .CfgRegfIQCollDel(              CfgRegfIQCollDel),
  .CfgRegfIQEstStep(              CfgRegfIQEstStep),
  .CfgRegfIQEstNite(              CfgRegfIQEstNite),
  .CfgRegfIQCoeff0(               CfgRegfIQCoeff0),
  .CfgRegfIQCoeff1(               CfgRegfIQCoeff1),
  .CfgRegfIQCoeff2(               CfgRegfIQCoeff2),
  .CfgRegfIQCoeff3(               CfgRegfIQCoeff3),
  .CfgRegfIQCoeff4(               CfgRegfIQCoeff4),
  .CfgRegfIQCoeff5(               CfgRegfIQCoeff5),
  .CfgRegfIQCoeff6(               CfgRegfIQCoeff6),
  .CfgRegfIQCoeff7(               CfgRegfIQCoeff7),
  .CfgRegfIQCoeff8(               CfgRegfIQCoeff8),
  .CfgRegfIQCoeff9(               CfgRegfIQCoeff9),
  .CfgRegfIQCoeff10(              CfgRegfIQCoeff10),
  .CfgRegfIQCoeff11(              CfgRegfIQCoeff11),
  .CfgRegfIQCoeff12(              CfgRegfIQCoeff12),
  .CfgRegfIQCoeff13(              CfgRegfIQCoeff13),
  .CfgRegfIQCoeff14(              CfgRegfIQCoeff14),
  .CfgRegfIQCoeff15(              CfgRegfIQCoeff15),
  .CfgRegfIQCoeff16(              CfgRegfIQCoeff16),
  .CfgRegfIQCoeff17(              CfgRegfIQCoeff17),
  .CfgRegfIQCoeff18(              CfgRegfIQCoeff18),
  .CfgRegfIQCoeff19(              CfgRegfIQCoeff19),
  .CfgRegfIQCoeffUpdate(          CfgRegfIQCoeffUpdate),
  // Stats
  .StRegfIQToggle0(               StRegfIQToggle0),
  .StRegfIQRxEstError0(           StRegfIQRxEstError0),
  .StRegfIQTxEstError0(           StRegfIQTxEstError0),
  .StRegfIQCoeff0(                StRegfIQCoeff0),
  .StRegfIQCoeff1(                StRegfIQCoeff1),
  .StRegfIQCoeff2(                StRegfIQCoeff2),
  .StRegfIQCoeff3(                StRegfIQCoeff3),
  .StRegfIQCoeff4(                StRegfIQCoeff4),
  .StRegfIQCoeff5(                StRegfIQCoeff5),
  .StRegfIQCoeff6(                StRegfIQCoeff6),
  .StRegfIQCoeff7(                StRegfIQCoeff7),
  .StRegfIQCoeff8(                StRegfIQCoeff8),
  .StRegfIQCoeff9(                StRegfIQCoeff9),
  .StRegfIQCoeff10(               StRegfIQCoeff10),
  .StRegfIQCoeff11(               StRegfIQCoeff11),
  .StRegfIQCoeff12(               StRegfIQCoeff12),
  .StRegfIQCoeff13(               StRegfIQCoeff13),
  .StRegfIQCoeff14(               StRegfIQCoeff14),
  .StRegfIQCoeff15(               StRegfIQCoeff15),
  .StRegfIQCoeff16(               StRegfIQCoeff16),
  .StRegfIQCoeff17(               StRegfIQCoeff17),
  .StRegfIQCoeff18(               StRegfIQCoeff18),
  .StRegfIQCoeff19(               StRegfIQCoeff19),
`ifdef RW_NX_DERIV_FE_PATH1
  .StRegfIQToggle1(               StRegfIQToggle1),
  .StRegfIQRxEstError1(           StRegfIQRxEstError1),
  .StRegfIQTxEstError1(           StRegfIQTxEstError1),
`endif // RW_NX_DERIV_FE_PATH1
  // RAM interface
  .RamAddr(                       fIQMemAddr),
  .RamRdEn(                       fIQMemRdEn),
  .RamWrEn(                       fIQMemWrEn),
  .RamWrData(                     fIQMemWrData),
  .RamRdData(                     fIQMemRdData),
  // Debug port
  .Dbg0(                          fIQDbgBank)
`endif // RW_NX_FIQ_COMP_EN 
    );

`else
  // FE Muxes
  assign DACEn0        = FEDACEn0;
  assign DACPreFixedI0 = FEDACI0;
  assign DACPreFixedQ0 = FEDACQ0;
  assign FEADCI0       = ADCFixedI0;
  assign FEADCQ0       = ADCFixedQ0;
`ifdef RW_NX_DERIV_FE_PATH1
  assign DACEn1        = FEDACEn1;
  assign DACPreFixedI1 = FEDACI1;
  assign DACPreFixedQ1 = FEDACQ1;
  assign FEADCI1       = ADCFixedI1;
  assign FEADCQ1       = ADCFixedQ1;
`endif
  
`endif // RW_NX_IQ_COMP_EN
  
  /*****************************************************************************
  * AGC/CCA instance
  *****************************************************************************/
  wire [11:0]          AGCFSMCtrl;
  wire [25:0]          CCACtrl;
  wire                 AgcFsmInit;
  wire                 RifsEn;
  wire                 HTSTFGainUpdateP;
  wire                 AGCBWSup20Masked;
  wire                 AGCBWEq20Masked;
  wire                 AGCBWEq40Masked;
  wire                 AGCBWEq80Masked;
  wire [ 9:0]          AgcRegSatLowThr_agc;
  wire [ 9:0]          AgcRegSatDynHighThr_agc;
  wire [ 9:0]          AgcRegSatDynLowThr_agc;
  wire [ 6:0]          AgcRegSatDelayCount_agc;
  wire [ 7:0]          AgcRegDetPlat_agc;
  wire [8 :0]          AgcRegADCPowBiasqdBm_agc;
  wire [8 :0]          AgcRegInBd20PPowBiasqdBm_agc;
  wire [8 :0]          AgcRegInBd40SPowBiasqdBm_agc;
  wire [8 :0]          AgcRegInBd20SPowBiasqdBm_agc;
  wire [ 9:0]          AgcRegInBddBVThr_agc;
  wire [10:0]          AgcRegInBddBmThr_agc;
  wire [ 9:0]          AgcRegADCdBVThr_agc;
  wire [10:0]          AgcRegADCdBmThr_agc;
  wire [15:0]          DbgAgc0;
  wire [15:0]          DbgAgc1;
  wire [8:0]           DbgAgc2;
  wire [15:0]          DbgAgc3;
  wire [6:0]           DbgAgc4;
`ifdef RW_RADAR_EN
  wire [15:0]          DbgAgc5;
`endif // RW_RADAR_EN
 
  /*****************************************************************************
  * FRONTEND PATH MUXES
  *****************************************************************************/
`ifdef RW_RADAR_EN
  /* RADAR mux */
  wire [12:0]  FERadI,     FERadQ;
  assign {FERadQ,FERadI} = 
`ifdef RW_NX_DERIV_FE_PATH1
    (AgcRegAntSelRadar==2'd1)?{FE1RadQ,FE1RadI}:
`endif
                              {FE0RadQ,FE0RadI};
`endif // RW_RADAR_EN

  wire [1:0]           AntSelBWEst;
`ifdef RW_NX_DERIV_FE_PATH40M
  /* RX20 secondary mux */
  assign {OFDMRx20SecI, OFDMRx20SecQ} = 
`ifdef RW_NX_DERIV_FE_PATH1
    (AntSelBWEst==2'd1)?{OFDMRx20SecI1, OFDMRx20SecQ1}:
`endif
                        {OFDMRx20SecI0, OFDMRx20SecQ0};
`endif
  assign AGCFSMCtrl = 
    {2'b0,AgcRegChCombMode,AgcRegGPSetting[3:0],
     AgcRegModeB,AgcRegModeA,
`ifdef RW_RADAR_EN
     AgcRegRadarDetEn,
`else
     1'b0,
`endif // RW_RADAR_EN
     AgcFsmInit};
 
  assign CCACtrl = 
    {AgcRegCCAFlag3Ctrl,AgcRegCCAFlag2Ctrl,AgcRegCCAFlag1Ctrl,
     AgcRegCCAFlag0Ctrl,AgcRegDisCCAEn,AgcRegSatCCAEn,AgcRegCCADemod,
     AgcRegCCACSEn,AgcRegCCARampUDen,AgcRegCCAEnergyEn};

  assign AgcFsmInit                   = ~AGCOn | AgcRegAgcFsmReset;
  
  assign RifsEn                       = AgcRegRifsDetEn & AGCKeepRFOn;

  assign HTSTFGainUpdateP             = AGCGainUpdateP & AgcRegHTSTFGainEn;

  /* $todo : move this to AGC */
  assign AGCBWSup20Masked             = (AGCDSSSLock)?1'b0:AGCBWSup20;
  assign AGCBWEq20Masked              = (AGCDSSSLock)?1'b1:AGCBWEq20;
  assign AGCBWEq40Masked              = (AGCDSSSLock)?1'b0:AGCBWEq40;
  assign AGCBWEq80Masked              = (AGCDSSSLock)?1'b0:AGCBWEq80;

  /* $todo : move this to AGC */
  assign AgcRegSatLowThr_agc          = {{4{AgcRegSatLowThr[5]}},AgcRegSatLowThr};
  assign AgcRegSatDynHighThr_agc      = {{4{AgcRegSatDynHighThr[5]}},AgcRegSatDynHighThr};
  assign AgcRegSatDynLowThr_agc       = {{4{AgcRegSatDynLowThr[5]}},AgcRegSatDynLowThr};
  assign AgcRegSatDelayCount_agc      = {2'd0,AgcRegSatDelayCount};
  assign AgcRegDetPlat_agc            = {{3{AgcRegDetPlat[4]}},AgcRegDetPlat};

  /* $todo : move this to AGC */
  assign AgcRegADCPowBiasqdBm_agc     = {AgcRegADCPowBiasqdBm[7],AgcRegADCPowBiasqdBm};
  assign AgcRegInBd20PPowBiasqdBm_agc = {AgcRegInBd20PPowBiasqdBm[7],AgcRegInBd20PPowBiasqdBm};
  assign AgcRegInBd20SPowBiasqdBm_agc = {AgcRegInBd20SPowBiasqdBm[7],AgcRegInBd20SPowBiasqdBm};
  assign AgcRegInBd40SPowBiasqdBm_agc = {AgcRegInBd40SPowBiasqdBm[7],AgcRegInBd40SPowBiasqdBm};

  /* $todo : move this to AGC */
  assign AgcRegInBddBVThr_agc         = {{2{AgcRegInBddBVThr[7]}},AgcRegInBddBVThr};
  assign AgcRegInBddBmThr_agc         = {{3{AgcRegInBddBmThr[7]}},AgcRegInBddBmThr};
  assign AgcRegADCdBVThr_agc          = {{2{AgcRegADCdBVThr[7]}},AgcRegADCdBVThr};
  assign AgcRegADCdBmThr_agc          = {{3{AgcRegADCdBmThr[7]}},AgcRegADCdBmThr};

  // Antenna selection
  assign AGCP2RxAntennaset = (AGCDSSSLock)          ? 
                             ((AntSelDSSSMux==2'b0) ? 8'd1 : 8'd2) :
                             {6'b0,CfgRegActiveAnt};

`ifndef RW_NX_AGC_SNR_EN
  // Force unused outputs to default value
  assign AGCP1Update       = 1'b1;
  assign AGCP1SNR          = 8'd25;
  assign AGCP1NoiseVardB   = 8'd0;
`endif // RW_NX_AGC_SNR_EN
    
  /*****************************************************************************
  * AGC
  *****************************************************************************/
  AGCCCATop
  #(
`ifdef RW_NX_DERIV_FE_PATH1
    .NRX(                                 2),
`else
    .NRX(                                 1),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .BW_PARAM(                            80)
`elsif RW_NX_DERIV_FE_PATH40M
    .BW_PARAM(                            40)
`else
    .BW_PARAM(                            20)
`endif
  )
  u_AGCCCATop
  (
    // Clock and reset
    .AGCClk(                              AGCGClk),
    .ADCPowClk(                           ADCPowGClk),
    .nAGCRst(                             nAGCRst),
`ifdef RW_RADAR_EN
    .RadarTimClk(                         RadarTimGClk),
    .nRadarTimRst(                        nRadarTimRst),
    .HClk(                                RegBusClk),
    .nHRst(                               nRegBusRst),
`endif // RW_RADAR_EN
    // Interface with AGC RAM
    .AGCMemRdData(                        AGCMemRdData),
    .AGCMemAddr(                          AGCMemAddr),
`ifdef RW_RADAR_EN
    // Interface with Radar RAM
    .RadarMemRdData(                      RadarMemRdData),
    .RadarMemWrData(                      RadarMemWrData),
    .RadarMemAddr(                        RadarMemAddr),
    .RadarMemWriteEn(                     RadarMemWrEn),
    .RadarMemEn(                          RadarMemEn),
    // Radar pulse FIFO
    .RadarFifoRdEn(                       RadarFifoRdEn),
    .RadarFifoRdData(                     RadarFifoRdData),
    .RadarFifoEmpty(                      StRegRadarFifoEmpty), 
    .RadarIrq(                            RadarIrq),
`endif // RW_RADAR_EN
    // External Control
    .HTSTFStartEstimP(                    AGCStartEstimP),
    .HTSTFGainUpdateP(                    HTSTFGainUpdateP),
    .RxEndTimingP(                        AGCRxEndTiming),
    .LSIGValid(                           AGCCCALSIGValid),
    .HTSIGValid(                          AGCCCAHTSigVHTSigAValid),
    .SFDFound(                            AGCSFDFound),
    .DemodRun(                            AGCDemodRun),
    .RifsEn(                              RifsEn),
    .BWDetected(                          AGCPlatFallP),
    .BWSup20(                             AGCBWSup20Masked),
    .BWEq20(                              AGCBWEq20Masked),
    .BWEq40(                              AGCBWEq40Masked),
    .BWEq80(                              AGCBWEq80Masked),
    .VHTSig(                              AGCVHTFrame),
    .NoACIMargin(                         AGCNoACIMargin),
    .HTSIGMCS(                            AGCFrameParamMCS),
    .InbdPowStartCaptureP(                InbdPowStartCaptureP),
    .AGCOFDMLock(                         AGCOFDMLock),
    .AGCOFDMHTSTF(                        AGCOFDMHTSTF),
    .AGCDSSSLock(                         AGCDSSSLock),
    .RifsDetected(                        AGCRifsDetected),
    .AntSelDSSS(                          AntSelDSSS),
    .AntSelBWEst(                         AntSelBWEst),
    .AGCFSMExtEn(                         ),
`ifdef RW_NX_AGC_SNR_EN
    .NoiseVardB(                          AGCP1NoiseVardB),
    .NoiseVardBValid(                     ),
    .SNR(                                 AGCP1SNR),
    .SNRValid(                            AGCP1Update),
`endif // RW_NX_AGC_SNR_EN
    // RC interface
    .RCProgRFDone(                        RCProgRFDone),
    .AGCRFGainCompDone(                   RCRFGainCompDone),
    .RFGain0dB(                           RFGaindB0),
`ifdef RW_NX_AGC_SNR_EN
    .RFGainNF0dB(                         RFGainNFdB0),
`endif // RW_NX_AGC_SNR_EN
`ifdef RW_NX_DERIV_FE_PATH1
    .RFGain1dB(                           RFGaindB0),
`ifdef RW_NX_AGC_SNR_EN
    .RFGainNF1dB(                         RFGainNFdB0),
`endif // RW_NX_AGC_SNR_EN
`else
    .RFGain1dB(                           8'b0),
`ifdef RW_NX_AGC_SNR_EN
    .RFGainNF1dB(                         6'b0),
`endif // RW_NX_AGC_SNR_EN
`endif
    .RFGain2dB(                           8'b0),
    .RFGain3dB(                           8'b0),
`ifdef RW_NX_AGC_SNR_EN
    .RFGainNF2dB(                         6'b0),
    .RFGainNF3dB(                         6'b0),
`endif // RW_NX_AGC_SNR_EN
    .RCExtDetect0(                        RCExtDetect0),
`ifdef RW_NX_DERIV_FE_PATH1
    .RCExtDetect1(                        RCExtDetect1),
`else
    .RCExtDetect1(                        1'b0),
`endif
    .RCExtDetect2(                        1'b0),
    .RCExtDetect3(                        1'b0),
    .RCProgRF(                            RCProgRF),
    .AGCRFGainCompReq(                    RCRFGainCompReq),
    .AGCGainTgt0(                         AGCGainTgt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .AGCGainTgt1(                         AGCGainTgt1),
`else
    .AGCGainTgt1(                         ),
`endif
    .AGCGainTgt2(                         ),
    .AGCGainTgt3(                         ),
    // Config Registers
    .Force20(                             force20),
    .Force40(                             force40),
    // AGC Registers
    .FSMEvent0Reg(                        AgcRegFsmEvent0),
    .FSMEvent1Reg(                        AgcRegFsmEvent1),
    .FSMEvent2Reg(                        AgcRegFsmEvent2),
    .FSMEvent3Reg(                        AgcRegFsmEvent3),
    .AGCFSMCtrl(                          AGCFSMCtrl),
    .CCACtrl(                             CCACtrl),
    .RegAntSelCCA20s(                     AgcRegAntSelCCA20s),
    .RegAntSelCCA40s(                     AgcRegAntSelCCA40s),
    .RxStateCca20PSel(                    AgcRegRxStateCca20PSel),
    .RxStateCca20SSel(                    AgcRegRxStateCca20SSel),
    .RxStateCca40SSel(                    AgcRegRxStateCca40SSel),
    .CCATimeoutReg(                       AgcRegCCATimeOut),
    .SatLowThr(                           AgcRegSatLowThr_agc),
    .SatDynHighThr(                       AgcRegSatDynHighThr_agc),
    .SatDynLowThr(                        AgcRegSatDynLowThr_agc),
    .SatDelayCount(                       AgcRegSatDelayCount_agc),
    .RegDetPlat(                          AgcRegDetPlat_agc),
    .RegDetRampUp(                        AgcRegDetRampUp),
    .RegDetRampDown(                      AgcRegDetRampDown),
    .RegCCADetRampUp(                     AgcRegCCADetRampUp),
    .RegCCADetRampDown(                   AgcRegCCADetRampDown),
    .DelRampUpTap(                        AgcRegDelRampUpTap),
    .DelRampDownTap(                      AgcRegDelRampDownTap),
    .DelPlatTap(                          AgcRegDelPlatTap),
    .DelCCARampUpTap(                     AgcRegDelCCARampUpTap),
    .DelCCARampDownTap(                   AgcRegDelCCARampDownTap),
    .RegDetRiseThrqdBm(                   AgcRegDetRiseThrqdBm),
    .RegDetFallThrqdBm(                   AgcRegDetFallThrqdBm),
    .RegADCPowDisThrdBV(                  AgcRegADCPowDisThrdBV),
    .RegADCPowDisNdl(                     AgcRegADCPowDisNdl),
    .RegInbdCCA20PPowMindBm(              AgcRegInbdCCA20PPowMindBm),
    .RegCCA20PRiseThrdBm(                 AgcRegCCA20PRiseThrdBm),
    .RegCCA20PFallThrdBm(                 AgcRegCCA20PFallThrdBm),
    .RegInbdCCA20SPowMindBm(              AgcRegInbdCCA20SPowMindBm),
    .RegCCA20SFallThrdBm(                 AgcRegCCA20SFallThrdBm),
    .RegCCA20SRiseThrdBm(                 AgcRegCCA20SRiseThrdBm),
    .RegInbdCCA40SPowMindBm(              AgcRegInbdCCA40SPowMindBm),
    .RegCCA40SFallThrdBm(                 AgcRegCCA40SFallThrdBm),
    .RegCCA40SRiseThrdBm(                 AgcRegCCA40SRiseThrdBm),
    .RegRFGainMax4Det(                    AgcRegRFGainMax4DetdB),
    .RegRFGainMin4Det(                    AgcRegRFGainMin4DetdB),
    .RegRFGainMax(                        AgcRegRFGainMaxdB),
    .RegRFGainMin(                        AgcRegRFGainMindB),
    .RegDelStableDC(                      AgcRegDelStableDC),
    .dcHoldTimeADC(                       AgcRegDC4ADCHoldTime),
    .dcCompTypeADC(                       AgcRegDC4ADCCompType),
    .dcForceZeroCntADC(                   AgcRegDC4ADCZeroTime),
    .RegAntLossdB0(                       AgcRegAntLossDB0),
`ifdef RW_NX_DERIV_FE_PATH1
    .RegAntLossdB1(                       AgcRegAntLossDB1),
`else
    .RegAntLossdB1(                       4'b0),
`endif
    .RegAntLossdB2(                       4'b0),
    .RegAntLossdB3(                       4'b0),
    .RegDigGain40vs20(                    AgcRegDigGain40vs20),
    .RegDigGain80vs20(                    AgcRegDigGain80vs20),
`ifdef RW_NX_AGC_SNR_EN
    .SNRMeasSel(                          AgcRegSNRMeasSel),
`endif // RW_NX_AGC_SNR_EN
    .IdInBdPowGapDnqdBm(                  AgcRegIdInbdPowGapDnqdBm),
    .IdInBdPowGapUpqdBm(                  AgcRegIdInbdPowGapUpqdBm),
    .InBdPowInfThrdBm(                    AgcRegInbdPowInfThrdBm),
    .InBdPowSupThrdBm(                    AgcRegInbdPowSupThrdBm),
    .ADCPowInfThrdBV(                     AgcRegADCPowInfThrdBV),
    .ADCPowSupThrdBV(                     AgcRegADCPowSupThrdBV),
    .ADCPowInfThrdBm(                     AgcRegADCPowInfThrdBm),
    .ADCPowSupThrdBm(                     AgcRegADCPowSupThrdBm),
    .NBitADC(                             AgcRegNBitAdc),
    .VPeakADCqdBV(                        AgcRegVPeakADCqdBV),
    .RegInBdRnd(                          AgcRegInBdRnd),
    .RegADCPowBiasqdBV(                   AgcRegADCPowBiasqdBV),
    .RegADCPowBiasqdBm(                   AgcRegADCPowBiasqdBm_agc),
    .RegInBd40SecPowBiasqdBm(             AgcRegInBd40SPowBiasqdBm_agc),
    .RegInBd20PowBiasqdBm(                AgcRegInBd20PPowBiasqdBm_agc),
    .RegInBd20SecPowBiasqdBm(             AgcRegInBd20SPowBiasqdBm_agc),
    .InBddBVThr(                          AgcRegInBddBVThr_agc),
    .InBddBmThr(                          AgcRegInBddBmThr_agc),
    .ADCdBVThr(                           AgcRegADCdBVThr_agc),
    .ADCdBmThr(                           AgcRegADCdBmThr_agc),
    .FE20Gain(                            AgcRegFE20Gain),
    .FE40Gain(                            AgcRegFE40Gain),
    .RegACI20MargMCS9(                    AgcRegACI20MargMCS9),
    .RegACI20MargMCS8(                    AgcRegACI20MargMCS8),
    .RegACI20MargMCS7(                    AgcRegACI20MargMCS7),
    .RegACI20MargMCS6(                    AgcRegACI20MargMCS6),
    .RegACI20MargMCS5(                    AgcRegACI20MargMCS5),
    .RegACI20MargMCS4(                    AgcRegACI20MargMCS4),
    .RegACI20MargMCS3(                    AgcRegACI20MargMCS3),
    .RegACI20MargMCS2(                    AgcRegACI20MargMCS2),
    .RegACI20MargMCS1(                    AgcRegACI20MargMCS1),
    .RegACI20MargMCS0(                    AgcRegACI20MargMCS0),
    .RegACI40MargMCS9(                    AgcRegACI40MargMCS9),
    .RegACI40MargMCS8(                    AgcRegACI40MargMCS8),
    .RegACI40MargMCS7(                    AgcRegACI40MargMCS7),
    .RegACI40MargMCS6(                    AgcRegACI40MargMCS6),
    .RegACI40MargMCS5(                    AgcRegACI40MargMCS5),
    .RegACI40MargMCS4(                    AgcRegACI40MargMCS4),
    .RegACI40MargMCS3(                    AgcRegACI40MargMCS3),
    .RegACI40MargMCS2(                    AgcRegACI40MargMCS2),
    .RegACI40MargMCS1(                    AgcRegACI40MargMCS1),
    .RegACI40MargMCS0(                    AgcRegACI40MargMCS0),
    .RegACI80MargMCS9(                    AgcRegACI80MargMCS9),
    .RegACI80MargMCS8(                    AgcRegACI80MargMCS8),
    .RegACI80MargMCS7(                    AgcRegACI80MargMCS7),
    .RegACI80MargMCS6(                    AgcRegACI80MargMCS6),
    .RegACI80MargMCS5(                    AgcRegACI80MargMCS5),
    .RegACI80MargMCS4(                    AgcRegACI80MargMCS4),
    .RegACI80MargMCS3(                    AgcRegACI80MargMCS3),
    .RegACI80MargMCS2(                    AgcRegACI80MargMCS2),
    .RegACI80MargMCS1(                    AgcRegACI80MargMCS1),
    .RegACI80MargMCS0(                    AgcRegACI80MargMCS0),
`ifdef RW_RADAR_EN
    .RegFreqSing(                         AgcRegFreqSing),
    .RegFreqSingGap(                      AgcRegFreqSingGap),
    .RegFomSing(                          AgcRegFomSing),
    .RegFomSingGap(                       AgcRegFomSingGap),
    .RegPulseIrqThr(                      AgcRegPulseIrqFifoThr),
    .RegPulseIrqTimeOut(                  AgcRegPulseIrqTimeOut),
    .RegPulseTimerClear(                  PulseTimerClear),
`endif // RW_RADAR_EN
    // ADC interface
    .ADCReRx0(                            ADCFixedI0),
    .ADCImRx0(                            ADCFixedQ0),
`ifdef RW_NX_DERIV_FE_PATH1
    .ADCReRx1(                            ADCFixedI1),
    .ADCImRx1(                            ADCFixedQ1),
`else
    .ADCReRx1(                            12'b0),
    .ADCImRx1(                            12'b0),
`endif
    .ADCReRx2(                            12'b0),
    .ADCImRx2(                            12'b0),
    .ADCReRx3(                            12'b0),
    .ADCImRx3(                            12'b0),
    // FE interface
    // 20MHz primary
    .RxAGC20PriReRx0(                     FE0AGC20I),
    .RxAGC20PriImRx0(                     FE0AGC20Q),
`ifdef RW_NX_DERIV_FE_PATH1
    .RxAGC20PriReRx1(                     FE1AGC20I),
    .RxAGC20PriImRx1(                     FE1AGC20Q),
`else
    .RxAGC20PriReRx1(                     13'b0),
    .RxAGC20PriImRx1(                     13'b0),
`endif
    .RxAGC20PriReRx2(                     13'b0),
    .RxAGC20PriImRx2(                     13'b0),
    .RxAGC20PriReRx3(                     13'b0),
    .RxAGC20PriImRx3(                     13'b0),
    // 20MHz secondary
`ifdef RW_NX_DERIV_FE_PATH40M
    .RxAGC20SecReRx0(                     FE0AGC20SecI),
    .RxAGC20SecImRx0(                     FE0AGC20SecQ),
`ifdef RW_NX_DERIV_FE_PATH1
    .RxAGC20SecReRx1(                     FE1AGC20SecI),
    .RxAGC20SecImRx1(                     FE1AGC20SecQ),
`else
    .RxAGC20SecReRx1(                     13'b0),
    .RxAGC20SecImRx1(                     13'b0),
`endif
    .RxAGC20SecReRx2(                     13'b0),
    .RxAGC20SecImRx2(                     13'b0),
    .RxAGC20SecReRx3(                     13'b0),
    .RxAGC20SecImRx3(                     13'b0),
`else
    .RxAGC20SecReRx0(                     13'b0),
    .RxAGC20SecImRx0(                     13'b0),
    .RxAGC20SecReRx1(                     13'b0),
    .RxAGC20SecImRx1(                     13'b0),
    .RxAGC20SecReRx2(                     13'b0),
    .RxAGC20SecImRx2(                     13'b0),
    .RxAGC20SecReRx3(                     13'b0),
    .RxAGC20SecImRx3(                     13'b0),
`endif
    // 40MHz secondary
`ifdef RW_NX_DERIV_FE_PATH80M
    .RxAGC40SecReRx0(                     FE0AGC40SecI),
    .RxAGC40SecImRx0(                     FE0AGC40SecQ),
`ifdef RW_NX_DERIV_FE_PATH1
    .RxAGC40SecReRx1(                     FE1AGC40SecI),
    .RxAGC40SecImRx1(                     FE1AGC40SecQ),
`else
    .RxAGC40SecReRx1(                     13'b0),
    .RxAGC40SecImRx1(                     13'b0),
`endif    
    .RxAGC40SecReRx2(                     13'b0),
    .RxAGC40SecImRx2(                     13'b0),
    .RxAGC40SecReRx3(                     13'b0),
    .RxAGC40SecImRx3(                     13'b0),
`else
    .RxAGC40SecReRx0(                     13'b0),
    .RxAGC40SecImRx0(                     13'b0),
    .RxAGC40SecReRx1(                     13'b0),
    .RxAGC40SecImRx1(                     13'b0),
    .RxAGC40SecReRx2(                     13'b0),
    .RxAGC40SecImRx2(                     13'b0),
    .RxAGC40SecReRx3(                     13'b0),
    .RxAGC40SecImRx3(                     13'b0),
`endif
`ifdef RW_RADAR_EN
    // Radar detection
    .RxRadI(                              FERadI),
    .RxRadQ(                              FERadQ),
`endif // RW_RADAR_EN
`ifdef RW_NX_DSSS_CORR_EN
    // DSSS Continuous Correlator
    .RxFilt4CorrI(                        FEBRxFilt4CorrI_resync),
    .RxFilt4CorrQ(                        FEBRxFilt4CorrQ_resync),
    .RxFilt4CorrValid(                    FEBRxFilt4CorrValid),
`endif
    // Digital Gain for 20MHz path
    .DigGain6dB20Rx0(                     Agc2FERx20DigGain6dB0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGain6dB20Rx1(                     Agc2FERx20DigGain6dB1),
`else
    .DigGain6dB20Rx1(                     ),
`endif
    .DigGain6dB20Rx2(                     ),
    .DigGain6dB20Rx3(                     ),
    .DigGainLin20Rx0(                     Agc2FERx20DigGainLin0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGainLin20Rx1(                     Agc2FERx20DigGainLin1),
`else
    .DigGainLin20Rx1(                     ),
`endif
    .DigGainLin20Rx2(                     ),
    .DigGainLin20Rx3(                     ),
    // Digital Gain for 40MHz path
    .DigGain6dB40Rx0(                     Agc2FERx40DigGain6dB0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGain6dB40Rx1(                     Agc2FERx40DigGain6dB1),
`else
    .DigGain6dB40Rx1(                     ),
`endif
    .DigGain6dB40Rx2(                     ),
    .DigGain6dB40Rx3(                     ),
    .DigGainLin40Rx0(                     Agc2FERx40DigGainLin0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGainLin40Rx1(                     Agc2FERx40DigGainLin1),
`else
    .DigGainLin40Rx1(                     ),
`endif
    .DigGainLin40Rx2(                     ),
    .DigGainLin40Rx3(                     ),
    // Digital Gain for 80MHz path
    .DigGain6dB80Rx0(                     Agc2FERx80DigGain6dB0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGain6dB80Rx1(                     Agc2FERx80DigGain6dB1),
`else
    .DigGain6dB80Rx1(                     ),
`endif
    .DigGain6dB80Rx2(                     ),
    .DigGain6dB80Rx3(                     ),
    .DigGainLin80Rx0(                     Agc2FERx80DigGainLin0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGainLin80Rx1(                     Agc2FERx80DigGainLin1),
`else
    .DigGainLin80Rx1(                     ),
`endif
    .DigGainLin80Rx2(                     ),
    .DigGainLin80Rx3(                     ),
`ifdef RW_NX_IQ_COMP_EN
    // Interface with IQ Imbalance
    .IQGnPhCompEn(                        AGCIQGnPhCompEn),
    .IQEstGainAccEn(                      AGCIQEstGainAccEn),
    .IQEstPhaseAccEn(                     AGCIQEstPhaseAccEn),
`endif
    // Interface with Front End Filter
    .OFDMFEEn(                            AGCOFDMFEEn),
    .DSSSFEEn(                            AGCDSSSFEEn),
    .DCEstReRx0(                          FE0DCEstI),
    .DCEstImRx0(                          FE0DCEstQ),
`ifdef RW_NX_DERIV_FE_PATH1
    .DCEstReRx1(                          FE1DCEstI),
    .DCEstImRx1(                          FE1DCEstQ),
`else
    .DCEstReRx1(                          ),
    .DCEstImRx1(                          ),
`endif    
    .DCEstReRx2(                          ),
    .DCEstImRx2(                          ),
    .DCEstReRx3(                          ),
    .DCEstImRx3(                          ),
    .DCEstValid(                          ),
    // CCA Related
    .CCAPrimary(                          AGCCCAPrimary20),
    .CCASecondary20(                      AGCCCASecondary20),
    .CCASecondary40(                      AGCCCASecondary40),
    .CCATimeOutErr(                       CCATimeOutErrIrq), 
    // Interface with Status registers
    .StatusTrigConf(                      StatusTrigConf),
    .StatusTrigReq(                       StatusTrigReq),
    .InBd20PowqdBmAnt0(                   StRegInBd20PowqdBmAnt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .InBd20PowqdBmAnt1(                   StRegInBd20PowqdBmAnt1),
`else
    .InBd20PowqdBmAnt1(                   ),
`endif
    .InBd20PowqdBmAnt2(                   ),
    .InBd20PowqdBmAnt3(                   ),
    .InBd20PowqdBmUpdate(                 AGCP2Update),
    .InBd20SecPowqdBmAnt(                 StRegInbdPow20SdBm),
    .InBd40SecPowqdBmAnt(                 StRegInbdPow40SdBm),
    .ADCPowqdBVAnt0(                      StRegADCPowqdBVAnt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .ADCPowqdBVAnt1(                      StRegADCPowqdBVAnt1),
`else
    .ADCPowqdBVAnt1(                      ),
`endif
    .ADCPowqdBVAnt2(                      ),
    .ADCPowqdBVAnt3(                      ),
    .InBd20PowNoiseqdBmAnt0(              StRegInbdPow20PNoisedBm0), 
`ifdef RW_NX_DERIV_FE_PATH1
    .InBd20PowNoiseqdBmAnt1(              StRegInbdPow20PNoisedBm1), 
`else
    .InBd20PowNoiseqdBmAnt1(              ), 
`endif
    .InBd20PowNoiseqdBmAnt2(              ), 
    .InBd20PowNoiseqdBmAnt3(              ),
    .InBd20PowNoiseqdBmUpdate(            StRegInbdPow20PNoiseUpdate),
    .InBd20SecPowNoiseqdBmAnt(            StRegInbdPow20SNoisedBm),
    .InBd40SecPowNoiseqdBmAnt(            StRegInbdPow40SNoisedBm),
    .DigGaindB20Ant0(                     StRegDigGaindB20Ant0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGaindB20Ant1(                     StRegDigGaindB20Ant1),
`else
    .DigGaindB20Ant1(                     ),
`endif
    .DigGaindB20Ant2(                     ),
    .DigGaindB20Ant3(                     ),
    .DigGaindB40Ant0(                     StRegDigGaindB40Ant0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGaindB40Ant1(                     StRegDigGaindB40Ant1),
`else
    .DigGaindB40Ant1(                     ),
`endif
    .DigGaindB40Ant2(                     ),
    .DigGaindB40Ant3(                     ),
    .DigGaindB80Ant0(                     StRegDigGaindB80Ant0),
`ifdef RW_NX_DERIV_FE_PATH1
    .DigGaindB80Ant1(                     StRegDigGaindB80Ant1),
`else
    .DigGaindB80Ant1(                     ),
`endif
    .DigGaindB80Ant2(                     ),
    .DigGaindB80Ant3(                     ),
    .RxGainAnt0(                          StRegRxGainAnt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .RxGainAnt1(                          StRegRxGainAnt1),
`else
    .RxGainAnt1(                          ),
`endif
    .RxGainAnt2(                          ),
    .RxGainAnt3(                          ),
    .RFGainAnt0(                          ),
    .RFGainAnt1(                          ),
    .RFGainAnt2(                          ),
    .RFGainAnt3(                          ),
   // Debug port
`ifdef RW_RADAR_EN
    .DbgAgc5(                             DbgAgc5),
`endif // RW_RADAR_EN
    .DbgAgc0(                             DbgAgc0),
    .DbgAgc1(                             DbgAgc1),
    .DbgAgc2(                             DbgAgc2),
    .DbgAgc3(                             DbgAgc3),
    .DbgAgc4(                             DbgAgc4),
    .DbgCca(                              CcaDbgBank)
  );

  assign AGCP2Rssi1 = StRegInBd20PowqdBmAnt0[9:2];

`ifdef RW_NX_DERIV_FE_PATH1
  assign AGCP2Rssi2 = StRegInBd20PowqdBmAnt1[9:2];
`endif

  /*****************************************************************************
  * Debug ports
  *****************************************************************************/
  wire   DebugAGCLock;
  assign DebugAGCLock = AGCOFDMLock | AGCDSSSLock;

  assign DbgBank0  = {DbgAgc2,DbgAgc4};
  assign DbgBank1  = DbgAgc0;
  assign DbgBank2  = DbgAgc1;
  assign DbgBank3  = DbgAgc3;
`ifdef RW_NX_DERIV_80211B
  assign DbgBank4  = {1'b0,DSSSRxValid,DSSSRxI,DSSSRxQ};
`else
  assign DbgBank4  = 16'b0;
`endif  
  assign DbgBank5  = {DbgAgc2,DebugAGCLock,AGCOFDMHTSTF,AGCOFDMFEEn_aligned,
                      AGCCCALSIGValid,AGCCCAHTSigVHTSigAValid,AGCSFDFound,AGCRxEndTiming};
  assign DbgBank6  = {2'b0,OFDMRxValid,OFDMRx20I0};
  assign DbgBank7  = {2'b0,OFDMRxValid,OFDMRx20Q0};
`ifdef RW_RADAR_EN
  assign DbgBank8  = DbgAgc5;
`endif // RW_RADAR_EN

endmodule
