//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: rblanc $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10864 $
// $Date: 2013-10-16 15:39:43 +0200 (Wed, 16 Oct 2013) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : KarstAGCGainTable register
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module KarstAGCGainTable
(
    ////////////////////////////////////////////
    //$port_g clock and reset
    ////////////////////////////////////////////
    input  wire         rst_n     , // Hard Reset.
    input  wire         clk         , // clock clock.

    ////////////////////////////////////////////
    // AGC GAIN Control
    ////////////////////////////////////////////

    input  wire [5 : 0] Rx0GainAddr,
    input  wire [5 : 0] Rx1GainAddr,
    output wire [7 : 0] Rx0GainOffset,
    output wire [7 : 0] Rx1GainOffset,

    ////////////////////////////////////////////
    //$port_g  APB slave
    ////////////////////////////////////////////
    input  wire        regbus_sel, 
    input  wire        regbus_rden,
    input  wire        regbus_wren, 
    input  wire [ 3:0] regbus_addr, 
    input  wire [31:0] regbus_wdata,
    output reg  [31:0] regbus_rdata 
    
  );
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////
// Constants for registers addresses
//////////////////////////////////////////////////////////////////////////////

// Constants for register addresses.
localparam RWNXAGCGAINTABLE0_ADDR_CT       = 4'b0000;
localparam RWNXAGCGAINTABLE1_ADDR_CT       = 4'b0001;
localparam RWNXAGCGAINTABLE2_ADDR_CT       = 4'b0010;
localparam RWNXAGCGAINTABLE3_ADDR_CT       = 4'b0011;
localparam RWNXAGCGAINTABLE4_ADDR_CT       = 4'b0100;
localparam RWNXAGCGAINTABLE5_ADDR_CT       = 4'b0101;
localparam RWNXAGCGAINTABLE6_ADDR_CT       = 4'b0110;
localparam RWNXAGCGAINTABLE7_ADDR_CT       = 4'b0111;
localparam RWNXAGCGAINTABLE8_ADDR_CT       = 4'b1000;
localparam RWNXAGCGAINTABLE9_ADDR_CT       = 4'b1001;
localparam RWNXAGCGAINTABLE10_ADDR_CT      = 4'b1010;
localparam RWNXAGCGAINTABLE11_ADDR_CT      = 4'b1011;
localparam RWNXAGCGAINTABLE12_ADDR_CT      = 4'b1100;
localparam RWNXAGCGAINTABLE13_ADDR_CT      = 4'b1101;
localparam RWNXAGCGAINTABLE14_ADDR_CT      = 4'b1110;
localparam RWNXAGCGAINTABLE15_ADDR_CT      = 4'b1111;


reg [7 : 0] AGCGAINTABLE [63 : 0];

assign Rx0GainOffset =AGCGAINTABLE[Rx0GainAddr];
assign Rx1GainOffset =AGCGAINTABLE[Rx1GainAddr];

  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  // apb_write_p:


  always @(posedge clk,negedge rst_n)
  begin
    if (!rst_n) 
    begin
      {AGCGAINTABLE[3],AGCGAINTABLE[2],AGCGAINTABLE[1],AGCGAINTABLE[0]} <= 32'hff;
      {AGCGAINTABLE[7],AGCGAINTABLE[6],AGCGAINTABLE[5],AGCGAINTABLE[4]} <= 32'h0;
      {AGCGAINTABLE[11],AGCGAINTABLE[10],AGCGAINTABLE[9],AGCGAINTABLE[8]} <= 32'h0;
      {AGCGAINTABLE[15],AGCGAINTABLE[14],AGCGAINTABLE[13],AGCGAINTABLE[12]} <= 32'h0;
      {AGCGAINTABLE[19],AGCGAINTABLE[18],AGCGAINTABLE[17],AGCGAINTABLE[16]} <= 32'h0;
      {AGCGAINTABLE[23],AGCGAINTABLE[22],AGCGAINTABLE[21],AGCGAINTABLE[20]} <= 32'h0;
      {AGCGAINTABLE[27],AGCGAINTABLE[26],AGCGAINTABLE[25],AGCGAINTABLE[24]} <= 32'h11000000;
      {AGCGAINTABLE[31],AGCGAINTABLE[30],AGCGAINTABLE[29],AGCGAINTABLE[28]} <= 32'h10101010;
      {AGCGAINTABLE[35],AGCGAINTABLE[34],AGCGAINTABLE[33],AGCGAINTABLE[32]} <= 32'h10101010;
      {AGCGAINTABLE[39],AGCGAINTABLE[38],AGCGAINTABLE[37],AGCGAINTABLE[36]} <= 32'h20211010;
      {AGCGAINTABLE[43],AGCGAINTABLE[42],AGCGAINTABLE[41],AGCGAINTABLE[40]} <= 32'h20202020;
      {AGCGAINTABLE[47],AGCGAINTABLE[46],AGCGAINTABLE[45],AGCGAINTABLE[44]} <= 32'h20202020;
      {AGCGAINTABLE[51],AGCGAINTABLE[50],AGCGAINTABLE[49],AGCGAINTABLE[48]} <= 32'h20202020;
      {AGCGAINTABLE[55],AGCGAINTABLE[54],AGCGAINTABLE[53],AGCGAINTABLE[52]} <= 32'h20202020;
      {AGCGAINTABLE[59],AGCGAINTABLE[58],AGCGAINTABLE[57],AGCGAINTABLE[56]} <= 32'h20202020;
      {AGCGAINTABLE[63],AGCGAINTABLE[62],AGCGAINTABLE[61],AGCGAINTABLE[60]} <= 32'h20202020;
    end

    else
    begin
      if(regbus_sel && regbus_wren)
      begin

        case(regbus_addr)

          //Write RWNXAGCGAINTABLE0 register.
          RWNXAGCGAINTABLE0_ADDR_CT : begin
            {AGCGAINTABLE[3][7:0],AGCGAINTABLE[2][7:0],AGCGAINTABLE[1][7:0],AGCGAINTABLE[0][7:0]} <= regbus_wdata[31 : 0];
          end

          //Write RWNXAGCGAINTABLE1 register.
          RWNXAGCGAINTABLE1_ADDR_CT : begin
            {AGCGAINTABLE[7],AGCGAINTABLE[6],AGCGAINTABLE[5],AGCGAINTABLE[4]} <= regbus_wdata[31 : 0];
          end

          //Write RWNXAGCGAINTABLE2 register.
          RWNXAGCGAINTABLE2_ADDR_CT : begin
            {AGCGAINTABLE[11],AGCGAINTABLE[10],AGCGAINTABLE[9],AGCGAINTABLE[8]} <= regbus_wdata[31 : 0];
          end

          //Write RWNXAGCGAINTABLE3 register.
          RWNXAGCGAINTABLE3_ADDR_CT : begin
            {AGCGAINTABLE[15],AGCGAINTABLE[14],AGCGAINTABLE[13],AGCGAINTABLE[12]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE4 register.
          RWNXAGCGAINTABLE4_ADDR_CT : begin
            {AGCGAINTABLE[19],AGCGAINTABLE[18],AGCGAINTABLE[17],AGCGAINTABLE[16]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE5 register.
          RWNXAGCGAINTABLE5_ADDR_CT : begin
            {AGCGAINTABLE[23],AGCGAINTABLE[22],AGCGAINTABLE[21],AGCGAINTABLE[20]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE6 register.
          RWNXAGCGAINTABLE6_ADDR_CT : begin
            {AGCGAINTABLE[27],AGCGAINTABLE[26],AGCGAINTABLE[25],AGCGAINTABLE[24]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE7 register.
          RWNXAGCGAINTABLE7_ADDR_CT : begin
            {AGCGAINTABLE[31],AGCGAINTABLE[30],AGCGAINTABLE[29],AGCGAINTABLE[28]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE8 register.
          RWNXAGCGAINTABLE8_ADDR_CT : begin
            {AGCGAINTABLE[35],AGCGAINTABLE[34],AGCGAINTABLE[33],AGCGAINTABLE[32]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE9 register.
          RWNXAGCGAINTABLE9_ADDR_CT : begin
            {AGCGAINTABLE[39],AGCGAINTABLE[38],AGCGAINTABLE[37],AGCGAINTABLE[36]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE10 register.
          RWNXAGCGAINTABLE10_ADDR_CT : begin
            {AGCGAINTABLE[43],AGCGAINTABLE[42],AGCGAINTABLE[41],AGCGAINTABLE[40]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE11 register.
          RWNXAGCGAINTABLE11_ADDR_CT : begin
            {AGCGAINTABLE[47],AGCGAINTABLE[46],AGCGAINTABLE[45],AGCGAINTABLE[44]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE12 register.
          RWNXAGCGAINTABLE12_ADDR_CT : begin
            {AGCGAINTABLE[51],AGCGAINTABLE[50],AGCGAINTABLE[49],AGCGAINTABLE[48]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE13 register.
          RWNXAGCGAINTABLE13_ADDR_CT : begin
            {AGCGAINTABLE[55],AGCGAINTABLE[54],AGCGAINTABLE[53],AGCGAINTABLE[52]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE14 register.
          RWNXAGCGAINTABLE14_ADDR_CT : begin
            {AGCGAINTABLE[59],AGCGAINTABLE[58],AGCGAINTABLE[57],AGCGAINTABLE[56]} <= regbus_wdata[31 : 0];
          end
          //Write RWNXAGCGAINTABLE15 register.
          RWNXAGCGAINTABLE15_ADDR_CT : begin
            {AGCGAINTABLE[63],AGCGAINTABLE[62],AGCGAINTABLE[61],AGCGAINTABLE[60]} <= regbus_wdata[31 : 0];
          end
          
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : begin

          end
          // pragma coverage block = on 
        endcase
      end
    end
  end
        
  //////////////////////////////////////////////////////////////////////////////
  // Registers read
  //////////////////////////////////////////////////////////////////////////////
  
  //Read_p: 
  always @(*)
  begin
    regbus_rdata      = 32'b0;
    // Test only psel to detect first cycle of the two-cycles APB read access.
    if (regbus_sel && regbus_rden)
    begin
      case(regbus_addr)

        //Read RWNXAGCGAINTABLE0 register.
        RWNXAGCGAINTABLE0_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[3],AGCGAINTABLE[2],AGCGAINTABLE[1],AGCGAINTABLE[0]};
        end
    
        //Read RWNXAGCGAINTABLE1 register.
        RWNXAGCGAINTABLE1_ADDR_CT : begin
          regbus_rdata[31 : 0]        = {AGCGAINTABLE[7],AGCGAINTABLE[6],AGCGAINTABLE[5],AGCGAINTABLE[4]};
        end

        //Read RWNXAGCGAINTABLE2 register.
        RWNXAGCGAINTABLE2_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[11],AGCGAINTABLE[10],AGCGAINTABLE[9],AGCGAINTABLE[8]};
        end

        //Read RWNXAGCGAINTABLE3 register.
        RWNXAGCGAINTABLE3_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[15],AGCGAINTABLE[14],AGCGAINTABLE[13],AGCGAINTABLE[12]};
        end
        
        //Read RWNXAGCGAINTABLE4 register.
        RWNXAGCGAINTABLE4_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[19],AGCGAINTABLE[18],AGCGAINTABLE[17],AGCGAINTABLE[16]};
        end

        //Read RWNXAGCGAINTABLE5 register.
        RWNXAGCGAINTABLE5_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[23],AGCGAINTABLE[22],AGCGAINTABLE[21],AGCGAINTABLE[20]};
        end
 
        //Read RWNXAGCGAINTABLE6 register.
        RWNXAGCGAINTABLE6_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[27],AGCGAINTABLE[26],AGCGAINTABLE[25],AGCGAINTABLE[24]};
        end

        //Read RWNXAGCGAINTABLE7 register.
        RWNXAGCGAINTABLE7_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[31],AGCGAINTABLE[30],AGCGAINTABLE[29],AGCGAINTABLE[28]};
        end

        //Read RWNXAGCGAINTABLE8 register.
        RWNXAGCGAINTABLE8_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[35],AGCGAINTABLE[34],AGCGAINTABLE[33],AGCGAINTABLE[32]};
        end
 
        //Read RWNXAGCGAINTABLE9 register.
        RWNXAGCGAINTABLE9_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[39],AGCGAINTABLE[38],AGCGAINTABLE[37],AGCGAINTABLE[36]};
        end
      
        //Read RWNXAGCGAINTABLE10 register.
        RWNXAGCGAINTABLE10_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[43],AGCGAINTABLE[42],AGCGAINTABLE[41],AGCGAINTABLE[40]};
        end
      
        //Read RWNXAGCGAINTABLE11 register.
        RWNXAGCGAINTABLE11_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[47],AGCGAINTABLE[46],AGCGAINTABLE[45],AGCGAINTABLE[44]};
        end
      
        //Read RWNXAGCGAINTABLE12 register.
        RWNXAGCGAINTABLE12_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[51],AGCGAINTABLE[50],AGCGAINTABLE[49],AGCGAINTABLE[48]};
        end
      
        //Read RWNXAGCGAINTABLE13 register.
        RWNXAGCGAINTABLE13_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[55],AGCGAINTABLE[54],AGCGAINTABLE[53],AGCGAINTABLE[52]};
        end
      
        //Read RWNXAGCGAINTABLE14 register.
        RWNXAGCGAINTABLE14_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {AGCGAINTABLE[59],AGCGAINTABLE[58],AGCGAINTABLE[57],AGCGAINTABLE[56]};
        end
      
        //Read RWNXAGCGAINTABLE15 register.
        RWNXAGCGAINTABLE15_ADDR_CT : begin
          regbus_rdata[31 : 0]        = {AGCGAINTABLE[63],AGCGAINTABLE[62],AGCGAINTABLE[61],AGCGAINTABLE[60]};
        end

       // Disable coverage on the default state because it cannot be reached.
        // pragma coverage block = off 
        default :
          regbus_rdata      = 32'b0;
        // pragma coverage block = on 
      endcase
    end
  end 
endmodule
`default_nettype wire
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

