//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 14955 $
// $Date: 2014-05-16 19:15:38 +0200 (Fri, 16 May 2014) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Karst Controller Arbiter module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module KarstCtrlArbiter(
  /* system */
  input  wire        clk,
  input  wire        rst_n,
  
  /* request A*/
  input  wire        a_start,
  
  /* request B*/
  input  wire        b_start,
  
  /* request C*/
  input  wire        c_start,
  
  /* request D*/
  input  wire        d_start,
  
  /* done */
  input  wire        done,
  
  /* mux command */
  output reg         a_mux_en,
  output reg         b_mux_en,
  output reg         c_mux_en,
  output reg         d_mux_en
  );

  /*****************************************************************************
  * 
  *****************************************************************************/
  reg   state;

  /*****************************************************************************
  * 
  *****************************************************************************/
  always @(posedge clk or negedge rst_n)
  begin
    if(rst_n==1'b0)
    begin
      a_mux_en <= 1'b0;
      b_mux_en <= 1'b0;
      c_mux_en <= 1'b0;
      d_mux_en <= 1'b0;
      state    <= 1'b0;
    end
    else
    begin
      if(state==1'b0)
      begin
      
        /* no access, wait for arbitration */
        if(a_start==1'b1)
        begin
          a_mux_en <= 1'b1;
          state    <= 1'b1;  
        end
        else if(b_start==1'b1)
        begin
          b_mux_en  <= 1'b1;  
          state     <= 1'b1;  
        end
        else if(c_start==1'b1)
        begin
          c_mux_en  <= 1'b1;  
          state     <= 1'b1;  
        end
        else if(d_start==1'b1)
        begin
          d_mux_en  <= 1'b1;  
          state     <= 1'b1;  
        end
      end
      else
      begin
      
        /* arbitration done, wait for end of access */
        if(done==1'b1)
        begin
          if(a_mux_en==1'b1 && a_start==1'b0)
          begin
            a_mux_en <= 1'b0;
            state       <= 1'b0;
          end
          if(b_mux_en==1'b1 && b_start==1'b0)
          begin
            b_mux_en  <= 1'b0;
            state       <= 1'b0;
          end
          if(c_mux_en==1'b1 && c_start==1'b0)
          begin
            c_mux_en  <= 1'b0;
            state       <= 1'b0;
          end
          if(d_mux_en==1'b1 && d_start==1'b0)
          begin
            d_mux_en  <= 1'b0;
            state       <= 1'b0;
          end
        end
      end
    end
  end

endmodule

`default_nettype wire

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
