//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: rblanc $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 10864 $
// $Date: 2013-10-16 15:39:43 +0200 (Wed, 16 Oct 2013) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : KarstCtrlReg register
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module KarstCtrlReg (
    ////////////////////////////////////////////
    //$port_g clock and reset
    ////////////////////////////////////////////
    input wire rst_n     , // Hard Reset.
    input wire clk         , // clock clock.

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g SW_CTRL register.
    input wire  START_DONEIn,// in
    input wire  START_DONEInValid,// in
    input wire [15 : 0] DATAIn,// in
    input wire  DATAInValid,// in

    //$port_g STATUS register.
    input wire [2 : 0] RC_STATE                 ,// in
    //
    //$port_g STATIC_CFG register.
    output reg [3 : 0] HW_PRESCALER  ,// out
    output reg  AUTO_TX_GAIN_EN      ,// out
    output reg  RF_FORCE_TXON        ,// out
    output reg  RF_TESTMODE          ,// out
    output reg  RF_SEL_2G4           ,// out
    output reg  SAMEANTCTRL          ,// out
    output reg  RF_RESET_N           ,// out
    //$port_g SW_CTRL register.
    output reg [3 : 0] SW_PRESCALER         ,// out
    output reg  START_DONE           ,// out
    output reg  READNOTWRITE         ,// out
    output reg [9 : 0] ADDRESS              ,// out
    output reg [15 : 0] DATA                 ,// out
    //$port_g HW_TRX0_MODE register.
    output reg [3 : 0] TX0PAMODE            ,// out
    output reg [3 : 0] TX0MODE              ,// out
    output reg [3 : 0] TX0LOMODE            ,// out
    output reg [3 : 0] RX0MODE              ,// out
    output reg [3 : 0] RX0LOMODE            ,// out
    //$port_g HW_TRX1_MODE register.
    output reg [3 : 0] TX1PAMODE            ,// out
    output reg [3 : 0] TX1MODE              ,// out
    output reg [3 : 0] TX1LOMODE            ,// out
    output reg [3 : 0] RX1MODE              ,// out
    output reg [3 : 0] RX1LOMODE            ,// out
    //$port_g HW_TX_GAIN_SPI_ADDR register.
    output reg [3 : 0] TX1GAINOFFSET        ,// out
    output reg [3 : 0] TX0GAINOFFSET        ,// out
    output reg [9 : 0] TX1GAINADDR          ,// out
    output reg [9 : 0] TX0GAINADDR          ,// out
    //$port_g HW_RX_GAIN_SPI_ADDR register.
    output reg [9 : 0] RX1GAINADDR          ,// out
    output reg [9 : 0] RX0GAINADDR          ,// out
    //$port_g HW_RX_DELAY register.
    output reg [9 : 0] RXON_2_LO_DELAY      ,// out
    output reg [9 : 0] LO_2_RXON_DELAY      ,// out
    //$port_g HW_TX_DELAY register.
    output reg [9 : 0] TXON_2_LO_DELAY      ,// out
    output reg [9 : 0] LO_2_TXON_DELAY      ,// out
    //$port_g HW_PA_DELAY register.
    output reg [9 : 0] PAOFF_DELAY          ,// out
    output reg [9 : 0] PAON_DELAY           ,// out
    //$port_g HW_RX2TX_DELAY register.
    output reg [9 : 0] RX2TXON_DELAY        ,// out
    //$port_g EXTPA_SEQ_ON_DELAY register.
    output reg [7 : 0] EXTPA1_SEQ_ON_DELAY  ,// out
    output reg [7 : 0] EXTPA0_SEQ_ON_DELAY  ,// out
    //$port_g EXTPA_SEQ_OFF_DELAY register.
    output reg [7 : 0] EXTPA1_SEQ_OFF_DELAY ,// out
    output reg [7 : 0] EXTPA0_SEQ_OFF_DELAY ,// out
    //$port_g TXSWITCH_ONOFF_DELAY register.
    output reg [9 : 0] TXSWITCH_OFF_DELAY   ,// out
    output reg [9 : 0] TXSWITCH_ON_DELAY    ,// out
    //$port_g SPI_RD_DELAY register.
    output reg [5 : 0] SPI_RD_DELAY         ,// out
    //$port_g HW_RX_AGCGAINREF register.
    output reg [6 : 0] RXAGCGAININDMAX      ,// out
    output reg [6 : 0] RXAGCGAININDMIN      ,// out

    ////////////////////////////////////////////
    //$port_g  regbus slave
    ////////////////////////////////////////////
    input  wire        regbus_sel, 
    input  wire        regbus_rden,
    input  wire        regbus_wren, 
    input  wire [ 3:0] regbus_addr, 
    input  wire [31:0] regbus_wdata,
    output reg  [31:0] regbus_rdata 
  );
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////
// Constants for registers addresses
//////////////////////////////////////////////////////////////////////////////



  // Constants for register addresses.
localparam STATIC_CFG_ADDR_CT            = 4'b000;
localparam SW_CTRL_ADDR_CT               = 4'b001;
localparam HW_TRX0_MODE_ADDR_CT          = 4'b010;
localparam HW_TRX1_MODE_ADDR_CT          = 4'b011;
localparam HW_TX_GAIN_SPI_ADDR_ADDR_CT   = 4'b100;
localparam HW_RX_GAIN_SPI_ADDR_ADDR_CT   = 4'b101;
localparam HW_RX_DELAY_ADDR_CT           = 4'b110;
localparam HW_TX_DELAY_ADDR_CT           = 4'b111;
localparam HW_PA_DELAY_ADDR_CT           = 4'b1000;
localparam HW_RX2TX_DELAY_ADDR_CT        = 4'b1001;
localparam EXTPA_SEQ_ON_DELAY_ADDR_CT    = 4'b1010;
localparam EXTPA_SEQ_OFF_DELAY_ADDR_CT   = 4'b1011;
localparam TXSWITCH_ONOFF_DELAY_ADDR_CT  = 4'b1100;
localparam SPI_RD_DELAY_ADDR_CT          = 4'b1101;
localparam STATUS_ADDR_CT                = 4'b1110;
localparam HW_RX_AGCGAINREF_ADDR_CT      = 4'b1111;



  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge clk,negedge rst_n)
  begin
    if (!rst_n) 
    begin

      // STATIC_CFG register.
      HW_PRESCALER          <= 4'b000;
      AUTO_TX_GAIN_EN       <= 1'b0;
      RF_FORCE_TXON         <= 1'b0;
      RF_TESTMODE           <= 1'b0;
      RF_SEL_2G4            <= 1'b0;
      SAMEANTCTRL           <= 1'b1;
      RF_RESET_N            <= 1'b0;
      // SW_CTRL register.
      SW_PRESCALER          <= 4'b000;
      START_DONE            <= 1'b0;
      READNOTWRITE          <= 1'b0;
      ADDRESS               <= 10'b000000000;
      DATA                  <= 16'b000000000000000;
      // HW_TRX0_MODE register.
      TX0PAMODE             <= 4'b100;
      TX0MODE               <= 4'b011;
      TX0LOMODE             <= 4'b001;
      RX0MODE               <= 4'b010;
      RX0LOMODE             <= 4'b001;
      // HW_TRX1_MODE register.
      TX1PAMODE             <= 4'b100;
      TX1MODE               <= 4'b011;
      TX1LOMODE             <= 4'b001;
      RX1MODE               <= 4'b010;
      RX1LOMODE             <= 4'b001;
      // HW_TX_GAIN_SPI_ADDR register.
      TX1GAINOFFSET         <= 4'b0000;
      TX0GAINOFFSET         <= 4'b0000;
      TX1GAINADDR           <= 10'b1001100011;
      TX0GAINADDR           <= 10'b0001100011;
      // HW_RX_GAIN_SPI_ADDR register.
      RX1GAINADDR           <= 10'b1001100000;
      RX0GAINADDR           <= 10'b001100000;
      // HW_RX_DELAY register.
      RXON_2_LO_DELAY       <= 10'b000000101;
      LO_2_RXON_DELAY       <= 10'b001010000;
      // HW_TX_DELAY register.
      TXON_2_LO_DELAY       <= 10'b000000101;
      LO_2_TXON_DELAY       <= 10'b001010000;
      // HW_PA_DELAY register.
      PAOFF_DELAY           <= 10'b000000101;
      PAON_DELAY            <= 10'b001010000;
      // HW_RX2TX_DELAY register.
      RX2TXON_DELAY         <= 10'b000000000;
      // EXTPA_SEQ_ON_DELAY register.
      EXTPA1_SEQ_ON_DELAY   <= 8'b0000000;
      EXTPA0_SEQ_ON_DELAY   <= 8'b1010000;
      // EXTPA_SEQ_OFF_DELAY register.
      EXTPA1_SEQ_OFF_DELAY  <= 8'b0000000;
      EXTPA0_SEQ_OFF_DELAY  <= 8'b0001000;
      // TXSWITCH_ONOFF_DELAY register.
      TXSWITCH_OFF_DELAY    <= 10'b010100000;
      TXSWITCH_ON_DELAY     <= 10'b000000000;
      // SPI_RD_DELAY register.
      SPI_RD_DELAY          <= 6'b011010;
      // HW_RX_AGCGAINREF register.
      RXAGCGAININDMAX       <= 7'b1000010;
      RXAGCGAININDMIN       <= 7'b000011;
    end

    else
    begin
      if (START_DONEInValid)
        START_DONE            <= START_DONEIn;
     
      if (DATAInValid)
        DATA                  <= DATAIn;
      
      if(regbus_sel && regbus_wren)
      begin

        case(regbus_addr)

          //Write STATIC_CFG register.
          STATIC_CFG_ADDR_CT : begin
            HW_PRESCALER          <= regbus_wdata[31 : 28];
            AUTO_TX_GAIN_EN       <= regbus_wdata[24];
            RF_FORCE_TXON         <= regbus_wdata[20];
            RF_TESTMODE           <= regbus_wdata[16];
            RF_SEL_2G4            <= regbus_wdata[8];
            SAMEANTCTRL           <= regbus_wdata[4];
            RF_RESET_N            <= regbus_wdata[0];
          end

          //Write SW_CTRL register.
          SW_CTRL_ADDR_CT : begin
            if (START_DONE==1'b0)
            begin
              /* not request on-going, otherwise ignore access */
              SW_PRESCALER          <= regbus_wdata[31 : 28];
              START_DONE            <= regbus_wdata[27];
              READNOTWRITE          <= regbus_wdata[26];
              ADDRESS               <= regbus_wdata[25 : 16];
              DATA                  <= regbus_wdata[15 : 0];
            end
          end

          //Write HW_TRX0_MODE register.
          HW_TRX0_MODE_ADDR_CT : begin
            TX0PAMODE             <= regbus_wdata[19 : 16];
            TX0MODE               <= regbus_wdata[15 : 12];
            TX0LOMODE             <= regbus_wdata[11 : 8];
            RX0MODE               <= regbus_wdata[7 : 4];
            RX0LOMODE             <= regbus_wdata[3 : 0];
          end

          //Write HW_TRX1_MODE register.
          HW_TRX1_MODE_ADDR_CT : begin
            TX1PAMODE             <= regbus_wdata[19 : 16];
            TX1MODE               <= regbus_wdata[15 : 12];
            TX1LOMODE             <= regbus_wdata[11 : 8];
            RX1MODE               <= regbus_wdata[7 : 4];
            RX1LOMODE             <= regbus_wdata[3 : 0];
          end

          //Write HW_TX_GAIN_SPI_ADDR register.
          HW_TX_GAIN_SPI_ADDR_ADDR_CT : begin
            TX1GAINOFFSET         <= regbus_wdata[31 : 28];
            TX0GAINOFFSET         <= regbus_wdata[27 : 24];
            TX1GAINADDR           <= regbus_wdata[21 : 12];
            TX0GAINADDR           <= regbus_wdata[9 : 0];
          end

          //Write HW_RX_GAIN_SPI_ADDR register.
          HW_RX_GAIN_SPI_ADDR_ADDR_CT : begin
            RX1GAINADDR           <= regbus_wdata[21 : 12];
            RX0GAINADDR           <= regbus_wdata[9 : 0];
          end

          //Write HW_RX_DELAY register.
          HW_RX_DELAY_ADDR_CT : begin
            RXON_2_LO_DELAY       <= regbus_wdata[25 : 16];
            LO_2_RXON_DELAY       <= regbus_wdata[9 : 0];
          end

          //Write HW_TX_DELAY register.
          HW_TX_DELAY_ADDR_CT : begin
            TXON_2_LO_DELAY       <= regbus_wdata[25 : 16];
            LO_2_TXON_DELAY       <= regbus_wdata[9 : 0];
          end

          //Write HW_PA_DELAY register.
          HW_PA_DELAY_ADDR_CT : begin
            PAOFF_DELAY           <= regbus_wdata[25 : 16];
            PAON_DELAY            <= regbus_wdata[9 : 0];
          end

          //Write HW_RX2TX_DELAY register.
          HW_RX2TX_DELAY_ADDR_CT : begin
            RX2TXON_DELAY         <= regbus_wdata[9 : 0];
          end

          //Write EXTPA_SEQ_ON_DELAY register.
          EXTPA_SEQ_ON_DELAY_ADDR_CT : begin
            EXTPA1_SEQ_ON_DELAY   <= regbus_wdata[15 : 8];
            EXTPA0_SEQ_ON_DELAY   <= regbus_wdata[7 : 0];
          end

          //Write EXTPA_SEQ_OFF_DELAY register.
          EXTPA_SEQ_OFF_DELAY_ADDR_CT : begin
            EXTPA1_SEQ_OFF_DELAY  <= regbus_wdata[15 : 8];
            EXTPA0_SEQ_OFF_DELAY  <= regbus_wdata[7 : 0];
          end

          //Write TXSWITCH_ONOFF_DELAY register.
          TXSWITCH_ONOFF_DELAY_ADDR_CT : begin
            TXSWITCH_OFF_DELAY    <= regbus_wdata[25 : 16];
            TXSWITCH_ON_DELAY     <= regbus_wdata[9 : 0];
          end

          //Write SPI_RD_DELAY register.
          SPI_RD_DELAY_ADDR_CT : begin
            SPI_RD_DELAY          <= regbus_wdata[5 : 0];
          end

          //Write HW_RX_AGCGAINREF register.
          HW_RX_AGCGAINREF_ADDR_CT : begin
            RXAGCGAININDMAX       <= regbus_wdata[22 : 16];
            RXAGCGAININDMIN       <= regbus_wdata[6 : 0];
          end


          
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : begin

          end
          // pragma coverage block = on 
        endcase
      end
      else begin

      end
    end
  end
        
  //////////////////////////////////////////////////////////////////////////////
  // Registers read
  //////////////////////////////////////////////////////////////////////////////
  //Read_p: 
  
  always @(*)
  begin

    regbus_rdata      = 32'b0;
    // Test only psel to detect first cycle of the two-cycles APB read access.
    if(regbus_sel && regbus_rden)
    begin
      case(regbus_addr)
        //Read STATIC_CFG register.
        STATIC_CFG_ADDR_CT : begin
          regbus_rdata[31 : 28]       = HW_PRESCALER;
          regbus_rdata[24]            = AUTO_TX_GAIN_EN;
          regbus_rdata[20]            = RF_FORCE_TXON;
          regbus_rdata[16]            = RF_TESTMODE;
          regbus_rdata[8]             = RF_SEL_2G4;
          regbus_rdata[4]             = SAMEANTCTRL;
          regbus_rdata[0]             = RF_RESET_N;
        end

        //Read SW_CTRL register.
        SW_CTRL_ADDR_CT : begin
          regbus_rdata[31 : 28]       = SW_PRESCALER;
          regbus_rdata[27]            = START_DONE;
          regbus_rdata[26]            = READNOTWRITE;
          regbus_rdata[25 : 16]       = ADDRESS;
          regbus_rdata[15 : 0]        = DATA;
        end

        //Read HW_TRX0_MODE register.
        HW_TRX0_MODE_ADDR_CT : begin
          regbus_rdata[19 : 16]       = TX0PAMODE;
          regbus_rdata[15 : 12]       = TX0MODE;
          regbus_rdata[11 : 8]        = TX0LOMODE;
          regbus_rdata[7 : 4]         = RX0MODE;
          regbus_rdata[3 : 0]         = RX0LOMODE;
        end

        //Read HW_TRX1_MODE register.
        HW_TRX1_MODE_ADDR_CT : begin
          regbus_rdata[19 : 16]       = TX1PAMODE;
          regbus_rdata[15 : 12]       = TX1MODE;
          regbus_rdata[11 : 8]        = TX1LOMODE;
          regbus_rdata[7 : 4]         = RX1MODE;
          regbus_rdata[3 : 0]         = RX1LOMODE;
        end

        //Read HW_TX_GAIN_SPI_ADDR register.
        HW_TX_GAIN_SPI_ADDR_ADDR_CT : begin
          regbus_rdata[31 : 28]       = TX1GAINOFFSET;
          regbus_rdata[27 : 24]       = TX0GAINOFFSET;
          regbus_rdata[21 : 12]       = TX1GAINADDR;
          regbus_rdata[9 : 0]         = TX0GAINADDR;
        end

        //Read HW_RX_GAIN_SPI_ADDR register.
        HW_RX_GAIN_SPI_ADDR_ADDR_CT : begin
          regbus_rdata[21 : 12]       = RX1GAINADDR;
          regbus_rdata[9 : 0]         = RX0GAINADDR;
        end

        //Read HW_RX_DELAY register.
        HW_RX_DELAY_ADDR_CT : begin
          regbus_rdata[25 : 16]       = RXON_2_LO_DELAY;
          regbus_rdata[9 : 0]         = LO_2_RXON_DELAY;
        end

        //Read HW_TX_DELAY register.
        HW_TX_DELAY_ADDR_CT : begin
          regbus_rdata[25 : 16]       = TXON_2_LO_DELAY;
          regbus_rdata[9 : 0]         = LO_2_TXON_DELAY;
        end

        //Read HW_PA_DELAY register.
        HW_PA_DELAY_ADDR_CT : begin
          regbus_rdata[25 : 16]       = PAOFF_DELAY;
          regbus_rdata[9 : 0]         = PAON_DELAY;
        end

        //Read HW_RX2TX_DELAY register.
        HW_RX2TX_DELAY_ADDR_CT : begin
          regbus_rdata[9 : 0]         = RX2TXON_DELAY;
        end

        //Read EXTPA_SEQ_ON_DELAY register.
        EXTPA_SEQ_ON_DELAY_ADDR_CT : begin
          regbus_rdata[15 : 8]        = EXTPA1_SEQ_ON_DELAY;
          regbus_rdata[7 : 0]         = EXTPA0_SEQ_ON_DELAY;
        end

        //Read EXTPA_SEQ_OFF_DELAY register.
        EXTPA_SEQ_OFF_DELAY_ADDR_CT : begin
          regbus_rdata[15 : 8]        = EXTPA1_SEQ_OFF_DELAY;
          regbus_rdata[7 : 0]         = EXTPA0_SEQ_OFF_DELAY;
        end

        //Read TXSWITCH_ONOFF_DELAY register.
        TXSWITCH_ONOFF_DELAY_ADDR_CT : begin
          regbus_rdata[25 : 16]       = TXSWITCH_OFF_DELAY;
          regbus_rdata[9 : 0]         = TXSWITCH_ON_DELAY;
        end

        //Read SPI_RD_DELAY register.
        SPI_RD_DELAY_ADDR_CT : begin
          regbus_rdata[5 : 0]         = SPI_RD_DELAY;
        end

        //Read STATUS register.
        STATUS_ADDR_CT : begin
          regbus_rdata[2 : 0]         = RC_STATE;
        end

        //Read HW_RX_AGCGAINREF register.
        HW_RX_AGCGAINREF_ADDR_CT : begin
          regbus_rdata[22 : 16]       = RXAGCGAININDMAX;
          regbus_rdata[6 : 0]         = RXAGCGAININDMIN;
        end

        // Disable coverage on the default state because it cannot be reached.
        // pragma coverage block = off 
        default :
        begin
          regbus_rdata      = 32'b0;
        end
        // pragma coverage block = on 

      endcase
    
    end
    else
      regbus_rdata = 32'b0;
  end 
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

