//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 22754 $
// $Date: 2015-11-06 15:50:14 +0100 (Fri, 06 Nov 2015) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : KarstNFGainTable register
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module KarstNFGainTable
(
    ////////////////////////////////////////////
    //$port_g clock and reset
    ////////////////////////////////////////////
    input  wire         rst_n     , // Hard Reset.
    input  wire         clk         , // clock clock.

    ////////////////////////////////////////////
    // NF GAIN Control
    ////////////////////////////////////////////

    input  wire [5 : 0] RFGain0Index,
    input  wire [5 : 0] RFGain1Index,
    output wire [5 : 0] Rx0GainNF,
    output wire [5 : 0] Rx1GainNF,

    ////////////////////////////////////////////
    //$port_g  APB slave
    ////////////////////////////////////////////
    input  wire        regbus_sel, 
    input  wire        regbus_rden,
    input  wire        regbus_wren, 
    input  wire [ 3:0] regbus_addr, 
    input  wire [31:0] regbus_wdata,
    output reg  [31:0] regbus_rdata 
    
  );
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////
// Constants for registers addresses
//////////////////////////////////////////////////////////////////////////////

// Constants for register addresses.
localparam RWNXNFGAINTABLE0_ADDR_CT  = 4'b0000;
localparam RWNXNFGAINTABLE1_ADDR_CT  = 4'b0001;
localparam RWNXNFGAINTABLE2_ADDR_CT  = 4'b0010;
localparam RWNXNFGAINTABLE3_ADDR_CT  = 4'b0011;
localparam RWNXNFGAINTABLE4_ADDR_CT  = 4'b0100;
localparam RWNXNFGAINTABLE5_ADDR_CT  = 4'b0101;
localparam RWNXNFGAINTABLE6_ADDR_CT  = 4'b0110;
localparam RWNXNFGAINTABLE7_ADDR_CT  = 4'b0111;
localparam RWNXNFGAINTABLE8_ADDR_CT  = 4'b1000;
localparam RWNXNFGAINTABLE9_ADDR_CT  = 4'b1001;
localparam RWNXNFGAINTABLE10_ADDR_CT = 4'b1010;
localparam RWNXNFGAINTABLE11_ADDR_CT = 4'b1011;
localparam RWNXNFGAINTABLE12_ADDR_CT = 4'b1100;
localparam RWNXNFGAINTABLE13_ADDR_CT = 4'b1101;
localparam RWNXNFGAINTABLE14_ADDR_CT = 4'b1110;
localparam RWNXNFGAINTABLE15_ADDR_CT = 4'b1111;


reg [5 : 0] NFGAINTABLE [63 : 0];

assign Rx0GainNF = NFGAINTABLE[RFGain0Index];
assign Rx1GainNF = NFGAINTABLE[RFGain1Index];


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge clk,negedge rst_n)
  begin
    if (!rst_n) 
    begin
      {NFGAINTABLE[3],NFGAINTABLE[2],NFGAINTABLE[1],NFGAINTABLE[0]}     <= {6'h1f,6'h1f,6'h1f,6'h1f};
      {NFGAINTABLE[7],NFGAINTABLE[6],NFGAINTABLE[5],NFGAINTABLE[4]}     <= {6'h1f,6'h1f,6'h1f,6'h1f};
      {NFGAINTABLE[11],NFGAINTABLE[10],NFGAINTABLE[9],NFGAINTABLE[8]}   <= {6'h1c,6'h1d,6'h1e,6'h1f};
      {NFGAINTABLE[15],NFGAINTABLE[14],NFGAINTABLE[13],NFGAINTABLE[12]} <= {6'h1a,6'h1b,6'h1b,6'h1c};
      {NFGAINTABLE[19],NFGAINTABLE[18],NFGAINTABLE[17],NFGAINTABLE[16]} <= {6'h17,6'h18,6'h19,6'h1a};
      {NFGAINTABLE[23],NFGAINTABLE[22],NFGAINTABLE[21],NFGAINTABLE[20]} <= {6'h14,6'h15,6'h16,6'h16};
      {NFGAINTABLE[27],NFGAINTABLE[26],NFGAINTABLE[25],NFGAINTABLE[24]} <= {6'h0f,6'h11,6'h12,6'h13};
      {NFGAINTABLE[31],NFGAINTABLE[30],NFGAINTABLE[29],NFGAINTABLE[28]} <= {6'h0b,6'h0c,6'h0c,6'h0d};
      {NFGAINTABLE[35],NFGAINTABLE[34],NFGAINTABLE[33],NFGAINTABLE[32]} <= {6'h09,6'h09,6'h0a,6'h0b};
      {NFGAINTABLE[39],NFGAINTABLE[38],NFGAINTABLE[37],NFGAINTABLE[36]} <= {6'h07,6'h07,6'h08,6'h08};
      {NFGAINTABLE[43],NFGAINTABLE[42],NFGAINTABLE[41],NFGAINTABLE[40]} <= {6'h04,6'h05,6'h05,6'h06};
      {NFGAINTABLE[47],NFGAINTABLE[46],NFGAINTABLE[45],NFGAINTABLE[44]} <= {6'h04,6'h04,6'h04,6'h04};
      {NFGAINTABLE[51],NFGAINTABLE[50],NFGAINTABLE[49],NFGAINTABLE[48]} <= {6'h04,6'h04,6'h04,6'h04};
      {NFGAINTABLE[55],NFGAINTABLE[54],NFGAINTABLE[53],NFGAINTABLE[52]} <= {6'h04,6'h04,6'h04,6'h04};
      {NFGAINTABLE[59],NFGAINTABLE[58],NFGAINTABLE[57],NFGAINTABLE[56]} <= {6'h04,6'h04,6'h04,6'h04};
      {NFGAINTABLE[63],NFGAINTABLE[62],NFGAINTABLE[61],NFGAINTABLE[60]} <= {6'h04,6'h04,6'h04,6'h04};
    end

    else
    begin
      if(regbus_sel && regbus_wren)
      begin

        case(regbus_addr)

          //Write RWNXNFGAINTABLE0 register.
          RWNXNFGAINTABLE0_ADDR_CT : begin
            {NFGAINTABLE[3],NFGAINTABLE[2],NFGAINTABLE[1],NFGAINTABLE[0]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end

          //Write RWNXNFGAINTABLE1 register.
          RWNXNFGAINTABLE1_ADDR_CT : begin
            {NFGAINTABLE[7],NFGAINTABLE[6],NFGAINTABLE[5],NFGAINTABLE[4]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end

          //Write RWNXNFGAINTABLE2 register.
          RWNXNFGAINTABLE2_ADDR_CT : begin
            {NFGAINTABLE[11],NFGAINTABLE[10],NFGAINTABLE[9],NFGAINTABLE[8]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end

          //Write RWNXNFGAINTABLE3 register.
          RWNXNFGAINTABLE3_ADDR_CT : begin
            {NFGAINTABLE[15],NFGAINTABLE[14],NFGAINTABLE[13],NFGAINTABLE[12]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE4 register.
          RWNXNFGAINTABLE4_ADDR_CT : begin
            {NFGAINTABLE[19],NFGAINTABLE[18],NFGAINTABLE[17],NFGAINTABLE[16]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE5 register.
          RWNXNFGAINTABLE5_ADDR_CT : begin
            {NFGAINTABLE[23],NFGAINTABLE[22],NFGAINTABLE[21],NFGAINTABLE[20]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE6 register.
          RWNXNFGAINTABLE6_ADDR_CT : begin
            {NFGAINTABLE[27],NFGAINTABLE[26],NFGAINTABLE[25],NFGAINTABLE[24]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE7 register.
          RWNXNFGAINTABLE7_ADDR_CT : begin
            {NFGAINTABLE[31],NFGAINTABLE[30],NFGAINTABLE[29],NFGAINTABLE[28]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE8 register.
          RWNXNFGAINTABLE8_ADDR_CT : begin
            {NFGAINTABLE[35],NFGAINTABLE[34],NFGAINTABLE[33],NFGAINTABLE[32]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE9 register.
          RWNXNFGAINTABLE9_ADDR_CT : begin
            {NFGAINTABLE[39],NFGAINTABLE[38],NFGAINTABLE[37],NFGAINTABLE[36]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE10 register.
          RWNXNFGAINTABLE10_ADDR_CT : begin
            {NFGAINTABLE[43],NFGAINTABLE[42],NFGAINTABLE[41],NFGAINTABLE[40]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE11 register.
          RWNXNFGAINTABLE11_ADDR_CT : begin
            {NFGAINTABLE[47],NFGAINTABLE[46],NFGAINTABLE[45],NFGAINTABLE[44]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE12 register.
          RWNXNFGAINTABLE12_ADDR_CT : begin
            {NFGAINTABLE[51],NFGAINTABLE[50],NFGAINTABLE[49],NFGAINTABLE[48]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE13 register.
          RWNXNFGAINTABLE13_ADDR_CT : begin
            {NFGAINTABLE[55],NFGAINTABLE[54],NFGAINTABLE[53],NFGAINTABLE[52]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE14 register.
          RWNXNFGAINTABLE14_ADDR_CT : begin
            {NFGAINTABLE[59],NFGAINTABLE[58],NFGAINTABLE[57],NFGAINTABLE[56]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          //Write RWNXNFGAINTABLE15 register.
          RWNXNFGAINTABLE15_ADDR_CT : begin
            {NFGAINTABLE[63],NFGAINTABLE[62],NFGAINTABLE[61],NFGAINTABLE[60]} <= {regbus_wdata[29:24],regbus_wdata[21:16],regbus_wdata[13:8],regbus_wdata[5:0]};
          end
          
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : begin

          end
          // pragma coverage block = on 
        endcase
      end
    end
  end
        
  //////////////////////////////////////////////////////////////////////////////
  // Registers read
  //////////////////////////////////////////////////////////////////////////////
  
  //Read_p: 
  always @(*)
  begin
    regbus_rdata      = 32'b0;
    // Test only psel to detect first cycle of the two-cycles APB read access.
    if (regbus_sel && regbus_rden)
    begin
      case(regbus_addr)

        //Read RWNXNFGAINTABLE0 register.
        RWNXNFGAINTABLE0_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[3],2'b0,NFGAINTABLE[2],2'b0,NFGAINTABLE[1],2'b0,NFGAINTABLE[0]};
        end
    
        //Read RWNXNFGAINTABLE1 register.
        RWNXNFGAINTABLE1_ADDR_CT : begin
          regbus_rdata[31 : 0]        = {2'b0,NFGAINTABLE[7],2'b0,NFGAINTABLE[6],2'b0,NFGAINTABLE[5],2'b0,NFGAINTABLE[4]};
        end

        //Read RWNXNFGAINTABLE2 register.
        RWNXNFGAINTABLE2_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[11],2'b0,NFGAINTABLE[10],2'b0,NFGAINTABLE[9],2'b0,NFGAINTABLE[8]};
        end

        //Read RWNXNFGAINTABLE3 register.
        RWNXNFGAINTABLE3_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[15],2'b0,NFGAINTABLE[14],2'b0,NFGAINTABLE[13],2'b0,NFGAINTABLE[12]};
        end
        
        //Read RWNXNFGAINTABLE4 register.
        RWNXNFGAINTABLE4_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[19],2'b0,NFGAINTABLE[18],2'b0,NFGAINTABLE[17],2'b0,NFGAINTABLE[16]};
        end

        //Read RWNXNFGAINTABLE5 register.
        RWNXNFGAINTABLE5_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[23],2'b0,NFGAINTABLE[22],2'b0,NFGAINTABLE[21],2'b0,NFGAINTABLE[20]};
        end
 
        //Read RWNXNFGAINTABLE6 register.
        RWNXNFGAINTABLE6_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[27],2'b0,NFGAINTABLE[26],2'b0,NFGAINTABLE[25],2'b0,NFGAINTABLE[24]};
        end

        //Read RWNXNFGAINTABLE7 register.
        RWNXNFGAINTABLE7_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[31],2'b0,NFGAINTABLE[30],2'b0,NFGAINTABLE[29],2'b0,NFGAINTABLE[28]};
        end

        //Read RWNXNFGAINTABLE8 register.
        RWNXNFGAINTABLE8_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[35],2'b0,NFGAINTABLE[34],2'b0,NFGAINTABLE[33],2'b0,NFGAINTABLE[32]};
        end
 
        //Read RWNXNFGAINTABLE9 register.
        RWNXNFGAINTABLE9_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[39],2'b0,NFGAINTABLE[38],2'b0,NFGAINTABLE[37],2'b0,NFGAINTABLE[36]};
        end
      
        //Read RWNXNFGAINTABLE10 register.
        RWNXNFGAINTABLE10_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[43],2'b0,NFGAINTABLE[42],2'b0,NFGAINTABLE[41],2'b0,NFGAINTABLE[40]};
        end
      
        //Read RWNXNFGAINTABLE11 register.
        RWNXNFGAINTABLE11_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[47],2'b0,NFGAINTABLE[46],2'b0,NFGAINTABLE[45],2'b0,NFGAINTABLE[44]};
        end
      
        //Read RWNXNFGAINTABLE12 register.
        RWNXNFGAINTABLE12_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[51],2'b0,NFGAINTABLE[50],2'b0,NFGAINTABLE[49],2'b0,NFGAINTABLE[48]};
        end
      
        //Read RWNXNFGAINTABLE13 register.
        RWNXNFGAINTABLE13_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[55],2'b0,NFGAINTABLE[54],2'b0,NFGAINTABLE[53],2'b0,NFGAINTABLE[52]};
        end
      
        //Read RWNXNFGAINTABLE14 register.
        RWNXNFGAINTABLE14_ADDR_CT : begin
          regbus_rdata[31 : 0]        =  {2'b0,NFGAINTABLE[59],2'b0,NFGAINTABLE[58],2'b0,NFGAINTABLE[57],2'b0,NFGAINTABLE[56]};
        end
      
        //Read RWNXNFGAINTABLE15 register.
        RWNXNFGAINTABLE15_ADDR_CT : begin
          regbus_rdata[31 : 0]        = {2'b0,NFGAINTABLE[63],2'b0,NFGAINTABLE[62],2'b0,NFGAINTABLE[61],2'b0,NFGAINTABLE[60]};
        end

       // Disable coverage on the default state because it cannot be reached.
        // pragma coverage block = off 
        default :
          regbus_rdata      = 32'b0;
        // pragma coverage block = on 
      endcase
    end
  end 
endmodule
`default_nettype wire
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

