//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 15388 $
// $Date: 2014-06-24 18:55:38 +0200 (Tue, 24 Jun 2014) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of KarstCtrl module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rc_karstTop
( 
  /*******************************************************************
  * Asynchronous Resets
  *******************************************************************/  
  input  wire        nRCRst,  
  input  wire        nRegBusRst,
  
  /*******************************************************************
  * Clocks
  *******************************************************************/
  input  wire        RCClk,
  input  wire        RegBusClk,

   /*******************************************************************
  * Interrupts
  *******************************************************************/
  output wire        RCRxEndP,
  output wire        RCTxEndP,
  
  /*****************************************************************************
  * RegBus interface
  *****************************************************************************/
  input  wire        RegBusSel,
  input  wire        RegBusRdEn,
  input  wire        RegBusWrEn,
  input  wire [5:0]  RegBusAddr,
  input  wire [31:0] RegBusWrData,
  output wire [31:0] RegBusRdData,
  
  /*******************************************************************
  * Modem interface
  *******************************************************************/
  input  wire        RCTxOn,
  output wire        RCTxAck,

  input  wire [5:0]  RCTxGain0,
`ifdef RW_NX_DERIV_FE_PATH1
   input  wire [5:0]  RCTxGain1,
`endif

  input  wire [1:0]  RCAntennaSet,
  
  input  wire        RCRxOn,
  output wire        RCRxAck,

  input  wire        RCProgRF,
  output wire        RCProgRFDone,

  input  wire        AGCRFGainCompReq,
  output wire        AGCRFGainCompDone,
  
  input  wire [7:0]  AGCGainTgt0,
  output wire [7:0]  RFGain0dB, 
`ifdef RW_NX_AGC_SNR_EN
  output wire [5:0]  RFGainNF0dB, 
`endif // RW_NX_AGC_SNR_EN
`ifdef RW_NX_DERIV_FE_PATH1
  input  wire [7:0]  AGCGainTgt1,
  output wire [7:0]  RFGain1dB, 
`ifdef RW_NX_AGC_SNR_EN
  output wire [5:0]  RFGainNF1dB, 
`endif // RW_NX_AGC_SNR_EN
`endif

  // Register Interface

  
 /*******************************************************************
  * RF interface
  *******************************************************************/
  /* SPI interface */
  input  wire        RFSpiMiso,
  output wire        RFSpiCsn,
  output wire        RFSpiSclk,
  output wire        RFSpiMosi,
  
  /* GPIO interface */
  output wire  [7:0] RFGPIO,

  /* RF AGC Control */
  output wire        RFAGCFreeze,

  /* Force RF TX path */
  output wire        RFForceTxOn,

  /* RF Test mode */
  output wire        RFTestMode,

 /* Reset */
  output wire        RFResetn,

  /*******************************************************************
  * External interface
  *******************************************************************/
  output wire        RFADCOn,
  
  //
  output wire        RFTRXSwitch,
  output wire        RFDACOn,
  output wire        RFExtPA0On_5G9,
  output wire        RFExtPA0On_2G4,
 `ifdef RW_NX_DERIV_FE_PATH1
  output wire        RFExtPA1On_5G9,
  output wire        RFExtPA1On_2G4,
`endif

  /*******************************************************************
  * Debug port
  *******************************************************************/
  output wire [15:0] DbgKarstCtrl
  );

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire [6:0]         RegGainIndMin; 
  wire [6:0]         RegGainIndMax; 
  wire               RegBusSelGT; 
  wire               RegBusSelRC; 
  wire               RegBusSelNT; 
  wire [31:0]        RegBusRdDataGT; 
  wire [31:0]        RegBusRdDataRC; 
  wire [31:0]        RegBusRdDataNT; 
  wire [5 : 0]       Rx0GainAddr;
  wire [7 : 0]       Rx0GainOffset;
  wire [5:0]         RFGain0Index;
`ifdef RW_NX_DERIV_FE_PATH1
  wire [5 : 0]       Rx1GainAddr;
  wire [7 : 0]       Rx1GainOffset;
  wire [5:0]         RFGain1Index;
`endif

  /*****************************************************************************
  * Register bus multiplexing
  *****************************************************************************/
  assign RegBusSelRC  = RegBusSel & ~RegBusAddr[4] & ~RegBusAddr[5];
  assign RegBusSelGT  = RegBusSel &  RegBusAddr[4] & ~RegBusAddr[5];
  assign RegBusSelNT  = RegBusSel & ~RegBusAddr[4] &  RegBusAddr[5];
  assign RegBusRdData = (RegBusSelGT) ? RegBusRdDataGT :
                        (RegBusSelRC) ? RegBusRdDataRC : RegBusRdDataNT;

  /*****************************************************************************
  * Effective Gain Computation
  *****************************************************************************/
  KarstGainComp U_KarstGainComp (
   .clk               (             RCClk ),          
   .rst_n             (            nRCRst ),         
   .AGCRFGainCompReq  (  AGCRFGainCompReq ),
   .AGCRFGainCompDone ( AGCRFGainCompDone ),
   .RegGainIndMin     (     RegGainIndMin ), 
   .RegGainIndMax     (     RegGainIndMax ), 
`ifdef RW_NX_DERIV_FE_PATH1
   .AGCGainTgt1       (       AGCGainTgt1 ),
   .Rx1GainOffset     (     Rx1GainOffset ), 
   .Rx1GainAddr       (       Rx1GainAddr ),  
   .RFGain1dB         (         RFGain1dB ), 
   .RFGain1Index      (      RFGain1Index ), 
`else
   .AGCGainTgt1       (              8'b0 ),
   .Rx1GainOffset     (              8'b0 ), 
   .Rx1GainAddr       (                   ),  
   .RFGain1dB         (                   ), 
   .RFGain1Index      (                   ), 
 `endif
   .AGCGainTgt0       (       AGCGainTgt0 ),
   .Rx0GainOffset     (     Rx0GainOffset ), 
   .Rx0GainAddr       (       Rx0GainAddr ), 
   .RFGain0dB         (         RFGain0dB ), 
   .RFGain0Index      (      RFGain0Index ) 
   
  );
            
  /*****************************************************************************
  * AGC Gain Table
  *****************************************************************************/
  KarstAGCGainTable U_KarstAGCGainTable 
  (
    .rst_n           (         nRegBusRst ), 
    .clk             (          RegBusClk ), 
    
    .Rx0GainAddr     (        Rx0GainAddr ),
    .Rx0GainOffset   (      Rx0GainOffset ),

`ifdef RW_NX_DERIV_FE_PATH1
    .Rx1GainAddr     (        Rx1GainAddr ),
    .Rx1GainOffset   (      Rx1GainOffset ),
`else
    .Rx1GainAddr     (               6'b0 ),
    .Rx1GainOffset   (                    ),
`endif
    
    .regbus_sel      (        RegBusSelGT ),
    .regbus_rden     (         RegBusRdEn ),
    .regbus_wren     (         RegBusWrEn ),
    .regbus_addr     (    RegBusAddr[3:0] ),
    .regbus_wdata    (       RegBusWrData ),
    .regbus_rdata    (     RegBusRdDataGT )
  );

  /*****************************************************************************
  * NF Gain Table
  *****************************************************************************/
`ifdef RW_NX_AGC_SNR_EN
  KarstNFGainTable U_KarstNFGainTable 
  (
    .rst_n           (         nRegBusRst ), 
    .clk             (          RegBusClk ), 
    
    .RFGain0Index    (       RFGain0Index ),
    .Rx0GainNF       (        RFGainNF0dB ),

`ifdef RW_NX_DERIV_FE_PATH1
    .RFGain1Index    (       RFGain1Index ),
    .Rx1GainNF       (        RFGainNF1dB ),
`else
    .RFGain1Index    (               6'b0 ),
    .Rx1GainNF       (                    ),
`endif
    
    .regbus_sel      (        RegBusSelNT ),
    .regbus_rden     (         RegBusRdEn ),
    .regbus_wren     (         RegBusWrEn ),
    .regbus_addr     (    RegBusAddr[3:0] ),
    .regbus_wdata    (       RegBusWrData ),
    .regbus_rdata    (     RegBusRdDataNT )
  );
`else
assign RegBusRdDataNT = 32'b0;
`endif // RW_NX_AGC_SNR_EN

  /*****************************************************************************
  * RF Controller
  *****************************************************************************/
  rc_karst U_KarstCtrl 
  (
    // resets
    .nRCRst                (        nRCRst  ),
    .nRegBusRst            (    nRegBusRst  ),
    // clocks
    .RCClk                 (         RCClk  ),
    .RegBusClk             (     RegBusClk  ),
    // Interrupts
    .RCRxEndP              (      RCRxEndP  ),
    .RCTxEndP              (      RCTxEndP  ),
    // regbus interface
    .RegBusSel             (   RegBusSelRC  ),
    .RegBusRdEn            (    RegBusRdEn  ),
    .RegBusWrEn            (    RegBusWrEn  ),
    .RegBusAddr            (RegBusAddr[3:0] ),
    .RegBusWData           (   RegBusWrData ),
    .RegBusRData           ( RegBusRdDataRC ),
    // PHY FSM interface
    .RCTxOn                (         RCTxOn ),
    .RCTxAck               (        RCTxAck ),
    .RCAntennaSet          (   RCAntennaSet ),
    .RCRxOn                (         RCRxOn ),
    .RCRxAck               (        RCRxAck ),
    // AGC interface
    .RCAGCFreeze           (           1'b1 ),
    .RCProgRFCont          (           1'b0 ),
    .RCProgRF              (       RCProgRF ),
    .RCProgForceRF         (           1'b0 ),
    .RCProgRFDone          (   RCProgRFDone ),
    .RCRxGain0             (   RFGain0Index ),
    .RCTxGain0             (      RCTxGain0 ), 
`ifdef RW_NX_DERIV_FE_PATH1
    .RCRxGain1             (   RFGain0Index ),
    .RCTxGain1             (      RCTxGain1 ),
`else
    .RCRxGain1             (           6'b0 ),
    .RCTxGain1             (           6'b0 ),
`endif
    .GainRdReq             (           2'b0 ),
    .GainRdDone            (                ),
    .RFLNAGain0            (                ),
    .RFLNAGain1            (                ),
 
    .RegGainIndMin         (  RegGainIndMin ), 
    .RegGainIndMax         (  RegGainIndMax ), 
    // RF interface
    .RFSpiMiso             (      RFSpiMiso ),     
    .RFSpiCsn              (       RFSpiCsn ),   
    .RFSpiSclk             (      RFSpiSclk ),    
    .RFSpiMosi             (      RFSpiMosi ),    
    .RFGPIO                (         RFGPIO ),
    .RFResetn              (       RFResetn ),
    .RFAGCFreeze           (    RFAGCFreeze ),
    .RFForceTxOn           (    RFForceTxOn ),   
    .RFTestMode            (     RFTestMode ),
    // External interface
    .RFDACOn               (        RFDACOn ),
    .RFADCOn               (        RFADCOn ),
    .RFTRXSwitch           (    RFTRXSwitch ),
    .RFExtPA0On_5G9        ( RFExtPA0On_5G9 ),
    .RFExtPA0On_2G4        ( RFExtPA0On_2G4 ),
`ifdef RW_NX_DERIV_FE_PATH1
    .RFExtPA1On_5G9        ( RFExtPA1On_5G9 ),
    .RFExtPA1On_2G4        ( RFExtPA1On_2G4 ),
`else
    .RFExtPA1On_5G9        (                ),
    .RFExtPA1On_2G4        (                ),
`endif
    // Debug interface
    .DbgKarstCtrl          (   DbgKarstCtrl )
  );
  
endmodule

`default_nettype wire

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
