--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : This block gives the max among the 2 inputs. It also provides
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/biggest_picker/vhdl/rtl/max_picker_2.vhd $
--/
--////////////////////////////////////////////////////////////////////////////

--              the index corresponding to the selected input :
--                if max = operande0 then index = 0
--                if max = operande1 then index = 1

library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 

--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity max_picker_2 is
  generic (
    data_length_g : integer := 16            -- Number of bits for data I/O ports.
  );
  port (
          operande0   : in  std_logic_vector (data_length_g-1 downto 0);
          operande1   : in  std_logic_vector (data_length_g-1 downto 0);

          max         : out std_logic_vector (data_length_g-1 downto 0);--Im part of out.
          index       : out std_logic
  );        
end max_picker_2;

--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture rtl of max_picker_2 is

  signal index_o   : std_logic;
  
--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin
  
  index   <= index_o;
  index_o <= '1' when (operande1 > operande0) else '0';
  max     <= operande1 when (index_o = '1') else operande0;
  
end rtl;


--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
