--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Counter with max count, enable and final count interrupt.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/commonlib/vhdl/rtl/block_pkg.vhd $
--/
--////////////////////////////////////////////////////////////////////////////

library ieee;
    use ieee.std_logic_1164.all;

--library commonlib;
library work;
--    use commonlib.slv_pkg.all;
use work.slv_pkg.all;


package block_pkg is

  component cnt_max_e_i
    generic ( depth_g        : integer := 4);
    port ( reset_n     :  in slv1;
           clk         :  in slv1;
           enable      :  in slv1;
           maxval      :  in std_logic_vector(depth_g-1 downto 0);
           termint     : out slv1;
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;


  component cnt_max_sr_e_i
    generic ( depth_g        : integer := 4);
    port ( reset_n     :  in slv1;
           clk         :  in slv1;
           sreset      :  in slv1;
           enable      :  in slv1;
           maxval      :  in std_logic_vector(depth_g-1 downto 0);
           termint     : out slv1;
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;


  component cnt_sr_e_i
    generic ( depth_g        : integer := 4);
    port ( reset_n     :  in slv1;
           clk         :  in slv1;
           sreset      :  in slv1;
           enable      :  in slv1;
           termint     : out slv1;
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;


  component cnt_sr_e
    generic ( depth_g        : integer := 4);
    port ( reset_n     :  in slv1;
           clk         :  in slv1;
           sreset      :  in slv1;
           enable      :  in slv1;
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;


  component cnt_max_min_e
    generic ( depth_g       : integer); -- Word depth
    port ( reset_n     : in slv1;  -- active low reset
           clk         : in slv1;  -- clock
           enable      : in slv1;  -- count enable
           minval      : in std_logic_vector(depth_g-1 downto 0);
           maxval      : in std_logic_vector(depth_g-1 downto 0);
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;

  component cnt_max_pl_e_i
    generic ( depth_g        : integer := 4);
    port ( reset_n     :  in slv1;
           clk         :  in slv1;
           enable      :  in slv1;
           load_enable :  in slv1;
           load_data   :  in std_logic_vector(depth_g-1 downto 0);
           maxval      :  in std_logic_vector(depth_g-1 downto 0);
           termint     : out slv1;
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;

  component dec_sr_e_i
    generic ( depth_g        : integer := 4);
    port ( reset_n     :  in slv1;
           clk         :  in slv1;
           sreset      :  in slv1;
           enable      :  in slv1;
           maxval      :  in std_logic_vector(depth_g-1 downto 0);
           termint     : out slv1;
           q           : out std_logic_vector(depth_g-1 downto 0)
         );
  end component;

  component ones_cnt
    generic ( depthin_g     : integer;
              depthout_g    : integer); -- Word depth
    port( vector_in    : in std_logic_vector(depthin_g-1 downto 0);
          ones_out     : out std_logic_vector(depthout_g-1 downto 0)
         );
  end component;


end block_pkg;

