--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Counter with min and max count, enable and final count interrupt.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/commonlib/vhdl/rtl/cnt_max_min_e.vhd $
--/
--////////////////////////////////////////////////////////////////////////////

library ieee;
    use ieee.std_logic_1164.all;
    use ieee.std_logic_unsigned.all;
    use ieee.std_logic_arith.all;

--library commonlib;
library work;
--    use commonlib.slv_pkg.all;
use work.slv_pkg.all;


entity cnt_max_min_e is
  generic ( depth_g        : integer := 4); -- Word depth
  port( reset_n      : in slv1;  -- active low reset
        clk          : in slv1;  -- clock
        enable       : in slv1;  -- count enable
        minval       : in std_logic_vector(depth_g-1 downto 0);
        maxval       : in std_logic_vector(depth_g-1 downto 0);
        q            : out std_logic_vector(depth_g-1 downto 0)
       );

end cnt_max_min_e;


--------------------------------------------------------------------------------
-- aRcHITecTURe decLaRaTION
--------------------------------------------------------------------------------
architecture rtl of cnt_max_min_e is


--------------------------------------------------------------------------------
-- SIGNaL decLaRaTION
--------------------------------------------------------------------------------
  signal q_o : std_logic_vector(depth_g-1 downto 0);


begin
--------------------------------------------------------------------------------
-- cONcURReNT aSSIGNMeNTS
--------------------------------------------------------------------------------

q <= q_o;
--------------------------------------------------------------------------------
-- PROceSSeS
--------------------------------------------------------------------------------

cnt : process (clk, reset_n, minval)
begin
  if reset_n = '0' then
    q_o <= (others => '0');
  elsif(clk'event and clk = '1') then
    if q_o < minval then
      q_o <= minval;
    elsif enable = '1' then
      if q_o < maxval then
        q_o <= q_o +1;
      else
        q_o <= minval;
      end if;
    end if;
  end if;
end process cnt;


end rtl;
