--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Ones counter.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/commonlib/vhdl/rtl/ones_cnt.vhd $
--/
--////////////////////////////////////////////////////////////////////////////


library ieee;
    use ieee.std_logic_1164.all;
    use ieee.std_logic_unsigned.all;
    use ieee.std_logic_arith.all;

--library commonlib;
library work;
--    use commonlib.slv_pkg.all;
use work.slv_pkg.all;


entity ones_cnt is
  generic ( depthin_g        : integer := 4;
            depthout_g       : integer := 4); -- Word depth
  port( vector_in            : in std_logic_vector(depthin_g-1 downto 0);
        ones_out             : out std_logic_vector(depthout_g-1 downto 0)
       );

end ones_cnt;


--------------------------------------------------------------------------------
-- architecture declaration
--------------------------------------------------------------------------------
architecture rtl of ones_cnt is
begin
  
  ----------------------------------------------------------------------------
  -- process
  ----------------------------------------------------------------------------
  cnt : process (vector_in)
    variable i : integer;
    variable ones_out_v   : std_logic_vector(depthout_g-1 downto 0);
  begin
    ones_out_v := (others => '0');
    for i in 0 to depthin_g-1 loop
      if vector_in(i) = '1' then
        ones_out_v := ones_out_v + '1';
      end if;
    end loop;
    ones_out <= ones_out_v;
  end process cnt;

end rtl;
