##################################################################################################
# testcases that demonstrates simulations mismatch if elabored with/without '-access +r' option
# following assignment are not performed :
#
#          -- Use temp_syn signals for Synopsys work-around.
#          temp_syn_y <= (others => y_n(datasize_g));
#          array_gen: for i in 1 to datasize_g generate
#          -- xn is always positive - MSB to add will always be 0 .
#            xn_shift_array(i)(datasize_g downto datasize_g-i+1) <= ZEROS_CT(datasize_g downto datasize_g-i+1);
# >>>>>>     xn_shift_array(i)(datasize_g-i downto 0) <=  x_n(datasize_g downto i);
#
#          --  yn_shift_array(i)(datasize_g downto datasize_g-i+1) <= (others => y_n(datasize_g));
#            yn_shift_array(i)(datasize_g downto datasize_g-i+1) <= temp_syn_y(datasize_g downto datasize_g-i+1);
# >>>>>>     yn_shift_array(i)(datasize_g-i downto 0) <=  y_n(datasize_g downto i);
#          end generate array_gen;
#
# affected IUS versions are :
#
# cadence/ius/INCISIV14.10         ok        
# cadence/ius/INCISIV14.10.12      ok
# cadence/ius/INCISIV14.10.14      ok
# cadence/ius/INCISIV14.20.006     failed
# cadence/ius/INCISIV15.10.004     failed   
# cadence/ius/INCISIV15.20.007     ok


cat <<EOF >cordic_vect_tb.v

module cordic_vect_tb;
  reg          clk;
  reg          rst_n;
   
  reg          load;
  reg   [14:0] x_in,y_in;
  wire  [13:0] angle_out;
  wire         cordic_ready;

  always
  begin
    #10 clk = 1'b1;
    #10 clk = 1'b0;
  end

  initial
  begin
    load  = 1'b0;
    x_in  = 15'b0;
    y_in  = 15'b0;
    rst_n = 1'b0;
    # 500;
    @(posedge clk);
    rst_n <= 1'b1;
    
    @(posedge clk);
    while(cordic_ready!=1'b1) @(posedge clk);
    
    \$write("result = 'h%h\n",angle_out);
    if(angle_out==14'h1bdb)
      \$write("PASSED\n");
    else
      \$write("FAILED\n");
    
    \$stop();
  end

  cordic_vect
  #(
      .datasize_g(     15),
      .errorsize_g(    14),
      .scaling_g(      0)
  )
  u_dut
  (
    .clk(          clk),              
    .reset_n(      rst_n),   
    .load(         load), 
    .x_in(         x_in),
    .y_in(         y_in),        
    .angle_out(    angle_out),   
    .cordic_ready( cordic_ready)
  );

endmodule


EOF

echo "INCLUDE $CDS_INST_DIR/tools.lnx86/inca/files/cds.lib" > cds.lib
echo "DEFINE worklib ./lib" >> cds.lib
touch hdl.var

rm -rf ./lib
mkdir -p ./lib


ncvhdl -64 -work worklib ../vhdl/rtl/cordic_vect_pkg.vhd
ncvhdl -64 -work worklib ../vhdl/rtl/arctan_lut.vhd
ncvhdl -64 -work worklib ../vhdl/rtl/cordic_vect.vhd
ncvlog -64 -work worklib ./cordic_vect_tb.v


echo "set assert_1164_warnings no" > simu_run
echo "database -open failed -into failed.shm -default" >> simu_run
echo "probe -create -shm cordic_vect_tb -all -variables -tasks -functions -ports -depth all -database failed -waveform" >> simu_run
echo "run" >> simu_run
echo "exit" >> simu_run
ncelab -64 -access +r cordic_vect_tb
ncsim -64 -batch -input ./simu_run cordic_vect_tb


echo "set assert_1164_warnings no" > simu_run
echo "database -open passed -into passed.shm -default" >> simu_run
echo "probe -create -shm cordic_vect_tb -all -variables -tasks -functions -ports -depth all -database passed -waveform" >> simu_run
echo "run" >> simu_run
echo "exit" >> simu_run
ncelab -64 -access +rwc cordic_vect_tb
ncsim -64 -batch -input ./simu_run cordic_vect_tb
