--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Look-up table for arctan(2^-i) values.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/cordic_vect/vhdl/rtl/arctan_lut.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 
use ieee.std_logic_unsigned.all;
 
--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity arctan_lut is
  generic (
    dsize_g       : integer := 32;                    -- max value = 32.
    scaling_g     : integer := 0   -- 1:Use all the amplitude (pi/2 = 2^errosize_g=~ 01111....) 
  );                               -- (-pi/2 = -2^errosize_g= 100000....) 
  port (
    index   : in  std_logic_vector(4 downto 0); -- i value.
    arctan  : out std_logic_vector(dsize_g-1 downto 0)
  );
 

end arctan_lut;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of arctan_lut is

  ------------------------------------------------------------------------------
  -- Signals
  ------------------------------------------------------------------------------
  signal arctan_int : std_logic_vector(31 downto 0); -- Keeps the dsize_g MSBs.

--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin
  -- returns arctan(2^-index) * 2^32.
  arctan <= arctan_int(31 downto 31-dsize_g+1);

  -----------------------------------------------------------------------------
  -- NO SCALING
  -----------------------------------------------------------------------------
  no_scaling_gen: if scaling_g = 0 generate
  with conv_integer(index) select
    arctan_int <= 
      "11001001000011111101101010100010" when 0, -- 2^32 * arctan(2^-0)
      "01110110101100011001110000010110" when 1, -- 2^32 * arctan(2^-1)
      "00111110101101101110101111110010" when 2, -- 2^32 * arctan(2^-2)
      "00011111110101011011101010011011" when 3, -- 2^32 * arctan(2^-3)
      "00001111111110101010110111011100" when 4, -- 2^32 * arctan(2^-4)
      "00000111111111110101010101101111" when 5, -- 2^32 * arctan(2^-5)
      "00000011111111111110101010101011" when 6, -- ...                
      "00000001111111111111110101010101" when 7,                       
      "00000000111111111111111110101011" when 8,                       
      "00000000011111111111111111110101" when 9,                       
      "00000000001111111111111111111111" when 10,                      
      "00000000001000000000000000000000" when 11,                      
      "00000000000100000000000000000000" when 12,                      
      "00000000000010000000000000000000" when 13,                      
      "00000000000001000000000000000000" when 14,                      
      "00000000000000100000000000000000" when 15,                      
      "00000000000000010000000000000000" when 16,                      
      "00000000000000001000000000000000" when 17,                      
      "00000000000000000100000000000000" when 18,                      
      "00000000000000000010000000000000" when 19,                      
      "00000000000000000001000000000000" when 20,                      
      "00000000000000000000100000000000" when 21,                      
      "00000000000000000000010000000000" when 22,                      
      "00000000000000000000001000000000" when 23,                      
      "00000000000000000000000100000000" when 24,                      
      "00000000000000000000000010000000" when 25,                      
      "00000000000000000000000001000000" when 26,                      
      "00000000000000000000000000100000" when 27,                      
      "00000000000000000000000000010000" when 28,                      
      "00000000000000000000000000001000" when 29,                      
      "00000000000000000000000000000100" when 30,                      
      "00000000000000000000000000000010" when 31,                      
      "00000000000000000000000000000001" when others;                  
    
  end generate no_scaling_gen;

  -----------------------------------------------------------------------------
  -- SCALING = pi/4 => 111111111111111  
  -----------------------------------------------------------------------------
  scaling_gen: if scaling_g = 1 generate
  with conv_integer(index) select
    arctan_int <= 
      "11111111111111111111111111111111" when 0, -- 2^32 * arctan(2^-0)*4/pi 
      "10010111001000000010100011101101" when 1, -- 2^32 * arctan(2^-1)*4/pi 
      "01001111110110011100001011011011" when 2, -- 2^32 * arctan(2^-2)*4/pi 
      "00101000100010001000111010100001" when 3, -- 2^32 * arctan(2^-3)*4/pi 
      "00010100010110000110101000011000" when 4, -- 2^32 * arctan(2^-4)*4/pi 
      "00001010001011101011111100001011" when 5, -- 2^32 * arctan(2^-5)*4/pi 
      "00000101000101111011000011110011" when 6, -- ...                
      "00000010100010111110001010101001" when 7,                       
      "00000001010001011111001010011010" when 8,                       
      "00000000101000101111100101110110" when 9,                       
      "00000000010100010111110011000000" when 10,                      
      "00000000001010001011111001100001" when 11,                      
      "00000000000101000101111100110000" when 12,                      
      "00000000000010100010111110011000" when 13,                      
      "00000000000001010001011111001100" when 14,                      
      "00000000000000101000101111100110" when 15,                      
      "00000000000000010100010111110011" when 16,                      
      "00000000000000001010001011111010" when 17,                      
      "00000000000000000101000101111101" when 18,                      
      "00000000000000000010100010111110" when 19,                      
      "00000000000000000001010001011111" when 20,                      
      "00000000000000000000101000110000" when 21,                      
      "00000000000000000000010100011000" when 22,                      
      "00000000000000000000001010001100" when 23,                      
      "00000000000000000000000101000110" when 24,                      
      "00000000000000000000000010100011" when 25,                      
      "00000000000000000000000001010001" when 26,                      
      "00000000000000000000000000101001" when 27,                      
      "00000000000000000000000000010100" when 28,                      
      "00000000000000000000000000001010" when 29,                      
      "00000000000000000000000000000101" when 30,                      
      "00000000000000000000000000000011" when 31,                      
      "00000000000000000000000000000001" when others;                  
    
  end generate scaling_gen;

end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
