--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : QPSK and BPSK demapping.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/demapping/vhdl/rtl/demapping.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_unsigned.all; 
 

--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity demapping is
  generic (
    dsize_g : integer := 6 -- Data size.
  );
  port (
    -- Demodulated data in
    demap_i      : in  std_logic_vector(dsize_g-1 downto 0); -- Real part.
    demap_q      : in  std_logic_vector(dsize_g-1 downto 0); -- Imaginary part.
    demod_rate   : in  std_logic; -- Demodulation rate: 0 for BPSK, 1 for QPSK.
    --
    demap_data   : out std_logic_vector(1 downto 0)
  );

end demapping;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of demapping is

  ------------------------------------------------------------------------------
  -- Signals
  ------------------------------------------------------------------------------
  signal demap_i_ext      : std_logic_vector(dsize_g downto 0);
  signal demap_q_ext      : std_logic_vector(dsize_g downto 0); 
  signal data_rot_i       : std_logic_vector(dsize_g downto 0);
  signal data_rot_q       : std_logic_vector(dsize_g downto 0); 

--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin
  
  -- Extend sign bit.
  demap_i_ext <= demap_i(dsize_g-1) & demap_i;
  demap_q_ext <= demap_q(dsize_g-1) & demap_q;
  
  -- Rotation of pi/4 = multiplication by (1+i)
  -- (a+i*b)*(1+i) = (a-b) + i*(a+b)
  data_rot_i <= demap_i_ext - demap_q_ext;
  data_rot_q <= demap_i_ext + demap_q_ext;
  
  with demod_rate select
    demap_data <=
      data_rot_q(dsize_g) & data_rot_i(dsize_g) when '1',    -- QPSK
      demap_i(dsize_g-1) & demap_i(dsize_g-1)   when others; -- BPSK
  
end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------

