--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Package for demapping.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/demapping/vhdl/rtl/demapping_pkg.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
    use IEEE.STD_LOGIC_1164.ALL; 

--------------------------------------------------------------------------------
-- Package
--------------------------------------------------------------------------------
package demapping_pkg is


--------------------------------------------------------------------------------
-- Components list declaration done by <fb> script.
--------------------------------------------------------------------------------
----------------------
-- File: demapping.vhd
----------------------
  component demapping
  generic (
    dsize_g : integer := 6 -- Data size.
  );
  port (
    -- Demodulated data in
    demap_i      : in  std_logic_vector(dsize_g-1 downto 0); -- Real part.
    demap_q      : in  std_logic_vector(dsize_g-1 downto 0); -- Imaginary part.
    demod_rate   : in  std_logic; -- Demodulation rate: 0 for BPSK, 1 for QPSK.
    --
    demap_data   : out std_logic_vector(1 downto 0)
  );

  end component;



 
end demapping_pkg;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
