--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Right shifts input data of a number of bits
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/equalizer/vhdl/rtl/beta_shift.vhd $
--/
--////////////////////////////////////////////////////////////////////////////

--               given by beta.


--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;


--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity beta_shift is
  generic (
    dsize_g : integer := 30 -- Data size
  );
  port (
    beta           : in  std_logic_vector(2 downto 0);
    data_in        : in  std_logic_vector(dsize_g-1 downto 0);
    --
    shifted_data   : out std_logic_vector(dsize_g+1 downto 0)
  );

end beta_shift;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of beta_shift is

--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin


  shift_pr: process (beta, data_in)
  begin
    case beta is     
      when "000" =>
        shifted_data <= data_in & "00";
      
      when "001" =>
        shifted_data <= sxt(data_in, dsize_g+1) & '0';

      when "010" =>
        shifted_data <= sxt(data_in, dsize_g+2);

      when "011" =>
        shifted_data <= sxt(data_in(data_in'high downto 1), dsize_g+2);
      
      when "100" =>
        shifted_data <= sxt(data_in(data_in'high downto 2), dsize_g+2);
      
      when "101" => 
        shifted_data <= sxt(data_in(data_in'high downto 3), dsize_g+2);

      when others => --"110"
        shifted_data <= sxt(data_in(data_in'high downto 4), dsize_g+2);
    end case;
    
      
  end process shift_pr;

end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------

