--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Delay line at half the clock frequency, length set by generic.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/equalizer/vhdl/rtl/delay_line2.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 
 

--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity delay_line2 is
  generic (
    dsize_g : integer := 20; -- Data size
    delay_g : integer := 49  -- Number of delay FFs (31 to 50)
  );
  port (
    -- Clock and reset
    reset_n       : in  std_logic;
    clk           : in  std_logic;
    -- 
    data_in       : in  std_logic_vector(dsize_g-1 downto 0);
    div_counter   : in  std_logic;
    -- 
    data_ff0      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff1      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff2      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff3      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff4      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff5      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff6      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff7      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff8      : out std_logic_vector(dsize_g-1 downto 0);
    data_ff9      : out std_logic_vector(dsize_g-1 downto 0);
    
    data_ff10     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff11     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff12     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff13     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff14     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff15     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff16     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff17     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff18     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff19     : out std_logic_vector(dsize_g-1 downto 0);
    
    data_ff20     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff21     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff22     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff23     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff24     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff25     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff26     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff27     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff28     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff29     : out std_logic_vector(dsize_g-1 downto 0);
    
    data_ff30     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff31     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff32     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff33     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff34     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff35     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff36     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff37     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff38     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff39     : out std_logic_vector(dsize_g-1 downto 0);
    
    data_ff40     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff41     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff42     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff43     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff44     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff45     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff46     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff47     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff48     : out std_logic_vector(dsize_g-1 downto 0);
    data_ff49     : out std_logic_vector(dsize_g-1 downto 0)
  );

end delay_line2;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of delay_line2 is

  ------------------------------------------------------------------------------
  -- Constants
  ------------------------------------------------------------------------------
  constant D_SAMPL_CT : std_logic := '1'; -- Sample when external counter high.

  ------------------------------------------------------------------------------
  -- Signals
  ------------------------------------------------------------------------------
  -- Registers for delay line
  signal data_ff0_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff1_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff2_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff3_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff4_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff5_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff6_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff7_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff8_int   : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff9_int   : std_logic_vector(dsize_g-1 downto 0);  

  signal data_ff10_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff11_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff12_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff13_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff14_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff15_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff16_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff17_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff18_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff19_int  : std_logic_vector(dsize_g-1 downto 0);  

  signal data_ff20_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff21_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff22_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff23_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff24_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff25_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff26_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff27_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff28_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff29_int  : std_logic_vector(dsize_g-1 downto 0);  

  signal data_ff30_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff31_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff32_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff33_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff34_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff35_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff36_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff37_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff38_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff39_int  : std_logic_vector(dsize_g-1 downto 0);  

  signal data_ff40_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff41_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff42_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff43_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff44_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff45_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff46_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff47_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff48_int  : std_logic_vector(dsize_g-1 downto 0);  
  signal data_ff49_int  : std_logic_vector(dsize_g-1 downto 0);  


--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin

  -- Delay line, at half the clock frequency.
  shift_pr: process (reset_n, clk)
  begin
    if reset_n = '0' then
      data_ff0_int   <= (others => '0');
      data_ff1_int   <= (others => '0');
      data_ff2_int   <= (others => '0');
      data_ff3_int   <= (others => '0');
      data_ff4_int   <= (others => '0');
      data_ff5_int   <= (others => '0');
      data_ff6_int   <= (others => '0');
      data_ff7_int   <= (others => '0');
      data_ff8_int   <= (others => '0');
      data_ff9_int   <= (others => '0');
      
      data_ff10_int  <= (others => '0');
      data_ff11_int  <= (others => '0');
      data_ff12_int  <= (others => '0');
      data_ff13_int  <= (others => '0');
      data_ff14_int  <= (others => '0');
      data_ff15_int  <= (others => '0');
      data_ff16_int  <= (others => '0');
      data_ff17_int  <= (others => '0');
      data_ff18_int  <= (others => '0');
      data_ff19_int  <= (others => '0');
      
      data_ff20_int  <= (others => '0');
      data_ff21_int  <= (others => '0');
      data_ff22_int  <= (others => '0');
      data_ff23_int  <= (others => '0');
      data_ff24_int  <= (others => '0');
      data_ff25_int  <= (others => '0');
      data_ff26_int  <= (others => '0');
      data_ff27_int  <= (others => '0');
      data_ff28_int  <= (others => '0');
      data_ff29_int  <= (others => '0');
      
      data_ff30_int  <= (others => '0');
      data_ff31_int  <= (others => '0');
      data_ff32_int  <= (others => '0');
      data_ff33_int  <= (others => '0');
      data_ff34_int  <= (others => '0');
      data_ff35_int  <= (others => '0');
      data_ff36_int  <= (others => '0');
      data_ff37_int  <= (others => '0');
      data_ff38_int  <= (others => '0');
      data_ff39_int  <= (others => '0');
      
      data_ff40_int  <= (others => '0');
      data_ff41_int  <= (others => '0');
      data_ff42_int  <= (others => '0');
      data_ff43_int  <= (others => '0');
      data_ff44_int  <= (others => '0');
      data_ff45_int  <= (others => '0');
      data_ff46_int  <= (others => '0');
      data_ff47_int  <= (others => '0');
      data_ff48_int  <= (others => '0');
      data_ff49_int  <= (others => '0');
      
    elsif clk'event and clk = '1' then
      if div_counter = D_SAMPL_CT then
        data_ff0_int  <= data_in;       -- Store new value.
        data_ff1_int  <= data_ff0_int;  -- Shift all others registers.
        data_ff2_int  <= data_ff1_int;     
        data_ff3_int  <= data_ff2_int;
        data_ff4_int  <= data_ff3_int;
        data_ff5_int  <= data_ff4_int;
        data_ff6_int  <= data_ff5_int;
        data_ff7_int  <= data_ff6_int;
        data_ff8_int  <= data_ff7_int;
        data_ff9_int  <= data_ff8_int;
                                 
        data_ff10_int  <= data_ff9_int; 
        data_ff11_int  <= data_ff10_int;
        data_ff12_int  <= data_ff11_int;
        data_ff13_int  <= data_ff12_int;
        data_ff14_int  <= data_ff13_int;
        data_ff15_int  <= data_ff14_int;
        data_ff16_int  <= data_ff15_int;
        data_ff17_int  <= data_ff16_int;
        data_ff18_int  <= data_ff17_int;
        data_ff19_int  <= data_ff18_int;
                                   
        data_ff20_int  <= data_ff19_int;
        data_ff21_int  <= data_ff20_int;
        data_ff22_int  <= data_ff21_int;
        data_ff23_int  <= data_ff22_int;
        data_ff24_int  <= data_ff23_int;
        data_ff25_int  <= data_ff24_int;
        data_ff26_int  <= data_ff25_int;
        data_ff27_int  <= data_ff26_int;
        data_ff28_int  <= data_ff27_int;
        data_ff29_int  <= data_ff28_int;
        
        data_ff30_int  <= data_ff29_int;
        data_ff31_int  <= data_ff30_int;
        data_ff32_int  <= data_ff31_int;
        data_ff33_int  <= data_ff32_int;
        data_ff34_int  <= data_ff33_int;
        data_ff35_int  <= data_ff34_int;
        data_ff36_int  <= data_ff35_int;
        data_ff37_int  <= data_ff36_int;
        data_ff38_int  <= data_ff37_int;
        data_ff39_int  <= data_ff38_int;
        
        data_ff40_int  <= data_ff39_int;
        data_ff41_int  <= data_ff40_int;
        data_ff42_int  <= data_ff41_int;
        data_ff43_int  <= data_ff42_int;
        data_ff44_int  <= data_ff43_int;
        data_ff45_int  <= data_ff44_int;
        data_ff46_int  <= data_ff45_int;
        data_ff47_int  <= data_ff46_int;
        data_ff48_int  <= data_ff47_int;
        data_ff49_int  <= data_ff48_int;
        
      end if;
    end if;
  end process shift_pr;
  
  -- Assign outputs.
  -- First 30 outputs always used.
  data_ff0  <= data_ff0_int; 
  data_ff1  <= data_ff1_int; 
  data_ff2  <= data_ff2_int; 
  data_ff3  <= data_ff3_int; 
  data_ff4  <= data_ff4_int; 
  data_ff5  <= data_ff5_int; 
  data_ff6  <= data_ff6_int; 
  data_ff7  <= data_ff7_int; 
  data_ff8  <= data_ff8_int; 
  data_ff9  <= data_ff9_int; 

  data_ff10 <= data_ff10_int;
  data_ff11 <= data_ff11_int;
  data_ff12 <= data_ff12_int;
  data_ff13 <= data_ff13_int;
  data_ff14 <= data_ff14_int;
  data_ff15 <= data_ff15_int;
  data_ff16 <= data_ff16_int;
  data_ff17 <= data_ff17_int;
  data_ff18 <= data_ff18_int;
  data_ff19 <= data_ff19_int;

  data_ff20 <= data_ff20_int;
  data_ff21 <= data_ff21_int;
  data_ff22 <= data_ff22_int;
  data_ff23 <= data_ff23_int;
  data_ff24 <= data_ff24_int;
  data_ff25 <= data_ff25_int;
  data_ff26 <= data_ff26_int;
  data_ff27 <= data_ff27_int;
  data_ff28 <= data_ff28_int;
  data_ff29 <= data_ff29_int;
  
-- Outputs 30 to 49 used following setting of delay_g
out30_gen: if delay_g > 30 generate
  data_ff30 <= data_ff30_int;
end generate out30_gen;
  
out31_gen: if delay_g > 31 generate
  data_ff31 <= data_ff31_int;
end generate out31_gen;
  
out32_gen: if delay_g > 32 generate
  data_ff32 <= data_ff32_int;
end generate out32_gen;
  
out33_gen: if delay_g > 33 generate
  data_ff33 <= data_ff33_int;
end generate out33_gen;
  
out34_gen: if delay_g > 34 generate
  data_ff34 <= data_ff34_int;
end generate out34_gen;
  
out35_gen: if delay_g > 35 generate
  data_ff35 <= data_ff35_int;
end generate out35_gen;
  
out36_gen: if delay_g > 36 generate
  data_ff36 <= data_ff36_int;
end generate out36_gen;
  
out37_gen: if delay_g > 37 generate
  data_ff37 <= data_ff37_int;
end generate out37_gen;
  
out38_gen: if delay_g > 38 generate
  data_ff38 <= data_ff38_int;
end generate out38_gen;
  
out39_gen: if delay_g > 39 generate
  data_ff39 <= data_ff39_int;
end generate out39_gen;
  
out40_gen: if delay_g > 40 generate
  data_ff40 <= data_ff40_int;
end generate out40_gen;
  
out41_gen: if delay_g > 41 generate
  data_ff41 <= data_ff41_int;
end generate out41_gen;
  
out42_gen: if delay_g > 42 generate
  data_ff42 <= data_ff42_int;
end generate out42_gen;
  
out43_gen: if delay_g > 43 generate
  data_ff43 <= data_ff43_int;
end generate out43_gen;
  
out44_gen: if delay_g > 44 generate
  data_ff44 <= data_ff44_int;
end generate out44_gen;
  
out45_gen: if delay_g > 45 generate
  data_ff45 <= data_ff45_int;
end generate out45_gen;
  
out46_gen: if delay_g > 46 generate
  data_ff46 <= data_ff46_int;
end generate out46_gen;
  
out47_gen: if delay_g > 47 generate
  data_ff47 <= data_ff47_int;
end generate out47_gen;
  
out48_gen: if delay_g > 48 generate
  data_ff48 <= data_ff48_int;
end generate out48_gen;
  
out49_gen: if delay_g > 49 generate
  data_ff49 <= data_ff49_int;
end generate out49_gen;
  
-- Set outputs to 0 when they are not used.  
out30_no_gen: if delay_g <= 30 generate
  data_ff30 <= (others => '0');
end generate out30_no_gen;
  
out31_no_gen: if delay_g <= 31 generate
  data_ff31 <= (others => '0');
end generate out31_no_gen;
  
out32_no_gen: if delay_g <= 32 generate
  data_ff32 <= (others => '0');
end generate out32_no_gen;
  
out33_no_gen: if delay_g <= 33 generate
  data_ff33 <= (others => '0');
end generate out33_no_gen;
  
out34_no_gen: if delay_g <= 34 generate
  data_ff34 <= (others => '0');
end generate out34_no_gen;
  
out35_no_gen: if delay_g <= 35 generate
  data_ff35 <= (others => '0');
end generate out35_no_gen;
  
out36_no_gen: if delay_g <= 36 generate
  data_ff36 <= (others => '0');
end generate out36_no_gen;
  
out37_no_gen: if delay_g <= 37 generate
  data_ff37 <= (others => '0');
end generate out37_no_gen;
  
out38_no_gen: if delay_g <= 38 generate
  data_ff38 <= (others => '0');
end generate out38_no_gen;
  
out39_no_gen: if delay_g <= 39 generate
  data_ff39 <= (others => '0');
end generate out39_no_gen;
  
out40_no_gen: if delay_g <= 40 generate
  data_ff40 <= (others => '0');
end generate out40_no_gen;
  
out41_no_gen: if delay_g <= 41 generate
  data_ff41 <= (others => '0');
end generate out41_no_gen;
  
out42_no_gen: if delay_g <= 42 generate
  data_ff42 <= (others => '0');
end generate out42_no_gen;
  
out43_no_gen: if delay_g <= 43 generate
  data_ff43 <= (others => '0');
end generate out43_no_gen;
  
out44_no_gen: if delay_g <= 44 generate
  data_ff44 <= (others => '0');
end generate out44_no_gen;
  
out45_no_gen: if delay_g <= 45 generate
  data_ff45 <= (others => '0');
end generate out45_no_gen;
  
out46_no_gen: if delay_g <= 46 generate
  data_ff46 <= (others => '0');
end generate out46_no_gen;
  
out47_no_gen: if delay_g <= 47 generate
  data_ff47 <= (others => '0');
end generate out47_no_gen;
  
out48_no_gen: if delay_g <= 48 generate
  data_ff48 <= (others => '0');
end generate out48_no_gen;
  
out49_no_gen: if delay_g <= 49 generate
  data_ff49 <= (others => '0');
end generate out49_no_gen;
    

end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
