--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Right shifts input data of a number of bits
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/equalizer/vhdl/rtl/eq_data_shift.vhd $
--/
--////////////////////////////////////////////////////////////////////////////

--               given in an input register.


--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 


--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity eq_data_shift is
  generic (
    dsize_g : integer := 30 -- Data size
  );
  port (
    shift_reg      : in  std_logic_vector(1 downto 0);
    data_in        : in  std_logic_vector(dsize_g-1 downto 0);
    --
    shifted_data   : out std_logic_vector(dsize_g+2 downto 0)
  );

end eq_data_shift;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of eq_data_shift is

  signal temp : std_logic_vector(2 downto 0);

--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin

  temp <= (others => data_in(dsize_g-1));

  shift_pr: process (data_in, shift_reg, temp)
  begin
    case shift_reg is
      when "00" =>
        shifted_data(dsize_g+2 downto 3) <= data_in;
        shifted_data(2 downto 0) <= (others => '0');
      
      when "01" =>
        shifted_data(dsize_g+2) <= data_in(dsize_g-1);
        shifted_data(dsize_g+1 downto 2) <= data_in;
        shifted_data(1 downto 0) <= (others => '0');
      
      when "10" =>
        shifted_data(dsize_g+2 downto dsize_g+1) <= temp (1 downto 0);
        shifted_data(dsize_g downto 1) <= data_in;
        shifted_data(0) <= '0';
      
      when others => --"11"
        shifted_data(dsize_g+2 downto dsize_g) <= temp (2 downto 0);
        shifted_data(dsize_g-1 downto 0) <= data_in;
    end case;
    
      
  end process shift_pr;

end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------

