--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Multiply conjugate of complex data by the quantized error.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/equalizer/vhdl/rtl/qerr_mult.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 
use IEEE.STD_LOGIC_UNSIGNED.ALL; 
use ieee.std_logic_arith.all;

--library equalizer_rtl;
library work;
--use equalizer_rtl.equalizer_pkg.all;
use work.equalizer_pkg.all;
 

--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity qerr_mult is
  generic (
    dsize_g : integer := 6 -- Data size
  );
  port (
    data_in_re     : in  std_logic_vector(dsize_g-1 downto 0);
    data_in_im     : in  std_logic_vector(dsize_g-1 downto 0);
    error_quant    : in  std_logic_vector(1 downto 0);
    --
    -- the addition does not need an extra extended bit (data calibrated)
    data_out_re    : out std_logic_vector(dsize_g downto 0);  
    data_out_im    : out std_logic_vector(dsize_g downto 0)
  );

end qerr_mult;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of qerr_mult is

  ------------------------------------------------------------------------------
  -- Signals
  ------------------------------------------------------------------------------
  signal add_re_in0 : std_logic_vector(dsize_g-1 downto 0);
  signal add_re_in1 : std_logic_vector(dsize_g-1 downto 0);
  signal add_im_in0 : std_logic_vector(dsize_g-1 downto 0);
  signal add_im_in1 : std_logic_vector(dsize_g-1 downto 0);


--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin
  
  -- Notation : error_quant = s0 + j*s1 where 
  --   s0 = 1 if error_quant(1) = '0' else s0 = -1
  --   s1 = 1 if error_quant(0) = '0' else s1 = -1
  -- This blocks mutiplies the conjugate of the complex input data (a + j*b)
  -- by the complex error s0 + j*s1.
  -- (s0 + j*s1)(a - j*b) = (s0*a + s1*b) + j*(-s0*b + s1*a)

  with error_quant(1) select
    add_re_in0 <=
      data_in_re when '0',
      not(data_in_re) + '1' when others;

  with error_quant(0) select
    add_re_in1 <=
      data_in_im when '0',
      not(data_in_im) + '1' when others;

  data_out_re <= (add_re_in0(add_re_in0'high) & add_re_in0)
               + (add_re_in1(add_re_in1'high) & add_re_in1);
  
  
  with error_quant(1) select
    add_im_in0 <=
      data_in_im when '1',
      not(data_in_im) + '1' when others;

  with error_quant(0) select
    add_im_in1 <=
      data_in_re when '0',
      not(data_in_re) + '1' when others;

  data_out_im <= (add_im_in0(add_im_in0'high) & add_im_in0)
               + (add_im_in1(add_im_in1'high) & add_im_in1);
              

end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
