-------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library ieee; 
use ieee.std_logic_1164.all; 
 
--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity fe11b_tx_lut_iq is
port 
(
  lut_add      : in std_logic_vector (4 downto 0);  -- address of the LUT
  fir_coef_sel : in std_logic;
  lut_out      : out std_logic_vector(27 downto 0)  -- output of the LUT
);
end fe11b_tx_lut_iq;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture rtl of fe11b_tx_lut_iq is

  signal lut_out_0    : std_logic_vector(27 downto 0);
  signal lut_out_1    : std_logic_vector(27 downto 0);

--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin

  lut_0_proc : process (lut_add)
  begin
    case lut_add is
      when "00000" =>             lut_out_0 <= "1101010110101011010011101010";
      when "00001" =>             lut_out_0 <= "1101000110100011010111101011";
      when "00010" =>             lut_out_0 <= "1000001110011011100101101101";
      when "00011" =>             lut_out_0 <= "0111111110010011101001101111";
      when "00100" =>             lut_out_0 <= "1000001001010000000000010100";
      when "00101" =>             lut_out_0 <= "0111111001001100000010010110";
      when "00110" =>             lut_out_0 <= "0011001001000100010010011000";
      when "00111" =>             lut_out_0 <= "0010110000111100010100011010";
      when "01000" =>             lut_out_0 <= "1101000110110111100101100110";
      when "01001" =>             lut_out_0 <= "1100101110110011101001101000";
      when "01010" =>             lut_out_0 <= "0111111110101011110111101010";
      when "01011" =>             lut_out_0 <= "0111101110100011111011101011";
      when "01100" =>             lut_out_0 <= "0111111001100000010010010001";
      when "01101" =>             lut_out_0 <= "0111101001011000010100010010";
      when "01110" =>             lut_out_0 <= "0010110001010100100100010101";
      when "01111" =>             lut_out_0 <= "0010100001001100100110010110";
      when "10000" =>             lut_out_0 <= "1101010110101111010111101000";
      when "10001" =>             lut_out_0 <= "1101000110100111011001101001";
      when "10010" =>             lut_out_0 <= "1000001110100011101001101100";
      when "10011" =>             lut_out_0 <= "0111111110011011101011101101";
      when "10100" =>             lut_out_0 <= "1000001001011000000010010011";
      when "10101" =>             lut_out_0 <= "0111111001010000000110010100";
      when "10110" =>             lut_out_0 <= "0011001001001000010100010110";
      when "10111" =>             lut_out_0 <= "0010110001000100011000011000";
      when "11000" =>             lut_out_0 <= "1101000110111111101001100100";
      when "11001" =>             lut_out_0 <= "1100101110110111101011100110";
      when "11010" =>             lut_out_0 <= "0111111110101111111011101000";
      when "11011" =>             lut_out_0 <= "0111101110101011111101101010";
      when "11100" =>             lut_out_0 <= "0111111001101000010100001111";
      when "11101" =>             lut_out_0 <= "0111101001100000011000010001";
      when "11110" =>             lut_out_0 <= "0010110001011000100110010011";
      when others  =>             lut_out_0 <= "0010100001010000101010010100"; --"11111"
    end case;
  end process;

  lut_1_proc : process (lut_add)
  begin
    case lut_add is
      when "00000" =>             lut_out_1 <= "0101110010000000100110100000";
      when "00001" =>             lut_out_1 <= "0110010001111000100100100001";
      when "00010" =>             lut_out_1 <= "0111011000111000010100100101";
      when "00011" =>             lut_out_1 <= "0111111000110100010010100111";
      when "00100" =>             lut_out_1 <= "0111011110101111111101101011";
      when "00101" =>             lut_out_1 <= "0111111110100111111011101100";
      when "00110" =>             lut_out_1 <= "1001001101100111101101110000";
      when "00111" =>             lut_out_1 <= "1001100101011111101011110001";
      when "01000" =>             lut_out_1 <= "0110010010010100010100001110";
      when "01001" =>             lut_out_1 <= "0110101010001100010010010000";
      when "01010" =>             lut_out_1 <= "0111111001010000000100010100";
      when "01011" =>             lut_out_1 <= "1000011001001000000010010101";
      when "01100" =>             lut_out_1 <= "0111111111000011101101011001";
      when "01101" =>             lut_out_1 <= "1000011110111011101011011011";
      when "01110" =>             lut_out_1 <= "1001100101111111011011011111";
      when "01111" =>             lut_out_1 <= "1010000101110111011001100000";
      when "10000" =>             lut_out_1 <= "0101110010000100100100011110";
      when "10001" =>             lut_out_1 <= "0110010001111100100010011111";
      when "10010" =>             lut_out_1 <= "0111011001000000010010100011";
      when "10011" =>             lut_out_1 <= "0111111000111000010000100101";
      when "10100" =>             lut_out_1 <= "0111011110110011111011101001";
      when "10101" =>             lut_out_1 <= "0111111110101011111001101010";
      when "10110" =>             lut_out_1 <= "1001001101101111101011101110";
      when "10111" =>             lut_out_1 <= "1001100101100111101001110000";
      when "11000" =>             lut_out_1 <= "0110010010011100010010001101";
      when "11001" =>             lut_out_1 <= "0110101010010100010000001110";
      when "11010" =>             lut_out_1 <= "0111111001010100000010010010";
      when "11011" =>             lut_out_1 <= "1000011001001100000000010011";
      when "11100" =>             lut_out_1 <= "0111111111000111101011010111";
      when "11101" =>             lut_out_1 <= "1000011111000011101001011001";
      when "11110" =>             lut_out_1 <= "1001100110000011011001011101";
      when others  =>             lut_out_1 <= "1010000101111011010111011110"; --"11111"
    end case;
  end process;

  lut_proc : process (fir_coef_sel,lut_out_0,lut_out_1)
  begin
    case fir_coef_sel is
      when '0'    => lut_out <= lut_out_0;
      when others => lut_out <= lut_out_1;
    end case;
  end process;

end rtl;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------

