//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of Modem80211BTop module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module modem80211b_top
( 
  /*****************************************************************************                                                     
  * resets                                                                                           
  *****************************************************************************/                                                     
  input  wire                 mpif_rst_n,                                          
  input  wire                 mdmb_rst_n,                                          
  
  /*****************************************************************************                                                     
  * clocks                                                                                           
  *****************************************************************************/                                                     
  input  wire                 mpif_clk,
  input  wire                 mdmb_clk,   
  input  wire                 mdmb_rx_gclk,
  input  wire                 mdmb_tx_gclk,

  /*****************************************************************************                                                     
  * clock enables    (mdmb_clk)                                                                                        
  *****************************************************************************/                                                     
  output wire                 rx_clken,                                                                  
  output wire                 tx_clken,                                                                  
  output wire                 clkskip,                                                                    

  /*****************************************************************************                                                     
  * parameters       (async)                                                                                    
  *****************************************************************************/                                                     
  /* config */
  input  wire                 regif_txdsssen,

  /* frontend 11b */
  input  wire                 regif_interpdisb,                                                          
  input  wire  [5:0]          regif_interpmaxstage,                                                      
  input  wire                 regif_gaindisb,                                                            
  input  wire                 regif_firdisb,                                                            
  input  wire                 regif_fircoefsel,                                                            

  /* modem 11b */                                                                     
  input  wire                 regif_iqmmdisb,                                                            
  input  wire                 regif_precompdisb,                                                         
  input  wire                 regif_dcoffdisb,                                                           
  input  wire                 regif_compdisb,                                                            
  input  wire                 regif_eqdisb,                                                              
  input  wire                 regif_spreaddisb,                                                          
  input  wire                 regif_scrambdisb,                                                          
  input  wire  [ 2:0]         regif_sfderr,                                                              
  input  wire  [ 2:0]         regif_sfdlen,                                                              
  input  wire  [ 5:0]         regif_prepre,                                                              
  input  wire  [ 1:0]         regif_rho,                                                                 
  input  wire  [ 1:0]         regif_mu,                                                                  
  input  wire  [ 1:0]         regif_beta,                                                                
  input  wire  [ 1:0]         regif_alpha,                                                               
  input  wire  [ 3:0]         regif_talpha3,                                                             
  input  wire  [ 3:0]         regif_talpha2,                                                             
  input  wire  [ 3:0]         regif_talpha1,                                                             
  input  wire  [ 3:0]         regif_talpha0,                                                             
  input  wire  [ 3:0]         regif_tbeta3,                                                              
  input  wire  [ 3:0]         regif_tbeta2,                                                              
  input  wire  [ 3:0]         regif_tbeta1,                                                              
  input  wire  [ 3:0]         regif_tbeta0,                                                              
  input  wire  [ 3:0]         regif_tmu3,                                                                
  input  wire  [ 3:0]         regif_tmu2,                                                                
  input  wire  [ 3:0]         regif_tmu1,                                                                
  input  wire  [ 3:0]         regif_tmu0,                                                                
  input  wire                 regif_rxlenchken,                                                          
  input  wire  [11:0]         regif_rxmaxlength,                                                         
  input  wire  [ 7:0]         regif_txenddel,                                                            
  input  wire  [11:0]         regif_eqhold,                                                              
  input  wire  [ 4:0]         regif_comptime,                                                            
  input  wire  [ 4:0]         regif_esttime,                                                             
  input  wire  [ 3:0]         regif_eqtime,                                                              
  input  wire  [ 5:0]         regif_precomp,                                                             
  input  wire  [ 5:0]         regif_synctime,                                                            
  input  wire  [ 3:0]         regif_looptime,                                                            
  output wire  [ 7:0]         regif_eqsumq,                                                                    
  output wire  [ 7:0]         regif_eqsumi,                                                                    
  output wire  [ 5:0]         regif_dcoffsetq,                                                                 
  output wire  [ 5:0]         regif_dcoffseti,                                                                 
  output wire  [ 6:0]         regif_iqgainestim,                                                               
  output wire  [ 7:0]         regif_freqoffestim,                                                              
  output wire  [12:0]         regif_evm,                                                                       

  /*****************************************************************************                                                     
  * Control          (mpif_clk domain)                                                                              
  *****************************************************************************/                                                     
  /* TX */
  input  wire                 tx_enable,
  input  wire                 tx_start,
  output reg                  tx_done,
  
  output reg                  mfsm_txv_update,
  output reg                  mfsm_txv_error,
  
  /* RX */
  input  wire                 rx_enable,
  output reg                  rx_endfortiming,
  
  output reg                  mfsm_rxv_update,   
  output reg  [ 1:0]          mfsm_rxv_rxerrorstat,                   
 
  /*****************************************************************************                                                     
  * Control          (mdmb domain)                                                                              
  *****************************************************************************/                                                     
  /* RX */
  output reg                  rx_sfd_found,
   
  /*****************************************************************************                                                     
  * MACIF VECTOR     (mpif_clk domain)                                                                                           
  *****************************************************************************/                                                     
  /* TX */
  input  wire                 txv_update,
  input  wire [11:0]          txv_leglength,     
  input  wire [ 3:0]          txv_legrate,       
  input  wire                 txv_pretype,       
  input  wire [15:0]          txv_service,       

  /* RX */
  output reg  [11:0]          rxv_leglength,
  output reg  [ 3:0]          rxv_legrate,
  output reg                  rxv_pretype,
  output reg  [15:0]          rxv_service,                   
  
  /*****************************************************************************                                                     
  * MACIF DATA       (mpif_clk domain)                                                                                          
  *****************************************************************************/                                                     
  /* TX */
  output wire                 macif_tx_ready,
  input  wire [7:0]           macif_tx_data,
  input  wire                 macif_tx_last,
  input  wire                 macif_tx_valid,
  
  /* RX */
  input  wire                 macif_rx_ready,
  output reg  [7:0]           macif_rx_data,
  output reg                  macif_rx_last,
  output reg                  macif_rx_valid,

  /*****************************************************************************                                                     
  * Data Frontend    (mdmb_clk domain)                                                                                               
  *****************************************************************************/                                                     
  input  wire [ 6:0]          feif_rx_i,                                           
  input  wire [ 6:0]          feif_rx_q,                                           

  output wire                 feif_tx_en,                                          
  output wire [ 6:0]          feif_tx_i,                                          
  output wire [ 6:0]          feif_tx_q,                                          
  
  /*****************************************************************************                                                     
  * Debug ports      (async)
  *****************************************************************************/                                                     
  output wire [15:0]          diag0,
  output wire [15:0]          diag1,
  output wire [15:0]          diag2
);

  /*****************************************************************************
  * 11b Frontend/Modem
  *****************************************************************************/
  /* phy resync */
  wire        txv_updated_clr;
  wire        phy_txstartend_conf;
  wire        t0_data_conf;
  wire        phy_rxstartend_ind;
  wire        phy_data_ind;
  wire        rx_endfortiming_stat;
 
  /* mdmb resync */
  wire        c44_txv_updated;
  wire        c44_txv_updated_clr_ack;
  wire        c44_tx_enable;
  wire        c44_tx_start_m1t;
  wire        c44_t0_data_req;
  wire        c44_rx_blocken;
  
  /* phy signaling */
  wire        txvector_valid;
  reg         phy_txstartend_conf_1t;
  reg         phy_rxstartend_ind_1t;
  reg         phy_data_ind_1t;
  reg  [7:0]  t0_data;
  reg         t0_data_last;
  reg         t0_data_req;
  reg  [11:0] rx_counter;
  wire [11:0] n_rx_counter;
  
  /* mdmb signaling */
  reg         c44_tx_start;
  reg         c44_txv_updated_clr;                
  reg         c44_modem_rx_init;                  
  reg         c44_rx_blocken_1t;                  
  reg         c44_powest_blocken;                 
  reg         c44_powest_update;                  
  reg  [ 9:0] c44_powest_counter;                 
  reg         c44_toest_blocken;                  
  reg         c44_rxinterp_blocken;               
  reg         c44_rxfilter_blocken;               
  reg         c44_rf_txonoff_conf;                
  reg         c44_rf_rxonoff_conf;                
  wire        c44_rx_endfortiming;                
  reg         c44_rx_endfortiming_stat;           
  reg         c44_t0_data_req_1t;                 
  reg  [ 7:0] c44_t0_data_1t;
  reg         c44_t0_data_last_1t;
  wire        c44_t0_data_conf;
  reg         c44_t0_data_conf_1t;
  
  wire        c44_modem_rx_init_n;                
  wire [12:0] c44_toest_tau;                      
  wire        c44_rxinterp_valid;                 
  wire [ 6:0] c44_rxinterp_i,c44_rxinterp_q;      
  wire        c44_rxfilt_toggle;                  
  wire [ 7:0] c44_rxfilt_i,c44_rxfilt_q;          
  wire [20:0] c44_powest_estimate;                
  wire        c44_txfilt_fir_activate;            
  wire        c44_txfilt_init_fir;                
  wire        c44_txfilt_phi_angle_tog;           
  wire [ 1:0] c44_txfilt_phi_angle;               
  wire        c44_rxgain_gain_enable;             
  wire [ 7:0] c44_rxgain_i,c44_rxgain_q;          
  wire        c44_rx_gating;                      
  wire        c44_tx_gating;                      
  wire        c44_rf_txonoff_req;                 
  wire        c44_rf_rxonoff_req;                 
  wire        c44_sfd_found;                      
  reg         c44_phy_txstartend_req;             
  wire        c44_phy_txstartend_conf;            
  reg         c44_phy_txstartend_conf_1t;
  reg  [11:0] c44_txv_length;                     
  reg  [ 7:0] c44_txv_service;                    
  reg  [ 3:0] c44_txv_datarate;                   
  reg         c44_txv_immstop;
  wire        c44_phy_rxstartend_ind;
  wire   [ 3:0]     n_c44_phy_rxstartend_sr;
  reg  [ 3:0] c44_phy_rxstartend_sr;
  reg         c44_phy_rxstartend_stat;
  wire [ 7:0] c44_rx_data;
  wire        c44_phy_data_ind;                   
  wire [11:0] c44_rxv_length;                     
  wire [ 7:0] c44_rxv_service;                    
  wire [ 3:0] c44_rxv_datarate;                   
  wire [ 1:0] c44_rxe_errorstat;
  
  // Unused signals but declared for VHDL instance
  wire        c44_phy_cca_ind;                   
  wire [15:0] c44_psdu_duration;                     
  wire        c44_correct_header;                   
  wire        c44_plcp_state;                   
  wire        c44_plcp_error;                   
  wire        c44_listen_start_o;                   
  wire        c44_symbol_sync2;                   
  wire        c44_clock_lock;                   
  wire [17:0] c44_tau_est;                     
  wire        c44_enable_error;                   
  wire        c44_symbol_sync_error_o;                   
  wire [13:0] c44_error_cart_i_o;                     
  wire [13:0] c44_error_cart_q_o;                     
  wire [15:0] c44_modem_diag;                     
  wire        c44_data_out_enable;                   

  /*****************************************************************************
  * PHY DOMAIN 
  *****************************************************************************/
  /* resynchro */
  ClkSyncSimple u_mpifclk_txvupdatedclr_resync
  ( 
    .dstclk(            mpif_clk),
    .dstresetn(         mpif_rst_n),
    .srcdata(           c44_txv_updated_clr),
    .dstdata(           txv_updated_clr)
  );

  ClkSyncSimple u_mpifclk_phytxstartendconf_resync
  ( 
    .dstclk(            mpif_clk),
    .dstresetn(         mpif_rst_n),
    .srcdata(           c44_phy_txstartend_conf_1t),
    .dstdata(           phy_txstartend_conf)
  );

  ClkSyncSimple u_mpifclk_phyrxstartendind_resync
  ( 
    .dstclk(            mpif_clk),
    .dstresetn(         mpif_rst_n),
    .srcdata(           c44_phy_rxstartend_stat),
    .dstdata(           phy_rxstartend_ind)
  );

  ClkSyncSimple u_mpifclk_dataind_resync
  ( 
    .dstclk(            mpif_clk),
    .dstresetn(         mpif_rst_n),
    .srcdata(           c44_phy_data_ind),
    .dstdata(           phy_data_ind)
  );

  ClkSyncSimple u_mpifclk_dataconf_resync
  ( 
    .dstclk(            mpif_clk),
    .dstresetn(         mpif_rst_n),
    .srcdata(           c44_t0_data_conf_1t),
    .dstdata(           t0_data_conf)
  );

  ClkSyncSimple u_mpifclk_rxendfortimingstat_resync
  ( 
    .dstclk(            mpif_clk),
    .dstresetn(         mpif_rst_n),
    .srcdata(           c44_rx_endfortiming_stat),
    .dstdata(           rx_endfortiming_stat)
  );

  always @(posedge mpif_clk, negedge mpif_rst_n)
    if(!mpif_rst_n)
    begin
      rx_endfortiming          <= 1'b0;
    end
    else
    begin
      /* rx_endfortiming */
      if(!rx_enable)
        rx_endfortiming <= 1'b0;
      else if(rx_endfortiming_stat)
        rx_endfortiming <= 1'b1;
    end
  
  /* TXVECTOR qualification */
  assign txvector_valid = ~(txv_legrate==4'd0 & txv_pretype==1'b0);
  
  always @(posedge mpif_clk, negedge mpif_rst_n)
    if(!mpif_rst_n)
    begin
      mfsm_txv_update <= 1'b0;
      mfsm_txv_error  <= 1'b0;
    end
    else if(!tx_enable)
    begin
      mfsm_txv_update <= 1'b0;
      mfsm_txv_error  <= 1'b0;
    end
    else
    begin
      /* clear resync flag */
      if(txv_updated_clr)
        mfsm_txv_update <= 1'b0;
      
      /* acknowledge txvector to macif */
      if(txv_update)
      begin
        mfsm_txv_update <= 1'b1;
        if(!txvector_valid || !regif_txdsssen)
          mfsm_txv_error <= 1'b1;
      end
    end

  /* macif tx data */
  always @(posedge mpif_clk, negedge mpif_rst_n)
    if(!mpif_rst_n)
    begin
      t0_data      <= 8'b0;
      t0_data_last <= 1'b0;
      t0_data_req  <= 1'b0;
    end
    else if(!tx_enable || !phy_txstartend_conf)
    begin
      t0_data      <= 8'b0;
      t0_data_last <= 1'b0;
      t0_data_req  <= 1'b0;
    end
    else
    begin
      if(macif_tx_ready)
      begin
        if(macif_tx_valid)
        begin
          t0_data      <= macif_tx_data;
          t0_data_last <= macif_tx_last; 
          t0_data_req  <= ~t0_data_req;
        end
      end
    end
  
  assign macif_tx_ready = phy_txstartend_conf & /* ask the macif to fetch the first bytes */
                          (t0_data_req==t0_data_conf); /* slot is free */

  /* tx normal termination */
  always @(posedge mpif_clk, negedge mpif_rst_n)
    if(!mpif_rst_n)
    begin
      tx_done <= 1'b0;
      phy_txstartend_conf_1t <= 1'b0;
    end
    else if(!tx_enable)
    begin
      tx_done                <= 1'b0;
      phy_txstartend_conf_1t <= 1'b0;
    end
    else
    begin
      tx_done                <= 1'b0;
      phy_txstartend_conf_1t <= phy_txstartend_conf;
      if(phy_txstartend_conf_1t && !phy_txstartend_conf)
        tx_done <= 1'b1;
    end
  
  /* rxvector */
  always @(posedge mpif_clk, negedge mpif_rst_n)
    if(!mpif_rst_n)
    begin
      phy_rxstartend_ind_1t <= 1'b0;
      mfsm_rxv_update       <= 1'b0;   
      mfsm_rxv_rxerrorstat  <= 2'b0;   
      rxv_leglength         <= 12'd0;
      rxv_legrate           <= 4'd0;
      rxv_pretype           <= 1'b0;  
      rxv_service           <= 16'b0;
    end
    else if(!rx_enable)
    begin
      phy_rxstartend_ind_1t <= 1'b0;
      mfsm_rxv_update       <= 1'b0;   
      mfsm_rxv_rxerrorstat  <= 2'b0;   
      rxv_leglength         <= 12'd0;
      rxv_legrate           <= 4'd0;
      rxv_pretype           <= 1'b0;  
      rxv_service           <= 16'b0;    
    end
    else
    begin
      phy_rxstartend_ind_1t <= phy_rxstartend_ind;
      if(!phy_rxstartend_ind_1t && phy_rxstartend_ind)
      begin
        mfsm_rxv_update      <= 1'b1;
        mfsm_rxv_rxerrorstat <= c44_rxe_errorstat;   
        rxv_leglength   <= c44_rxv_length;
        rxv_legrate     <= {2'b0,c44_rxv_datarate[1:0]};
        rxv_pretype     <= c44_rxv_datarate[2];
        rxv_service     <= {8'b0,c44_rxv_service};
      end
    end
  
  /* rx data */
  assign n_rx_counter = rx_counter + 12'b1;
  
  always @(posedge mpif_clk, negedge mpif_rst_n)
    if(!mpif_rst_n)
    begin
      macif_rx_data   <= 8'd0;
      macif_rx_last   <= 1'b0;
      macif_rx_valid  <= 1'b0; 
      phy_data_ind_1t <= 1'b0;
      rx_counter      <= 12'b0;
    end
    else if(!rx_enable)
    begin
      macif_rx_data   <= 8'd0;
      macif_rx_last   <= 1'b0;
      macif_rx_valid  <= 1'b0;  
      phy_data_ind_1t <= 1'b0;
      rx_counter      <= 12'b0;
    end
    else
    begin
      phy_data_ind_1t <= phy_data_ind;
      /* read/clear */
      if(macif_rx_ready && macif_rx_valid)
        macif_rx_valid <= 1'b0;
      
      /* write/set */
      if(phy_data_ind!=phy_data_ind_1t)
      begin
        macif_rx_data  <= c44_rx_data;
        macif_rx_valid <= 1'b1;
        macif_rx_last  <= n_rx_counter==rxv_leglength;
        /* note: rx_counter indicates the number of bytes pushed towards macif */
        rx_counter     <= n_rx_counter;
      end
    end
  
  /*****************************************************************************
  * MDMB DOMAIN 
  *****************************************************************************/
  /* resynchro */
  ClkSyncSimple u_mdmbclk_txvupdate_resync
  ( 
    .dstclk(            mdmb_clk),
    .dstresetn(         mdmb_rst_n),
    .srcdata(           mfsm_txv_update),
    .dstdata(           c44_txv_updated)
  );

  ClkSyncSimple u_mdmbclk_txv_updated_clr_ack_resync
  ( 
    .dstclk(            mdmb_clk),
    .dstresetn(         mdmb_rst_n),
    .srcdata(           txv_updated_clr),
    .dstdata(           c44_txv_updated_clr_ack)
  );

  ClkSyncSimple u_mdmbclk_txenable_resync
  ( 
    .dstclk(            mdmb_clk),
    .dstresetn(         mdmb_rst_n),
    .srcdata(           tx_enable),
    .dstdata(           c44_tx_enable)
  );

  ClkSyncSimple u_mdmbclk_txstart_resync
  ( 
    .dstclk(            mdmb_clk),
    .dstresetn(         mdmb_rst_n),
    .srcdata(           tx_start),
    .dstdata(           c44_tx_start_m1t)
  );

  ClkSyncSimple u_mdmbclk_t0datareq_resync
  ( 
    .dstclk(            mdmb_clk),
    .dstresetn(         mdmb_rst_n),
    .srcdata(           t0_data_req),
    .dstdata(           c44_t0_data_req)
  );

  ClkSyncSimple u_mdmbclk_rxenable_resync
  ( 
    .dstclk(            mdmb_clk),
    .dstresetn(         mdmb_rst_n),
    .srcdata(           rx_enable),
    .dstdata(           c44_rx_blocken)
  );

  always @(posedge mdmb_clk, negedge mdmb_rst_n)
    if(!mdmb_rst_n)
    begin
      c44_tx_start   <= 1'b0;     
    end
    else
    begin
      /* delay for edge detection tx_start */
      c44_tx_start  <= c44_tx_start_m1t;
    end

  /* synchro @mdmb_clk for FF to FF exchange */
  assign n_c44_phy_rxstartend_sr = {c44_phy_rxstartend_sr[2:0],c44_phy_rxstartend_ind};
  
  always @(posedge mdmb_clk, negedge mdmb_rst_n)
    if(!mdmb_rst_n)
    begin
      c44_t0_data_conf_1t        <= 1'b0;
      c44_phy_txstartend_conf_1t <= 1'b0;
      c44_phy_rxstartend_sr      <= 4'b0;
	  c44_phy_rxstartend_stat    <= 1'b0;
    end
    else
    begin
      /* c44_t0_data_conf */
      c44_t0_data_conf_1t        <= c44_t0_data_conf;
      /* c44_phy_txstartend_conf_1t */
      c44_phy_txstartend_conf_1t <= c44_phy_txstartend_conf & ~c44_txv_immstop; // do not propagate conf if abort on going */
      /* c44_phy_rxstartend_ind_1t */
      c44_phy_rxstartend_sr      <= n_c44_phy_rxstartend_sr;
	  c44_phy_rxstartend_stat    <= |n_c44_phy_rxstartend_sr;
    end
  
  /* TXVECTOR capture */
  always @(posedge mdmb_clk, negedge mdmb_rst_n)
    if(!mdmb_rst_n)
    begin
      c44_txv_length      <= 12'b0;
      c44_txv_datarate    <= 4'b0100;
      c44_txv_service     <= 8'b0;
      c44_txv_updated_clr <= 1'b0;
    end
    else if(!c44_txv_immstop)
    begin
      if(c44_txv_updated)
      begin
        c44_txv_updated_clr <= 1'b1;
        c44_txv_length      <= txv_leglength;
        c44_txv_datarate    <= {1'b0,txv_pretype,txv_legrate[1:0]};
        c44_txv_service     <= txv_service[15:8];
      end
      else if (c44_txv_updated_clr_ack)
        c44_txv_updated_clr  <= 1'b0;
    end
    else
    begin
      c44_txv_length      <= 12'b0;
      c44_txv_datarate    <= 4'b0100;
      c44_txv_service     <= 8'b0;
      if (c44_txv_updated_clr_ack)
        c44_txv_updated_clr <= 1'b0;
    end  
  
  /* c44_txstartend_req, c44_txv_immstop : start and abort */
  always @(posedge mdmb_clk, negedge mdmb_rst_n)
    if(!mdmb_rst_n)
    begin
      c44_txv_immstop        <= 1'b0;
      c44_phy_txstartend_req <= 1'b0;
    end
    else if(!c44_txv_immstop)
    begin                                                                  
      /* normal operation */                                               
      if(!c44_phy_txstartend_req)                                          
      begin                                                                
        /* waiting tx start */                                               
        if(c44_tx_start_m1t && !c44_tx_start)                                                
          c44_phy_txstartend_req <= 1'b1;                                  
      end                                                                  
      else                                                                 
      begin                                                                
        /* last byte pushed */                                             
        if((c44_t0_data_req_1t==c44_t0_data_conf_1t) && c44_t0_data_last_1t)  
          c44_phy_txstartend_req <= 1'b0;                                  
        /* abort requested */                                              
        if(!c44_tx_enable)                                                 
          c44_txv_immstop <= 1'b1;                                         
      end                                                                  
    end                                                                    
    else                                                                   
    begin                                                                  
      c44_phy_txstartend_req <= 1'b0;                                      
      /* wait de-assertion of both req and conf to leave immstop state */  
      if(!c44_phy_txstartend_req && !c44_phy_txstartend_conf_1t)              
        c44_txv_immstop        <= 1'b0;                                    
    end                                                                    
  
  /* data transfer */
  always @(posedge mdmb_clk, negedge mdmb_rst_n)
    if(!mdmb_rst_n)
    begin
      c44_t0_data_req_1t  <= 1'b0;
      c44_t0_data_1t      <= 8'b0;
      c44_t0_data_last_1t <= 1'b0;
    end
    else if(c44_txv_immstop)
    begin
      c44_t0_data_req_1t  <= 1'b0;
      c44_t0_data_1t      <= 8'b0;
      c44_t0_data_last_1t <= 1'b0;
    end  
    else
    begin
      if(c44_phy_txstartend_req)
      begin
        if(c44_t0_data_req!=c44_t0_data_req_1t)
        begin
          c44_t0_data_req_1t  <= c44_t0_data_req;
          c44_t0_data_1t      <= t0_data;
          c44_t0_data_last_1t <= t0_data_last;
        end
      end
      else
      begin
        c44_t0_data_req_1t  <= 1'b0;
        c44_t0_data_1t      <= 8'b0;
        c44_t0_data_last_1t <= 1'b0;
      end  
    end
  
  /* rx_endfortiming */
  /* convert the pulse into a level (_stat)*/
  always @(posedge mdmb_clk, negedge mdmb_rst_n)
    if(!mdmb_rst_n)
      c44_rx_endfortiming_stat <= 1'b0;
    else if(!c44_phy_rxstartend_stat)
      c44_rx_endfortiming_stat <= 1'b0;
    else if(c44_rx_endfortiming)
      c44_rx_endfortiming_stat <= 1'b1;
  
  /*****************************************************************************
  * 802.11B modem 
  *****************************************************************************/
  /* 802.11B embedded frontend control */
  always @(posedge mdmb_clk, negedge mdmb_rst_n)
  if(!mdmb_rst_n)                                                             
  begin                                                                       
     c44_modem_rx_init    <= 1'b0;                                            
     c44_powest_counter   <= 10'b0;                                           
     c44_powest_blocken   <= 1'b0;                                            
     c44_powest_update    <= 1'b0;                                            
     c44_rxinterp_blocken <= 1'b0;                                            
     c44_toest_blocken    <= 1'b0;                                            
     c44_rxfilter_blocken <= 1'b0;                                            
     c44_rx_blocken_1t    <= 1'b0;                                            
     c44_rf_txonoff_conf  <= 1'b0;                                            
     c44_rf_rxonoff_conf  <= 1'b0;                                            
     rx_sfd_found         <= 1'b0;
  end                                                                         
  else                                                                        
  begin                                                                       
    c44_rf_txonoff_conf <= c44_rf_txonoff_req;                                
    c44_rf_rxonoff_conf <= c44_rf_rxonoff_req;                                
    c44_rx_blocken_1t   <= c44_rx_blocken;                                     
    rx_sfd_found        <= c44_sfd_found;
    if(c44_rx_blocken)                                                         
    begin                                                                     
      if(!c44_rx_blocken_1t)                                                  
      begin                                                                   
        /* init for RX */                                                     
        c44_modem_rx_init    <= 1'b1;    // init pulse                        
        c44_powest_counter   <= 10'd615; // wait 14 us for power integration  
        c44_powest_blocken   <= 1'b1;                                         
        c44_powest_update    <= 1'b0;                                         
        c44_rxinterp_blocken <= 1'b0;                                         
        c44_toest_blocken    <= 1'b0;                                         
        c44_rxfilter_blocken <= 1'b0;                                         
      end                                                                     
      else                                                                    
      begin                                                                   
        c44_modem_rx_init    <= 1'b0;                                         
        c44_rxfilter_blocken <= 1'b1;                                         
        c44_rxinterp_blocken <= 1'b1;                                         
        c44_toest_blocken    <= 1'b1;                                         
        if(c44_powest_counter == 10'd0)                                       
        begin                                                                 
          if(c44_powest_update)                                               
          begin                                                               
            c44_powest_blocken   <= 1'b0;                                     
            c44_powest_update    <= 1'b0;                                     
          end                                                                 
          else                                                                
          begin                                                               
            if(c44_powest_blocken)                                            
            begin                                                             
              c44_powest_update <= 1'b1;                                      
            end                                                               
          end                                                                 
        end                                                                   
        else                                                                  
        begin                                                                 
          /* power estimation on going */                                     
          c44_powest_counter <= c44_powest_counter + {10{1'b1}};              
        end                                                                   
      end                                                                     
    end                                                                       
    else                                                                      
    begin                                                                     
     c44_modem_rx_init    <= 1'b0;                                            
     c44_powest_counter   <= 10'b0;                                           
     c44_powest_blocken   <= 1'b0;                                            
     c44_powest_update    <= 1'b0;                                            
     c44_rxinterp_blocken <= 1'b0;                                            
     c44_toest_blocken    <= 1'b0;                                            
     c44_rxfilter_blocken <= 1'b0;                                            
    end                                                                       
  end                                                                         
  
  assign c44_modem_rx_init_n = ~c44_modem_rx_init;
  assign rx_clken            = ~c44_rx_gating;
  assign tx_clken            = ~c44_tx_gating;
  
  /* modem80211b_core instance */
  modem802_11b_core u_modem802_11b_core 
  (
    /***************************************************************************
    * reset
    ***************************************************************************/
    .reset_n(                       mdmb_rst_n),
    
    /***************************************************************************
    * clocks
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .rx_path_b_gclk(                mdmb_rx_gclk),
    .tx_path_b_gclk(                mdmb_tx_gclk),
    
    /***************************************************************************
    * clock gating
    ***************************************************************************/
    .rx_gating(                     c44_rx_gating),
    .tx_gating(                     c44_tx_gating),

    /***************************************************************************
    * MAC/PHY
    ***************************************************************************/
    /* TX */
    .phy_txstartend_req(            c44_phy_txstartend_req),
    .phy_txstartend_conf(           c44_phy_txstartend_conf),
   
    .txv_length(                    c44_txv_length),
    .txv_service(                   c44_txv_service),
    .txv_datarate(                  c44_txv_datarate),
    .txv_immstop(                   c44_txv_immstop),
    
    .phy_data_req(                  c44_t0_data_req_1t),
    .phy_data_conf(                 c44_t0_data_conf),
    .bup_txdata(                    c44_t0_data_1t),
   
    /* RX */
    .phy_rxstartend_ind(            c44_phy_rxstartend_ind),
    .bup_rxdata(                    c44_rx_data),
    .phy_data_ind(                  c44_phy_data_ind),
    .rxv_length(                    c44_rxv_length),
    .rxv_service(                   c44_rxv_service),
    .rxv_datarate(                  c44_rxv_datarate),
    .rxe_errorstat(                 c44_rxe_errorstat),
    .phy_cca_ind(                   c44_phy_cca_ind),  // unused

    /***************************************************************************
    * RC
    ***************************************************************************/
    /* TX */
    .rf_txonoff_req(                c44_rf_txonoff_req),
    .rf_txonoff_conf(               c44_rf_txonoff_conf),
    
    /* RX */
    .rf_rxonoff_req(                c44_rf_rxonoff_req),
    .rf_rxonoff_conf(               c44_rf_rxonoff_conf),

    /***************************************************************************
    * AGC
    ***************************************************************************/
    .agcproc_end(                   c44_modem_rx_init),
    .cca_busy(                      c44_rx_blocken_1t),
    .correl_rst_n(                  c44_modem_rx_init_n),

    .psdu_duration(                 c44_psdu_duration),  // unused
    .correct_header(                c44_correct_header), // unused 
    .plcp_state(                    c44_plcp_state),     // unused    
    .plcp_error(                    c44_plcp_error),     // unused    
    .listen_start_o(                c44_listen_start_o), // unused
    .rx_end_for_timing(             c44_rx_endfortiming),
    .sfd_found(                     c44_sfd_found),
    .symbol_sync2(                  c44_symbol_sync2),   // unused

    /***************************************************************************
    * Frontend
    ***************************************************************************/
    .rf_rxi(                        c44_rxgain_i),
    .rf_rxq(                        c44_rxgain_q),

    .init_fir(                      c44_txfilt_init_fir),
    .fir_activate(                  c44_txfilt_fir_activate),
    .fir_phi_out_tog_o(             c44_txfilt_phi_angle_tog),
    .fir_phi_out(                   c44_txfilt_phi_angle),

    /***************************************************************************
    * register interface
    ***************************************************************************/
    .reg_gaindisb(                  regif_gaindisb),
    .reg_interpdisb(                regif_interpdisb),
    .reg_iqmmdisb(                  regif_iqmmdisb),
    .reg_precompdisb(               regif_precompdisb),
    .reg_dcoffdisb(                 regif_dcoffdisb),
    .reg_compdisb(                  regif_compdisb),
    .reg_eqdisb(                    regif_eqdisb),
    .reg_spreaddisb(                regif_spreaddisb),
    .reg_scrambdisb(                regif_scrambdisb),
    .reg_sfderr(                    regif_sfderr),
    .reg_sfdlen(                    regif_sfdlen),
    .reg_prepre(                    regif_prepre),
    .reg_rho(                       regif_rho),
    .reg_mu(                        regif_mu),
    .reg_beta(                      regif_beta),
    .reg_alpha(                     regif_alpha),
    .reg_talpha3(                   regif_talpha3),
    .reg_talpha2(                   regif_talpha2),
    .reg_talpha1(                   regif_talpha1),
    .reg_talpha0(                   regif_talpha0),
    .reg_tbeta3(                    regif_tbeta3),
    .reg_tbeta2(                    regif_tbeta2),
    .reg_tbeta1(                    regif_tbeta1),
    .reg_tbeta0(                    regif_tbeta0),
    .reg_tmu3(                      regif_tmu3),
    .reg_tmu2(                      regif_tmu2),
    .reg_tmu1(                      regif_tmu1),
    .reg_tmu0(                      regif_tmu0),
    .reg_rxlenchken(                regif_rxlenchken),
    .reg_rxmaxlength(               regif_rxmaxlength),
    .reg_txenddel(                  regif_txenddel),
    .reg_eqhold(                    regif_eqhold),
    .reg_comptime(                  regif_comptime),
    .reg_esttime(                   regif_esttime),
    .reg_eqtime(                    regif_eqtime),
    .reg_precomp(                   regif_precomp),
    .reg_synctime(                  regif_synctime),
    .reg_looptime(                  regif_looptime),
    
    /* status */
    .reg_eqsumq(                    regif_eqsumq),
    .reg_eqsumi(                    regif_eqsumi),
    .reg_dcoffsetq(                 regif_dcoffsetq),
    .reg_dcoffseti(                 regif_dcoffseti),
    .reg_iqgainestim(               regif_iqgainestim),
    .reg_freqoffestim(              regif_freqoffestim),
    .reg_evm(                       regif_evm),

    /***************************************************************************
    * Interface with RX Frontend
    ***************************************************************************/
    .clock_lock(                    c44_clock_lock),          // unused
    .gain_enable(                   c44_rxgain_gain_enable),
    .tau_est(                       c44_tau_est),             // unused
    .enable_error(                  c44_enable_error),        // unused

    /***************************************************************************
    * Error
    ***************************************************************************/
    .symbol_sync_error_o(           c44_symbol_sync_error_o), // unused
    .error_cart_i_o(                c44_error_cart_i_o),      // unused
    .error_cart_q_o(                c44_error_cart_q_o),      // unused

    /***************************************************************************
    * Diagnostic port
    ***************************************************************************/
    .modem_diag(                    c44_modem_diag),          // unused
    .modem_diag0(                   diag0),
    .modem_diag1(                   diag1),
    .modem_diag2(                   diag2) 
  );

  /*****************************************************************************
  *
  * RX 11B frontend
  *
  *****************************************************************************/
  /*****************************************************************************
  * power estimation 
  *****************************************************************************/
  fe11b_power_estim
  #(
    .m_size_g(                      7)
  )
  u_fe11b_power_estim
  (
    /***************************************************************************
    * clock and reset
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .reset_n(                       mdmb_rst_n),

    /***************************************************************************
    * parameters/control
    ***************************************************************************/
    .blocken(                       c44_powest_blocken),
    .update(                        c44_powest_update),
    
    /***************************************************************************
    * data I/Q
    ***************************************************************************/
    .data_in_i(                     feif_rx_i),
    .data_in_q(                     feif_rx_q),
    
    /***************************************************************************
    * power estimate
    ***************************************************************************/
    .power_estimation(              c44_powest_estimate)
  );

  /*****************************************************************************
  * timing offset estimator instance
  *****************************************************************************/
  fe11b_timingoff_estim
  #(
    .m_size_g(                      7),     
    .tau_size_g(                    13)
  )        
  u_fe11b_timingoff_estim 
  (
    /***************************************************************************
    * Clocks & Reset
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .reset_n(                       mdmb_rst_n),
 
    /***************************************************************************
    * Control
    ***************************************************************************/
    .timingoff_en(                  c44_toest_blocken),
  
    /***************************************************************************
    * I & Q
    ***************************************************************************/
    .datain_enable(                 1'b1),
    .data_in_i(                     feif_rx_i),
    .data_in_q(                     feif_rx_q),
    .tau(                           c44_toest_tau)
  );

  /*****************************************************************************
  * interpolator instance
  *****************************************************************************/
  fe11b_interpolator
  #(
    .dsize_g(                       7),
    .tausize_g(                     13)
  )
  u_fe11b_interpolator
  (
    /***************************************************************************
    * Clocks & Reset
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .reset_n(                       mdmb_rst_n),
    
    /***************************************************************************
    * Test control signal
    ***************************************************************************/
    .interpolator_enable(           c44_rxinterp_blocken),
    .clock_lock(                    1'b0),
    
    /* Value of timing offset */
    .tau_clock_unlocked(            c44_toest_tau),
    .tau_clock_locked(              13'b0),
    
    /* Input data */
    .shift_sample(                  1'b1),
    .data_in_i(                     feif_rx_i),
    .data_in_q(                     feif_rx_q),
    
    /* Interpolated data */
    .shift_sample_interp(           c44_rxinterp_valid),
    .interpolated_data_i(           c44_rxinterp_i),
    .interpolated_data_q(           c44_rxinterp_q),
    
    /* Max value of stage which is filled -> from register (max value 40) */
    .interp_max_stage_i(            regif_interpmaxstage),
    
    /* Indicate when the datas are right */
    .clk_skip(                      clkskip)
  );
  
  /*****************************************************************************
  * rx filter 
  *****************************************************************************/
  fe11b_rx_filter
  #(
    .dsize_g(                       7)
  )
  u_fe11b_rx_filter
  ( 
    /***************************************************************************
    * Clock and reset          
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .reset_n(                       mdmb_rst_n),
    .blocken(                       c44_rxfilter_blocken),
    
    /***************************************************************************
    * Control  
    ***************************************************************************/
    .firdisb(                       regif_firdisb),
  
    /***************************************************************************
    * I & Q      
    ***************************************************************************/
    .filter_in_en(                  c44_rxinterp_valid),
    .filter_in_i(                   c44_rxinterp_i),
    .filter_in_q(                   c44_rxinterp_q),
    
    .filter_out_tog(                c44_rxfilt_toggle),
    .filter_out_i(                  c44_rxfilt_i),
    .filter_out_q(                  c44_rxfilt_q)
  );

  /*****************************************************************************
  * gain compensation
  *****************************************************************************/
  fe11b_gain_compensation
  #(
    .dsize_g(                       8)
  )
  u_fe11b_gain_compensation
  (
    /***************************************************************************
    * Clocks & Reset
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .reset_n(                       mdmb_rst_n),
    
    /***************************************************************************
    * Control signal
    ***************************************************************************/
    .gain_enable(                   c44_rxgain_gain_enable),
    .power_estimation(              c44_powest_estimate),
    
    /***************************************************************************
    * Data
    ***************************************************************************/
    .data_in_enable(                c44_rxfilt_toggle),
    .data_i_in(                     c44_rxfilt_i),
    .data_q_in(                     c44_rxfilt_q),
	
    .data_out_enable(               c44_data_out_enable), // unused
    .data_i_out(                    c44_rxgain_i),
    .data_q_out(                    c44_rxgain_q)
  );

  /*****************************************************************************
  *
  * TX 11B frontend
  *
  *****************************************************************************/
  fe11b_tx_filter
  #(
    .out_length_g(                  7),
    .phi_degree_g(                  5)
  )
  u_fe11b_tx_filter
  (
    /***************************************************************************
    * Clocks & Reset
    ***************************************************************************/
    .clk(                           mdmb_clk),
    .reset_n(                       mdmb_rst_n),
    
    /***************************************************************************
    * control
    ***************************************************************************/
    .fir_activate(                  c44_txfilt_fir_activate),
    .fir_disb(                      regif_firdisb),
    .init_fir(                      c44_txfilt_init_fir),
    .fir_coef_sel(                  regif_fircoefsel),
   
    /***************************************************************************
    * data in
    ***************************************************************************/
    .phi_angle(                     c44_txfilt_phi_angle),
    
    /***************************************************************************
    * data out
    ***************************************************************************/
    .data_valid(                    feif_tx_en),
    .data_i(                        feif_tx_i),
    .data_q(                        feif_tx_q)
  );

endmodule
`default_nettype wire
