--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 1275 $
--/ $Date: 2012-03-02 13:40:05 +0100 (Fri, 02 Mar 2012) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : 
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/modem802_11b_core/vhdl/rtl/modemb_registers_if.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 
 

--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity modemb_registers_if is
  port (
    --------------------------------------
    -- Clocks & Reset
    --------------------------------------
    reset_n : in std_logic;
    hclk    : in std_logic;             -- 44 MHz clock.

    --------------------------------------
    -- Controls
    --------------------------------------
    -- Registers inputs :
    reg_gaindisb          : in  std_logic;  -- '0' to enable Gain compensation.
    reg_interpdisb        : in  std_logic;  -- '0' to enable Interpolation.
    reg_iqmmdisb          : in  std_logic;  -- '0' to enable I/Q mismatch compensation.
    reg_precompdisb       : in  std_logic;  -- '0' to enable timing offset compensation
    reg_dcoffdisb         : in  std_logic;  -- '0' to enable the DC offset compensation
    reg_compdisb          : in  std_logic;  -- '0' to enable the compensation.
    reg_eqdisb            : in  std_logic;  -- '0' to enable the Equalizer.
    reg_spreaddisb        : in  std_logic;  -- '0' to enable spreading.                        
    reg_scrambdisb        : in  std_logic;  -- '0' to enable scrambling.
    -- Registers outputs :
    reg_gaindisb_sync     : out std_logic;  -- '0' to enable Gain compensation.
    reg_interpdisb_sync   : out std_logic;  -- '0' to enable Interpolation.
    reg_iqmmdisb_sync     : out std_logic;  -- '0' to enable I/Q mismatch compensation.
    reg_precompdisb_sync  : out std_logic;  -- '0' to enable timing offset compensation
    reg_dcoffdisb_sync    : out std_logic;  -- '0' to enable the DC offset compensation
    reg_compdisb_sync     : out std_logic;  -- '0' to enable the compensation.
    reg_eqdisb_sync       : out std_logic;  -- '0' to enable the Equalizer.
    reg_spreaddisb_sync   : out std_logic;  -- '0' to enable spreading.                        
    reg_scrambdisb_sync   : out std_logic   -- '0' to enable scrambling.
    );

end modemb_registers_if;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of modemb_registers_if is

  signal reg_gaindisb_ff1_resync     : std_logic;
  signal reg_gaindisb_ff2_resync     : std_logic;
  signal reg_interpdisb_ff1_resync   : std_logic;
  signal reg_interpdisb_ff2_resync   : std_logic;
  signal reg_iqmmdisb_ff1_resync     : std_logic;
  signal reg_iqmmdisb_ff2_resync     : std_logic;
  signal reg_precompdisb_ff1_resync  : std_logic;
  signal reg_precompdisb_ff2_resync  : std_logic;
  signal reg_dcoffdisb_ff1_resync    : std_logic;
  signal reg_dcoffdisb_ff2_resync    : std_logic;
  signal reg_compdisb_ff1_resync     : std_logic;
  signal reg_compdisb_ff2_resync     : std_logic;
  signal reg_eqdisb_ff1_resync       : std_logic;
  signal reg_eqdisb_ff2_resync       : std_logic;
  signal reg_spreaddisb_ff1_resync   : std_logic;
  signal reg_spreaddisb_ff2_resync   : std_logic;
  signal reg_scrambdisb_ff1_resync   : std_logic;
  signal reg_scrambdisb_ff2_resync   : std_logic;
  
--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin

  resync_p: process (hclk, reset_n)
  begin
    if reset_n = '0' then
      reg_gaindisb_ff1_resync     <= '0';
      reg_gaindisb_ff2_resync     <= '0';
      reg_interpdisb_ff1_resync   <= '0';
      reg_interpdisb_ff2_resync   <= '0';
      reg_iqmmdisb_ff1_resync     <= '0';
      reg_iqmmdisb_ff2_resync     <= '0';
      reg_precompdisb_ff1_resync  <= '0';
      reg_precompdisb_ff2_resync  <= '0';
      reg_dcoffdisb_ff1_resync    <= '0';
      reg_dcoffdisb_ff2_resync    <= '0';
      reg_compdisb_ff1_resync     <= '0';
      reg_compdisb_ff2_resync     <= '0';
      reg_eqdisb_ff1_resync       <= '0';
      reg_eqdisb_ff2_resync       <= '0';
      reg_spreaddisb_ff1_resync   <= '0';
      reg_spreaddisb_ff2_resync   <= '0';
      reg_scrambdisb_ff1_resync   <= '0';
      reg_scrambdisb_ff2_resync   <= '0';
    elsif hclk'event and hclk = '1' then
      reg_gaindisb_ff1_resync     <= reg_gaindisb;
      reg_gaindisb_ff2_resync     <= reg_gaindisb_ff1_resync;
      reg_interpdisb_ff1_resync   <= reg_interpdisb;
      reg_interpdisb_ff2_resync   <= reg_interpdisb_ff1_resync;
      reg_iqmmdisb_ff1_resync     <= reg_iqmmdisb;
      reg_iqmmdisb_ff2_resync     <= reg_iqmmdisb_ff1_resync;
      reg_precompdisb_ff1_resync  <= reg_precompdisb;
      reg_precompdisb_ff2_resync  <= reg_precompdisb_ff1_resync;
      reg_dcoffdisb_ff1_resync    <= reg_dcoffdisb;
      reg_dcoffdisb_ff2_resync    <= reg_dcoffdisb_ff1_resync;
      reg_compdisb_ff1_resync     <= reg_compdisb;
      reg_compdisb_ff2_resync     <= reg_compdisb_ff1_resync;
      reg_eqdisb_ff1_resync       <= reg_eqdisb;
      reg_eqdisb_ff2_resync       <= reg_eqdisb_ff1_resync;
      reg_spreaddisb_ff1_resync   <= reg_spreaddisb;
      reg_spreaddisb_ff2_resync   <= reg_spreaddisb_ff1_resync;
      reg_scrambdisb_ff1_resync   <= reg_scrambdisb;
      reg_scrambdisb_ff2_resync   <= reg_scrambdisb_ff1_resync;
    end if;
  end process resync_p;
  
    reg_gaindisb_sync     <= reg_gaindisb_ff2_resync;
    reg_interpdisb_sync   <= reg_interpdisb_ff2_resync;
    reg_iqmmdisb_sync     <= reg_iqmmdisb_ff2_resync;
    reg_precompdisb_sync  <= reg_precompdisb_ff2_resync;
    reg_dcoffdisb_sync    <= reg_dcoffdisb_ff2_resync;
    reg_compdisb_sync     <= reg_compdisb_ff2_resync;
    reg_eqdisb_sync       <= reg_eqdisb_ff2_resync;
    reg_spreaddisb_sync   <= reg_spreaddisb_ff2_resync;
    reg_scrambdisb_sync   <= reg_scrambdisb_ff2_resync;
    
end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------

