--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 4387 $
--/ $Date: 2012-09-21 15:41:09 +0200 (Fri, 21 Sep 2012) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Modem 802.11b state machines.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/modem_sm_b/vhdl/rtl/modem_sm_b.vhd $
--/
--////////////////////////////////////////////////////////////////////////////


library ieee; 
use ieee.std_logic_1164.all; 

--library modem_sm_b_rtl;
library work;
--use modem_sm_b_rtl.modem_sm_b_pkg.all;      
use work.modem_sm_b_pkg.all;      

entity modem_sm_b is
  port (
    --------------------------------------
    -- Clocks & Reset
    -------------------------------------- 
    hresetn             : in  std_logic; -- AHB reset line.
    hclk                : in  std_logic; -- AHB clock line.
    --------------------------------------
    -- TX path block
    -------------------------------------- 
    seria_data_conf     : in  std_logic; -- Serializer is ready for new data
    tx_activated        : in  std_logic; -- the tx_path is transmitting    
    -- 
    scr_data_in         : out std_logic_vector(7 downto 0); -- data sent to scrambler
    sm_data_req         : out std_logic; -- State machines data request
    tx_psk_mode         : out std_logic; -- 0 = BPSK; 1 = QPSK
    activate_seria      : out std_logic; -- activate Serializer
    shift_period        : out std_logic_vector(3 downto 0); -- Serializer speed
    activate_cck        : out std_logic; -- activate CCK modulator
    tx_cck_rate         : out std_logic; -- CCK speed (0 = 5.5 Mbit/s; 1 = 11 Mbit/s)
    preamble_type_tx    : out std_logic; -- preamble type (0 = short; 1 = long)
    --------------------------------------
    -- RX path block
    -------------------------------------- 
    cca_busy            : in  std_logic; -- CCA busy
    preamble_type_rx    : in  std_logic; -- 1: long preamble ; 0: short preamble
    sfd_found           : in  std_logic; -- pulse when SFD is detected
    byte_ind            : in  std_logic; -- byte indication  
    symbol_sync         : in  std_logic; -- symbol indication
    rx_data             : in  std_logic_vector(7 downto 0); -- rx descrambled data
    --
    decode_path_activate: out std_logic; -- decode path activate
    diff_decod_first_val: out std_logic; -- pulse on first byte to decode
    rec_mode            : out std_logic_vector(1 downto 0); -- BPSK, QPSK, CCK5.5, CCK 11
    mod_type            : out std_logic; -- 0 : DSSS ; 1 : CCK
    rx_psk_mode         : out std_logic; -- 0 = BPSK; 1 = QPSK
    rx_cck_rate         : out std_logic; -- CCK rate (0 = 5.5 Mb/s; 1 = 11 Mb/s)
    rx_idle_state       : out std_logic; -- high when sm is idle
    rx_plcp_state       : out std_logic; -- high when sm is in plcp state
    --------------------------------------------
    -- Registers
    --------------------------------------------
    reg_prepre          : in  std_logic_vector(5 downto 0); -- pre-preamble count.
    txenddel_reg        : in  std_logic_vector(7 downto 0);
    rxlenchken          : in  std_logic; -- select ckeck on rx data lenght.
    rxmaxlength         : in  std_logic_vector(11 downto 0); -- Max accepted received length.    
    --------------------------------------------
    -- CCA
    --------------------------------------------
    psdu_duration       : out std_logic_vector(15 downto 0); --length in us
    correct_header      : out std_logic; -- high when header is correct.
    plcp_error          : out std_logic; -- high when plcp error occures
    listen_start_o      : out std_logic; -- high when start to listen
    rx_end_for_timing   : out std_logic; -- indication of end of frame
    --------------------------------------
    -- CRC
    -------------------------------------- 
    crc_data_1st        : in  std_logic_vector(7 downto 0); -- CRC data
    crc_data_2nd        : in  std_logic_vector(7 downto 0); -- CRC data
    --
    crc_init            : out std_logic; -- init CRC computation
    crc_data_valid      : out std_logic; -- compute CRC on packet header
    data_to_crc         : out std_logic_vector(7 downto 0); -- byte data to CRC
    --------------------------------------------
    -- Radio controller interface
    --------------------------------------------
    rf_txonoff_req     : out std_logic;  -- tx on off request
    rf_txonoff_conf    : in  std_logic;  -- tx on off confirmation
    rf_rxonoff_req     : out std_logic;  -- rx on off request
    rf_rxonoff_conf    : in  std_logic;  -- rx on off confirmation
    --------------------------------------
    -- BuP
    -------------------------------------- 
    -- TX
    phy_txstartend_req  : in  std_logic; -- request to start a packet transmission
                                         -- or request for end of transmission
    txv_service         : in  std_logic_vector(7 downto 0); -- service field
    phy_data_req        : in  std_logic; -- request from BuP to send a byte
    txv_datarate        : in  std_logic_vector( 3 downto 0); -- PSDU transmission rate
    txv_length          : in  std_logic_vector(11 downto 0); -- packet length in bytes
    bup_txdata          : in  std_logic_vector( 7 downto 0); -- data from BuP
    phy_txstartend_conf : out std_logic; -- transmission started, ready for data
                                         -- or transmission ended
    txv_immstop         : in std_logic;  -- request from Bup to stop tx.
    -- RX
    phy_cca_ind         : out  std_logic; -- indication of a carrier
    phy_rxstartend_ind  : out  std_logic; -- indication of a received PSDU
    rxv_service         : out  std_logic_vector(7 downto 0); -- service field
    phy_data_ind        : out  std_logic; -- indication of a received byte
    rxv_datarate        : out  std_logic_vector( 3 downto 0); -- PSDU RX rate
    rxv_length          : out  std_logic_vector(11 downto 0); -- packet length in bytes
    rxe_errorstat       : out  std_logic_vector(1 downto 0); -- error
    bup_rxdata          : out  std_logic_vector( 7 downto 0);  -- data to BuP
    --------------------------------------------
    -- Misc
    --------------------------------------------
    tx_sfd              : out std_logic;  -- Tx sfd avtive
    --------------------------------------
    -- Diag
    --------------------------------------
    rx_state_diag       : out std_logic_vector(2 downto 0)  -- Diag port
    );
end modem_sm_b;

--============================================================================--
--                                   ARCHITECTURE                             --
--============================================================================--

architecture RTL of modem_sm_b is

  ------------------------------------------------------------------------------
  -- Signals
  ------------------------------------------------------------------------------
  signal rx_crc_init       : std_logic;
  signal tx_crc_init       : std_logic;
  signal rx_crc_data_valid : std_logic;
  signal tx_crc_data_valid : std_logic;
  signal rx_data_to_crc    : std_logic_vector(7 downto 0);
  signal tx_data_to_crc    : std_logic_vector(7 downto 0);
  signal tx_activated_long : std_logic;
  
  ---------------------------------------------------- End of Signal declaration

--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------

begin

  
  -- CRC muxes
  crc_init       <= tx_crc_init when phy_txstartend_req = '1' else 
                    rx_crc_init;
  crc_data_valid <= tx_crc_data_valid when phy_txstartend_req = '1' else 
                    rx_crc_data_valid;
  data_to_crc    <= tx_data_to_crc when phy_txstartend_req = '1' else 
                    rx_data_to_crc;
                    
  ------------------------------------------------------------------------------
  -- TX state machine
  ------------------------------------------------------------------------------
  modem_tx_sm_1 : modem_tx_sm
    port map (
    --------------------------------------
    -- Clocks & Reset
    -------------------------------------- 
    hresetn             => hresetn,
    hclk                => hclk,
    --------------------------------------
    -- TX path block
    -------------------------------------- 
    seria_data_conf     => seria_data_conf,
    tx_activated        => tx_activated_long,
    --                     
    scr_data_in         => scr_data_in,
    sm_data_req         => sm_data_req,
    psk_mode            => tx_psk_mode,
    activate_seria      => activate_seria,
    shift_period        => shift_period,
    activate_cck        => activate_cck,
    cck_speed           => tx_cck_rate,
    preamble_type       => preamble_type_tx,
    --------------------------------------------
    -- Registers
    --------------------------------------------
    reg_prepre          => reg_prepre,
    --------------------------------------
    -- CRC
    -------------------------------------- 
    crc_data_1st        => crc_data_1st,
    crc_data_2nd        => crc_data_2nd,
    --                     
    crc_init            => tx_crc_init,
    crc_data_valid      => tx_crc_data_valid,
    data_to_crc         => tx_data_to_crc,
    --------------------------------------------
    -- Radio controller interface
    --------------------------------------------
    rf_txonoff_req      => rf_txonoff_req,
    rf_txonoff_conf     => rf_txonoff_conf,
    rf_rxonoff_req      => rf_rxonoff_req,
    rf_rxonoff_conf     => rf_rxonoff_conf,
    --------------------------------------
    -- BuP
    -------------------------------------- 
    phy_txstartend_req  => phy_txstartend_req,
    txv_service         => txv_service,
    phy_data_req        => phy_data_req,
    txv_datarate        => txv_datarate,
    txv_length          => txv_length,
    bup_txdata          => bup_txdata,
    txv_immstop         => txv_immstop,
    --                  
    phy_txstartend_conf => phy_txstartend_conf,
    
    --------------------------------------------
    -- Tx sfd avtive
    --------------------------------------------
    tx_sfd              => tx_sfd
    );


  ------------------------------------------------------------------------------
  -- RX state machine
  ------------------------------------------------------------------------------
  modem_rx_sm_1 : modem_rx_sm
    port map (
    --------------------------------------
    -- Clocks & Reset
    -------------------------------------- 
    hresetn             => hresetn,
    hclk                => hclk,
    --------------------------------------
    -- RX path block
    -------------------------------------- 
    cca_busy            => cca_busy,
    preamble_type       => preamble_type_rx,
    sfd_found           => sfd_found,
    byte_ind            => byte_ind,
    symbol_sync         => symbol_sync,
    tx_activated        => tx_activated_long,
    rx_data             => rx_data,
    --       
    decode_path_activate => decode_path_activate,
    diff_decod_first_val => diff_decod_first_val,
    rec_mode             => rec_mode,
    mod_type            => mod_type,              
    rx_psk_mode         => rx_psk_mode,
    cck_rate            => rx_cck_rate,
    rx_idle_state       => rx_idle_state,
    rx_plcp_state       => rx_plcp_state,
    --------------------------------------------
    -- CCA
    --------------------------------------------
    psdu_duration       => psdu_duration,
    correct_header      => correct_header,
    plcp_error          => plcp_error,
    listen_start_o      => listen_start_o,
    rx_end_for_timing   => rx_end_for_timing,
    --------------------------------------
    -- CRC
    -------------------------------------- 
    crc_data_1st        => crc_data_1st,
    crc_data_2nd        => crc_data_2nd,
    --                     
    crc_init            => rx_crc_init,
    crc_data_valid      => rx_crc_data_valid,
    data_to_crc         => rx_data_to_crc,
    --------------------------------------
    -- BuP
    --------------------------------------
    phy_txstartend_req  => phy_txstartend_req,
    phy_cca_ind         => phy_cca_ind,
    phy_rxstartend_ind  => phy_rxstartend_ind,
    rxv_service         => rxv_service,
    phy_data_ind        => phy_data_ind,
    rxv_datarate        => rxv_datarate,
    rxv_length          => rxv_length,
    rxe_errorstat       => rxe_errorstat,
    bup_rxdata          => bup_rxdata,
    --------------------------------------
    -- Registers
    --------------------------------------
    rxlenchken          => rxlenchken,
    rxmaxlength         => rxmaxlength,
    --------------------------------------
    -- Diag
    --------------------------------------    
    rx_state_diag       => rx_state_diag
    );


  -----------------------------------------------------------------------------
  -- Delay the tx_activate of the delay of the front-end
  -----------------------------------------------------------------------------
  tx_activ_gen_1: tx_activ_gen
    port map (
    --------------------------------------
    -- Clocks & Reset
    --------------------------------------
      hresetn          => hresetn,    -- [in]  AHB reset line.
      hclk             => hclk,       -- [in]  AHB clock line.
     --------------------------------------
     -- Signals
     --------------------------------------
      txenddel_reg      => txenddel_reg,        -- [in]
      tx_acti_tx_path   => tx_activated,        -- [in]  tx_activate from tx_path_core
      tx_activated_long => tx_activated_long);  -- [out] tx_activate longer of txenddel_reg periods

  
end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
