--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Package for phase_estimation.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/phase_estimation/vhdl/rtl/phase_estimation_pkg.vhd $
--/
--////////////////////////////////////////////////////////////////////////////



--------------------------------------------------------------------------------
-- Library
--------------------------------------------------------------------------------
library IEEE; 
    use IEEE.STD_LOGIC_1164.ALL; 


--------------------------------------------------------------------------------
-- Package
--------------------------------------------------------------------------------
package phase_estimation_pkg is


--------------------------------------------------------------------------------
-- Components list declaration done by <fb> script.
--------------------------------------------------------------------------------
----------------------
-- File: /share/hw_projects/PROJECTS/RW_WLAN_IP_LIB/IPs/RW-Ware/DSP/cordic_vect/vhdl/rtl/arctan_lut.vhd
----------------------
  component arctan_lut
  generic (
    dsize_g       : integer := 32;                    -- max value = 32.
    scaling_g     : integer := 0   -- 1:Use all the amplitude (pi/2 = 2^errosize_g=~ 01111....) 
  );                               -- (-pi/2 = -2^errosize_g= 100000....) 
  port (
    index   : in  std_logic_vector(4 downto 0); -- i value.
    arctan  : out std_logic_vector(dsize_g-1 downto 0)
  );
 

  end component;


----------------------
-- File: /share/hw_projects/PROJECTS/RW_WLAN_IP_LIB/IPs/RW-Ware/DSP/cordic_vect/vhdl/rtl/cordic_vect.vhd
----------------------
  component cordic_vect
  generic (
    datasize_g    : integer := 10; -- Data size. Max value is 30.
    errorsize_g   : integer := 10; -- Data size. Max value is 30.
    scaling_g     : integer := 0   -- 1:Use all the amplitude of angle_out
                                        --  pi/2 =^=  2^errosize_g =~ 01111... 
  );                                    -- -pi/2 =^= -2^errosize_g =  100000.. 
  port (
    -- clock and reset.
    clk          : in  std_logic;                   
    reset_n      : in  std_logic;    
    --
    load         : in  std_logic; -- Load input values.
    x_in         : in  std_logic_vector(datasize_g-1 downto 0); -- Real part in.
    y_in         : in  std_logic_vector(datasize_g-1 downto 0); -- Imaginary part.
    --
    angle_out    : out std_logic_vector(errorsize_g-1 downto 0); -- Angle out.
    cordic_ready : out std_logic                             -- Angle ready.
  );

  end component;


----------------------
-- File: data_shift.vhd
----------------------
  component data_shift
  generic (
    dsize_g : integer := 30 -- Data size
  );
  port (
    shift_reg      : in  std_logic_vector(3 downto 0);
    data_in        : in  std_logic_vector(dsize_g-1 downto 0);
    --
    shifted_data   : out std_logic_vector(dsize_g+14 downto 0)
  );

  end component;


----------------------
-- File: error_gen.vhd
----------------------
  component error_gen
  generic (
    datasize_g  : integer := 28;-- Max value is 28.
    errorsize_g : integer := 28 -- Max value is 28.
  );
  port (
    -- clock and reset.
    clk            : in  std_logic;
    reset_n        : in  std_logic;
    --
    symbol_sync    : in  std_logic;     -- Symbol synchronization pulse.
    -- Demodulated datain (real and im).
    data_i         : in  std_logic_vector(datasize_g-1 downto 0);
    data_q         : in  std_logic_vector(datasize_g-1 downto 0);
    -- Demapped data.
    demap_data     : in  std_logic_vector(1 downto 0);
    enable_error   : in  std_logic;
    --
    -- Error detected.
    phase_error    : out std_logic_vector(errorsize_g-1 downto 0);
    -- Error 
    error_cart_i_o : out std_logic_vector(datasize_g-1 downto 0);  -- real part.
    error_cart_q_o : out std_logic_vector(datasize_g-1 downto 0);  -- Imaginary part
    -- Error ready.
    error_ready    : out std_logic
    );

  end component;


----------------------
-- File: filter.vhd
----------------------
  component filter
  generic (
    esize_g  : integer := 13; -- size of error (must >= dsize_g).
    phisize_g    : integer := 15; -- size of angle phi
    omegasize_g  : integer := 12; -- size of angle omega
    sigmasize_g  : integer := 10; -- size of angle sigma
    tausize_g    : integer := 19  -- size of angle tau
  );
  port (
    -- clock and reset.
    clk            : in  std_logic;                   
    reset_n        : in  std_logic;    
    --
    load           : in  std_logic; -- Filter synchronization.
    precomp_enable : in  std_logic; -- Reload the omega accumulator
    interpolation_enable : in  std_logic; -- load the tau accumulator
    enable_error   : in std_logic; -- Enable the compensation.
    symbol_sync    : in  std_logic; -- Symbol synchronization.
    mod_type       : in  std_logic; -- Modulation type: '0' for DSSS, 
                                    -- '1' for CCK.
    phase_error    : in  std_logic_vector(esize_g-1 downto 0);-- Error
    rho            : in  std_logic_vector(3 downto 0); -- rho parameter value.
    mu             : in  std_logic_vector(3 downto 0); -- mu parameter value.

    -- Filter outputs.
    freqoffestim_stat : out std_logic_vector(7 downto 0);  -- Status register.
    phi            : out std_logic_vector(phisize_g-1 downto 0);  -- phi.
    sigma          : out std_logic_vector(sigmasize_g-1 downto 0);-- sigma.
    omega          : out std_logic_vector(omegasize_g-1 downto 0); -- omega.
    tau            : out std_logic_vector(tausize_g-1 downto 0) -- tau.
  
  );

  end component;


----------------------
-- File: phase_estimation.vhd
----------------------
  component phase_estimation
  generic (
    dsize_g      : integer := 13; -- size of data in
    esize_g      : integer := 13; -- size of error (must >= dsize_g).
    phisize_g    : integer := 15; -- size of angle phi
    omegasize_g  : integer := 12; -- size of angle omega
    sigmasize_g  : integer := 10; -- size of angle sigma
    tausize_g    : integer := 18  -- size of tau
  );
  port (
    -- clock and reset.
    clk                  : in  std_logic;
    reset_n              : in  std_logic;
    --
    symbol_sync          : in  std_logic;  -- Symbol synchronization pulse.
    precomp_enable       : in  std_logic;  -- Enable the precompensation
    interpolation_enable : in  std_logic;  -- Load the tau accumulator
    data_i               : in  std_logic_vector(dsize_g-1 downto 0);  -- Real data in
    data_q               : in  std_logic_vector(dsize_g-1 downto 0);  -- Im data in.
    demap_data           : in  std_logic_vector(1 downto 0);  -- Data from demapping.
    enable_error         : in  std_logic;  -- Enable the error calculation.
    mod_type             : in  std_logic;  -- Modulation type: '0' for DSSS, '1' for CCK.
    rho                  : in  std_logic_vector(3 downto 0);  -- rho parameter value.
    mu                   : in  std_logic_vector(3 downto 0);  -- mu parameter value.
    -- Filtered outputs.
    freqoffestim_stat    : out std_logic_vector(7 downto 0);  -- Status register.
    phi                  : out std_logic_vector(phisize_g-1 downto 0);  -- phi angle.
    sigma                : out std_logic_vector(sigmasize_g-1 downto 0);  -- sigma angle.
    omega                : out std_logic_vector(omegasize_g-1 downto 0);  -- omega angle.
    tau                  : out std_logic_vector(tausize_g-1 downto 0);   -- tau.
    -- Phase Error 
    phase_error_o        : out std_logic_vector(esize_g-1 downto 0);
    phase_error_ready_o  : out std_logic;
    -- Error 
    error_cart_i_o : out std_logic_vector(dsize_g downto 0);  -- real part.
    error_cart_q_o : out std_logic_vector(dsize_g downto 0)  -- Imaginary part    
    );

  end component;



 
end phase_estimation_pkg;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------
