--////////////////////////////////////////////////////////////////////////////
--/  Copyright (C) by RivieraWaves.
--/  This module is a confidential and proprietary property of RivieraWaves
--/  and a possession or use of this module requires written permission
--/  from RivieraWaves.
--/---------------------------------------------------------------------------
--/ $Author: cvandebu $
--/ Company          : RivieraWaves
--/---------------------------------------------------------------------------
--/ $Revision: 50 $
--/ $Date: 2011-09-21 18:10:05 +0200 (Wed, 21 Sep 2011) $
--/ --------------------------------------------------------------------------
--/ Dependencies     : None
--/ Description      : Sampling of Barker correlator peak for chip synchronization.
--/ Application Note :
--/ Terms & concepts :
--/ Bugs             :
--/ Open issues and future enhancements :
--/ References       :
--/ Revision History :
--/ --------------------------------------------------------------------------
--/
--/ $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/MODEM80211BCORE/symbol_sync/vhdl/rtl/symbol_sync.vhd $
--/
--////////////////////////////////////////////////////////////////////////////

library IEEE; 
use IEEE.STD_LOGIC_1164.ALL; 
use ieee.std_logic_unsigned.all; 
 
--library symbol_sync_rtl;
library work;
--use symbol_sync_rtl.symbol_sync_pkg.all;
use work.symbol_sync_pkg.all;



--------------------------------------------------------------------------------
-- Entity
--------------------------------------------------------------------------------
entity symbol_sync is
  generic (
    dsize_g : integer := 10
  );
  port (
    -- clock and reset.
    reset_n      : in  std_logic; -- Global reset.
    clk          : in  std_logic; -- Clock for Modem 802.11b (44 Mhz).
    --
    corr_i       : in  std_logic_vector(dsize_g-1 downto 0); -- correlated 
    corr_q       : in  std_logic_vector(dsize_g-1 downto 0); -- inputs.
    symbol_sync  : in  std_logic; -- Symbol synchronization signal.
    --
    data_i       : out std_logic_vector(dsize_g-1 downto 0); -- Sampled
    data_q       : out std_logic_vector(dsize_g-1 downto 0)  -- outputs.
  
  );

end symbol_sync;


--------------------------------------------------------------------------------
-- Architecture
--------------------------------------------------------------------------------
architecture RTL of symbol_sync is

  ------------------------------------------------------------------------------
  -- Signals
  ------------------------------------------------------------------------------


--------------------------------------------------------------------------------
-- Architecture Body
--------------------------------------------------------------------------------
begin

  --------------------------------------------
  -- Sample process.
  --------------------------------------------
  -- This process samples the Barker correlator peak output when the symbol_sync
  -- signal is received.
  sampl_pr: process (reset_n, clk)
  begin
    if reset_n = '0' then
      data_i <= (others => '0');
      data_q <= (others => '0');
    elsif clk'event and clk = '1' then
      if symbol_sync = '1' then
        data_i <= corr_i;
        data_q <= corr_q;
      end if;
    end if;
  end process sampl_pr;

end RTL;

--------------------------------------------------------------------------------
-- End of file
--------------------------------------------------------------------------------

