/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm 
( 
  /*****************************************************************************
  * SYSTEM
  *****************************************************************************/    
  input wire         sys_rst_n,
  input wire         ref0_root_clk, // ASIC: for now 120 MHz, used to generate phy clocks: should be aligned with RF clock
  input wire         ref1_root_clk, // ASIC: for now 80 MHz, does not need to be aligned with RF clock
`ifndef RW_CRM_FPGA
  input wire         plf_root_clk,                 
  input wire         mac_lp_root_clk,              
`else
  // POR reset control
  input wire         global_rst_n,
  // for ADC/DAC controllers
  output wire        ref80_clk, 
  output wire        ref80_rst_n,
  // for CPU subsys
  input  wire        axi_aclk,
  output wire        axi_por_n,
`endif

  /*****************************************************************************
  * RESET REQUESTS
  *****************************************************************************/    
  input wire         plf_swrsten_n,
  input wire         phywdog_hwrsten_n,

  /*****************************************************************************
  * CLOCK ENABLES
  *****************************************************************************/    
  input wire         mac_pi_clken,                 
  input wire         mac_pi_tx_clken,              
  input wire         mac_pi_rx_clken,              
  input wire         mac_core_clken,               
  input wire         mac_core_tx_clken,            
  input wire         mac_core_rx_clken,            
  input wire         mac_crypt_clken,              
  input wire         mac_wt_clken,                 
  input wire         mac_lp_clkswitch,             
  input wire         mpif_clken,                   
  input wire         macbypass_clken,                   
  input wire         phy_clken,
  input wire         phytx_clken,
  input wire         tbe_clken,
  input wire         tdfoest_clken,
  input wire         tdcomp_clken,
  input wire         channelest_clken,
  input wire         equ_clken,
  input wire         fdo_clken,
  input wire         fft0_clken,
`ifdef RW_BFMEE_EN
  input wire         svd_free_clken,
  input wire         svd_clken,
`endif //  RW_BFMEE_EN
  input wire         vtb_clken,
  input wire         vtbcore0_clken,
`ifdef RW_NX_LDPC_DEC
  input wire         ldpcrx0_clken,
  input wire         ldpcrx0_dec_clken,
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  input wire         ldpc0tx0_clken,
`endif // RW_NX_LDPC_ENC
 
  /* riu clock enables */
`ifdef RW_NX_DERIV_FE_PATH40M
  input wire         fe80_clken,
`endif // RW_NX_DERIV_FE_PATH40M
  input wire         fe40_clken,
  input wire         fe44_clken,
  input wire         agc_clken,
  input wire         agcmem_clken,
  input wire         ferx_clken,
  input wire         fetx_clken,
  /* mdmb clock enables */
  input wire         mdmb_clken,
  input wire         mdmb_clkskip,
  input wire         mdmbrx_clken,
  input wire         mdmbtx_clken,

  /*****************************************************************************
  * OUTGOING RESETS
  *****************************************************************************/    
  output wire        plf_por_n,
  output wire        plf_rst_n,     
  output wire        mac_core_rst_n,
  output wire        mac_wt_rst_n,  
  output wire        mac_mpif_rst_n,
`ifdef  RW_EMBEDDED_LA
  output wire        la_rst_n,      
`endif//RW_EMBEDDED_LA
  output wire        phy_rst_n,     
  output wire        rxbd_rst_n,    
  output wire        mdmb_rst_n,    
  output wire        fe40_rst_n,
  output wire        fe44_rst_n,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire        fe80_rst_n,
`endif // RW_NX_DERIV_FE_PATH40M
  output wire        fe_rst_n,
  output wire        rc_rst_n,      
  output wire        agc_rst_n,     
  output wire        radar_rst_n,   
  
  /*****************************************************************************
  * OUTGOING CLOCKS
  *****************************************************************************/    
  output wire        plf_clk,              
  output wire        mac_pi_clk,          
  output wire        mac_pi_tx_clk,       
  output wire        mac_pi_rx_clk,       
  output wire        mac_core_clk,        
  output wire        mac_core_tx_clk,     
  output wire        mac_core_rx_clk,     
  output wire        mac_crypt_clk,       
  output wire        mac_lp_clk,          
  output wire        mac_wt_clk,          
`ifdef  RW_EMBEDDED_LA
  output wire        la_clk,
`endif//RW_EMBEDDED_LA
  output wire        rc_clk,
  output wire        fe_clk,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire        fe80_clk,
`endif // RW_NX_DERIV_FE_PATH40M
  output wire        fe40_clk,
  output wire        fe44_clk,
  output wire        agc_clk,
  output wire        agcmem_clk,
  output wire        adcpow_clk,
  output wire        ferxpath_clk,
  output wire        fetxpath_clk,
  output wire        radar_clk,
  output wire        mpif_clk,
  output wire        macbypass_clk,
  output wire        phy_clk,
  output wire        phytx_clk,
  output wire        tbe_clk,
  output wire        tdfoest_clk,
  output wire        tdcomp_clk,
  output wire        channelest_clk,
  output wire        equ_clk,
  output wire        fdo_clk,
  output wire        fft0_clk,
`ifdef RW_BFMEE_EN
  output wire        svd_clk,
  output wire        svd_gclk,
`endif //  RW_BFMEE_EN
  output wire        vtb_clk,
  output wire        vtbcore0_clk,
`ifdef RW_NX_LDPC_DEC
  output wire        ldpcrx0_clk,
  output wire        ldpcrx0_dec_clk,
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  output wire        ldpc0tx0_clk,
`endif // RW_NX_LDPC_ENC
  /* mdmb */
  output wire        mdmb_clk,
  output wire        mdmbrx_clk,
  output wire        mdmbtx_clk,

  /*****************************************************************************
  * OUTGOING registers
  *****************************************************************************/    
  output wire [ 7:0] la_sampling_freq,

  ////////////////////////////////////////////
  //$port_g Bus interface
  ////////////////////////////////////////////
  input  wire        hready_in,
  input  wire        hsel,
  input  wire [ 9:0] haddr,
  input  wire [ 1:0] htrans,
  input  wire        hwrite,
  input  wire [31:0] hwdata,
  output wire [31:0] hrdata,
  output wire [ 1:0] hresp,
  output wire        hready
);


  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire    phy_root_clk;
  wire    mac_wt_root_clk;
  wire    mac_core_root_clk;
  wire    ref200_root_clk;
`ifdef  RW_EMBEDDED_LA
  wire    la_root_clk;
`endif//  RW_EMBEDDED_LA
  wire    rxbd_root_clk;
  
  wire    ref0_rst_n;
  wire    ref1_rst_n;
  wire    ref200_rst_n;
  wire    ref44_root_clk;
  wire    ref80_root_clk;

  // Registers  
  wire         regb_fmetre_start;
  reg          regb_fmetre_done;
  wire [19:0]  regb_fmetre_ref44;
  wire [19:0]  regb_fmetre_ref40;
  wire [19:0]  regb_fmetre_ref80;
  wire [19:0]  regb_fmetre_fe;
  wire [19:0]  regb_fmetre_phy;
  wire [19:0]  regb_fmetre_rxbd;
  wire [19:0]  regb_fmetre_mpif;
  wire [19:0]  regb_fmetre_la;
  wire [19:0]  regb_fmetre_plf;
  wire [19:0]  regb_fmetre_maccore;
  wire [19:0]  regb_fmetre_macwt;
  /* MMCM dynamic configuration */
  wire [ 6:0]  mmc_lock;
  wire [ 3:0]  regb_dyncfgmmc_sel;
  wire         regb_dyncfgmmc_start;
  wire [15:0]  regb_dyncfgmmc_addr;
  wire         regb_dyncfgmmc_we;
  wire [15:0]  regb_dyncfgmmc_wdata;
  wire [15:0]  regb_dyncfgmmc_rdata;
  wire         regb_dyncfgmmc_done;
  /* Clock control */
  wire         regb_plfclk_sel;

  wire         radar_clken;
  wire         rc_clken;
  // force clocks
  wire         phytxclkforce;   
  wire         bdtxclkforce;    
  wire         agcmemclkforce;  
  wire         agcclkforce;     
  wire         feclkforce;      
  wire         fdoclkforce;     
  wire         equclkforce;     
  wire         physvdclkforce;     
  wire         tdcompclkforce;  
  wire         tdfoestclkforce; 
  wire         tbeclkforce;     
  wire         fft0memclkforce; 
  wire         fft0clkforce;    
  wire         chestclkforce;   
  wire         intlvmemclkforce;    
  wire         vtb1clkforce;    
  wire         vtb0clkforce;    
  wire         bdrxclkforce;    
  wire         mdmbtxclkforce;  
  wire         mdmbrxclkforce;  
  wire         ldpcencclkforce;  
  wire         ldpcdecclkforce;  
  // enable with force
  wire         phytx_fclken;   
  wire         bdtx_fclken;    
  wire         agcmem_fclken;  
  wire         agc_fclken;     
  wire         ferx_fclken;      
  wire         fetx_fclken;      
  wire         fdo_fclken;     
  wire         equ_fclken;     
`ifdef RW_BFMEE_EN
  wire         svd_fclken;     
`endif  
  wire         tdcomp_fclken;  
  wire         tdfoest_fclken; 
  wire         tbe_fclken;     
  wire         fft0_fclken;    
  wire         channelest_fclken;   
  wire         vtb_fclken;    
  wire         vtbcore0_fclken;    
  wire         bdrx_fclken;    
  wire         mdmbtx_fclken;  
  wire         mdmbrx_fclken;  
  wire         mdmb_fclken;  
`ifdef RW_NX_LDPC_ENC
  wire         ldpc0tx0_fclken;  
`endif  
`ifdef RW_NX_LDPC_DEC
  wire         ldpcrx0_fclken;  
  wire         ldpcrx0_dec_fclken;  
`endif  
  wire         rxbd_fclken;  

  wire         phy_swrsten_n;
  wire         agc_swrsten_n;
  wire         rc_swrsten_n;
  wire         ref40_rst_n;
  wire         ref44_rst_n;
  
  wire         regb_physwreset;
  wire         regb_agcswreset;
  wire         regb_rcswreset;
  wire         ref40_root_clk;
  wire         fe_root_clk;
  wire [1:0]   regb_feclk_freq_sel;
  wire [3:0]   regb_maccoreclk_freq_sel;
  wire [1:0]   regb_macwtclk_ratio_sel;


  assign phy_swrsten_n = ~regb_physwreset;
  assign agc_swrsten_n = ~regb_agcswreset;
  assign rc_swrsten_n  = ~regb_rcswreset;


`ifdef  RW_CRM_FPGA
  wire phy_rst_n_prebufg;
  wire rxbd_rst_n_prebufg;
`endif//RW_CRM_FPGA

`ifdef RW_CRM_FPGA

  wire plf_root_clk;    // input in ASIC mode
  wire por_rst_n;
  
  assign ref80_clk = ref80_root_clk;


//******************************************************************************
// Power On Reset
//******************************************************************************
wire [11:0] n_por_rst_counter;
reg  [11:0] por_rst_counter;

assign n_por_rst_counter[11:8] = por_rst_counter[11:8]+{3'd0,&por_rst_counter[7:0]};
assign n_por_rst_counter[ 7:4] = por_rst_counter[ 7:4]+{3'd0,&por_rst_counter[3:0]};
assign n_por_rst_counter[ 3:0] = por_rst_counter[ 3:0]+{3'd0,1'b1};

always@(posedge ref200_root_clk or negedge global_rst_n)
begin
  if (global_rst_n==1'b0)
    por_rst_counter <= 12'h0;
  else if (por_rst_counter[11]==1'b0) // todo : Count only when 200MHz mmc is locked
    por_rst_counter <= n_por_rst_counter;
end

assign por_rst_n = por_rst_counter[11];

(* IODELAY_GROUP = "IODELAY_KARST" *) IDELAYCTRL IDELAYCTRL(
   .RST        (~por_rst_n     ),
   .REFCLK     (ref200_root_clk),
   .RDY        (               )
);


rw_he_crm_reset_cleaner u_axi_por_reset_cleaner(
   .clk        (axi_aclk     ),
   .nrst_sys   (por_rst_n    ),
   .nrst_in    (por_rst_n    ),
   .nrst_out   (axi_por_n    )
);

rw_he_crm_reset_cleaner u_plf_por_reset_cleaner(
   .clk        (plf_clk      ),
   .nrst_sys   (por_rst_n    ),
   .nrst_in    (por_rst_n    ),
   .nrst_out   (plf_por_n    )
);

`else // ASIC mode
  wire   ref80_rst_n;

rw_he_crm_reset_cleaner u_plf_por_reset_cleaner(
   .clk        (plf_clk      ),
   .nrst_sys   (sys_rst_n    ),
   .nrst_in    (sys_rst_n    ),
   .nrst_out   (plf_por_n    )
);

`endif

  /*****************************************************************************
  * REGISTERS
  *****************************************************************************/
rw_he_crm_reg u_rw_he_crm_reg(
  //----------------------------------------------------------------------------
  // Clock and reset
  //----------------------------------------------------------------------------
  .ahb_nrst          (plf_rst_n                                    ),
  .ahb_clk           (plf_clk                                      ),
  //----------------------------------------------------------------------------
  // Registers
  //----------------------------------------------------------------------------
  .mmc_lock          (mmc_lock                                     ),
  //----------------------------------------------------------------------------
  .dyncfgmmc_done    (regb_dyncfgmmc_done                          ),
  .dyncfgmmc_rdata   (regb_dyncfgmmc_rdata                         ),
  .fmetre_done       (regb_fmetre_done                             ),
  //----------------------------------------------------------------------------
  .plfclk_sel          (regb_plfclk_sel ),
  .feclk_freq_sel      (regb_feclk_freq_sel ),
  .maccoreclk_freq_sel (regb_maccoreclk_freq_sel),
  .macwtclk_ratio_sel  (regb_macwtclk_ratio_sel), 
  //----------------------------------------------------------------------------
  .phytxclkforce     (phytxclkforce   ),
  .bdtxclkforce      (bdtxclkforce    ),
  .agcmemclkforce    (agcmemclkforce  ),
  .agcclkforce       (agcclkforce     ),
  .rcclkforce        (rc_clken        ),
  .feclkforce        (feclkforce      ),
  .fdoclkforce       (fdoclkforce     ),
  .equclkforce       (equclkforce     ),
  .physvdclkforce    (physvdclkforce  ),
  .tdcompclkforce    (tdcompclkforce  ),
  .tdfoestclkforce   (tdfoestclkforce ),
  .tbeclkforce       (tbeclkforce     ),
  .fft1memclkforce   ( ),
  .fft1clkforce      ( ),
  .fft0memclkforce   (fft0memclkforce ),
  .fft0clkforce      (fft0clkforce    ),
  .chestclkforce     (chestclkforce   ),
  .hmemclkforce      ( ),
  .intlvmemclkforce  (intlvmemclkforce),
  .vtb1clkforce      (vtb1clkforce    ),
  .vtb0clkforce      (vtb0clkforce    ),
  .bdrxclkforce      (bdrxclkforce    ),
  .radartimclkforce  (radar_clken),
  .mdmbtxclkforce    (mdmbtxclkforce  ),
  .mdmbrxclkforce    (mdmbrxclkforce  ),
  .ldpcencclkforce   (ldpcencclkforce ),
  .ldpcdecclkforce   (ldpcdecclkforce ),
  //---------------------------------------------------------------------
  .physwreset        (regb_physwreset),
  .agcswreset        (regb_agcswreset),
  .rcswreset         (regb_rcswreset),
  //---------------------------------------------------------------------
  .fmetre_ref44      (regb_fmetre_ref44                            ),
  .fmetre_ref30      (20'h0                                        ),
  .fmetre_ref60      (20'h0                                        ),
  .fmetre_ref40      (regb_fmetre_ref40                            ),
  .fmetre_ref80      (regb_fmetre_ref80                            ),
  .fmetre_fe         (regb_fmetre_fe                               ),
  .fmetre_bd         (regb_fmetre_rxbd                             ),
  .fmetre_phy        (regb_fmetre_phy                              ),
  .fmetre_mpif       (regb_fmetre_mpif                             ),
  .fmetre_la         (regb_fmetre_la                               ),
  .fmetre_maccore    (regb_fmetre_maccore                          ),
  .fmetre_macwt      (regb_fmetre_macwt                            ),
  .fmetre_plf        (regb_fmetre_plf                              ),
  //----------------------------------------------------------------------------
  .dyncfgmmc_start   (regb_dyncfgmmc_start                         ),
  .dyncfgmmc_we      (regb_dyncfgmmc_we                            ),
  .dyncfgmmc_sel     (regb_dyncfgmmc_sel                           ),
  .dyncfgmmc_addr    (regb_dyncfgmmc_addr                          ),
  .dyncfgmmc_wdata   (regb_dyncfgmmc_wdata                         ),
  .fmetre_start      (regb_fmetre_start                            ),
  //----------------------------------------------------------------------------
  .la_sampling_freq  (la_sampling_freq                             ),
  //----------------------------------------------------------------------------
  // Bus interface
  //----------------------------------------------------------------------------
  .hready_in         (hready_in                                    ),
  .hsel              (hsel                                         ),
  .haddr             (haddr                                        ),
  .htrans            (htrans                                       ),
  .hwrite            (hwrite                                       ),
  .hwdata            (hwdata                                       ),
  .hrdata            (hrdata                                       ),
  .hresp             (hresp                                        ),
  .hready            (hready                                       )
);


  /*****************************************************************************
  * RESET CLEANING
  *****************************************************************************/
  rw_he_crm_reset u_rw_he_crm_reset
  (
    /* system reset */
    .sys_rst_n(            sys_rst_n),
    
    /* reset requests */
    .phy_swrsten_n(        phy_swrsten_n),
    .agc_swrsten_n(        agc_swrsten_n),
    .rc_swrsten_n(         rc_swrsten_n),
    .plf_swrsten_n(        plf_swrsten_n),
    .phywdog_hwrsten_n(    phywdog_hwrsten_n),
    .mmc4_lock(            mmc_lock[4]),
    
    /* root clocks */
    .plf_root_clk(         plf_root_clk),
    .ref200_root_clk(      ref200_root_clk),
    .ref44_root_clk(       ref44_root_clk),
    .ref40_root_clk(       ref40_root_clk),
    .ref80_root_clk(       ref80_root_clk),
    .fe_root_clk(          fe_root_clk),
`ifdef  RW_EMBEDDED_LA
    .la_root_clk(          la_root_clk),
`endif//  RW_EMBEDDED_LA
    .mac_core_root_clk(    mac_core_root_clk),
    .ref0_root_clk(        ref0_root_clk),
    .ref1_root_clk(        ref1_root_clk),
    .phy_root_clk(         phy_root_clk),
    .rxbd_root_clk(        rxbd_root_clk),
  
    /* cleaned resets */
    .plf_rst_n(            plf_rst_n),      
    .ref200_rst_n(         ref200_rst_n),      
    .ref40_rst_n(          ref40_rst_n),
    .ref80_rst_n(          ref80_rst_n),      
    .ref44_rst_n(          ref44_rst_n),
    .fe_rst_n(             fe_rst_n),      
    .fe40_rst_n(           fe40_rst_n),      
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_rst_n(           fe80_rst_n),      
`else
    .fe80_rst_n(           ),      
`endif
    .fe44_rst_n(           fe44_rst_n),      
`ifdef  RW_EMBEDDED_LA
    .la_rst_n(             la_rst_n),      
`endif//  RW_EMBEDDED_LA
    .mac_core_rst_n(       mac_core_rst_n), 
    .mac_wt_rst_n(         mac_wt_rst_n),   
    .ref0_rst_n(           ref0_rst_n),
    .ref1_rst_n(           ref1_rst_n),
    .mac_mpif_rst_n(       mac_mpif_rst_n), 
`ifdef  RW_CRM_FPGA
    .phy_rst_n(            phy_rst_n_prebufg),
    .rxbd_rst_n(           rxbd_rst_n_prebufg),
`else //RW_CRM_FPGA
    .phy_rst_n(            phy_rst_n),
    .rxbd_rst_n(           rxbd_rst_n),
`endif//RW_CRM_FPGA
    .mdmb_rst_n(           mdmb_rst_n),
    .rc_rst_n(             rc_rst_n),
    .agc_rst_n(            agc_rst_n),
    .radar_rst_n(          radar_rst_n)
  );

`ifdef  RW_CRM_FPGA
  wire phy_rst;
  wire rxbd_rst;
  BUFG u_phy_rst_bufg  ( .I(~phy_rst_n_prebufg ), .O(phy_rst ));
  BUFG u_rxbd_rst_bufg ( .I(~rxbd_rst_n_prebufg), .O(rxbd_rst));
  assign phy_rst_n  = ~phy_rst;
  assign rxbd_rst_n = ~rxbd_rst;
`endif//RW_CRM_FPGA

 
  /*****************************************************************************
  * CLOCK GENERATION
  *****************************************************************************/
`ifndef RW_CRM_FPGA
  rw_he_crm_clock_generation u_rw_he_crm_clock_generation
  (
    .ref0_rst_n(               ref0_rst_n),
    .ref0_root_clk(            ref0_root_clk),
    
    .ref1_rst_n(               ref1_rst_n),
    .ref1_root_clk(            ref1_root_clk),
    
    .mac_lp_root_clk(          mac_lp_root_clk),
    .mac_lp_clkswitch(         mac_lp_clkswitch),
    
    .regb_feclk_freq_sel(      regb_feclk_freq_sel),
    .regb_maccoreclk_freq_sel( regb_maccoreclk_freq_sel),
    .regb_macwtclk_ratio_sel(  regb_macwtclk_ratio_sel),


    .phy_root_clk(             phy_root_clk),
    .rxbd_root_clk(            rxbd_root_clk),
    .ref40_root_clk(           ref40_root_clk),
    .ref80_root_clk(           ref80_root_clk),
    .fe_root_clk(              fe_root_clk),
    .ref44_root_clk(           ref44_root_clk),

    .mac_wt_root_clk(          mac_wt_root_clk),  
    .mac_core_root_clk(        mac_core_root_clk),
    .mac_lp_clk(               mac_lp_clk),
    .ref200_root_clk(          ref200_root_clk)
  );
  
  assign mmc_lock = 7'b0010000; // Set mmc4_lock to 1 for mac_rst_n
  assign regb_dyncfgmmc_done = 1'b0;
  assign regb_dyncfgmmc_rdata = 16'b0;
  
  
`else
  assign mmc_lock[2] = 1'b0;
  assign mmc_lock[3] = 1'b0;
  // FPGA: Viterbi needs 120 MHz, LDPC is limited in synthesis to 120 MHz.
  // RXBD and PHY run at the same frequency
  assign rxbd_root_clk = phy_root_clk;
  rw_he_crm_fpga u_rw_he_crm_fpga
  (
    .sys_rst_n(               sys_rst_n),    
    .ref200_rst_n(            ref200_rst_n),      
    .fsys_prebufg(            ref0_root_clk),
    .clk_ext_25(              ref1_root_clk),
    .regb_dyncfgmmc_sel(      regb_dyncfgmmc_sel),
    .regb_dyncfgmmc_start(    regb_dyncfgmmc_start),
    .regb_dyncfgmmc_addr(     regb_dyncfgmmc_addr[7:0]),
    .regb_dyncfgmmc_we(       regb_dyncfgmmc_we),
    .regb_dyncfgmmc_wdata(    regb_dyncfgmmc_wdata), 
    .regb_dyncfgmmc_rdata(    regb_dyncfgmmc_rdata),
    .regb_dyncfgmmc_done(     regb_dyncfgmmc_done),
    .regb_plfclk_sel(         regb_plfclk_sel),
    .mac_lp_clkswitch(        mac_lp_clkswitch),
    .plf_root_clk(            plf_root_clk),  
    .ref200_root_clk(         ref200_root_clk),
    .ref44_root_clk(          ref44_root_clk),
    .ref40_root_clk(          ref40_root_clk),
    .ref80_root_clk(          ref80_root_clk),
    .fe_root_clk(             fe_root_clk),
    .mac_wt_root_clk(         mac_wt_root_clk),     
    .mac_core_root_clk(       mac_core_root_clk),    
    .mac_lp_clk(              mac_lp_clk),
    .phy_root_clk(            phy_root_clk),  
`ifdef  RW_EMBEDDED_LA
    .la_root_clk(             la_root_clk),   
`endif//def  RW_EMBEDDED_LA
    .mmc0_lock(               mmc_lock[0]),
    .mmc1_lock(               mmc_lock[1]),
    .mmc4_lock(               mmc_lock[4]),
    .mmc5_lock(               mmc_lock[5]),
    .mmc6_lock(               mmc_lock[6])
  );
`endif
  
  /*****************************************************************************
  * CLOCK GATING
  *****************************************************************************/
  assign plf_clk = plf_root_clk;
  
  // Force clocks
  assign phytx_fclken       = phytx_clken       | phytxclkforce;
//  assign bdtx_fclken        = bdtx_clken        | bdtxclkforce;
  assign agcmem_fclken      = agcmem_clken      | agcmemclkforce;
  assign agc_fclken         = agc_clken         | agcclkforce;
  assign ferx_fclken        = ferx_clken        | feclkforce;
  assign fetx_fclken        = fetx_clken        | feclkforce;
  assign fdo_fclken         = fdo_clken         | fdoclkforce;
  assign equ_fclken         = equ_clken         | equclkforce;
`ifdef RW_BFMEE_EN
  assign svd_fclken         = svd_clken         | physvdclkforce;
`endif // RW_BFMEE_EN
  assign tdcomp_fclken      = tdcomp_clken      | tdcompclkforce;
  assign tdfoest_fclken     = tdfoest_clken     | tdfoestclkforce;
  assign tbe_fclken         = tbe_clken         | tbeclkforce;
  assign fft0_fclken        = fft0_clken        | fft0clkforce;
  assign channelest_fclken  = channelest_clken  | chestclkforce;
  assign vtb_fclken         = vtb_clken         | vtb0clkforce;
  assign vtbcore0_fclken    = vtbcore0_clken    | vtb0clkforce;
  assign rxbd_fclken        = 1'b0              | bdrxclkforce;
  assign mdmbtx_fclken      = mdmbtx_clken      | mdmbtxclkforce;
  assign mdmbrx_fclken      = mdmbrx_clken      | mdmbrxclkforce;
  assign mdmb_fclken        = mdmb_clken        | mdmbrxclkforce | mdmbtxclkforce;
`ifdef RW_NX_LDPC_DEC
  assign ldpcrx0_fclken     = ldpcrx0_clken     | ldpcdecclkforce;
  assign ldpcrx0_dec_fclken = ldpcrx0_dec_clken | ldpcdecclkforce;
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  assign ldpc0tx0_fclken    = ldpc0tx0_clken    | ldpcencclkforce;
`endif // RW_NX_LDPC_ENC
 
  assign fe_clk             = fe_root_clk;

  rw_he_crm_clock_gate u_rw_he_crm_clock_gate
  (
    /* resets */
    .plf_rst_n(            plf_rst_n),
    .mac_core_rst_n(       mac_core_rst_n),
    .mac_wt_rst_n(         mac_wt_rst_n),
    .phy_rst_n(            phy_rst_n),
    .rxbd_rst_n(           rxbd_rst_n),
    .ref80_rst_n(          ref80_rst_n),
    .ref40_rst_n(          ref40_rst_n),
    .fe_rst_n(             fe_rst_n),
    .ref44_rst_n(          ref44_rst_n),
  
    /* root clocks */
    .plf_root_clk(         plf_root_clk),
    .mac_core_root_clk(    mac_core_root_clk),
    .mac_wt_root_clk(      mac_wt_root_clk),
    .phy_root_clk(         phy_root_clk),
    .rxbd_root_clk(        rxbd_root_clk),
    .ref80_root_clk(       ref80_root_clk),
    .ref40_root_clk(       ref40_root_clk),
    .ref44_root_clk(       ref44_root_clk),
    .fe_root_clk(          fe_root_clk),
  
    /* gated/muxed clocks */
    .mac_pi_clken(         mac_pi_clken),  // All mac clocks: force register done in platform
    .mac_pi_clk(           mac_pi_clk),
    .mac_pi_tx_clken(      mac_pi_tx_clken),
    .mac_pi_tx_clk(        mac_pi_tx_clk),
    .mac_pi_rx_clken(      mac_pi_rx_clken),
    .mac_pi_rx_clk(        mac_pi_rx_clk),
    .mac_core_clken(       mac_core_clken),
    .mac_core_clk(         mac_core_clk),
    .mac_core_rx_clken(    mac_core_rx_clken), 
    .mac_core_rx_clk(      mac_core_rx_clk),
    .mac_core_tx_clken(    mac_core_tx_clken),
    .mac_core_tx_clk(      mac_core_tx_clk),
    .mac_crypt_clken(      mac_crypt_clken),
    .mac_crypt_clk(        mac_crypt_clk),
    .mac_wt_clken(         mac_wt_clken),
    .mac_wt_clk(           mac_wt_clk),
    .phy_clken(            phy_clken),    // force register done in platform
    .rc_clken(             rc_clken),
    .rc_clk(               rc_clk),
    .phy_clk(              phy_clk),
    .macbypass_clken(      macbypass_clken), 
    .macbypass_clk(        macbypass_clk), 
    .mpif_clken(           mpif_clken),   // force register done in platform
    .mpif_clk(             mpif_clk),
    .phytx_clken(          phytx_fclken),
    .phytx_clk(            phytx_clk),
    .fft0_clken(           fft0_fclken),
    .fft0_clk(             fft0_clk),
    .tbe_clken(            tbe_fclken),
    .tbe_clk(              tbe_clk),
    .tdfoest_clken(        tdfoest_fclken),
    .tdfoest_clk(          tdfoest_clk),
    .tdcomp_clken(         tdcomp_fclken),
    .tdcomp_clk(           tdcomp_clk),
    .channelest_clken(     channelest_fclken),              
    .channelest_clk(       channelest_clk),
    .equ_clken(            equ_fclken),              
    .equ_clk(              equ_clk),
    .fdo_clken(            fdo_fclken),              
    .fdo_clk(              fdo_clk),
`ifdef RW_BFMEE_EN
    .svd_free_clken(       svd_free_clken),
    .svd_clk(              svd_clk),
    .svd_clken(            svd_fclken),              
    .svd_gclk(             svd_gclk),
`endif //  RW_BFMEE_EN
    .fe40_clken(           fe40_clken), // no force?
    .fe40_clk(             fe40_clk),
    .fe44_clken(           fe44_clken), // no force?
    .fe44_clk(             fe44_clk),
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clken(           fe80_clken), // no force?
    .fe80_clk(             fe80_clk),
`endif // RW_NX_DERIV_FE_PATH40M
    .mdmb_clkskip(         mdmb_clkskip),
    .mdmb_clken(           mdmb_fclken),
    .mdmb_clk(             mdmb_clk),
    .mdmbrx_clken(         mdmbrx_fclken),
    .mdmbrx_clk(           mdmbrx_clk),
    .mdmbtx_clken(         mdmbtx_fclken),
    .mdmbtx_clk(           mdmbtx_clk),
    .agc_clken(            agc_fclken),
    .agc_clk(              agc_clk),
    .agcmem_clken(         agcmem_fclken),
    .agcmem_clk(           agcmem_clk),
    .radar_clken(          radar_clken),
    .radar_clk(            radar_clk),
    .adcpow_clken(         ferx_fclken),
    .adcpow_clk(           adcpow_clk),
    .ferxpath_clken(       ferx_fclken),
    .ferxpath_clk(         ferxpath_clk),
    .fetxpath_clken(       fetx_fclken),
    .fetxpath_clk(         fetxpath_clk),
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clken(       ldpc0tx0_fclken),
    .ldpc0tx0_clk(         ldpc0tx0_clk),
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clken(        ldpcrx0_fclken),
    .ldpcrx0_clk(          ldpcrx0_clk),
    .ldpcrx0_dec_clken(    ldpcrx0_dec_fclken),
    .ldpcrx0_dec_clk(      ldpcrx0_dec_clk),
`endif // RW_NX_LDPC_DEC
    .vtb_clken(            vtb_fclken),
    .vtb_clk(              vtb_clk),
    .vtbcore0_clken(       vtbcore0_fclken),
    .vtbcore0_clk(         vtbcore0_clk)
  );

  /*****************************************************************************
  * Frequency meters
  *****************************************************************************/
  reg         fmetre_start_1t,fmetre_start_2t,fmetre_enable;
  wire [19:0] fmetre_ref200;
  
  always @(posedge ref200_root_clk,negedge ref200_rst_n)
  begin
    if(!ref200_rst_n)
    begin
      fmetre_start_1t  <= 1'b0;
      fmetre_start_2t  <= 1'b0;
      fmetre_enable    <= 1'b0;
      regb_fmetre_done <= 1'b0;
    end
    else
    begin
      fmetre_start_1t  <= regb_fmetre_start;
      fmetre_start_2t  <= fmetre_start_1t;
     
      if(fmetre_start_2t)
      begin
        if(!regb_fmetre_done)
        begin
`ifndef RW_CRM_FPGA
`ifdef RW_SIMU_ON
          if(fmetre_ref200==20'd1200-3)
`else//RW_SIMU_ON
          if(fmetre_ref200==20'd120000-3) // 3 cycles (fmetre start delay)
`endif//RW_SIMU_ON
`else
`ifdef RW_SIMU_ON
          if(fmetre_ref200==20'd2000-3)
`else//RW_SIMU_ON
          if(fmetre_ref200==20'd200000-3) // 3 cycles (fmetre start delay)
`endif//RW_SIMU_ON
`endif//RW_CRM_FPGA
          begin
            fmetre_enable    <= 1'b0;
            regb_fmetre_done <= 1'b1;
          end
          else
          begin
            fmetre_enable  <= 1'b1;
          end  
        end
      end
      else
      begin
        fmetre_enable    <= 1'b0;
        regb_fmetre_done <= 1'b0;
      end
    end
  end

  rw_he_crm_fmetre u_rw_he_crm_fmetre_ref200 (
    .rst_n      (ref200_rst_n),
    .clk        (ref200_root_clk),
    .enable     (fmetre_enable),
    .count      (fmetre_ref200)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_ref44 (
    .rst_n(   fe44_rst_n ),
    .clk(     ref44_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_ref44)
  );
  
  rw_he_crm_fmetre u_rw_he_crm_fmetre_ref40 (
    .rst_n(   ref40_rst_n),
    .clk(     ref40_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_ref40)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_ref80 (
    .rst_n(   ref80_rst_n),
    .clk(     ref80_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_ref80)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_fe (
    .rst_n(   fe_rst_n),
    .clk(     fe_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_fe)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_phy (
    .rst_n(   phy_rst_n),
    .clk(     phy_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_phy)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_rxbd (
    .rst_n(   rxbd_rst_n),
    .clk(     rxbd_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_rxbd)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_mpif (
    .rst_n(   phy_rst_n),
    .clk(     phy_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_mpif)
  );

`ifdef  RW_EMBEDDED_LA
  rw_he_crm_fmetre u_rw_he_crm_fmetre_la (
    .rst_n(   la_rst_n),
    .clk(     la_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_la)
  );
assign la_clk = la_root_clk;  
`else
assign regb_fmetre_la = 20'd0;
`endif//  RW_EMBEDDED_LA
  
  rw_he_crm_fmetre u_rw_he_crm_fmetre_plf (
    .rst_n(   plf_rst_n),
    .clk(     plf_root_clk),
    .enable(  fmetre_enable),
    .count(   regb_fmetre_plf)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_maccore (
    .rst_n      (mac_core_rst_n),
    .clk        (mac_core_root_clk),
    .enable     (fmetre_enable),
    .count      (regb_fmetre_maccore)
  );

  rw_he_crm_fmetre u_rw_he_crm_fmetre_macwt (
    .rst_n      (mac_wt_rst_n),
    .clk        (mac_wt_root_clk),
    .enable     (fmetre_enable),
    .count      (regb_fmetre_macwt)
  );

  
endmodule 
`default_nettype wire
