/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_clock_gate
( 
  /*****************************************************************************
  * resets
  *****************************************************************************/
  input  wire    plf_rst_n,
  input  wire    mac_core_rst_n,
  input  wire    mac_wt_rst_n,
  input  wire    phy_rst_n,
  input  wire    rxbd_rst_n,
  input  wire    ref80_rst_n,
  input  wire    ref40_rst_n,
  input  wire    fe_rst_n,
  input  wire    ref44_rst_n,
  
  /*****************************************************************************
  * root clocks
  *****************************************************************************/
  input  wire    plf_root_clk,
  input  wire    mac_core_root_clk,
  input  wire    mac_wt_root_clk,
  input  wire    phy_root_clk,
  input  wire    rxbd_root_clk,
  input  wire    ref44_root_clk,
  input  wire    ref40_root_clk,
  input  wire    ref80_root_clk,
  input  wire    fe_root_clk,
  
  /*****************************************************************************
  * gated/muxed clocks
  *****************************************************************************/
  /* mac_pi_clk */
  input  wire    mac_pi_clken,
  output wire    mac_pi_clk,
  
  /* mac_pi_tx_clk */
  input  wire    mac_pi_tx_clken,
  output wire    mac_pi_tx_clk,

  /* mac_pi_tx_clk */
  input  wire    mac_pi_rx_clken,
  output wire    mac_pi_rx_clk,
  
  /* mac_core_clk */
  input  wire    mac_core_clken,
  output wire    mac_core_clk,

  /* mac_core_rx_clk */
  input  wire    mac_core_rx_clken,  
  output wire    mac_core_rx_clk,
  
  /* mac_core_tx_clk */
  input  wire    mac_core_tx_clken,
  output wire    mac_core_tx_clk,
 
  /* mac_crypt_clk */
  input  wire    mac_crypt_clken,
  output wire    mac_crypt_clk,
  
  /* mac_wt_clk */
  input  wire    mac_wt_clken,
  output wire    mac_wt_clk,

  /* rc_clk */
  input  wire    rc_clken,
  output wire    rc_clk,
                   
  /* macbypass_clk */
  input  wire    macbypass_clken,  
  output wire    macbypass_clk,

  /* mpif_clk */
  input  wire    mpif_clken,  
  output wire    mpif_clk,

  /* phy_clk */
  input  wire    phy_clken,
  output wire    phy_clk,
                   
  /* phytx_clk */
  input  wire    phytx_clken,
  output wire    phytx_clk,
  
  /* fft0_clk */
  input  wire    fft0_clken,
  output wire    fft0_clk,
  
  /* tbe_clk */
  input wire     tbe_clken,
  output wire    tbe_clk,
  
  /* tdfoest_clk */
  input wire     tdfoest_clken,
  output wire    tdfoest_clk,
  
  /* tdcomp_clk */
  input wire     tdcomp_clken,
  output wire    tdcomp_clk,

  /* channelest_clk */
  input wire     channelest_clken,
  output wire    channelest_clk,

  /* equ_clk */
  input wire     equ_clken,
  output wire    equ_clk,

  /* fdo_clk */
  input wire     fdo_clken,
  output wire    fdo_clk,
`ifdef RW_BFMEE_EN
  /* svd_clk */
  input wire     svd_free_clken,
  output wire    svd_clk,

  /* svd_gclk */
  input wire     svd_clken,
  output wire    svd_gclk,
`endif //  RW_BFMEE_EN

  /* mdmb_clk */
  input wire     mdmb_clkskip,
  input wire     mdmb_clken,
  output wire    mdmb_clk,

  /* mdmbrx_clk */
  input wire     mdmbrx_clken,
  output wire    mdmbrx_clk,

  /* mdmbtx_clk */
  input wire     mdmbtx_clken,
  output wire    mdmbtx_clk,

  /* fe40_clk */
  input wire     fe40_clken,
  output wire    fe40_clk,

  /* fe44_clk */
  input wire     fe44_clken,
  output wire    fe44_clk,

`ifdef RW_NX_DERIV_FE_PATH40M
  /* fe80_clk */
  input wire     fe80_clken,
  output wire    fe80_clk,
`endif // RW_NX_DERIV_FE_PATH40M

  /* agc_clk */
  input wire     agc_clken,
  output wire    agc_clk,

  /* agcmem_clk */
  input wire     agcmem_clken,
  output wire    agcmem_clk,

  /* radar_clk */
  input wire     radar_clken,
  output wire    radar_clk,

  /* adcpow_clk */
  input wire     adcpow_clken,
  output wire    adcpow_clk,

  /* ferxpath_clk */
  input wire     ferxpath_clken,
  output wire    ferxpath_clk,

  /* fetxpath_clk */
  input wire     fetxpath_clken,
  output wire    fetxpath_clk,

`ifdef RW_NX_LDPC_ENC
  input  wire    ldpc0tx0_clken,
  output wire    ldpc0tx0_clk,
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_ENC
  input  wire    ldpcrx0_clken,
  output wire    ldpcrx0_clk,
  input  wire    ldpcrx0_dec_clken,
  output wire    ldpcrx0_dec_clk,
`endif // RW_NX_LDPC_ENC
  /* vtb_clk */
  input wire     vtb_clken,
  output wire    vtb_clk,

  /* vtbcore_clk */
  input wire     vtbcore0_clken,
  output wire    vtbcore0_clk
);

  /*****************************************************************************
  * PLATFORM clock domain (70-300 Mhz)
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_mac_pi_clk
  (
  	.clk(           plf_root_clk),
  	.rst_n(         plf_rst_n),
  	.en(            mac_pi_clken),
  	.gclk(          mac_pi_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_mac_pi_tx_clk 
  (
    .clk(           plf_root_clk),
    .rst_n(         plf_rst_n),
    .en(            mac_pi_tx_clken),
    .gclk(          mac_pi_tx_clk)
  );
  
  rw_he_crm_clock_gater u_clock_gater_mac_pi_rx_clk 
  (
  	 .clk(          plf_root_clk),
  	 .rst_n(        plf_rst_n),
  	 .en(           mac_pi_rx_clken),
  	 .gclk(         mac_pi_rx_clk)
  );
  
  /*****************************************************************************
  * MAC core clock domain (20-255 Mhz)
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_mac_core_clk 
  (
  	.clk(          mac_core_root_clk),
  	.rst_n(        mac_core_rst_n),
  	.en(           mac_core_clken),
  	.gclk(         mac_core_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_mac_core_tx_clk 
  (
  	.clk(          mac_core_root_clk),
  	.rst_n(        mac_core_rst_n),
  	.en(           mac_core_tx_clken),
  	.gclk(         mac_core_tx_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_mac_core_rx_clk
  (
  	.clk(          mac_core_root_clk),
  	.rst_n(        mac_core_rst_n),
  	.en(           mac_core_rx_clken),
  	.gclk(         mac_core_rx_clk)
  );
  
  rw_he_crm_clock_gater u_clock_gater_mac_crypt_clk 
  (
  	.clk(          mac_core_root_clk),
  	.rst_n(        mac_core_rst_n),
  	.en(           mac_crypt_clken),
  	.gclk(         mac_crypt_clk)
  );

  /*****************************************************************************
  * MAC WEP/TKIP clock domain (x1/x2/x3 macCoreClk)
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_mac_wt_clk 
  (
  	.clk(          mac_wt_root_clk),	
  	.rst_n(        mac_wt_rst_n),   	
  	.en(           mac_wt_clken),   	
  	.gclk(         mac_wt_clk)
  );

  /*****************************************************************************
  * PHY clock domain 
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_phy_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           phy_clken),
  	.gclk(         phy_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_mpif_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           mpif_clken),
  	.gclk(         mpif_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_mpif_macbypass_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           macbypass_clken),
  	.gclk(         macbypass_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_phytx_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           phytx_clken),
  	.gclk(         phytx_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_tbe_clk
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           tbe_clken),
  	.gclk(         tbe_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_tdfoest_clk
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           tdfoest_clken),
  	.gclk(         tdfoest_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_tdcomp_clk
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           tdcomp_clken),
  	.gclk(         tdcomp_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_channelest_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           channelest_clken),
  	.gclk(         channelest_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_equ_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           equ_clken),
  	.gclk(         equ_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_fdo_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           fdo_clken),
  	.gclk(         fdo_clk)
  );

`ifdef RW_BFMEE_EN
  rw_he_crm_clock_gater u_clock_gater_svd_free_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           svd_free_clken),
  	.gclk(         svd_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_svd_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           svd_clken),
  	.gclk(         svd_gclk)
  );
`endif //  RW_BFMEE_EN

  rw_he_crm_clock_gater u_clock_gater_fft0_clk 
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           fft0_clken),
  	.gclk(         fft0_clk)
  );
 
  rw_he_crm_clock_gater u_clock_gater_vtb_clk
  (
  	.clk(          rxbd_root_clk),
  	.rst_n(        rxbd_rst_n),
  	.en(           vtb_clken),
  	.gclk(         vtb_clk)
  );
  
  rw_he_crm_clock_gater u_clock_gater_vtbcore0_clk
  (
  	.clk(          rxbd_root_clk),
  	.rst_n(        rxbd_rst_n),
  	.en(           vtbcore0_clken),
  	.gclk(         vtbcore0_clk)
  );
  
`ifdef RW_NX_LDPC_ENC
  rw_he_crm_clock_gater u_clock_gater_ldpctx0_clk
  (
  	.clk(          phy_root_clk),
  	.rst_n(        phy_rst_n),
  	.en(           ldpc0tx0_clken),
  	.gclk(         ldpc0tx0_clk)
  );
`endif // RW_NX_LDPC_ENC
  
`ifdef RW_NX_LDPC_DEC
  rw_he_crm_clock_gater u_clock_gater_ldpcrx0_clk
  (
  	.clk(          rxbd_root_clk),
  	.rst_n(        rxbd_rst_n),
  	.en(           ldpcrx0_clken),
  	.gclk(         ldpcrx0_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_ldpcrx0_dec_clk
  (
  	.clk(          rxbd_root_clk),
  	.rst_n(        rxbd_rst_n),
  	.en(           ldpcrx0_dec_clken),
  	.gclk(         ldpcrx0_dec_clk)
  );
`endif // RW_NX_LDPC_DEC
  
  /*****************************************************************************
  * mdmb clock domain 
  *****************************************************************************/
  wire mdmbrx_preskip_clk,mdmbtx_preskip_clk;
  
  rw_he_crm_clock_gater u_clock_gater_mdmb_clk
  (
  	.clk(          ref44_root_clk),
  	.rst_n(        ref44_rst_n),
  	.en(           mdmb_clken),
  	.gclk(         mdmb_clk)
  );
  
  rw_he_crm_clock_gater u_clock_gater_mdmbrx_clk
  (
  	.clk(          ref44_root_clk),
  	.rst_n(        ref44_rst_n),
  	.en(           mdmbrx_clken),
  	.gclk(         mdmbrx_preskip_clk)
  );
  assign mdmbrx_clk = mdmbrx_preskip_clk | mdmb_clkskip;
  
  rw_he_crm_clock_gater u_clock_gater_mdmbtx_clk
  (
  	.clk(          ref44_root_clk),
  	.rst_n(        ref44_rst_n),
  	.en(           mdmbtx_clken),
  	.gclk(         mdmbtx_preskip_clk)
  );
  assign mdmbtx_clk = mdmbtx_preskip_clk | mdmb_clkskip;
  
  rw_he_crm_clock_gater u_clock_gater_fe44_clk
  (
  	.clk(          ref44_root_clk),
  	.rst_n(        ref44_rst_n),
  	.en(           fe44_clken),
  	.gclk(         fe44_clk)
  );

  /*****************************************************************************
  * ref80 clock domain
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_rc_clk 
  (
  	.clk(          ref80_root_clk),
  	.rst_n(        ref80_rst_n),
  	.en(           rc_clken),
  	.gclk(         rc_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_agc_clk
  (
  	.clk(          ref80_root_clk),
  	.rst_n(        ref80_rst_n),
  	.en(           agc_clken),
  	.gclk(         agc_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_agcmem_clk
  (
  	.clk(          ref80_root_clk),
  	.rst_n(        ref80_rst_n),
  	.en(           agcmem_clken),
  	.gclk(         agcmem_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_radar_clk
  (
  	.clk(          ref80_root_clk),
  	.rst_n(        ref80_rst_n),
  	.en(           radar_clken),
  	.gclk(         radar_clk)
  );

`ifdef RW_NX_DERIV_FE_PATH40M
  /*****************************************************************************
  * ref80 clock domain
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_fe80_clk
  (
  	.clk(          ref80_root_clk),
  	.rst_n(        ref80_rst_n),
  	.en(           fe80_clken),
  	.gclk(         fe80_clk)
  );
`endif // RW_NX_DERIV_FE_PATH40M

  /*****************************************************************************
  * ref40 clock domain
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_fe40_clk
  (
  	.clk(          ref40_root_clk),
  	.rst_n(        ref40_rst_n),
  	.en(           fe40_clken),
  	.gclk(         fe40_clk)
  );

  /*****************************************************************************
  * FE clock domain
  *****************************************************************************/
  rw_he_crm_clock_gater u_clock_gater_adcpow_clk
  (
  	.clk(          fe_root_clk),
  	.rst_n(        fe_rst_n),
  	.en(           adcpow_clken),
  	.gclk(         adcpow_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_ferxpath_clk
  (
  	.clk(          fe_root_clk),
  	.rst_n(        fe_rst_n),
  	.en(           ferxpath_clken),
  	.gclk(         ferxpath_clk)
  );

  rw_he_crm_clock_gater u_clock_gater_fetxpath_clk
  (
  	.clk(          fe_root_clk),
  	.rst_n(        fe_rst_n),
  	.en(           fetxpath_clken),
  	.gclk(         fetxpath_clk)
  );

endmodule
`default_nettype wire
 
