/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_clock_generation
( 
  input   wire       ref0_rst_n,
  input   wire       ref0_root_clk,
    
  input   wire       ref1_rst_n,
  input   wire       ref1_root_clk,
  
  input   wire       mac_lp_root_clk,
  input   wire       mac_lp_clkswitch,
  input   wire [1:0] regb_feclk_freq_sel,
  input   wire [3:0] regb_maccoreclk_freq_sel,
  input   wire [1:0] regb_macwtclk_ratio_sel,
    
  output  wire       phy_root_clk,
  output  wire       rxbd_root_clk,
  output  wire       ref40_root_clk,
  output  wire       ref80_root_clk,
  output  wire       fe_root_clk,
  output  wire       ref44_root_clk,

  output  reg        mac_wt_root_clk,              
  output  reg        mac_core_root_clk,
  output  wire       mac_lp_clk,
  output  wire       ref200_root_clk
  
);


  /*****************************************************************************
  * declaration
  *****************************************************************************/ 
  reg  [10:0]  ref44_sr,     n_ref44_sr;
  reg  [ 3:0]  ref44_count,  n_ref44_count;
  reg  [ 1:0]  ref120_sr,       n_ref120_sr;
  reg  [ 5:0]  ref40_sr,     n_ref40_sr;
  reg  [ 2:0]  ref80_sr,     n_ref80_sr;
  reg  [ 2:0]  state,        n_state;
  reg          ref44_clk, ref40_clk, ref80_clk, ref160_clk, phy_clk;
  reg  [ 3:0]  ref60_sr,       n_ref60_sr;
  reg          fe_clk;

  /*****************************************************************************
  *                       0 0 0 0 0 0 0 0
  *                       7 6 5 4 3 2 1 0
  * 240                  0101010101010101
  *
  * 120                              0011
  *  80                            000011                             
  *  60                          00001111
  *  40                      000000111111                             
  *
  *****************************************************************************/ 
  always @(*)
  begin
    
    /* pattern generation */
    if(state==3'd5)
    begin
      n_state     = 5'd0;
      n_ref40_sr  = 6'b000111; /* 40  */
      n_ref80_sr  = 3'b001;    /* 80  */
      n_ref120_sr = 2'b01;     /* 120 */
    end
    else
    begin
      n_state      = state + 3'd1;

      /* fixed frequency */
      n_ref40_sr   = {ref40_sr[0], ref40_sr[ 5:1]};
      n_ref80_sr   = {ref80_sr[0], ref80_sr[ 2:1]};
      n_ref120_sr  = {ref120_sr[0], ref120_sr[1]};

    end
    n_ref60_sr   = {ref60_sr[0], ref60_sr[ 3:1]};

    /* 44 MHz clock generation, SHALL BE COHERENT WITH REF0_CLK */
    n_ref44_count         = ref44_count;          
    n_ref44_sr    = { ref44_sr[9:0],  ref44_sr[10]};

    if(ref44_sr[10:9]==2'b01)
    begin
      if(ref44_count==4'd10)
      begin
        n_ref44_count = 4'd0;
        n_ref44_sr    = {5'b11100,6'b111000};
      end
      else
      begin
        n_ref44_count = ref44_count + 4'd1;
      end
    end  
  end
  
  always @(posedge ref0_root_clk, negedge ref0_rst_n)
  begin
    if(!ref0_rst_n)
    begin
      ref120_sr         <= 2'b01;      /* 120 */
      ref40_sr          <= 6'b000111;  /* 40  */
      ref60_sr          <= 4'b0011;    /* 60  */
      ref80_sr          <= 3'b001;     /* 80  */
      state             <= 3'd0;
      
      ref44_sr          <= {5'b11100,6'b111000};
      ref44_count       <=  4'b0000;
   
      ref44_clk         <= 1'b1;
      ref40_clk         <= 1'b1;
      ref80_clk         <= 1'b1;
      fe_clk            <= 1'b1;

      phy_clk           <= 1'b1;

    end
    else
    begin
      ref120_sr         <= n_ref120_sr;          
      ref80_sr          <= n_ref80_sr;         
      ref60_sr          <= n_ref60_sr;         
      ref40_sr          <= n_ref40_sr;         
      state             <= n_state;            
      
      ref44_sr          <= n_ref44_sr;         
      ref44_count       <= n_ref44_count; 
      
      ref44_clk         <= n_ref44_sr[10];
      ref40_clk         <= n_ref40_sr[0];
      ref80_clk         <= n_ref80_sr[0];
      case(regb_feclk_freq_sel)
        /*********************************************************************
        * FE Clock 40MHz
        *********************************************************************/
          2'd0:
            fe_clk      <= n_ref40_sr[0];
        /*********************************************************************
        * FE Clock 80MHz
        *********************************************************************/
          2'd1:
            fe_clk      <= n_ref80_sr[0];
          default:  
            fe_clk      <= n_ref40_sr[0];
      endcase    
      phy_clk           <= n_ref120_sr[0];
    end
  end


  assign phy_root_clk    = phy_clk;
`ifdef RW_NX_FPGA_SIM
  assign rxbd_root_clk   = phy_clk;
`else
  `ifdef RW_NX_LDPC_DEC
    assign rxbd_root_clk   = ref0_root_clk; // TODO
  `else
    assign rxbd_root_clk   = phy_clk;
  `endif // RW_NX_LDPC_DEC
`endif // RW_NX_FPGA_SIM

  assign ref200_root_clk = phy_clk; // TODO this is the fastest clock, used to control frequency meters
  assign ref44_root_clk  = ref44_clk;
  assign ref40_root_clk  = ref40_clk;
  assign ref80_root_clk  = ref80_clk;
  assign fe_root_clk     = fe_clk;

  always @(posedge ref0_root_clk, negedge ref0_rst_n)
  begin
    if(!ref0_rst_n)
    begin
      mac_wt_root_clk   <= 1'b1;
      mac_core_root_clk <= 1'b1;
    end  
    else
    begin
      case ({regb_macwtclk_ratio_sel,regb_maccoreclk_freq_sel})
        6'b010010 : {mac_wt_root_clk,mac_core_root_clk} <= {n_ref120_sr[0],n_ref120_sr[0]};
        6'b010011 : {mac_wt_root_clk,mac_core_root_clk} <= {n_ref80_sr[0],n_ref80_sr[0]};
        6'b010100 : {mac_wt_root_clk,mac_core_root_clk} <= {n_ref60_sr[0],n_ref60_sr[0]};
        6'b100110 : {mac_wt_root_clk,mac_core_root_clk} <= {n_ref80_sr[0],n_ref40_sr[0]};
        default   : {mac_wt_root_clk,mac_core_root_clk} <= {n_ref60_sr[0],n_ref60_sr[0]};
      endcase
    end
  end

  /*****************************************************************************
  * MAC LP clock domain ( mac_lp_root_clk ,  mac_core_root_clk)
  *****************************************************************************/
  rw_he_crm_clock_mux u_rw_clock_mux 
  (
  	.clk0_rst_n(   ref0_rst_n),
  	.clk0(         mac_core_root_clk),
  	.clk1_rst_n(   ref1_rst_n),
  	.clk1(         mac_lp_root_clk),
  	.sel(          mac_lp_clkswitch),
  	.sclk(         mac_lp_clk)
  );

`ifdef RW_SIMU_ON
  initial
  begin
    $display("ASIC CRM Configuration :");
    $display("  FECLK_FREQ_SEL_RST      = %0d (%0d MHz)",`FECLK_FREQ_SEL_RST,40*2**(`FECLK_FREQ_SEL_RST));
    $display("  MACCORECLK_FREQ_SEL_RST = %0d (%0d MHz)\n",`MACCORECLK_FREQ_SEL_RST,240/`MACCORECLK_FREQ_SEL_RST);


    if ((`MAC_FREQ != 120) && (`MAC_FREQ != 80) && (`MAC_FREQ != 60) && (`MAC_FREQ != 48) && (`MAC_FREQ != 40))
    begin
      $display("ERROR !!!. Wrong configuration of MACCOREClk frequency.`MAC_FREQ is set to %0d. It shall be either 240,120,80,60,48 or 40",`MAC_FREQ);
      $finish();
    end
    
    if ((`WEP_2_BB_CLK_RATIO != 1) && (`WEP_2_BB_CLK_RATIO != 2))
    begin
      $display("ERROR !!!. Wrong configuration of WEP_2_BB_CLK_RATIO.`WEP_2_BB_CLK_RATIO is set to %0d. It shall be either 1 or 2",`WEP_2_BB_CLK_RATIO);
      $finish();
    end
  end
`endif // RW_SIMU_ON

  
endmodule
`default_nettype wire
