/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_clock_mux 
( 
  input  wire   clk0_rst_n,
  input  wire   clk0,
  input  wire   clk1_rst_n,
  input  wire   clk1,
  input  wire   sel, // 0 : clk0, 1 : clk1
  output wire   sclk
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire  clken0;
  reg   clken0_1t;
  reg   clken0_2t;
  wire  gclk0;
  
  wire  clken1;
  reg   clken1_1t;
  reg   clken1_2t;
  wire  gclk1;
 
  /*****************************************************************************
  * clk1 resync
  *****************************************************************************/
  assign clken0 = !sel & !clken1_2t;
  
  always @(negedge clk0_rst_n, posedge clk0)
  begin
    if (!clk0_rst_n)
      clken0_1t <= 1'b0;
    else
      clken0_1t <= clken0;
  end    

  always @(negedge clk0_rst_n, negedge clk0)
  begin
    if (!clk0_rst_n)
      clken0_2t <= 1'b0;
    else
      clken0_2t <= clken0_1t;
  end    
  
  assign gclk0 = clk0 & clken0_2t;
  
  /*****************************************************************************
  * clk2 resync
  *****************************************************************************/
  assign clken1 = sel & !clken0_2t;
  
  always @(negedge clk1_rst_n, posedge clk1)
  begin
    if (!clk1_rst_n)
      clken1_1t <= 1'b0;
    else
      clken1_1t <= clken1;
  end    

  always @(negedge clk1_rst_n, negedge clk1)
  begin
    if (!clk1_rst_n)
      clken1_2t <= 1'b0;
    else
      clken1_2t <= clken1_1t;
  end    

  assign gclk1 = clk1 & clken1_2t;

  /*****************************************************************************
  * output
  *****************************************************************************/
  assign sclk = gclk0 | gclk1;

endmodule
`default_nettype wire


