/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_fmetre
(
  input  wire       rst_n,
  input  wire       clk,
  input  wire       enable,
  output reg [19:0] count
);
  reg enable_1t_resync,enable_2t,enable_3t;
 
  wire   [19:0] n_count;
  assign n_count[19:16] = count[19:16] + {3'b0,&count[15:0]};
  assign n_count[15:12] = count[15:12] + {3'b0,&count[11:0]};
  assign n_count[11: 8] = count[11: 8] + {3'b0,&count[ 7:0]};
  assign n_count[ 7: 4] = count[ 7: 4] + {3'b0,&count[ 3:0]};
  assign n_count[ 3: 0] = count[ 3: 0] + {3'b0,        1'b1};

  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      enable_1t_resync <= 1'b0;
      enable_2t        <= 1'b0;
      enable_3t        <= 1'b0;
      count            <= 20'd0;
    end
    else
    begin
      enable_1t_resync <= enable;
      enable_2t        <= enable_1t_resync;
      enable_3t        <= enable_2t;
      if(enable_2t && !enable_3t)
        count <= 20'd1;
      else if(enable_2t)
        count <= n_count;
    end
  end
  
  endmodule
`default_nettype wire
