/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_fpga
( 
  input   wire        sys_rst_n,    
  input   wire        ref200_rst_n,    

  input   wire        fsys_prebufg,
                                    
//  input   wire        ref1_rst_n,
  input   wire        clk_ext_25,
    
  /***************************************************************************  
  * register bank interface                                                           
  ***************************************************************************/  
  /* MMCM dynamic configuration */
  input  wire [ 3:0]  regb_dyncfgmmc_sel,
  input  wire         regb_dyncfgmmc_start,
  input  wire [ 7:0]  regb_dyncfgmmc_addr,
  input  wire         regb_dyncfgmmc_we,
  input  wire [15:0]  regb_dyncfgmmc_wdata,
  output wire [15:0]  regb_dyncfgmmc_rdata,
  output wire         regb_dyncfgmmc_done,

  /* Clock control */
  input  wire         regb_plfclk_sel,
  input  wire         mac_lp_clkswitch,

  output  wire        plf_root_clk           /* synthesis syn_keep = 1 */,
  output  wire        ref200_root_clk        /* synthesis syn_keep = 1 */,
  output  wire        ref44_root_clk         /* synthesis syn_keep = 1 */,
  output  wire        ref40_root_clk         /* synthesis syn_keep = 1 */,
  output  wire        ref80_root_clk         /* synthesis syn_keep = 1 */,
  output  wire        fe_root_clk            /* synthesis syn_keep = 1 */,
  output  wire        mac_wt_root_clk        /* synthesis syn_keep = 1 */,
  output  wire        mac_core_root_clk      /* synthesis syn_keep = 1 */,
  output  wire        mac_lp_clk,
  output  wire        phy_root_clk       /* synthesis syn_keep = 1 */,
`ifdef  RW_EMBEDDED_LA
  output  wire        la_root_clk       /* synthesis syn_keep = 1 */,
`endif//RW_EMBEDDED_LA

  /* status */                                              
  output wire         mmc0_lock,
  output wire         mmc1_lock,                                                
//  output wire         mmc2_lock,
//  output wire         mmc3_lock,
  output wire         mmc4_lock,
  output wire         mmc5_lock,
  output wire         mmc6_lock
 
);
  
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire plf_clk;
  
  /* root clocks */
  wire mac_lp_root_clk    /* synthesis syn_keep = 1 */;

  /*****************************************************************************
  * MMC dynamic configuration
  *****************************************************************************/
  wire        dcfg_mmc1_rst,   dcfg_mmc2_rst,   dcfg_mmc4_rst,   dcfg_mmc5_rst,   dcfg_mmc6_rst;
  wire        dcfg_mmc1_den,   dcfg_mmc2_den,   dcfg_mmc4_den,   dcfg_mmc5_den,   dcfg_mmc6_den;
  wire        dcfg_mmc1_dwe,   dcfg_mmc2_dwe,   dcfg_mmc4_dwe,   dcfg_mmc5_dwe,   dcfg_mmc6_dwe;
  wire [ 6:0] dcfg_mmc1_daddr, dcfg_mmc2_daddr, dcfg_mmc4_daddr, dcfg_mmc5_daddr, dcfg_mmc6_daddr;
  wire [15:0] dcfg_mmc1_di,    dcfg_mmc2_di,    dcfg_mmc4_di,    dcfg_mmc5_di,    dcfg_mmc6_di;
  wire [15:0] dcfg_mmc1_do,    dcfg_mmc2_do,    dcfg_mmc4_do,    dcfg_mmc5_do,    dcfg_mmc6_do;
  wire        dcfg_mmc1_drdy,  dcfg_mmc2_drdy,  dcfg_mmc4_drdy,  dcfg_mmc5_drdy,  dcfg_mmc6_drdy;
  
  // MMC2 not used
  assign dcfg_mmc2_do = 16'd0;
  assign dcfg_mmc2_drdy = 1'b0;
    
  rw_he_crm_mmc_config u_rw_he_crm_mmc_config
  (
    /* system */
    .clk(                 plf_clk),
    .rst_n(               sys_rst_n),
    /* register bank interface */
    .regb_start(          regb_dyncfgmmc_start),
    .regb_sel(            regb_dyncfgmmc_sel[2:0]),
    .regb_addr(           regb_dyncfgmmc_addr[6:0]),
    .regb_we(             regb_dyncfgmmc_we),
    .regb_wdata(          regb_dyncfgmmc_wdata),
    .regb_rdata(          regb_dyncfgmmc_rdata),
    .regb_done(           regb_dyncfgmmc_done),
    /* mmc0 interface */
    .mmc0_rst(            dcfg_mmc1_rst),
    .mmc0_den(            dcfg_mmc1_den),
    .mmc0_dwe(            dcfg_mmc1_dwe),
    .mmc0_daddr(          dcfg_mmc1_daddr),
    .mmc0_di(             dcfg_mmc1_di),
    .mmc0_do(             dcfg_mmc1_do),
    .mmc0_drdy(           dcfg_mmc1_drdy),
    /* mmc1 interface */
    .mmc1_rst(            dcfg_mmc2_rst),
    .mmc1_den(            dcfg_mmc2_den),
    .mmc1_dwe(            dcfg_mmc2_dwe),
    .mmc1_daddr(          dcfg_mmc2_daddr),
    .mmc1_di(             dcfg_mmc2_di),
    .mmc1_do(             dcfg_mmc2_do),
    .mmc1_drdy(           dcfg_mmc2_drdy),
    /* mmc2 interface */
    .mmc2_rst(            dcfg_mmc4_rst),
    .mmc2_den(            dcfg_mmc4_den),
    .mmc2_dwe(            dcfg_mmc4_dwe),
    .mmc2_daddr(          dcfg_mmc4_daddr),
    .mmc2_di(             dcfg_mmc4_di),
    .mmc2_do(             dcfg_mmc4_do),
    .mmc2_drdy(           dcfg_mmc4_drdy),
    /* mmc3 interface */
    .mmc3_rst(            dcfg_mmc5_rst),
    .mmc3_den(            dcfg_mmc5_den),
    .mmc3_dwe(            dcfg_mmc5_dwe),
    .mmc3_daddr(          dcfg_mmc5_daddr),
    .mmc3_di(             dcfg_mmc5_di),
    .mmc3_do(             dcfg_mmc5_do),
    .mmc3_drdy(           dcfg_mmc5_drdy),
    /* mmc4 interface */
    .mmc4_rst(            dcfg_mmc6_rst),
    .mmc4_den(            dcfg_mmc6_den),
    .mmc4_dwe(            dcfg_mmc6_dwe),
    .mmc4_daddr(          dcfg_mmc6_daddr),
    .mmc4_di(             dcfg_mmc6_di),
    .mmc4_do(             dcfg_mmc6_do),
    .mmc4_drdy(           dcfg_mmc6_drdy)
  );
  

  /*****************************************************************************
  * 25 MHz reference clock => used to generate MAC and platform clocks
  *****************************************************************************/
  wire ref25_clk;

  /*****************************************************************************
  * 25 MHz reference clock
  *****************************************************************************/
  BUFG u_clk_ext_25_bufg
  (
    .I(                clk_ext_25),
    .O(                ref25_clk )
  );

  /*****************************************************************************
  * clock dividers based on MMCM cells
  *****************************************************************************/
  wire mmc0_rst;
  wire mmc1_rst;
  wire mmc2_rst;
  wire mmc3_rst;
  wire mmc4_rst;
  wire mmc5_rst;
  wire mmc6_rst;
  
  assign mmc0_rst        = 1'b0;
  assign mmc1_rst        = ~sys_rst_n | dcfg_mmc1_rst;
  assign mmc2_rst        = ~sys_rst_n | dcfg_mmc2_rst;
  assign mmc3_rst        = ~sys_rst_n;
  assign mmc4_rst        = ~sys_rst_n | dcfg_mmc4_rst;
  assign mmc5_rst        = dcfg_mmc5_rst; // Clock is needed to release sys_rst_n
  assign mmc6_rst        = ~sys_rst_n | dcfg_mmc6_rst;
 

  /*****************************************************************************
  * MMC5: PLatform
  *****************************************************************************/
  // for now only define MACPI_CLK_FREQ 80 supported
  wire mmc5_fb;
  wire plf_prebufg;
 
  MMCM_ADV #(
    .CLKIN1_PERIOD   (40              ), // CLKIN  :   25.0MHz
    .DIVCLK_DIVIDE   (1               ),
    .CLKFBOUT_MULT_F (48              ), // CLKVCO : 1200.0MHz
    .CLKOUT0_DIVIDE_F(15              )  // CLKOUT0:   80.0MHz
  ) u_mmc5 (
    .RST             (mmc5_rst        ),
    .PWRDWN          (1'b0            ),
    
    .DCLK            (plf_clk         ),
    .DEN             (dcfg_mmc5_den   ),
    .DADDR           (dcfg_mmc5_daddr ),
    .DWE             (dcfg_mmc5_dwe   ),
    .DI              (dcfg_mmc5_di    ),
    .DO              (dcfg_mmc5_do    ),
    .DRDY            (dcfg_mmc5_drdy  ),
    
    .PSCLK           (1'b0            ),
    .PSEN            (1'b0            ),
    .PSINCDEC        (1'b0            ),
    .PSDONE          (/*Open*/        ),
    
    .CLKINSTOPPED    (/*Open*/        ),
    .CLKFBSTOPPED    (/*Open*/        ),
    
    .CLKINSEL        (1'b1            ),
    .CLKIN1          (ref25_clk       ),
    .CLKIN2          (1'b0            ),
    .CLKFBIN         (mmc5_fb         ),
    
    .CLKOUT0         (plf_prebufg     ),
    .CLKOUT0B        (/*Open*/        ),
    .CLKOUT1         (/*Open*/        ),
    .CLKOUT1B        (/*Open*/        ),
    .CLKOUT2         (/*Open*/        ),
    .CLKOUT2B        (/*Open*/        ),
    .CLKOUT3         (/*Open*/        ),
    .CLKOUT3B        (/*Open*/        ),
    .CLKOUT4         (/*Open*/        ),
    .CLKOUT5         (/*Open*/        ),
    .CLKOUT6         (/*Open*/        ),
    .CLKFBOUT        (mmc5_fb         ),
    .CLKFBOUTB       (/*Open*/        ),
    .LOCKED          (mmc5_lock       )
  );


  /*****************************************************************************
  * MMC0: 20 MHz and 200MHz
  *****************************************************************************/
  wire mmc0_fb;
  wire ref200_prebufg;
  wire plf20_prebufg;
  
  MMCM_BASE #(
    .CLKIN1_PERIOD   (40             ), // CLKIN  :   25.0MHz
    .DIVCLK_DIVIDE   (1              ),
    .CLKFBOUT_MULT_F (48             ), // CLKVCO : 1200.0MHz
    .CLKOUT0_DIVIDE_F(6              ), // CLKOUT0:  200.0MHz
    .CLKOUT1_DIVIDE  (60             )  // CLKOUT1:   20.0MHz
  ) u_mmc0 (
    .RST             (mmc0_rst       ),
    .PWRDWN          (1'b0           ),
    
    .CLKIN1          (ref25_clk      ),
    .CLKFBIN         (mmc0_fb        ),
    
    .CLKOUT0         (ref200_prebufg ),
    .CLKOUT0B        (/*Open*/       ),
    .CLKOUT1         (plf20_prebufg  ),
    .CLKOUT1B        (/*Open*/       ),
    .CLKOUT2         (/*Open*/       ),
    .CLKOUT2B        (/*Open*/       ),
    .CLKOUT3         (/*Open*/       ),
    .CLKOUT3B        (/*Open*/       ),
    .CLKOUT4         (/*Open*/       ),
    .CLKOUT5         (/*Open*/       ),
    .CLKOUT6         (/*Open*/       ),
    .CLKFBOUT        (mmc0_fb        ),
    .CLKFBOUTB       (/*Open*/       ),
    .LOCKED          (mmc0_lock      )
  );
  
  /* plf_root_clk */
  BUFGMUX_CTRL u_plf_bufg (
    .I0(               plf_prebufg),
    .I1(               plf20_prebufg),
    .S(                regb_plfclk_sel),
    .O(                plf_root_clk)
  );
  assign plf_clk = plf_root_clk;

  /* ref200_root_clk */
  BUFG u_ref200_bufg
  (
    .I(                ref200_prebufg),
    .O(                ref200_root_clk)
  );


  /*****************************************************************************
  * Generate low-power MAC clock from 200 MHz ref clock200 MHz reference clock (Virtex7 fabric calibration)
  *****************************************************************************/

  reg  mac_lp_clk_gen;
  wire [11:0] n_mac_lp_clk_cnt;
  reg  [11:0] mac_lp_clk_cnt;
  // generation of a 32kHz clock from the 200MHz clock
  assign n_mac_lp_clk_cnt[11:8] = mac_lp_clk_cnt[11:8] + {3'd0,&mac_lp_clk_cnt[7:0]};
  assign n_mac_lp_clk_cnt[ 7:4] = mac_lp_clk_cnt[ 7:4] + {3'd0,&mac_lp_clk_cnt[3:0]};
  assign n_mac_lp_clk_cnt[ 3:0] = mac_lp_clk_cnt[ 3:0] + {3'd0,1'b1};
  
  always @(posedge ref200_root_clk or negedge ref200_rst_n)
  begin
    if(ref200_rst_n==1'b0)
    begin
      mac_lp_clk_gen <= 1'b0; 
      mac_lp_clk_cnt <= 12'b0;
    end
    else
    begin 
      if (mac_lp_clk_cnt == 12'd3124)
      begin
        mac_lp_clk_gen <= ~mac_lp_clk_gen;
        mac_lp_clk_cnt <= 12'b0;
      end
      else
        mac_lp_clk_cnt <= n_mac_lp_clk_cnt;
    end
  end


  /*****************************************************************************
  * MMC4: MAC Core, WT
  *****************************************************************************/
  // for now only define MAC_FREQ 40 supported, with WEP_2_BB_CLK_RATIO 2
  wire mmc4_fb;
  wire mac_core_clk_prebufg;
  wire mac_wt_clk_prebufg;

  MMCM_ADV #(
`ifdef  MAC_FREQ_80MHZ
    .CLKOUT1_DIVIDE  (15                   ), // CLKOUT1:   80.0MHz
    .CLKOUT2_DIVIDE  (15                   ), // CLKOUT2:   80.0MHz
`endif//MAC_FREQ_80MHZ

`ifdef  MAC_FREQ_60MHZ
    .CLKOUT1_DIVIDE  (20                   ), // CLKOUT1:   60.0MHz
    .CLKOUT2_DIVIDE  (20                   ), // CLKOUT2:   60.0MHz
`endif//MAC_FREQ_60MHZ

`ifdef  MAC_FREQ_40MHZ
    .CLKOUT1_DIVIDE  (30                   ), // CLKOUT1:   40.0MHz
    .CLKOUT2_DIVIDE  (15                   ), // CLKOUT2:   80.0MHz
`endif//MAC_FREQ_40MHZ


    .CLKIN1_PERIOD   (40                   ), // CLKIN  :   25.0MHz
    .DIVCLK_DIVIDE   (1                    ),
    .CLKFBOUT_MULT_F (48                   )  // CLKVCO : 1200.0MHz
  ) u_mmc4 (
    .RST             (mmc4_rst             ),
    .PWRDWN          (1'b0                 ),
    
    .DCLK            (plf_clk              ),
    .DEN             (dcfg_mmc4_den        ),
    .DADDR           (dcfg_mmc4_daddr      ),
    .DWE             (dcfg_mmc4_dwe        ),
    .DI              (dcfg_mmc4_di         ),
    .DO              (dcfg_mmc4_do         ),
    .DRDY            (dcfg_mmc4_drdy       ),
    
    .PSCLK           (1'b0                 ),
    .PSEN            (1'b0                 ),
    .PSINCDEC        (1'b0                 ),
    .PSDONE          (/*Open*/             ),
    
    .CLKINSTOPPED    (/*Open*/             ),
    .CLKFBSTOPPED    (/*Open*/             ),
    
    .CLKINSEL        (1'b1                 ),
    .CLKIN1          (ref25_clk            ),
    .CLKIN2          (1'b0                 ),
    .CLKFBIN         (mmc4_fb              ),
    
    .CLKOUT0         (/*Open*/             ),
    .CLKOUT0B        (/*Open*/             ),
    .CLKOUT1         (mac_core_clk_prebufg ),
    .CLKOUT1B        (/*Open*/             ),
    .CLKOUT2         (mac_wt_clk_prebufg   ),
    .CLKOUT2B        (/*Open*/             ),
    .CLKOUT3         (/*Open*/             ),
    .CLKOUT3B        (/*Open*/             ),
    .CLKOUT4         (/*Open*/             ),
    .CLKOUT5         (/*Open*/             ),
    .CLKOUT6         (/*Open*/             ),
    .CLKFBOUT        (mmc4_fb              ),
    .CLKFBOUTB       (/*Open*/             ),
    .LOCKED          (mmc4_lock            ) 
  );
  
  /* mac_core_root_clk */
  BUFG mac_core_clk_bufg (
    .I            (mac_core_clk_prebufg ),
    .O            (mac_core_root_clk    )
  ); 

  /* mac_wt_root_clk */
  BUFG mac_wt_clk_bufg (
    .I            (mac_wt_clk_prebufg   ),
    .O            (mac_wt_root_clk      )
  ); 


  /*****************************************************************************
  * Mux for lp clock: low-power or mac_core
  *****************************************************************************/
  /* #( .CLK_SEL_TYPE ("ASYNC"              ))  */
  BUFGMUX_CTRL mac_lp_clk_bufgmux (
    .I0           (mac_core_clk_prebufg ),
    .I1           (mac_lp_clk_gen       ),
    .S            (mac_lp_clkswitch     ),
    .O            (mac_lp_root_clk      )
   );
  assign mac_lp_clk = mac_lp_root_clk;


  /*****************************************************************************
  * 40 MHz reference clock => used to generate PHY clocks
  *****************************************************************************/
  /* fsys : rf 40MHz reference clock */
  wire fsys_premmc;
  BUFG u_karst_fsys_bufg
  (
    .I(             fsys_prebufg),
    .O(             fsys_premmc)
  );

  
  /*****************************************************************************
  * MMC1: PHY,MPIF,LA
  *****************************************************************************/
  wire mmc1_fb;
  wire ref40_prebufg;
  wire ref80_prebufg;
  wire fe_prebufg;
  wire phy_prebufg;
//  wire mpif_prebufg;
`ifdef  RW_EMBEDDED_LA
  wire la_prebufg;
`endif//  RW_EMBEDDED_LA

  MMCM_ADV
  #(
    .CLKIN1_PERIOD(    25),         // CLKIN: 40 MHz
    .DIVCLK_DIVIDE(    1),
    .CLKFBOUT_MULT_F(  24),         // CLKVCO : 960M                24x40MHz
    .CLKOUT0_DIVIDE_F(  8),         // CLKOUT0: 120M                la
    .CLKOUT1_DIVIDE(   16),         // CLKOUT1:  60M                svd
    .CLKOUT2_DIVIDE(   24),         // CLKOUT2:  40M                ref40  (fe40)
    .CLKOUT3_DIVIDE(   12),         // CLKOUT3:  80M                ref80  (fe80)
    .CLKOUT4_DIVIDE(   24),         // CLKOUT4:  40M/80M/160M       ref160 (fe160,adc/dac)
    .CLKOUT5_DIVIDE(    8),         // CLKOUT5:  120M               phy    
    .CLKOUT6_DIVIDE(    8)          // CLKOUT6:  120M               mpif
  )
  u_mmc1
  (
    .RST(              mmc1_rst),
    .PWRDWN(           1'b0),
    
    .DCLK(             plf_clk),
    .DEN(              dcfg_mmc1_den),
    .DADDR(            dcfg_mmc1_daddr),
    .DWE(              dcfg_mmc1_dwe),
    .DI(               dcfg_mmc1_di),
    .DO(               dcfg_mmc1_do),
    .DRDY(             dcfg_mmc1_drdy),
    
    .PSCLK(            1'b0),
    .PSEN(             1'b0),
    .PSINCDEC(         1'b0),
    .PSDONE(           ),
    
    .CLKINSTOPPED(     ),
    .CLKFBSTOPPED(     ),
    
    .CLKINSEL(         1'b1),
    .CLKIN1(           fsys_premmc),
    .CLKIN2(           1'b0),
    .CLKFBIN(          mmc1_fb),
  
`ifdef  RW_EMBEDDED_LA
    .CLKOUT0(          la_prebufg),
`else
    .CLKOUT0(          ),
`endif//  RW_EMBEDDED_LA
    .CLKOUT0B(         ),
    .CLKOUT1(          ),
    .CLKOUT1B(         ),
    .CLKOUT2(          ref40_prebufg),
    .CLKOUT2B(         ),
    .CLKOUT3(          ref80_prebufg),
    .CLKOUT3B(         ),
    .CLKOUT4(          fe_prebufg),
    .CLKOUT5(          phy_prebufg),
    .CLKOUT6(          ), // mpif_prebufg
    .CLKFBOUT(         mmc1_fb),
    .CLKFBOUTB(        ),
    .LOCKED(           mmc1_lock)
  );
 
  /* REF40 */
  BUFG u_ref40_bufg
  (
    .I(                ref40_prebufg),
    .O(                ref40_root_clk)
  );

  /* REF80 */
  BUFG u_ref80_bufg
  (
    .I(                ref80_prebufg),
    .O(                ref80_root_clk)
  );

  /* FE */
  BUFG u_fe_prebufg
  (
    .I(                fe_prebufg),
    .O(                fe_root_clk)
  );

  /* REFPHY */
  BUFG u_phy_bufg
  (
    .I(                phy_prebufg),
    .O(                phy_root_clk)
  );

`ifdef  RW_EMBEDDED_LA
  /* LA */
  BUFG u_la_bufg
  (
    .I(                la_prebufg),        
    .O(                la_root_clk)
  );
`endif//  RW_EMBEDDED_LA

  /*****************************************************************************
  * MMC6: 44MHz
  *****************************************************************************/
  wire mmc6_fb;
  wire ref44_prebufg;

  MMCM_ADV
  #(
    .CLKIN1_PERIOD    (25),         // CLKIN: 40 MHz
    .DIVCLK_DIVIDE    (1),
    .CLKFBOUT_MULT_F  (22),         // CLKVCO : 880.0M                  22x40MHz
    .CLKOUT1_DIVIDE   (20)          // CLKOUT1:  44.0M                  mdmb
  ) 
  u_mmc6
  (
    .RST(              mmc6_rst),
    .PWRDWN(           1'b0),
    
    .DCLK(             plf_clk),
    .DEN(              dcfg_mmc6_den),
    .DADDR(            dcfg_mmc6_daddr),
    .DWE(              dcfg_mmc6_dwe),
    .DI(               dcfg_mmc6_di),
    .DO(               dcfg_mmc6_do),
    .DRDY(             dcfg_mmc6_drdy),
    
    .PSCLK(            1'b0),
    .PSEN(             1'b0),
    .PSINCDEC(         1'b0),
    .PSDONE(           ),
    
    .CLKINSTOPPED(     ),
    .CLKFBSTOPPED(     ),
    
    .CLKINSEL(         1'b1),
    .CLKIN1(           fsys_premmc),
    .CLKIN2(           1'b0),
    .CLKFBIN(          mmc6_fb),
  
    .CLKOUT0(          ),
    .CLKOUT0B(         ),
    .CLKOUT1(          ref44_prebufg),
    .CLKOUT1B(         ),
    .CLKOUT2(          ),
    .CLKOUT2B(         ),
    .CLKOUT3(          ),
    .CLKOUT3B(         ),
    .CLKOUT4(          ),
    .CLKOUT5(          ),
    .CLKOUT6(          ),
    .CLKFBOUT(         mmc6_fb),
    .CLKFBOUTB(        ),
    
    .LOCKED(           mmc6_lock)
  );
 
  /* ref44_root_clk */
  BUFG u_ref44_bufg
  (
    .I(                ref44_prebufg),
    .O(                ref44_root_clk)
  );


endmodule
`default_nettype wire
