/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_mmc_config
(
  /* system */
  input  wire        clk,
  input  wire        rst_n,
  
  /* register bank interface */
  input  wire        regb_start,
  input  wire [ 2:0] regb_sel,
  input  wire [ 6:0] regb_addr,
  input  wire        regb_we,
  input  wire [15:0] regb_wdata,
  output reg  [15:0] regb_rdata,
  output reg         regb_done,
  
  /* mmc0 interface */
  output reg         mmc0_rst,
  output reg         mmc0_den,
  output reg         mmc0_dwe,
  output reg  [ 6:0] mmc0_daddr,
  output reg  [15:0] mmc0_di,
  input  wire [15:0] mmc0_do,
  input  wire        mmc0_drdy,

  /* mmc1 interface */
  output reg         mmc1_rst,
  output reg         mmc1_den,
  output reg         mmc1_dwe,
  output reg  [ 6:0] mmc1_daddr,
  output reg  [15:0] mmc1_di,
  input  wire [15:0] mmc1_do,
  input  wire        mmc1_drdy,

  /* mmc2 interface */
  output reg         mmc2_rst,
  output reg         mmc2_den,
  output reg         mmc2_dwe,
  output reg  [ 6:0] mmc2_daddr,
  output reg  [15:0] mmc2_di,
  input  wire [15:0] mmc2_do,
  input  wire        mmc2_drdy,

  /* mmc3 interface */
  output reg         mmc3_rst,
  output reg         mmc3_den,
  output reg         mmc3_dwe,
  output reg  [ 6:0] mmc3_daddr,
  output reg  [15:0] mmc3_di,
  input  wire [15:0] mmc3_do,
  input  wire        mmc3_drdy,

  /* mmc4 interface */
  output reg         mmc4_rst,
  output reg         mmc4_den,
  output reg         mmc4_dwe,
  output reg  [ 6:0] mmc4_daddr,
  output reg  [15:0] mmc4_di,
  input  wire [15:0] mmc4_do,
  input  wire        mmc4_drdy
);
  localparam S_IDLE=2'd0,S_DO_RESET=2'd1,S_WAIT_DRDY=2'd2,S_WAIT_DONE=2'd3;
  reg [ 1:0] state; 
  reg        regb_start_1t,regb_start_2t;   
  
  // MMCM DRP output registered
  reg        mmc0_drdy_reg = 0;
  reg        mmc1_drdy_reg = 0;
  reg        mmc2_drdy_reg = 0;
  reg        mmc3_drdy_reg = 0;
  reg        mmc4_drdy_reg = 0;
  reg [15:0] mmc0_do_reg   = 0;
  reg [15:0] mmc1_do_reg   = 0;
  reg [15:0] mmc2_do_reg   = 0;
  reg [15:0] mmc3_do_reg   = 0;
  reg [15:0] mmc4_do_reg   = 0;

  always @(posedge clk)
  begin
    mmc0_drdy_reg <= mmc0_drdy;
    mmc1_drdy_reg <= mmc1_drdy;
    mmc2_drdy_reg <= mmc2_drdy;
    mmc3_drdy_reg <= mmc3_drdy;
    mmc4_drdy_reg <= mmc4_drdy;

    mmc0_do_reg   <= mmc0_do;
    mmc1_do_reg   <= mmc1_do;
    mmc2_do_reg   <= mmc2_do;
    mmc3_do_reg   <= mmc3_do;
    mmc4_do_reg   <= mmc4_do;
  end


  always @(posedge clk,negedge rst_n)
    if(!rst_n)
    begin
      regb_start_1t <= 1'b0;
      regb_start_2t <= 1'b0;   
      regb_done     <= 1'b0;
      regb_rdata    <= 16'd0;
      mmc0_rst      <= 1'b0;   
      mmc0_den      <= 1'b0;   
      mmc0_dwe      <= 1'b0;   
      mmc0_daddr    <= 7'b0;   
      mmc0_di       <= 16'b0; 
      mmc1_rst      <= 1'b0;   
      mmc1_den      <= 1'b0;   
      mmc1_dwe      <= 1'b0;   
      mmc1_daddr    <= 7'b0;   
      mmc1_di       <= 16'b0; 
      mmc2_rst      <= 1'b0;   
      mmc2_den      <= 1'b0;   
      mmc2_dwe      <= 1'b0;   
      mmc2_daddr    <= 7'b0;   
      mmc2_di       <= 16'b0; 
      mmc3_rst      <= 1'b0;   
      mmc3_den      <= 1'b0;   
      mmc3_dwe      <= 1'b0;   
      mmc3_daddr    <= 7'b0;   
      mmc3_di       <= 16'b0;
      mmc4_rst      <= 1'b0;   
      mmc4_den      <= 1'b0;   
      mmc4_dwe      <= 1'b0;   
      mmc4_daddr    <= 7'b0;   
      mmc4_di       <= 16'b0; 
      state         <= S_IDLE; 
    end
    else
    begin
      /* resynchro */
      regb_start_1t <= regb_start;
      regb_start_2t <= regb_start_1t;
      
      /* fsm */
      case(state)
        S_IDLE:
        begin
          if(regb_start_2t)
          begin
            case(regb_sel[2:0])
            3'b000:  mmc0_rst <= 1'b1;
            3'b001:  mmc1_rst <= 1'b1;
            3'b010:  mmc2_rst <= 1'b1;
            3'b011:  mmc3_rst <= 1'b1;
            default: mmc4_rst <= 1'b1;
            endcase
            state   <= S_DO_RESET;
          end
        end
        S_DO_RESET:
        begin
          case(regb_sel[2:0])
          3'b000:
          begin
            mmc0_daddr <= regb_addr[6:0];
            mmc0_den   <= 1'b1;
            if(regb_we)
            begin
              mmc0_di  <= regb_wdata;
              mmc0_dwe <= 1'b1;
            end
          end
          3'b001:
          begin
            mmc1_daddr <= regb_addr[6:0];
            mmc1_den   <= 1'b1;
            if(regb_we)
            begin
              mmc1_di  <= regb_wdata;
              mmc1_dwe <= 1'b1;
            end
          end
          3'b010:
          begin
            mmc2_daddr <= regb_addr[6:0];
            mmc2_den   <= 1'b1;
            if(regb_we)
            begin
              mmc2_di  <= regb_wdata;
              mmc2_dwe <= 1'b1;
            end
          end
          3'b011:
          begin
            mmc3_daddr <= regb_addr[6:0];
            mmc3_den   <= 1'b1;
            if(regb_we)
            begin
              mmc3_di  <= regb_wdata;
              mmc3_dwe <= 1'b1;
            end
          end
          default:
          begin
            mmc4_daddr <= regb_addr[6:0];
            mmc4_den   <= 1'b1;
            if(regb_we)
            begin
              mmc4_di  <= regb_wdata;
              mmc4_dwe <= 1'b1;
            end
          end
          endcase
          state <= S_WAIT_DRDY;
        end
        S_WAIT_DRDY:
        begin
          case(regb_sel[2:0])
          3'b000:
          begin
            mmc0_daddr <= 7'b0;
            mmc0_den   <= 1'b0;
            mmc0_dwe   <= 1'b0;
            if(mmc0_drdy_reg)
            begin
              if(!regb_we)
              begin
                regb_rdata<= mmc0_do_reg;
              end
              mmc0_rst  <= 1'b0;
              regb_done <= 1'b1;
              state     <= S_WAIT_DONE;
            end
          end
          3'b001:
          begin
            mmc1_daddr <= 7'b0;
            mmc1_den   <= 1'b0;
            mmc1_dwe   <= 1'b0;
            if(mmc1_drdy_reg)
            begin
              if(!regb_we)
              begin
                regb_rdata<= mmc1_do_reg;
              end
              mmc1_rst  <= 1'b0;
              regb_done <= 1'b1;
              state     <= S_WAIT_DONE;
            end
          end
          3'b010:
          begin
            mmc2_daddr <= 7'b0;
            mmc2_den   <= 1'b0;
            mmc2_dwe   <= 1'b0;
            if(mmc2_drdy_reg)
            begin
              if(!regb_we)
              begin
                regb_rdata<= mmc2_do_reg;
              end
              mmc2_rst  <= 1'b0;
              regb_done <= 1'b1;
              state     <= S_WAIT_DONE;
            end
          end
          3'b011:
          begin
            mmc3_daddr <= 7'b0;
            mmc3_den   <= 1'b0;
            mmc3_dwe   <= 1'b0;
            if(mmc3_drdy_reg)
            begin
              if(!regb_we)
              begin
                regb_rdata<= mmc3_do_reg;
              end
              mmc3_rst  <= 1'b0;
              regb_done <= 1'b1;
              state     <= S_WAIT_DONE;
            end
          end
          default:
          begin
            mmc4_daddr <= 7'b0;
            mmc4_den   <= 1'b0;
            mmc4_dwe   <= 1'b0;
            if(mmc4_drdy_reg)
            begin
              if(!regb_we)
              begin
                regb_rdata<= mmc4_do_reg;
              end
              mmc4_rst  <= 1'b0;
              regb_done <= 1'b1;
              state     <= S_WAIT_DONE;
            end
          end
          endcase
        end 
        default: /* S_WAIT_DONE */
        begin
          if(!regb_start_2t)
          begin
            regb_done <= 1'b0;
            state     <= S_IDLE;
          end
        end
      endcase
    end

`ifdef RW_SIMU_ON
  reg [32*8-1:0] state_str;
  always @(*)
    case(state)
      S_IDLE:      state_str = "S_IDLE";
      S_DO_RESET:  state_str = "S_DO_RESET";
      S_WAIT_DRDY: state_str = "S_WAIT_DRDY";
      S_WAIT_DONE: state_str = "S_WAIT_DONE";
      default:     state_str = "XXXXXXXXXX";
    endcase
`endif

endmodule
`default_nettype wire
