//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : rw_he_crm_reg registers
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rw_he_crm_reg (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    input wire            ahb_nrst,  // AHB Hard Reset
    input wire            ahb_clk,   // AHB clock

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g CLKRST_STAT register.
    input wire [6 : 0]    mmc_lock                     , // Provide the lock indication of each MMC
    //$port_g DYNCFGMMC_CNTL register.
    input wire            dyncfgmmc_done               , // Indicate the completion of MMC configuration
    input wire            fmetre_done                  , // Indicate the completion of the frequency meters measurement
    //$port_g DYNCFGMMC_DATA register.
    input wire [15 : 0]   dyncfgmmc_rdata              , // Read data from MMC
    //$port_g FMETRE_REF44 register.
    input wire [19 : 0]   fmetre_ref44                 , // Return the frequency of the 44MHz reference clock
    //$port_g FMETRE_REF30 register.
    input wire [19 : 0]   fmetre_ref30                 , // Return the frequency of the 30MHz reference clock
    //$port_g FMETRE_REF60 register.
    input wire [19 : 0]   fmetre_ref60                 , // Return the frequency of the 60MHz reference clock
    //$port_g FMETRE_REF40 register.
    input wire [19 : 0]   fmetre_ref40                 , // Return the frequency of the 40MHz reference clock
    //$port_g FMETRE_REF80 register.
    input wire [19 : 0]   fmetre_ref80                 , // Return the frequency of the 80MHz reference clock
    //$port_g FMETRE_FE register.
    input wire [19 : 0]   fmetre_fe                    , // Return the frequency of the Front End clock
    //$port_g FMETRE_BD register.
    input wire [19 : 0]   fmetre_bd                    , // Return the frequency of the Bit Domain clock
    //$port_g FMETRE_PHY register.
    input wire [19 : 0]   fmetre_phy                   , // Return the frequency of the PHY clock
    //$port_g FMETRE_MPIF register.
    input wire [19 : 0]   fmetre_mpif                  , // Return the frequency of the MAC-PHY Interface clock
    //$port_g FMETRE_LA register.
    input wire [19 : 0]   fmetre_la                    , // Return the frequency of the Logic Analyzer clock
    //$port_g FMETRE_MACCORE register.
    input wire [19 : 0]   fmetre_maccore               , // Return the frequency of the MAC Core clock
    //$port_g FMETRE_MACWT register.
    input wire [19 : 0]   fmetre_macwt                 , // Return the frequency of the MACWT clock
    //$port_g FMETRE_PLF register.
    input wire [19 : 0]   fmetre_plf                   , // Return the frequency of the platform clock
    //
    //$port_g CLKRST_CNTL register.
    output wire [1 : 0]    macwtclk_ratio_sel          , // Configure Clock ratio for wep/tkip clock
    output wire [3 : 0]    maccoreclk_freq_sel         , // Configure divider of reference clock for MACCORE clock generation
    output wire [1 : 0]    feclk_freq_sel              , // Configure FE clock frequency
    output wire            plfclk_sel                  , // 0: select the fixed platform clock
    //$port_g CLKGATEPHYFCTRL0 register.
    output wire            phytxclkforce               , // PHY Transmit clock gating  1:  Software override(forces the clock to run)   0 : disabled
    output wire            bdtxclkforce                , // BD Tx clock gating   1:  Software override(forces the clock to run)   0 : disabled
    output wire            agcmemclkforce              , // AGC memory clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            agcclkforce                 , // AGC clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            rcclkforce                  , // RC clock gating   1:  Software override(forces the clock to run)   0 : disabled
    output wire            feclkforce                  , // Front end clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            fdoclkforce                 , // FDO clock gating   1:  Software override(forces the clock to run) 0 : disabled
    output wire            equclkforce                 , // Equalizer clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            physvdclkforce              , // PHY SVD clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            tdcompclkforce              , // TD Compensation blocks clock gating  1:  Software override(forces the clock to run)   0 : disabled
    output wire            tdfoestclkforce             , // TDFO Estimation clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            tbeclkforce                 , // TBE clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            fft1memclkforce             , // FFT 1 memory clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            fft1clkforce                , // FFT 1 clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            fft0memclkforce             , // FFT 0 memory clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            fft0clkforce                , // FFT 0 clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            chestclkforce               , // Channel Estimation clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            hmemclkforce                , // H/G memory clock gating 1:  Software override(forces the clock to run)  0 : disabled
    output wire            intlvmemclkforce            , // Interleaver memory clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            vtb1clkforce                , // Viterbi 1 clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            vtb0clkforce                , // Viterbi 0 clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            bdrxclkforce                , // BD Rx clock gating   1:  Software override(forces the clock to run)   0 : disabled
    //$port_g CLKGATEPHYFCTRL1 register.
    output wire            radartimclkforce            , // Radar clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            mdmbtxclkforce              , // 11b modem Transmit clock gating  1:  Software override(forces the clock to run)  0 : disabled
    output wire            mdmbrxclkforce              , // 11 b modem Receive clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            ldpcencclkforce             , // LDPC Tx encoder clock gating  1:  Software override(forces the clock to run) 0 : disabled
    output wire            ldpcdecclkforce             , // LDPC Rx decoder clock gating  1:  Software override(forces the clock to run) 0 : disabled
    //$port_g RSTCTRL register.
    output wire            rcswreset                   , // SW reset of RC
    output wire            agcswreset                  , // SW reset of AGC
    output wire            physwreset                  , // SW reset of PHY
    //$port_g DYNCFGMMC_CNTL register.
    output wire            fmetre_start                , // Start the frequency meters
    output wire            dyncfgmmc_start             , // Start the MMC Configuration
    //$port_g DYNCFGMMC_ADDR register.
    output wire            dyncfgmmc_we                , // MMC Configuration Write
    output wire [3 : 0]    dyncfgmmc_sel               , // MMC to be configured
    output wire [15 : 0]   dyncfgmmc_addr              , // This register indicates the ADDR and MMC selection to be reprogrammed
    //$port_g DYNCFGMMC_DATA register.
    output wire [15 : 0]   dyncfgmmc_wdata             , // Data to be written in the MMC.
    //$port_g LA_SAMPLING_FREQ register.
    output wire [7 : 0]    la_sampling_freq            , // This register configures the Logic Analyzer clock frequency

    ////////////////////////////////////////////
    //$port_g Bus interface
    ////////////////////////////////////////////
    input  wire            hready_in,
    input  wire            hsel,
    input  wire [9:0]     haddr,
    input  wire [ 1:0]     htrans,
    input  wire            hwrite,
    input  wire [31:0]     hwdata,
    output wire [31:0]     hrdata,
    output wire [ 1:0]     hresp,
    output wire            hready
    );
  
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Constants for registers addresses
  //////////////////////////////////////////////////////////////////////////////
  // Register configuration
  

  // Constants for register addresses.
  localparam RW_HE_CRM_CLKRST_CNTL_ADDR_CT    = 8'b00000010;
  localparam RW_HE_CRM_CLKRST_STAT_ADDR_CT    = 8'b00000011;
  localparam RW_HE_CRM_CLKGATEPHYFCTRL0_ADDR_CT = 8'b00000100;
  localparam RW_HE_CRM_CLKGATEPHYFCTRL1_ADDR_CT = 8'b00000101;
  localparam RW_HE_CRM_RSTCTRL_ADDR_CT        = 8'b00000110;
  localparam RW_HE_CRM_DYNCFGMMC_CNTL_ADDR_CT = 8'b11000000;
  localparam RW_HE_CRM_DYNCFGMMC_ADDR_ADDR_CT = 8'b11000001;
  localparam RW_HE_CRM_DYNCFGMMC_DATA_ADDR_CT = 8'b11000010;
  localparam RW_HE_CRM_FMETRE_REF44_ADDR_CT   = 8'b11000100;
  localparam RW_HE_CRM_FMETRE_REF30_ADDR_CT   = 8'b11000101;
  localparam RW_HE_CRM_FMETRE_REF60_ADDR_CT   = 8'b11000110;
  localparam RW_HE_CRM_FMETRE_REF40_ADDR_CT   = 8'b11000111;
  localparam RW_HE_CRM_FMETRE_REF80_ADDR_CT   = 8'b11001000;
  localparam RW_HE_CRM_FMETRE_FE_ADDR_CT      = 8'b11001001;
  localparam RW_HE_CRM_FMETRE_BD_ADDR_CT      = 8'b11001010;
  localparam RW_HE_CRM_FMETRE_PHY_ADDR_CT     = 8'b11001011;
  localparam RW_HE_CRM_FMETRE_MPIF_ADDR_CT    = 8'b11001100;
  localparam RW_HE_CRM_FMETRE_LA_ADDR_CT      = 8'b11001101;
  localparam RW_HE_CRM_FMETRE_MACCORE_ADDR_CT = 8'b11001110;
  localparam RW_HE_CRM_FMETRE_MACWT_ADDR_CT   = 8'b11001111;
  localparam RW_HE_CRM_FMETRE_PLF_ADDR_CT     = 8'b11010000;
  localparam RW_HE_CRM_LA_SAMPLING_FREQ_ADDR_CT = 8'b00011011;
 
  //////////////////////////////////////////////////////////////////////////////
  // Signals
  //////////////////////////////////////////////////////////////////////////////
  reg  [31: 0] int_reg_dr;
  wire [31: 0] int_reg_dw;
  reg          int_reg_rdy;
  reg          pending_write;
  reg          pending_read;
  reg   [7:0]  pending_addr;

  // CLKRST_CNTL register.
  reg [1 : 0] int_macwtclk_ratio_sel  ;
  reg [3 : 0] int_maccoreclk_freq_sel ;
  reg [1 : 0] int_feclk_freq_sel      ;
  reg         int_plfclk_sel          ;
  // CLKGATEPHYFCTRL0 register.
  reg         int_phytxclkforce       ;
  reg         int_bdtxclkforce        ;
  reg         int_agcmemclkforce      ;
  reg         int_agcclkforce         ;
  reg         int_rcclkforce          ;
  reg         int_feclkforce          ;
  reg         int_fdoclkforce         ;
  reg         int_equclkforce         ;
  reg         int_physvdclkforce      ;
  reg         int_tdcompclkforce      ;
  reg         int_tdfoestclkforce     ;
  reg         int_tbeclkforce         ;
  reg         int_fft1memclkforce     ;
  reg         int_fft1clkforce        ;
  reg         int_fft0memclkforce     ;
  reg         int_fft0clkforce        ;
  reg         int_chestclkforce       ;
  reg         int_hmemclkforce        ;
  reg         int_intlvmemclkforce    ;
  reg         int_vtb1clkforce        ;
  reg         int_vtb0clkforce        ;
  reg         int_bdrxclkforce        ;
  // CLKGATEPHYFCTRL1 register.
  reg         int_radartimclkforce    ;
  reg         int_mdmbtxclkforce      ;
  reg         int_mdmbrxclkforce      ;
  reg         int_ldpcencclkforce     ;
  reg         int_ldpcdecclkforce     ;
  // RSTCTRL register.
  reg         int_rcswreset           ;
  reg         int_agcswreset          ;
  reg         int_physwreset          ;
  // DYNCFGMMC_CNTL register.
  reg         int_fmetre_start        ;
  reg         int_dyncfgmmc_start     ;
  // DYNCFGMMC_ADDR register.
  reg         int_dyncfgmmc_we        ;
  reg [3 : 0] int_dyncfgmmc_sel       ;
  reg [15 : 0] int_dyncfgmmc_addr      ;
  // DYNCFGMMC_DATA register.
  reg [15 : 0] int_dyncfgmmc_wdata     ;
  // LA_SAMPLING_FREQ register.
  reg [7 : 0] int_la_sampling_freq    ;


  //////////////////////////////////////////////////////////////////////////////
  // Ouput linkage
  //////////////////////////////////////////////////////////////////////////////
  assign macwtclk_ratio_sel  = int_macwtclk_ratio_sel  ;
  assign maccoreclk_freq_sel = int_maccoreclk_freq_sel ;
  assign feclk_freq_sel      = int_feclk_freq_sel      ;
  assign plfclk_sel          = int_plfclk_sel          ;
  assign phytxclkforce       = int_phytxclkforce       ;
  assign bdtxclkforce        = int_bdtxclkforce        ;
  assign agcmemclkforce      = int_agcmemclkforce      ;
  assign agcclkforce         = int_agcclkforce         ;
  assign rcclkforce          = int_rcclkforce          ;
  assign feclkforce          = int_feclkforce          ;
  assign fdoclkforce         = int_fdoclkforce         ;
  assign equclkforce         = int_equclkforce         ;
  assign physvdclkforce      = int_physvdclkforce      ;
  assign tdcompclkforce      = int_tdcompclkforce      ;
  assign tdfoestclkforce     = int_tdfoestclkforce     ;
  assign tbeclkforce         = int_tbeclkforce         ;
  assign fft1memclkforce     = int_fft1memclkforce     ;
  assign fft1clkforce        = int_fft1clkforce        ;
  assign fft0memclkforce     = int_fft0memclkforce     ;
  assign fft0clkforce        = int_fft0clkforce        ;
  assign chestclkforce       = int_chestclkforce       ;
  assign hmemclkforce        = int_hmemclkforce        ;
  assign intlvmemclkforce    = int_intlvmemclkforce    ;
  assign vtb1clkforce        = int_vtb1clkforce        ;
  assign vtb0clkforce        = int_vtb0clkforce        ;
  assign bdrxclkforce        = int_bdrxclkforce        ;
  assign radartimclkforce    = int_radartimclkforce    ;
  assign mdmbtxclkforce      = int_mdmbtxclkforce      ;
  assign mdmbrxclkforce      = int_mdmbrxclkforce      ;
  assign ldpcencclkforce     = int_ldpcencclkforce     ;
  assign ldpcdecclkforce     = int_ldpcdecclkforce     ;
  assign rcswreset           = int_rcswreset           ;
  assign agcswreset          = int_agcswreset          ;
  assign physwreset          = int_physwreset          ;
  assign fmetre_start        = int_fmetre_start        ;
  assign dyncfgmmc_start     = int_dyncfgmmc_start     ;
  assign dyncfgmmc_we        = int_dyncfgmmc_we        ;
  assign dyncfgmmc_sel       = int_dyncfgmmc_sel       ;
  assign dyncfgmmc_addr      = int_dyncfgmmc_addr      ;
  assign dyncfgmmc_wdata     = int_dyncfgmmc_wdata     ;
  assign la_sampling_freq    = int_la_sampling_freq    ;


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge ahb_clk or negedge ahb_nrst)
  begin
    if (!ahb_nrst) 
    begin
      pending_write             <= 1'b0;
      pending_read              <= 1'b0;
      pending_addr              <= 8'b0;
      int_reg_dr                <= 32'b0;
      int_reg_rdy               <= 1'b1;
      // CLKRST_CNTL register.
      int_macwtclk_ratio_sel   <= 2'd`WEP_2_BB_CLK_RATIO;
      int_maccoreclk_freq_sel  <= `MACCORECLK_FREQ_SEL_RST;
      int_feclk_freq_sel       <= `FECLK_FREQ_SEL_RST;
      int_plfclk_sel           <= 1'b0;
      // CLKGATEPHYFCTRL0 register.
      int_phytxclkforce        <= 1'b0;
      int_bdtxclkforce         <= 1'b0;
      int_agcmemclkforce       <= 1'b0;
      int_agcclkforce          <= 1'b0;
      int_rcclkforce           <= 1'b0;
      int_feclkforce           <= 1'b0;
      int_fdoclkforce          <= 1'b0;
      int_equclkforce          <= 1'b0;
      int_physvdclkforce       <= 1'b0;
      int_tdcompclkforce       <= 1'b0;
      int_tdfoestclkforce      <= 1'b0;
      int_tbeclkforce          <= 1'b0;
      int_fft1memclkforce      <= 1'b0;
      int_fft1clkforce         <= 1'b0;
      int_fft0memclkforce      <= 1'b0;
      int_fft0clkforce         <= 1'b0;
      int_chestclkforce        <= 1'b0;
      int_hmemclkforce         <= 1'b0;
      int_intlvmemclkforce     <= 1'b0;
      int_vtb1clkforce         <= 1'b0;
      int_vtb0clkforce         <= 1'b0;
      int_bdrxclkforce         <= 1'b0;
      // CLKGATEPHYFCTRL1 register.
      int_radartimclkforce     <= 1'b0;
      int_mdmbtxclkforce       <= 1'b0;
      int_mdmbrxclkforce       <= 1'b0;
      int_ldpcencclkforce      <= 1'b0;
      int_ldpcdecclkforce      <= 1'b0;
      // RSTCTRL register.
      int_rcswreset            <= 1'b0;
      int_agcswreset           <= 1'b0;
      int_physwreset           <= 1'b0;
      // DYNCFGMMC_CNTL register.
      int_fmetre_start         <= 1'b0;
      int_dyncfgmmc_start      <= 1'b0;
      // DYNCFGMMC_ADDR register.
      int_dyncfgmmc_we         <= 1'b0;
      int_dyncfgmmc_sel        <= 4'b0000;
      int_dyncfgmmc_addr       <= 16'b0000000000000000;
      // DYNCFGMMC_DATA register.
      int_dyncfgmmc_wdata      <= 16'b0000000000000000;
      // LA_SAMPLING_FREQ register.
      int_la_sampling_freq     <= 8'b00000000;
    end
    else
    begin
      int_reg_rdy <= 1'b1;

      if (pending_write==1'b1)
      begin
        
        pending_write <= 1'b0;
        
        case(pending_addr)

          // Write CLKRST_CNTL register.
          RW_HE_CRM_CLKRST_CNTL_ADDR_CT :
          begin
              int_macwtclk_ratio_sel   <= int_reg_dw[13 : 12];
              int_maccoreclk_freq_sel  <= int_reg_dw[11 : 8];
              int_feclk_freq_sel       <= int_reg_dw[5 : 4];
              int_plfclk_sel           <= int_reg_dw[0];
          end

          // Write CLKGATEPHYFCTRL0 register.
          RW_HE_CRM_CLKGATEPHYFCTRL0_ADDR_CT :
          begin
              int_phytxclkforce        <= int_reg_dw[31];
              int_bdtxclkforce         <= int_reg_dw[30];
              int_agcmemclkforce       <= int_reg_dw[29];
              int_agcclkforce          <= int_reg_dw[28];
              int_rcclkforce           <= int_reg_dw[27];
              int_feclkforce           <= int_reg_dw[24];
              int_fdoclkforce          <= int_reg_dw[23];
              int_equclkforce          <= int_reg_dw[22];
              int_physvdclkforce       <= int_reg_dw[20];
              int_tdcompclkforce       <= int_reg_dw[18];
              int_tdfoestclkforce      <= int_reg_dw[17];
              int_tbeclkforce          <= int_reg_dw[16];
              int_fft1memclkforce      <= int_reg_dw[10];
              int_fft1clkforce         <= int_reg_dw[9];
              int_fft0memclkforce      <= int_reg_dw[8];
              int_fft0clkforce         <= int_reg_dw[7];
              int_chestclkforce        <= int_reg_dw[6];
              int_hmemclkforce         <= int_reg_dw[4];
              int_intlvmemclkforce     <= int_reg_dw[3];
              int_vtb1clkforce         <= int_reg_dw[2];
              int_vtb0clkforce         <= int_reg_dw[1];
              int_bdrxclkforce         <= int_reg_dw[0];
          end

          // Write CLKGATEPHYFCTRL1 register.
          RW_HE_CRM_CLKGATEPHYFCTRL1_ADDR_CT :
          begin
              int_radartimclkforce     <= int_reg_dw[5];
              int_mdmbtxclkforce       <= int_reg_dw[4];
              int_mdmbrxclkforce       <= int_reg_dw[3];
              int_ldpcencclkforce      <= int_reg_dw[1];
              int_ldpcdecclkforce      <= int_reg_dw[0];
          end

          // Write RSTCTRL register.
          RW_HE_CRM_RSTCTRL_ADDR_CT :
          begin
              int_rcswreset            <= int_reg_dw[8];
              int_agcswreset           <= int_reg_dw[4];
              int_physwreset           <= int_reg_dw[0];
          end

          // Write DYNCFGMMC_CNTL register.
          RW_HE_CRM_DYNCFGMMC_CNTL_ADDR_CT :
          begin
              int_fmetre_start         <= int_reg_dw[1];
              int_dyncfgmmc_start      <= int_reg_dw[0];
          end

          // Write DYNCFGMMC_ADDR register.
          RW_HE_CRM_DYNCFGMMC_ADDR_ADDR_CT :
          begin
              int_dyncfgmmc_we         <= int_reg_dw[31];
              int_dyncfgmmc_sel        <= int_reg_dw[19 : 16];
              int_dyncfgmmc_addr       <= int_reg_dw[15 : 0];
          end

          // Write DYNCFGMMC_DATA register.
          RW_HE_CRM_DYNCFGMMC_DATA_ADDR_CT :
          begin
              int_dyncfgmmc_wdata      <= int_reg_dw[15 : 0];
          end

          // Write LA_SAMPLING_FREQ register.
          RW_HE_CRM_LA_SAMPLING_FREQ_ADDR_CT :
          begin
              int_la_sampling_freq     <= int_reg_dw[7 : 0];
          end
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : 
          begin
          end
          // pragma coverage block = on 

        endcase
      end

      if (pending_read==1'b1)
      begin
        
        pending_read <= 1'b0;
        int_reg_dr   <= 32'b0;
        
        case(pending_addr)

        // Read CLKRST_CNTL register.
        RW_HE_CRM_CLKRST_CNTL_ADDR_CT :
        begin
          int_reg_dr[13 : 12]       <= macwtclk_ratio_sel;
          int_reg_dr[11 : 8]        <= maccoreclk_freq_sel;
          int_reg_dr[5 : 4]         <= feclk_freq_sel;
          int_reg_dr[0]             <= plfclk_sel;
        end

        // Read CLKRST_STAT register.
        RW_HE_CRM_CLKRST_STAT_ADDR_CT :
        begin
          int_reg_dr[10 : 4]        <= mmc_lock;
        end

        // Read CLKGATEPHYFCTRL0 register.
        RW_HE_CRM_CLKGATEPHYFCTRL0_ADDR_CT :
        begin
          int_reg_dr[31]            <= phytxclkforce;
          int_reg_dr[30]            <= bdtxclkforce;
          int_reg_dr[29]            <= agcmemclkforce;
          int_reg_dr[28]            <= agcclkforce;
          int_reg_dr[27]            <= rcclkforce;
          int_reg_dr[24]            <= feclkforce;
          int_reg_dr[23]            <= fdoclkforce;
          int_reg_dr[22]            <= equclkforce;
          int_reg_dr[20]            <= physvdclkforce;
          int_reg_dr[18]            <= tdcompclkforce;
          int_reg_dr[17]            <= tdfoestclkforce;
          int_reg_dr[16]            <= tbeclkforce;
          int_reg_dr[10]            <= fft1memclkforce;
          int_reg_dr[9]             <= fft1clkforce;
          int_reg_dr[8]             <= fft0memclkforce;
          int_reg_dr[7]             <= fft0clkforce;
          int_reg_dr[6]             <= chestclkforce;
          int_reg_dr[4]             <= hmemclkforce;
          int_reg_dr[3]             <= intlvmemclkforce;
          int_reg_dr[2]             <= vtb1clkforce;
          int_reg_dr[1]             <= vtb0clkforce;
          int_reg_dr[0]             <= bdrxclkforce;
        end

        // Read CLKGATEPHYFCTRL1 register.
        RW_HE_CRM_CLKGATEPHYFCTRL1_ADDR_CT :
        begin
          int_reg_dr[5]             <= radartimclkforce;
          int_reg_dr[4]             <= mdmbtxclkforce;
          int_reg_dr[3]             <= mdmbrxclkforce;
          int_reg_dr[1]             <= ldpcencclkforce;
          int_reg_dr[0]             <= ldpcdecclkforce;
        end

        // Read RSTCTRL register.
        RW_HE_CRM_RSTCTRL_ADDR_CT :
        begin
          int_reg_dr[8]             <= rcswreset;
          int_reg_dr[4]             <= agcswreset;
          int_reg_dr[0]             <= physwreset;
        end

        // Read DYNCFGMMC_CNTL register.
        RW_HE_CRM_DYNCFGMMC_CNTL_ADDR_CT :
        begin
          int_reg_dr[31]            <= dyncfgmmc_done;
          int_reg_dr[30]            <= fmetre_done;
          int_reg_dr[1]             <= fmetre_start;
          int_reg_dr[0]             <= dyncfgmmc_start;
        end

        // Read DYNCFGMMC_ADDR register.
        RW_HE_CRM_DYNCFGMMC_ADDR_ADDR_CT :
        begin
          int_reg_dr[31]            <= dyncfgmmc_we;
          int_reg_dr[19 : 16]       <= dyncfgmmc_sel;
          int_reg_dr[15 : 0]        <= dyncfgmmc_addr;
        end

        // Read DYNCFGMMC_DATA register.
        RW_HE_CRM_DYNCFGMMC_DATA_ADDR_CT :
        begin
          int_reg_dr[31 : 16]       <= dyncfgmmc_rdata;
          int_reg_dr[15 : 0]        <= dyncfgmmc_wdata;
        end

        // Read FMETRE_REF44 register.
        RW_HE_CRM_FMETRE_REF44_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_ref44;
        end

        // Read FMETRE_REF30 register.
        RW_HE_CRM_FMETRE_REF30_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_ref30;
        end

        // Read FMETRE_REF60 register.
        RW_HE_CRM_FMETRE_REF60_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_ref60;
        end

        // Read FMETRE_REF40 register.
        RW_HE_CRM_FMETRE_REF40_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_ref40;
        end

        // Read FMETRE_REF80 register.
        RW_HE_CRM_FMETRE_REF80_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_ref80;
        end

        // Read FMETRE_FE register.
        RW_HE_CRM_FMETRE_FE_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_fe;
        end

        // Read FMETRE_BD register.
        RW_HE_CRM_FMETRE_BD_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_bd;
        end

        // Read FMETRE_PHY register.
        RW_HE_CRM_FMETRE_PHY_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_phy;
        end

        // Read FMETRE_MPIF register.
        RW_HE_CRM_FMETRE_MPIF_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_mpif;
        end

        // Read FMETRE_LA register.
        RW_HE_CRM_FMETRE_LA_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_la;
        end

        // Read FMETRE_MACCORE register.
        RW_HE_CRM_FMETRE_MACCORE_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_maccore;
        end

        // Read FMETRE_MACWT register.
        RW_HE_CRM_FMETRE_MACWT_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_macwt;
        end

        // Read FMETRE_PLF register.
        RW_HE_CRM_FMETRE_PLF_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= fmetre_plf;
        end

        // Read LA_SAMPLING_FREQ register.
        RW_HE_CRM_LA_SAMPLING_FREQ_ADDR_CT :
        begin
          int_reg_dr[7 : 0]         <= la_sampling_freq;
        end
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : int_reg_dr <= 32'b0;
          // pragma coverage block = on 

        endcase
      end

      // Pulse generation
      // Hardware update

      if(hready_in==1'b1 && hsel==1'b1 && htrans[1]==1'b1)
      begin
        if(hwrite==1'b1)
        begin
          pending_addr  <= haddr[9:2];
          pending_write <= 1'b1;
        end
        else
        begin
          pending_addr  <= haddr[9:2];
          pending_read  <= 1'b1;
          int_reg_rdy   <= 1'b0;
        end
      end
    end
  end




  //////////////////////////////////////////////////////////////////////////////
  // Read data 
  //////////////////////////////////////////////////////////////////////////////
  assign  hrdata     = int_reg_dr;

  //////////////////////////////////////////////////////////////////////////////
  // Write data 
  //////////////////////////////////////////////////////////////////////////////
  assign  int_reg_dw = hwdata;

  assign  hready = int_reg_rdy;
  assign  hresp  = 2'b0;

`ifdef RW_ASSERT_ON

`endif // RW_ASSERT_ON
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

