/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
*----------------------------------------------------------------------------
* $Author: $
* Company : RivieraWaves
*----------------------------------------------------------------------------
* $Revision: $
* $Date: $
*---------------------------------------------------------------------------
* Description : 
*
* Terms & concepts : 
* Bugs :  
* Open issues and future enhancements : 
* Tasks and functions:  
* interfaces : 
* Revision History : 
*******************************************************************************/
`default_nettype none
module rw_he_crm_reset
( 
  /*****************************************************************************
  * system reset
  *****************************************************************************/
  input  wire          sys_rst_n,

  /*****************************************************************************
  * reset requests
  *****************************************************************************/
  input  wire          phy_swrsten_n,
  input  wire          agc_swrsten_n,
  input  wire          rc_swrsten_n,
  input  wire          plf_swrsten_n,
  input  wire          phywdog_hwrsten_n,
  input  wire          mmc4_lock,

  /*****************************************************************************
  * clocks
  *****************************************************************************/
  input  wire          ref0_root_clk,
  input  wire          ref1_root_clk,
  input  wire          plf_root_clk,
  input  wire          ref200_root_clk,
  input  wire          ref44_root_clk,
  input  wire          ref40_root_clk,
  input  wire          ref80_root_clk,
  input  wire          fe_root_clk,
`ifdef  RW_EMBEDDED_LA
  input  wire          la_root_clk,
`endif//  RW_EMBEDDED_LA
  input  wire          mac_core_root_clk,
  input  wire          phy_root_clk,
  input  wire          rxbd_root_clk,
  
  /*****************************************************************************
  * cleaned resets
  *****************************************************************************/
  output wire          ref0_rst_n,
  output wire          ref1_rst_n,
  output wire          plf_rst_n,     
  output wire          ref200_rst_n,
  output wire          ref44_rst_n,
  output wire          ref40_rst_n,
  output wire          ref80_rst_n,
  output wire          fe_rst_n,
  output wire          fe40_rst_n,
  output wire          fe80_rst_n,
  output wire          fe44_rst_n,
`ifdef  RW_EMBEDDED_LA
  output wire          la_rst_n,
`endif//  RW_EMBEDDED_LA
  output wire          mac_core_rst_n,  
  output wire          mac_wt_rst_n,    
  output wire          mac_mpif_rst_n,  
  output wire          phy_rst_n,
  output wire          rxbd_rst_n,
  output wire          mdmb_rst_n,
  output wire          rc_rst_n,
  output wire          agc_rst_n,
  output wire          radar_rst_n
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  
  /* ref200 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_ref200
  (
    .clk(              ref200_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          sys_rst_n),
    .nrst_out(         ref200_rst_n)
  );

  /* ref44 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_ref44
  (
    .clk(              ref44_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          sys_rst_n),
    .nrst_out(         ref44_rst_n)
  );

  /* ref40 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_ref40
  (
    .clk(              ref40_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          sys_rst_n),
    .nrst_out(         ref40_rst_n)
  );

  /* ref80 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_ref80
  (
    .clk(              ref80_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          sys_rst_n),
    .nrst_out(         ref80_rst_n)
  );
  
`ifdef  RW_EMBEDDED_LA
  /* LA reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_la(
     .clk        (la_root_clk),
     .nrst_sys   (sys_rst_n  ),
     .nrst_in    (sys_rst_n  ),
     .nrst_out   (la_rst_n   )
  );
`endif//  RW_EMBEDDED_LA

  /*****************************************************************************
  * cleaner for domain ref0_clk
  *  o sys_rst_n
  *****************************************************************************/
  wire   preclean_ref0_rst_n;
  assign preclean_ref0_rst_n = sys_rst_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_ref0_rst_n
  (
    .clk(            ref0_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_ref0_rst_n),
    .nrst_out(       ref0_rst_n)
  );
 
  /*****************************************************************************
  * cleaner for domain ref1_clk
  *  o sys_rst_n
  *****************************************************************************/
  wire   preclean_ref1_rst_n;
  assign preclean_ref1_rst_n = sys_rst_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_ref1_rst_n
  (
    .clk(            ref1_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_ref1_rst_n),
    .nrst_out(       ref1_rst_n)
  );
 
  /*****************************************************************************
  * cleaner for domain mpif_clk
  *
  * not controlled by phywdog_hwrsten_n and phy_swrsten_n
  *  o mac_mpif_rst_n
  *
  *****************************************************************************/
  wire   preclean_mac_mpif_rst_n;
  assign preclean_mac_mpif_rst_n = sys_rst_n;
      
  rw_he_crm_reset_cleaner u_reset_cleaner_mac_mpif_rst_n
  (
    .clk(            phy_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_mac_mpif_rst_n),
    .nrst_out(       mac_mpif_rst_n)
  );

  /*****************************************************************************
  * cleaner for domain phy_clk
  * controlled by phywdog_hwrsten_n and phy_swrsten_n
  *  o phy_rst_n
  *
  *****************************************************************************/
  wire   preclean_phy_rst_n;
  assign preclean_phy_rst_n = sys_rst_n & phy_swrsten_n & phywdog_hwrsten_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_phy_rst_n
  (
    .clk(            phy_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_phy_rst_n),
    .nrst_out(       phy_rst_n)
  );
  
  /*****************************************************************************
  * cleaner for domain rxbd_clk
  * controlled by phywdog_hwrsten_n and phy_swrsten_n
  *  o phy_rst_n
  *
  *****************************************************************************/
  wire   preclean_rxbd_rst_n;
  assign preclean_rxbd_rst_n = sys_rst_n & phy_swrsten_n & phywdog_hwrsten_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_rxbd_rst_n
  (
    .clk(            rxbd_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_rxbd_rst_n),
    .nrst_out(       rxbd_rst_n)
  );
  
  /*****************************************************************************
  * cleaner for domain mdmb_clk
  * controlled by phywdog_hwrsten_n and phy_swrsten_n
  *  o mdmb_rst_n
  *
  *****************************************************************************/
  wire   preclean_mdmb_rst_n;
  assign preclean_mdmb_rst_n = sys_rst_n & phy_swrsten_n & phywdog_hwrsten_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_mdmb_rst_n
  (
    .clk(            ref44_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_mdmb_rst_n),
    .nrst_out(       mdmb_rst_n)
  );
  
  /*****************************************************************************
  * cleaner for domain RC 
  * controlled by rc_swrsten_n
  *
  * note: this reset is intended for the above domains only, in case of
  *   watchdog event, these parts are NOT reset
  *
  *****************************************************************************/
  wire preclean_rc_rst_n;
  
  assign preclean_rc_rst_n = 
    sys_rst_n & 
    rc_swrsten_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_rc_rst_n
  (
    .clk(            ref80_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_rc_rst_n),
    .nrst_out(       rc_rst_n)
  );
 
  /*****************************************************************************
  * cleaner for domain AGC 
  * controlled by phywdog_hwrsten_n and phy_swrsten_n and agc_swrsten_n
  *  o agc_rst_n
  *
  *****************************************************************************/
  wire preclean_agc_rst_n;
  
  assign preclean_agc_rst_n = sys_rst_n & phy_swrsten_n & agc_swrsten_n & phywdog_hwrsten_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_agc_rst_n
  (
    .clk(            ref80_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_agc_rst_n),
    .nrst_out(       agc_rst_n)
  );
 

  /*****************************************************************************
  * cleaner for domain radar 
  * controlled by phy_swrsten_n
  *  o radar_rst_n
  *
  *****************************************************************************/
  wire preclean_radar_rst_n;
  
  assign preclean_radar_rst_n = sys_rst_n & phy_swrsten_n;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_radar_rst_n
  (
    .clk(            ref80_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_radar_rst_n),
    .nrst_out(       radar_rst_n)
  );

  /*****************************************************************************
  * cleaner for domain fe 
  * controlled by phy_swrsten_n and phywdog_hwrsten_n
  *
  *****************************************************************************/
  wire preclean_fe_rst_n;
  
  assign preclean_fe_rst_n = sys_rst_n & phy_swrsten_n & phywdog_hwrsten_n;

  /* fe reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_fe
  (
    .clk(              fe_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          preclean_fe_rst_n),
    .nrst_out(         fe_rst_n)
  );

 /* fe40 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_fe40
  (
    .clk(              ref40_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          preclean_fe_rst_n),
    .nrst_out(         fe40_rst_n)
  );
  
  /* fe80 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_fe80
  (
    .clk(              ref80_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          preclean_fe_rst_n),
    .nrst_out(         fe80_rst_n)
  );

  /* fe44 reset cleaner  */
  rw_he_crm_reset_cleaner u_reset_cleaner_fe44
  (
    .clk(              ref44_root_clk),
    .nrst_sys(         sys_rst_n),
    .nrst_in(          preclean_fe_rst_n),
    .nrst_out(         fe44_rst_n)
  );

//******************************************************************************
// Mac Resets
//******************************************************************************
  
  /*****************************************************************************
  * cleaner for domain plf_clk
  *  o sys_rst_n
  *****************************************************************************/
  reg  reset_req_n_1t;
  reg  reset_req_n_2t;
  
  always@(posedge plf_root_clk or negedge sys_rst_n)
  begin
    if (!sys_rst_n)
    begin
      reset_req_n_1t <= 1'b0;
      reset_req_n_2t <= 1'b0;
    end
    else
    begin
      reset_req_n_1t <= plf_swrsten_n;
      reset_req_n_2t <= reset_req_n_1t;
    end
  end
  
  wire   preclean_plf_rst_n;
  assign preclean_plf_rst_n = sys_rst_n & reset_req_n_2t;
  
  rw_he_crm_reset_cleaner u_reset_cleaner_plf_rst_n
  (
    .clk(            plf_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_plf_rst_n),
    .nrst_out(       plf_rst_n)
  );
 

  /*****************************************************************************
  * cleaner for domain mac_core_clk & mac_wt_clk
  *  o sys_rst_n
  *****************************************************************************/
  wire   preclean_mac_rst_n;
  assign preclean_mac_rst_n = sys_rst_n & reset_req_n_2t & mmc4_lock;
      
  wire mac_rst_n;
  rw_he_crm_reset_cleaner u_reset_cleaner_mac_rst_n
  (
    .clk(            mac_core_root_clk),
    .nrst_sys(       sys_rst_n),
    .nrst_in(        preclean_mac_rst_n),
    .nrst_out(       mac_rst_n)
  );
  assign mac_core_rst_n = mac_rst_n;
  assign mac_wt_rst_n   = mac_rst_n;

  
endmodule
`default_nettype wire
